/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.util.ReverseCharSequence;

public class PatternSearchMatcher
extends SearchMatcher {
    private final int flags;
    private Pattern re;
    private final String pattern;

    public PatternSearchMatcher(String search, boolean ignoreCase) {
        this.pattern = search;
        this.flags = PatternSearchMatcher.getFlag(ignoreCase);
    }

    public PatternSearchMatcher(Pattern re, boolean ignoreCase, boolean wholeWord) {
        this(re.pattern(), ignoreCase);
        this.re = re;
        this.wholeWord = wholeWord;
    }

    public PatternSearchMatcher(Pattern re, boolean ignoreCase) {
        this(re, ignoreCase, false);
    }

    @Override
    public SearchMatcher.Match nextMatch(CharSequence text, boolean start, boolean end, boolean firstTime, boolean reverse) {
        Pattern p;
        Matcher match;
        if (text instanceof ReverseCharSequence) {
            text = ((ReverseCharSequence)text).baseSequence();
        }
        if (this.re == null) {
            this.re = Pattern.compile(this.pattern, this.flags);
        }
        int matchStart = 0;
        if (!start && this.re.pattern().charAt(0) == '^') {
            Matcher sol = Pattern.compile("^", this.flags).matcher(text);
            sol.find();
            if (!sol.find()) {
                return null;
            }
            matchStart = sol.start();
        }
        if (!(match = this.re.matcher(text)).find(matchStart) && !(match = (p = PatternSearchMatcher.removeNonCapturingGroups(this.re, this.flags)).matcher(text)).matches()) {
            return null;
        }
        if (!(reverse || firstTime || match.start() != 0 || match.end() != 0 || match.find())) {
            return null;
        }
        SearchMatcher.Match previous = null;
        while (true) {
            if (!(end && text.charAt(text.length() - 1) != '\n' || match.end() != text.length() || this.pattern.charAt(this.pattern.length() - 1) != '$')) {
                if (previous != null) {
                    this.returnValue.start = previous.start;
                    this.returnValue.end = previous.end;
                    this.returnValue.substitutions = previous.substitutions;
                    break;
                }
                return null;
            }
            this.returnValue.substitutions = new String[match.groupCount() + 1];
            for (int i = 0; i < this.returnValue.substitutions.length; ++i) {
                this.returnValue.substitutions[i] = match.group(i);
            }
            int _start = match.start();
            int _end = match.end();
            this.returnValue.start = _start;
            this.returnValue.end = _end;
            if (this.wholeWord && !this.isWholeWord(text, _start, _end)) {
                if (match.find()) continue;
                return null;
            }
            if (!reverse || !match.find()) {
                if (!reverse || firstTime || this.returnValue.start != text.length() || this.returnValue.end != text.length()) break;
                if (previous != null) {
                    this.returnValue.start = previous.start;
                    this.returnValue.end = previous.end;
                    this.returnValue.substitutions = previous.substitutions;
                    break;
                }
                return null;
            }
            if (previous == null) {
                previous = new SearchMatcher.Match();
            }
            previous.start = this.returnValue.start;
            previous.end = this.returnValue.end;
            previous.substitutions = this.returnValue.substitutions;
        }
        if (reverse) {
            int len = this.returnValue.end - this.returnValue.start;
            this.returnValue.start = text.length() - this.returnValue.end;
            this.returnValue.end = this.returnValue.start + len;
        }
        return this.returnValue;
    }

    public static Pattern removeNonCapturingGroups(Pattern re, int flags) {
        String p = re.pattern();
        String ncgroups = "[(][?].+?[)]";
        Pattern nc_pattern = Pattern.compile(ncgroups, flags);
        Matcher nc_matcher = nc_pattern.matcher(p);
        if (nc_matcher.find()) {
            int index = nc_matcher.start();
            int open_count = 0;
            for (int i = index; i < p.length(); ++i) {
                if (p.charAt(i) == '(' && (i == 0 || p.charAt(i - 1) != '\\')) {
                    ++open_count;
                }
                if (p.charAt(i) == ')' && (i == 0 || p.charAt(i - 1) != '\\')) {
                    --open_count;
                }
                if (open_count != 0 || i >= p.length() - 1) continue;
                int end = i + 1;
                char c = p.charAt(end);
                if (c == '{') {
                    while (c != '}' && end < p.length() - 1) {
                        c = p.charAt(++end);
                    }
                    ++end;
                }
                if (((c = p.charAt(end)) == '?' || c == '+' || c == '*') && end < p.length() - 1) {
                    ++end;
                }
                if (((c = p.charAt(end)) == '?' || c == '+') && end < p.length() - 1) {
                    ++end;
                }
                StringBuilder sb = new StringBuilder(p);
                sb.delete(index, end);
                return PatternSearchMatcher.removeNonCapturingGroups(Pattern.compile(sb.toString(), flags), flags);
            }
        }
        return re;
    }

    public String toString() {
        boolean ignoreCase = (this.flags & 2) != 0;
        return "PatternSearchMatcher[" + this.pattern + "," + ignoreCase + "]";
    }

    static int getFlag(boolean ignoreCase) {
        int flags = 8;
        if (ignoreCase) {
            flags |= 2;
        }
        return flags;
    }
}

