/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class VFSManager {
    public static final String SERVICE = "org.gjt.sp.jedit.io.VFS";
    private static final VFS fileVFS;
    private static final VFS urlVFS;
    private static boolean error;
    private static final Object errorLock;
    private static final Vector<ErrorListDialog.ErrorEntry> errors;
    private static final Object vfsUpdateLock;
    private static final List<VFSUpdate> vfsUpdates;
    private static boolean errorDisplayerActive;

    public static void init() {
    }

    public static void start() {
        AwtRunnableQueue.INSTANCE.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canReadFile(String path) {
        VFS vfs = VFSManager.getVFSForPath(path);
        Object vfsSession = vfs.createVFSSession(path, jEdit.getActiveView());
        if (vfsSession == null) {
            return false;
        }
        try {
            VFSFile vfsFile = vfs._getFile(vfsSession, path, jEdit.getActiveView());
            boolean bl = vfsFile != null && vfsFile.isReadable();
            return bl;
        }
        catch (IOException e) {
            Log.log(9, VFSManager.class, e, e);
        }
        finally {
            try {
                vfs._endVFSSession(vfsSession, jEdit.getActiveView());
            }
            catch (IOException e) {
                Log.log(9, VFSManager.class, e, e);
            }
        }
        return false;
    }

    public static VFS getFileVFS() {
        return fileVFS;
    }

    public static VFS getUrlVFS() {
        return urlVFS;
    }

    @Nonnull
    public static VFS getVFSForProtocol(String protocol) {
        if (protocol.equals("file")) {
            return fileVFS;
        }
        VFS vfs = (VFS)ServiceManager.getService(SERVICE, protocol);
        if (vfs != null) {
            return vfs;
        }
        return urlVFS;
    }

    @Nonnull
    public static VFS getVFSForPath(String path) {
        if (MiscUtilities.isURL(path)) {
            return VFSManager.getVFSForProtocol(MiscUtilities.getProtocolOfURL(path));
        }
        return fileVFS;
    }

    public static String[] getVFSs() {
        String[] newAPI = ServiceManager.getServiceNames(SERVICE);
        return newAPI;
    }

    public static void waitForRequests() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException();
        }
        TaskManager.instance.waitForIoTasks();
    }

    public static boolean errorOccurred() {
        return error;
    }

    public static int getRequestCount() {
        return TaskManager.instance.countIoTasks();
    }

    public static void error(IOException e, String path, Component comp) {
        Log.log(9, VFSManager.class, e);
        VFSManager.error(comp, path, "ioerror", new String[]{e.toString()});
    }

    public static void error(Component comp, String path, String messageProp, Object[] args) {
        VFSManager.error(comp, path, messageProp, args, 9);
    }

    public static void error(final Component comp, final String path, final String messageProp, final Object[] args, final int urgency) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Frame frame = JOptionPane.getFrameForComponent(comp);
                Object object = errorLock;
                synchronized (object) {
                    error = true;
                    errors.add(new ErrorListDialog.ErrorEntry(path, messageProp, args, urgency));
                    if (errors.size() == 1 && !errorDisplayerActive) {
                        ThreadUtilities.runInBackground(new ErrorDisplayer(frame));
                    }
                }
            }
        };
        ThreadUtilities.runInDispatchThread(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendVFSUpdate(VFS vfs, String path, boolean parent) {
        if (parent) {
            VFSManager.sendVFSUpdate(vfs, vfs.getParentOfPath(path), false);
            VFSManager.sendVFSUpdate(vfs, path, false);
        } else {
            if (path.length() != 1 && (path.endsWith("/") || path.endsWith(File.separator))) {
                path = path.substring(0, path.length() - 1);
            }
            Object object = vfsUpdateLock;
            synchronized (object) {
                for (VFSUpdate msg : vfsUpdates) {
                    if (!msg.getPath().equals(path)) continue;
                    return;
                }
                vfsUpdates.add(new VFSUpdate(path));
                if (vfsUpdates.size() == 1) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    AwtRunnableQueue.INSTANCE.runAfterIoTasks(new SendVFSUpdatesSafely());
                }
            }
        }
    }

    private VFSManager() {
    }

    static {
        errorLock = new Object();
        vfsUpdateLock = new Object();
        errors = new Vector();
        fileVFS = new FileVFS();
        urlVFS = new UrlVFS();
        vfsUpdates = new ArrayList<VFSUpdate>(10);
    }

    private static class SendVFSUpdatesSafely
    implements Runnable {
        private SendVFSUpdatesSafely() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = vfsUpdateLock;
            synchronized (object) {
                vfsUpdates.sort(new StandardUtilities.StringCompare());
                vfsUpdates.forEach(EditBus::send);
                vfsUpdates.clear();
            }
        }
    }

    private static class ErrorDisplayer
    implements Runnable {
        private final Frame frame;

        ErrorDisplayer(Frame frame) {
            this.frame = frame;
        }

        private static void showDialog(Frame frame, Vector<ErrorListDialog.ErrorEntry> errors) {
            try {
                EventQueue.invokeAndWait(() -> {
                    String caption = jEdit.getProperty("ioerror.caption" + (errors.size() == 1 ? "-1" : ""), new Integer[]{errors.size()});
                    new ErrorListDialog(frame.isShowing() ? frame : jEdit.getFirstView(), jEdit.getProperty("ioerror.title"), caption, errors, false);
                });
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException ite) {
                Log.log(9, ErrorDisplayer.class, ite);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = errorLock;
            synchronized (object) {
                if (errorDisplayerActive) {
                    return;
                }
                errorDisplayerActive = true;
            }
            while (true) {
                Vector<ErrorListDialog.ErrorEntry> errorsCopy;
                object = errorLock;
                synchronized (object) {
                    if (errors.isEmpty()) {
                        errorDisplayerActive = false;
                        break;
                    }
                }
                int errCount1 = -1;
                int errCount2 = 0;
                while (errCount1 != errCount2) {
                    errCount1 = errors.size();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    errCount2 = errors.size();
                }
                Object object2 = errorLock;
                synchronized (object2) {
                    errorsCopy = new Vector<ErrorListDialog.ErrorEntry>(errors);
                    errors.clear();
                    error = false;
                }
                ErrorDisplayer.showDialog(this.frame, errorsCopy);
            }
        }
    }
}

