/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.tray;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.SystemTray;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import javax.swing.JPanel;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.tray.JEditSwingTrayIcon;
import org.gjt.sp.jedit.gui.tray.JEditTrayIcon;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class JTrayIconManager {
    private static JEditTrayIcon trayIcon;
    private static Image originalTrayIconImage;
    private static boolean restore;
    private static String userDir;
    private static String[] args;

    public static void setTrayIconArgs(boolean restore, String userDir, String[] args) {
        JTrayIconManager.restore = restore;
        JTrayIconManager.userDir = userDir;
        JTrayIconManager.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTrayIcon() {
        if (trayIcon == null && SystemTray.isSupported()) {
            String trayIconName = jEdit.getProperty("systrayicon.service", "swing");
            trayIcon = ServiceManager.getService(JEditTrayIcon.class, trayIconName);
            if (trayIcon == null) {
                if ("swing".equals(trayIconName)) {
                    Log.log(9, JTrayIconManager.class, "No service " + JEditTrayIcon.class.getName() + " with name swing");
                    return;
                }
                Log.log(7, JTrayIconManager.class, "No service " + JEditTrayIcon.class.getName() + " with name " + trayIconName);
                trayIcon = ServiceManager.getService(JEditTrayIcon.class, "swing");
            }
            if (trayIcon == null) {
                Log.log(9, JTrayIconManager.class, "No service " + JEditTrayIcon.class.getName() + " with name swing");
                return;
            }
            trayIcon.setTrayIconArgs(restore, userDir, args);
            originalTrayIconImage = trayIcon.getImage();
            SystemTray systemTray = SystemTray.getSystemTray();
            boolean backgroundDefault = false;
            boolean backgroundFixed = false;
            boolean backgroundPicked = false;
            boolean backgroundAutodetect = false;
            switch (jEdit.getProperty("systrayicon.background", "autodetect").toLowerCase()) {
                case "default": {
                    backgroundDefault = true;
                    break;
                }
                case "fixed": {
                    backgroundFixed = true;
                    break;
                }
                case "picked": {
                    backgroundPicked = true;
                    break;
                }
                default: {
                    backgroundAutodetect = true;
                }
            }
            if (OperatingSystem.isX11() && !backgroundDefault) {
                try {
                    int height;
                    Robot robot = null;
                    if (backgroundAutodetect) {
                        robot = new Robot();
                    }
                    Dimension trayIconSize = systemTray.getTrayIconSize();
                    BufferedImage trayIconImage = new BufferedImage(trayIconSize.width, trayIconSize.height, 2);
                    Graphics2D g = trayIconImage.createGraphics();
                    CompletableFuture<Integer> widthFuture = new CompletableFuture<Integer>();
                    CompletableFuture<Integer> heightFuture = new CompletableFuture<Integer>();
                    int width = originalTrayIconImage.getWidth((img, infoflags, x, y, w, h) -> {
                        if ((infoflags & 1) == 1) {
                            widthFuture.complete(w);
                        }
                        return !widthFuture.isDone();
                    });
                    if (width != -1) {
                        widthFuture.complete(width);
                    }
                    if ((height = originalTrayIconImage.getHeight((img, infoflags, x, y, w, h) -> {
                        if ((infoflags & 2) == 2) {
                            heightFuture.complete(h);
                        }
                        return !heightFuture.isDone();
                    })) != -1) {
                        heightFuture.complete(height);
                    }
                    try {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        double scaleFactorX = trayIconSize.getWidth() / (double)((Integer)widthFuture.join()).intValue();
                        double scaleFactorY = trayIconSize.getHeight() / (double)((Integer)heightFuture.join()).intValue();
                        g.drawImage(originalTrayIconImage, AffineTransform.getScaleInstance(scaleFactorX, scaleFactorY), null);
                    }
                    finally {
                        g.dispose();
                    }
                    Color[][] backgroundColorMatrix = null;
                    int backgroundColorMatrixWidth = 0;
                    int backgroundColorMatrixHeight = 0;
                    if (backgroundPicked && (backgroundColorMatrix = jEdit.getColorMatrixProperty("systrayicon.bgPixel")) != null) {
                        backgroundColorMatrixWidth = backgroundColorMatrix[0].length;
                        backgroundColorMatrixHeight = backgroundColorMatrix.length;
                    }
                    Color backgroundColor = null;
                    if (backgroundFixed) {
                        backgroundColor = jEdit.getColorProperty("systrayicon.bgColor");
                    }
                    Color defaultBackgroundColor = null;
                    if (backgroundPicked) {
                        defaultBackgroundColor = new JPanel().getBackground();
                    }
                    for (int y2 = 0; y2 < trayIconSize.height; ++y2) {
                        if (backgroundAutodetect) {
                            backgroundColor = robot.getPixelColor(1, y2);
                        }
                        for (int x2 = 0; x2 < trayIconSize.width; ++x2) {
                            if (backgroundPicked) {
                                backgroundColor = x2 >= backgroundColorMatrixWidth || y2 >= backgroundColorMatrixHeight ? defaultBackgroundColor : backgroundColorMatrix[y2][x2];
                            }
                            int imageRGB = trayIconImage.getRGB(x2, y2);
                            Color imageColor = new Color(imageRGB);
                            float alpha = (float)(imageRGB >> 24 & 0xFF) / 255.0f;
                            float antiAlpha = 1.0f - alpha;
                            int red = Math.round(alpha * (float)imageColor.getRed() + antiAlpha * (float)backgroundColor.getRed());
                            int green = Math.round(alpha * (float)imageColor.getGreen() + antiAlpha * (float)backgroundColor.getGreen());
                            int blue = Math.round(alpha * (float)imageColor.getBlue() + antiAlpha * (float)backgroundColor.getBlue());
                            trayIconImage.setRGB(x2, y2, new Color(red, green, blue).getRGB());
                        }
                    }
                    trayIcon.setImage(trayIconImage);
                }
                catch (AWTException robot) {
                    // empty catch block
                }
            }
            try {
                systemTray.add(trayIcon);
            }
            catch (AWTException e) {
                Log.log(9, JEditSwingTrayIcon.class, "Unable to add Tray icon", e);
                trayIcon = null;
                return;
            }
            EditBus.addToBus(trayIcon);
        }
    }

    public static void removeTrayIcon() {
        if (trayIcon != null) {
            SystemTray.getSystemTray().remove(trayIcon);
            EditBus.removeFromBus(trayIcon);
            trayIcon.setImage(originalTrayIconImage);
            trayIcon = null;
        }
    }
}

