/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.tray;

import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditServer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.tray.JEditTrayIcon;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;

public class JEditSwingTrayIcon
extends JEditTrayIcon {
    private boolean restore;
    private String userDir;
    private String[] args;

    public JEditSwingTrayIcon() {
        super(GUIUtilities.getEditorIcon(), "jEdit");
        this.setImageAutoSize(true);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem newViewItem = new JMenuItem(jEdit.getProperty("tray.newView.label"));
        JMenuItem newPlainViewItem = new JMenuItem(jEdit.getProperty("tray.newPlainView.label"));
        JMenuItem exitItem = new JMenuItem(jEdit.getProperty("tray.exit.label"));
        popup.add(newViewItem);
        popup.add(newPlainViewItem);
        popup.addSeparator();
        popup.add(exitItem);
        newViewItem.addActionListener(e -> jEdit.newView(null));
        newPlainViewItem.addActionListener(e -> jEdit.newView(null, null, true));
        exitItem.addActionListener(e -> jEdit.exit(null, true));
        this.setMenu(popup);
        this.addMouseListener(new MyMouseAdapter());
    }

    @EditBus.EBHandler
    public void handleMessage(EditPaneUpdate editPaneUpdate) {
        if (editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
            ArrayList sl = new ArrayList();
            jEdit.getViewManager().forEach(view -> sl.add(view.getTitle()));
            this.setToolTip(String.join((CharSequence)" | ", sl));
        }
    }

    @Override
    void setTrayIconArgs(boolean restore, String userDir, String[] args) {
        this.restore = restore;
        this.userDir = userDir;
        this.args = args;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private final Map<Window, Boolean> windowState = new HashMap<Window, Boolean>();

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (jEdit.getViewCount() == 0) {
                EditServer.handleClient(JEditSwingTrayIcon.this.restore, true, false, JEditSwingTrayIcon.this.userDir, JEditSwingTrayIcon.this.args);
            } else {
                boolean newVisibilityState;
                boolean bl = newVisibilityState = !jEdit.getActiveView().isVisible();
                if (newVisibilityState) {
                    for (Window window : Window.getOwnerlessWindows()) {
                        if (this.skipWindow(window)) continue;
                        Boolean previousState = this.windowState.get(window);
                        if (previousState == null) {
                            window.setVisible(true);
                            continue;
                        }
                        if (!previousState.booleanValue()) continue;
                        window.setVisible(previousState);
                    }
                    this.windowState.clear();
                    if (jEdit.getActiveView().getState() == 1) {
                        jEdit.getActiveView().setState(0);
                    }
                    jEdit.getActiveView().toFront();
                } else {
                    for (Window window : Window.getOwnerlessWindows()) {
                        if (this.skipWindow(window)) continue;
                        this.windowState.put(window, window.isVisible());
                        window.setVisible(false);
                    }
                }
            }
        }

        private boolean skipWindow(Window window) {
            return window.getClass().getName().contains("Tray");
        }
    }
}

