/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class LockedWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        LockedWidget widget = new LockedWidget(view);
        return widget;
    }

    private static class LockedWidget
    extends AbstractLabelWidget {
        private static Icon lockClosed;
        private static Icon lockOpened;

        LockedWidget(View view) {
            super(view);
            this.initIcons();
            Dimension dim = new Dimension(16, 16);
            this.label.setMinimumSize(dim);
            this.label.setPreferredSize(dim);
            this.label.setMaximumSize(dim);
        }

        @Override
        protected void singleClick(MouseEvent e) {
            this.view.getBuffer().toggleLocked(this.view);
        }

        private void initIcons() {
            if (lockClosed == null) {
                try {
                    lockClosed = new ImageIcon(new ImageIcon(new URL("jeditresource:/org/gjt/sp/jedit/icons/themes/lock-rounded.png")).getImage().getScaledInstance(14, 14, 4));
                    lockOpened = new ImageIcon(new ImageIcon(new URL("jeditresource:/org/gjt/sp/jedit/icons/themes/lock-rounded-open.png")).getImage().getScaledInstance(14, 14, 4));
                }
                catch (MalformedURLException e) {
                    Log.log(9, this, "Unable to load icon");
                }
            }
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            boolean locked = buffer.isLocked();
            this.label.setIcon(locked ? lockClosed : lockOpened);
            this.label.setToolTipText(jEdit.getProperty("view.status.locked-tooltip", new Integer[]{locked ? 1 : 0}));
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Buffer;
        }
    }
}

