/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.File;
import java.security.SecureRandom;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class TipOfTheDay
extends EnhancedDialog {
    private final JCheckBox showNextTime;
    private final JEditorPane tipText;
    private int currentTip = -1;
    private final Random random = new SecureRandom();

    public TipOfTheDay(View view) {
        super(view, jEdit.getProperty("tip.title"), false);
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JLabel label = new JLabel(jEdit.getProperty("tip.caption"));
        label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() * 2.0f));
        label.setForeground(UIManager.getColor("Button.foreground"));
        content.add("North", label);
        this.tipText = new JEditorPane();
        this.tipText.setEditable(false);
        this.tipText.setContentType("text/html");
        this.tipText.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.tipText.setFont(jEdit.getFontProperty("helpviewer.font"));
        this.nextTip();
        JScrollPane scroller = new JScrollPane(this.tipText);
        scroller.setPreferredSize(new Dimension(250, 250));
        content.add("Center", scroller);
        Box buttons = new Box(0);
        this.showNextTime = new JCheckBox(jEdit.getProperty("tip.show-next-time"), jEdit.getBooleanProperty("tip.show"));
        this.showNextTime.addActionListener(e -> jEdit.setBooleanProperty("tip.show", this.showNextTime.isSelected()));
        buttons.add(this.showNextTime);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(Box.createGlue());
        JButton nextTip = new JButton(jEdit.getProperty("tip.next-tip"));
        nextTip.addActionListener(e -> this.nextTip());
        buttons.add(nextTip);
        buttons.add(Box.createHorizontalStrut(6));
        JButton close = new JButton(jEdit.getProperty("common.close"));
        close.addActionListener(e -> this.dispose());
        buttons.add(close);
        content.getRootPane().setDefaultButton(close);
        Dimension dim = nextTip.getPreferredSize();
        dim.width = Math.max(dim.width, close.getPreferredSize().width);
        nextTip.setPreferredSize(dim);
        close.setPreferredSize(dim);
        content.add("South", buttons);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    private void nextTip() {
        File[] tips = new File(MiscUtilities.constructPath(jEdit.getJEditHome(), "doc", "tips")).listFiles();
        if (tips == null || tips.length == 0) {
            this.tipText.setText(jEdit.getProperty("tip.not-found"));
            return;
        }
        int count = tips.length;
        int tipToShow = this.currentTip;
        while (tipToShow == this.currentTip || !tips[tipToShow].getName().endsWith(".html")) {
            tipToShow = this.random.nextInt(Integer.MAX_VALUE) % count;
        }
        try {
            this.tipText.setPage(tips[tipToShow].toURI().toURL());
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }
}

