/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class ScreenRectangleSelectionButton
extends JButton {
    public ScreenRectangleSelectionButton(BufferedImage image) {
        this.setIcon(new ScreenRectangle(image));
        this.setMargin(new Insets(2, 2, 2, 2));
        this.addActionListener(new ActionHandler());
    }

    public BufferedImage getSelectedImage() {
        return ((ScreenRectangle)this.getIcon()).image;
    }

    public void setSelectedImage(BufferedImage image) {
        ((ScreenRectangle)this.getIcon()).image = image;
        this.repaint();
        this.fireStateChanged();
    }

    public void setRectangleDimension(Dimension dimension) {
        ((ScreenRectangle)this.getIcon()).dimension = dimension;
        this.repaint();
        this.fireStateChanged();
    }

    static class ScreenRectangle
    implements Icon {
        Dimension dimension;
        BufferedImage image;

        ScreenRectangle(BufferedImage image) {
            this.image = image;
        }

        @Override
        public int getIconWidth() {
            return this.dimension.width;
        }

        @Override
        public int getIconHeight() {
            return this.dimension.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = g.create();
            g.setColor(c.getBackground());
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            if (this.image != null) {
                g.setClip(x, y, this.getIconWidth(), this.getIconHeight());
                g.drawImage(this.image, x, y, null);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final int iconWidth = ScreenRectangleSelectionButton.this.getIcon().getIconWidth();
            final int iconHeight = ScreenRectangleSelectionButton.this.getIcon().getIconHeight();
            int zoomedWidth = iconWidth * 12;
            int zoomedHeight = iconHeight * 12;
            JLabel directionsLabel = new JLabel(jEdit.getProperty("screen-rectangle-selection.directions"));
            ImageIcon rectangleIcon = new ImageIcon();
            JLabel rectangleLabel = new JLabel(rectangleIcon){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g = g.create();
                    g.setColor(Color.RED);
                    g.drawRect(iconWidth * 2 - 1, iconHeight * 2 - 1, iconWidth * 8 + 1, iconHeight * 8 + 1);
                }
            };
            rectangleLabel.setMinimumSize(new Dimension(zoomedWidth, zoomedHeight));
            rectangleLabel.setPreferredSize(new Dimension(zoomedWidth, zoomedHeight));
            rectangleLabel.setMaximumSize(new Dimension(zoomedWidth, zoomedHeight));
            Robot[] robot = new Robot[1];
            try {
                robot[0] = new Robot();
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
            int rectangleUpperLeftDeltaX = Math.round((float)iconWidth * 0.75f);
            int rectangleUpperLeftDeltaY = Math.round((float)iconHeight * 0.75f);
            Rectangle rectangle = new Rectangle(Math.round((float)iconWidth * 1.5f), Math.round((float)iconHeight * 1.5f));
            final BufferedImage[] rectangleImage = new BufferedImage[1];
            final Timer timer = new Timer(100, e -> {
                Point mousePointerLocation = MouseInfo.getPointerInfo().getLocation();
                rectangle.x = mousePointerLocation.x - rectangleUpperLeftDeltaX;
                rectangle.y = mousePointerLocation.y - rectangleUpperLeftDeltaY;
                rectangleImage[0] = robot[0].createScreenCapture(rectangle);
                rectangleIcon.setImage(rectangleImage[0].getScaledInstance(zoomedWidth, zoomedHeight, 4));
                rectangleLabel.repaint();
            });
            timer.setInitialDelay(0);
            if (robot[0] != null) {
                timer.start();
            }
            JPanel rectangleSelectorPanel = new JPanel();
            rectangleSelectorPanel.setLayout(new BoxLayout(rectangleSelectorPanel, 3));
            rectangleSelectorPanel.setBorder(new CompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            directionsLabel.setAlignmentX(0.5f);
            rectangleSelectorPanel.add(directionsLabel);
            rectangleSelectorPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            rectangleLabel.setAlignmentX(0.5f);
            rectangleSelectorPanel.add(rectangleLabel);
            JDialog parent = GenericGUIUtilities.getParentDialog(ScreenRectangleSelectionButton.this);
            final JDialog rectangleSelector = new JDialog((Window)parent, Dialog.ModalityType.APPLICATION_MODAL);
            rectangleSelector.setContentPane(rectangleSelectorPanel);
            rectangleSelector.setUndecorated(true);
            rectangleSelector.setAlwaysOnTop(true);
            rectangleSelector.setDefaultCloseOperation(0);
            rectangleSelector.addKeyListener(new KeyAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void keyReleased(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 10: {
                            timer.stop();
                            rectangleSelector.dispose();
                            BufferedImage selectedRectangleImage = new BufferedImage(iconWidth, iconHeight, 1);
                            Graphics2D g = selectedRectangleImage.createGraphics();
                            try {
                                int sx1 = Math.round((float)iconWidth * 0.25f);
                                int sy1 = Math.round((float)iconHeight * 0.25f);
                                int sx2 = iconWidth + sx1;
                                int sy2 = iconHeight + sy1;
                                g.drawImage(rectangleImage[0], 0, 0, iconWidth, iconHeight, sx1, sy1, sx2, sy2, null);
                            }
                            finally {
                                g.dispose();
                            }
                            ScreenRectangleSelectionButton.this.setSelectedImage(selectedRectangleImage);
                            break;
                        }
                        case 27: {
                            timer.stop();
                            rectangleSelector.dispose();
                            break;
                        }
                    }
                }
            });
            rectangleSelector.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    rectangleSelector.pack();
                    rectangleSelector.setLocationRelativeTo(ScreenRectangleSelectionButton.this);
                }
            });
            rectangleSelector.pack();
            rectangleSelector.setLocationRelativeTo(ScreenRectangleSelectionButton.this);
            rectangleSelector.setVisible(true);
        }
    }
}

