/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryModelSaver;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class JEditHistoryModelSaver
implements HistoryModelSaver {
    private static final String TO_ESCAPE = "\r\n\t\\\"'[]";
    private static File history;
    private static long historyModTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Map<String, HistoryModel> load(Map<String, HistoryModel> models) {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            return models;
        }
        history = new File(MiscUtilities.constructPath(settingsDirectory, "history"));
        if (!history.exists()) {
            return models;
        }
        historyModTime = history.lastModified();
        Log.log(3, HistoryModel.class, "Loading history");
        if (models == null) {
            models = Collections.synchronizedMap(new HashMap());
        }
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(history), StandardCharsets.UTF_8.newDecoder()));
                models.putAll(JEditHistoryModelSaver.loadFromReader(in));
            }
            catch (CharacterCodingException e) {
                in.close();
                Log.log(3, HistoryModel.class, "Failed to load history with UTF-8. Fallbacking to the system default encoding.");
                in = new BufferedReader(new FileReader(history));
                models.putAll(JEditHistoryModelSaver.loadFromReader(in));
            }
        }
        catch (FileNotFoundException e) {
            IOUtilities.closeQuietly(in);
        }
        catch (IOException io) {
            Log.log(9, HistoryModel.class, io);
            {
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtilities.closeQuietly(in);
        }
        IOUtilities.closeQuietly(in);
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(Map<String, HistoryModel> models) {
        Log.log(3, HistoryModel.class, "Saving history");
        File file1 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "#history#save#"));
        File file2 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "history"));
        if (file2.exists() && file2.lastModified() != historyModTime) {
            Log.log(7, HistoryModel.class, String.valueOf(file2) + " changed on disk; will not save history");
            return false;
        }
        jEdit.backupSettingsFile(file2);
        String lineSep = System.getProperty("line.separator");
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file1), StandardCharsets.UTF_8));
            if (models != null) {
                Collection<HistoryModel> values = models.values();
                for (HistoryModel model : values) {
                    if (model.getSize() == 0) continue;
                    out.write(91);
                    out.write(StandardUtilities.charsToEscapes(model.getName(), TO_ESCAPE));
                    out.write(93);
                    out.write(lineSep);
                    for (int i = 0; i < model.getSize(); ++i) {
                        out.write(StandardUtilities.charsToEscapes(model.getItem(i), TO_ESCAPE));
                        out.write(lineSep);
                    }
                }
            }
            out.close();
            file2.delete();
            file1.renameTo(file2);
            IOUtilities.closeQuietly(out);
        }
        catch (IOException io) {
            Log.log(9, HistoryModel.class, io);
        }
        finally {
            IOUtilities.closeQuietly(out);
        }
        historyModTime = file2.lastModified();
        return true;
    }

    private static Map<String, HistoryModel> loadFromReader(BufferedReader in) throws IOException {
        String line;
        HashMap<String, HistoryModel> result = new HashMap<String, HistoryModel>();
        HistoryModel currentModel = null;
        while ((line = in.readLine()) != null) {
            if (!line.isEmpty() && line.charAt(0) == '[' && line.charAt(line.length() - 1) == ']') {
                if (currentModel != null) {
                    result.put(currentModel.getName(), currentModel);
                }
                String modelName = MiscUtilities.escapesToChars(line.substring(1, line.length() - 1));
                currentModel = new HistoryModel(modelName);
                continue;
            }
            if (currentModel == null) {
                throw new IOException("History data starts before model name");
            }
            currentModel.addElement(MiscUtilities.escapesToChars(line));
        }
        if (currentModel != null) {
            result.put(currentModel.getName(), currentModel);
        }
        return result;
    }
}

