/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.GenericGUIUtilities;

public class FilesChangedDialog
extends EnhancedDialog {
    private final View view;
    private final JTree bufferTree;
    private final DefaultTreeModel bufferTreeModel;
    private final DefaultMutableTreeNode root;
    private boolean selectAllInProgress;
    private JButton reload;
    private JButton ignore;

    public FilesChangedDialog(View view, int[] states, boolean alreadyReloaded) {
        super(view, jEdit.getProperty("files-changed.title"), false);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setContentPane(content);
        Box iconBox = new Box(1);
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.warningIcon")));
        iconBox.add(Box.createGlue());
        content.add("West", iconBox);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(jEdit.getProperty("files-changed.caption"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        centerPanel.add("North", label);
        DefaultMutableTreeNode deleted = new DefaultMutableTreeNode(jEdit.getProperty("files-changed.deleted"), true);
        DefaultMutableTreeNode changed = new DefaultMutableTreeNode(jEdit.getProperty("files-changed.changed" + (alreadyReloaded ? "-auto" : "")), true);
        DefaultMutableTreeNode changedDirty = new DefaultMutableTreeNode(jEdit.getProperty("files-changed.changed-dirty" + (alreadyReloaded ? "-auto" : "")), true);
        List<Buffer> buffers = jEdit.getBufferManager().getBuffers();
        for (int i = 0; i < states.length; ++i) {
            DefaultMutableTreeNode addTo;
            Buffer buffer = buffers.get(i);
            switch (states[i]) {
                case 2: {
                    addTo = deleted;
                    break;
                }
                case 1: {
                    addTo = buffer.isDirty() ? changedDirty : changed;
                    break;
                }
                default: {
                    addTo = null;
                }
            }
            if (addTo == null) continue;
            addTo.add(new DefaultMutableTreeNode(buffer.getPath()));
        }
        this.root = new DefaultMutableTreeNode("", true);
        if (deleted.getChildCount() != 0) {
            this.root.add(deleted);
        }
        if (changed.getChildCount() != 0) {
            this.root.add(changed);
        }
        if (changedDirty.getChildCount() != 0) {
            this.root.add(changedDirty);
        }
        this.bufferTreeModel = new DefaultTreeModel(this.root);
        this.bufferTree = new JTree(this.bufferTreeModel);
        this.bufferTree.setRowHeight(0);
        this.bufferTree.setRootVisible(false);
        this.bufferTree.setVisibleRowCount(10);
        this.bufferTree.setCellRenderer(new Renderer());
        this.bufferTree.getSelectionModel().addTreeSelectionListener(new TreeHandler());
        this.bufferTree.getSelectionModel().setSelectionMode(4);
        centerPanel.add("Center", new JScrollPane(this.bufferTree));
        content.add("Center", centerPanel);
        Box buttons = new Box(0);
        buttons.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 0));
        buttons.add(Box.createGlue());
        if (!alreadyReloaded) {
            JButton selectAll = new JButton(jEdit.getProperty("files-changed.select-all"));
            selectAll.setMnemonic(jEdit.getProperty("files-changed.select-all.mnemonic").charAt(0));
            buttons.add(selectAll);
            selectAll.addActionListener(e -> this.selectAll());
            buttons.add(Box.createHorizontalStrut(6));
            this.reload = new JButton(jEdit.getProperty("files-changed.reload"));
            this.reload.setMnemonic(jEdit.getProperty("files-changed.reload.mnemonic").charAt(0));
            buttons.add(this.reload);
            this.reload.addActionListener(e -> this.action("RELOAD"));
            buttons.add(Box.createHorizontalStrut(6));
            this.ignore = new JButton(jEdit.getProperty("files-changed.ignore"));
            this.ignore.setMnemonic(jEdit.getProperty("files-changed.ignore.mnemonic").charAt(0));
            buttons.add(this.ignore);
            this.ignore.addActionListener(e -> this.action("IGNORE"));
            buttons.add(Box.createHorizontalStrut(6));
        }
        JButton close = new JButton(jEdit.getProperty("common.close"));
        this.getRootPane().setDefaultButton(close);
        buttons.add(close);
        close.addActionListener(e -> this.dispose());
        content.add("South", buttons);
        this.bufferTree.expandPath(new TreePath(new Object[]{this.root, deleted}));
        this.bufferTree.expandPath(new TreePath(new Object[]{this.root, changed}));
        this.bufferTree.expandPath(new TreePath(new Object[]{this.root, changedDirty}));
        GenericGUIUtilities.requestFocus(this, this.bufferTree);
        this.updateEnabled();
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    private void updateEnabled() {
        TreePath[] paths = this.bufferTree.getSelectionPaths();
        boolean enabled = false;
        if (paths != null) {
            for (TreePath tp : paths) {
                Object[] path = tp.getPath();
                if (path.length != 3) continue;
                enabled = true;
            }
        }
        if (this.reload != null) {
            this.reload.setEnabled(enabled);
        }
        if (this.ignore != null) {
            this.ignore.setEnabled(enabled);
        }
    }

    private void selectAll() {
        this.selectAllInProgress = true;
        Object[] path = new TreeNode[3];
        path[0] = this.root;
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            path[1] = node;
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)node.getChildAt(j);
                path[2] = node2;
                this.bufferTree.getSelectionModel().addSelectionPath(new TreePath(path));
            }
        }
        this.selectAllInProgress = false;
        this.updateEnabled();
    }

    private void action(String action) {
        TreePath[] paths = this.bufferTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        int row = this.bufferTree.getRowForPath(paths[0]);
        BufferManager bufferManager = jEdit.getBufferManager();
        for (TreePath path : paths) {
            if (path.getPathCount() == 2) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!(node.getUserObject() instanceof String)) {
                return;
            }
            bufferManager.getBuffer((String)node.getUserObject()).ifPresent(buffer -> {
                if ("RELOAD".equals(action)) {
                    buffer.reload(this.view);
                } else {
                    buffer.setAutoReload(false);
                    buffer.setAutoReloadDialog(false);
                }
                MutableTreeNode parent = (MutableTreeNode)node.getParent();
                parent.remove(node);
            });
        }
        this.bufferTreeModel.reload(this.root);
        Object[] nodes = new TreeNode[]{this.root, null};
        for (int j = 0; j < this.root.getChildCount(); ++j) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(j);
            if (this.root.getChildAt(j).getChildCount() == 0) {
                this.root.remove(j);
                --j;
                continue;
            }
            nodes[1] = node;
            this.bufferTree.expandPath(new TreePath(nodes));
        }
        if (this.root.getChildCount() == 0) {
            this.dispose();
        } else {
            TreePath path;
            if (row >= this.bufferTree.getRowCount()) {
                row = this.bufferTree.getRowCount() - 1;
            }
            if ((path = this.bufferTree.getPathForRow(row)).getPathCount() == 2) {
                this.bufferTree.setSelectionRow(row + 1);
            } else {
                this.bufferTree.setSelectionPath(path);
            }
        }
    }

    static class Renderer
    extends EnhancedTreeCellRenderer {
        private Font entryFont = UIManager.getFont("Tree.font");
        private final Font groupFont;

        Renderer() {
            if (this.entryFont == null) {
                this.entryFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.groupFont = this.entryFont.deriveFont(1);
        }

        @Override
        protected TreeCellRenderer newInstance() {
            return new Renderer();
        }

        @Override
        protected void configureTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getParent() == tree.getModel().getRoot()) {
                this.setFont(this.groupFont);
            } else {
                this.setFont(this.entryFont);
            }
            this.setIcon(null);
        }
    }

    class TreeHandler
    implements TreeSelectionListener {
        TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            if (FilesChangedDialog.this.selectAllInProgress) {
                return;
            }
            FilesChangedDialog.this.updateEnabled();
            TreePath[] paths = FilesChangedDialog.this.bufferTree.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return;
            }
            TreePath path = paths[paths.length - 1];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof String) {
                jEdit.getBufferManager().getBuffer((String)node.getUserObject()).ifPresent(buffer -> FilesChangedDialog.this.view.showBuffer((Buffer)buffer));
            }
        }
    }
}

