/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;

public class UndoManager {
    private final JEditBuffer buffer;
    private Edit undosFirst;
    private Edit undosLast;
    private Edit redosFirst;
    private int limit;
    private int undoCount;
    private int compoundEditCount;
    private CompoundEdit compoundEdit;
    private Edit undoClearDirty;
    private Edit redoClearDirty;
    private Object undoId;

    public UndoManager(JEditBuffer buffer) {
        this.buffer = buffer;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void clear() {
        this.redosFirst = null;
        this.undosLast = null;
        this.undosFirst = null;
        this.undoCount = 0;
    }

    public boolean canUndo() {
        return this.undosLast != null;
    }

    public Selection[] undo() {
        if (this.insideCompoundEdit()) {
            throw new InternalError("Unbalanced begin/endCompoundEdit()");
        }
        if (this.undosLast == null) {
            return null;
        }
        this.reviseUndoId();
        --this.undoCount;
        Selection[] selections = this.undosLast.undo(this);
        this.redosFirst = this.undosLast;
        this.undosLast = this.undosLast.prev;
        if (this.undosLast == null) {
            this.undosFirst = null;
        }
        return selections;
    }

    public boolean canRedo() {
        return this.redosFirst != null;
    }

    public Selection[] redo() {
        if (this.insideCompoundEdit()) {
            throw new InternalError("Unbalanced begin/endCompoundEdit()");
        }
        if (this.redosFirst == null) {
            return null;
        }
        this.reviseUndoId();
        ++this.undoCount;
        Selection[] s = this.redosFirst.redo(this);
        this.undosLast = this.redosFirst;
        if (this.undosFirst == null) {
            this.undosFirst = this.undosLast;
        }
        this.redosFirst = this.redosFirst.next;
        return s;
    }

    public void beginCompoundEdit() {
        if (this.compoundEditCount == 0) {
            this.compoundEdit = new CompoundEdit();
            this.reviseUndoId();
        }
        ++this.compoundEditCount;
    }

    public void endCompoundEdit() {
        if (this.compoundEditCount == 0) {
            Log.log(7, this, new Exception("Unbalanced begin/endCompoundEdit()"));
            return;
        }
        if (this.compoundEditCount == 1) {
            if (this.compoundEdit.first != null) {
                if (this.compoundEdit.first == this.compoundEdit.last) {
                    this.addEdit(this.compoundEdit.first);
                } else {
                    this.addEdit(this.compoundEdit);
                }
            }
            this.compoundEdit = null;
        }
        --this.compoundEditCount;
    }

    public boolean insideCompoundEdit() {
        return this.compoundEditCount != 0;
    }

    public Object getUndoId() {
        return this.undoId;
    }

    public void contentInserted(int offset, int length, String text, boolean clearDirty) {
        Insert ins;
        Edit toMerge = this.getMergeEdit();
        if (!clearDirty && toMerge instanceof Insert && this.redosFirst == null) {
            ins = (Insert)toMerge;
            if (ins.offset == offset) {
                ins.str = text.concat(ins.str);
                return;
            }
            if (ins.offset + ins.str.length() == offset) {
                ins.str = ins.str.concat(text);
                return;
            }
        }
        ins = new Insert(offset, text);
        if (clearDirty) {
            this.redoClearDirty = this.getLastEdit();
            this.undoClearDirty = ins;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.add(this, ins);
        } else {
            this.reviseUndoId();
            this.addEdit(ins);
        }
    }

    public void contentRemoved(int offset, int length, String text, boolean clearDirty) {
        Remove rem;
        Edit toMerge = this.getMergeEdit();
        if (!clearDirty && toMerge instanceof Remove && this.redosFirst == null) {
            rem = (Remove)toMerge;
            if (rem.offset == offset) {
                String newStr = rem.str.concat(text);
                KillRing.getInstance().changed(rem.str, newStr);
                rem.str = newStr;
                return;
            }
            if (offset + length == rem.offset) {
                String newStr = text.concat(rem.str);
                KillRing.getInstance().changed(rem.str, newStr);
                rem.offset = offset;
                rem.str = newStr;
                return;
            }
        }
        rem = new Remove(offset, text.intern());
        if (clearDirty) {
            this.redoClearDirty = this.getLastEdit();
            this.undoClearDirty = rem;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.add(this, rem);
        } else {
            this.reviseUndoId();
            this.addEdit(rem);
        }
        KillRing.getInstance().add(rem.str);
    }

    public void resetClearDirty() {
        this.redoClearDirty = this.getLastEdit();
        this.undoClearDirty = this.redosFirst instanceof CompoundEdit ? ((CompoundEdit)this.redosFirst).first : this.redosFirst;
    }

    private void addEdit(Edit edit) {
        if (this.undosFirst == null) {
            this.undosFirst = this.undosLast = edit;
        } else {
            this.undosLast.next = edit;
            edit.prev = this.undosLast;
            this.undosLast = edit;
        }
        this.redosFirst = null;
        ++this.undoCount;
        while (this.undoCount > this.limit) {
            --this.undoCount;
            if (this.undosFirst == this.undosLast) {
                this.undosLast = null;
                this.undosFirst = null;
                continue;
            }
            this.undosFirst.next.prev = null;
            this.undosFirst = this.undosFirst.next;
        }
    }

    private Edit getMergeEdit() {
        return this.compoundEdit != null ? this.compoundEdit.last : this.getLastEdit();
    }

    private Edit getLastEdit() {
        if (this.undosLast instanceof CompoundEdit) {
            return ((CompoundEdit)this.undosLast).last;
        }
        return this.undosLast;
    }

    private void reviseUndoId() {
        this.undoId = new Object();
    }

    private Replace getReplaceFromRemoveInsert(Edit lastElement, Edit newElement) {
        if (lastElement instanceof Remove && newElement instanceof Insert) {
            if (lastElement == this.undoClearDirty || newElement == this.undoClearDirty) {
                return null;
            }
            assert (newElement != this.redoClearDirty);
            assert (lastElement != this.redoClearDirty);
            Remove rem = (Remove)lastElement;
            Insert ins = (Insert)newElement;
            if (rem.offset == ins.offset) {
                return new Replace(rem.offset, rem.str, ins.str);
            }
        }
        return null;
    }

    private static CompressedReplace getCompressedReplaceFromReplaceReplace(Edit lastElement, Edit newElement) {
        if (newElement instanceof Replace) {
            if (lastElement instanceof CompressedReplace) {
                CompressedReplace rep = (CompressedReplace)lastElement;
                return rep.add((Replace)newElement);
            }
            if (lastElement instanceof Replace) {
                CompressedReplace rep = new CompressedReplace((Replace)lastElement);
                return rep.add((Replace)newElement);
            }
        }
        return null;
    }

    private static abstract class Edit {
        Edit prev;
        Edit next;

        private Edit() {
        }

        abstract Selection[] undo(UndoManager var1);

        abstract Selection[] redo(UndoManager var1);
    }

    private static class CompoundEdit
    extends Edit {
        Edit first;
        Edit last;

        private CompoundEdit() {
        }

        @Override
        public Selection[] undo(UndoManager mgr) {
            Selection[] retVal = null;
            Edit edit = this.last;
            while (edit != null) {
                retVal = edit.undo(mgr);
                edit = edit.prev;
            }
            return retVal;
        }

        @Override
        public Selection[] redo(UndoManager mgr) {
            Selection[] retVal = null;
            Edit edit = this.first;
            while (edit != null) {
                retVal = edit.redo(mgr);
                edit = edit.next;
            }
            return retVal;
        }

        private void _add(Edit edit) {
            if (this.first == null) {
                this.first = this.last = edit;
            } else {
                edit.prev = this.last;
                this.last.next = edit;
                this.last = edit;
            }
        }

        public void add(UndoManager mgr, Edit edit) {
            Replace rep;
            this._add(edit);
            if (this.last.prev != null && (rep = mgr.getReplaceFromRemoveInsert(this.last.prev, this.last)) != null) {
                this.exchangeLastElement(rep);
            }
            if (this.last.prev != null && (rep = UndoManager.getCompressedReplaceFromReplaceReplace(this.last.prev, this.last)) != null) {
                this.exchangeLastElement(rep);
            }
            if (this.last.prev != null && (rep = UndoManager.getCompressedReplaceFromReplaceReplace(this.last.prev, this.last)) != null) {
                this.exchangeLastElement(rep);
            }
        }

        private void exchangeLastElement(Edit edit) {
            if (this.first == this.last) {
                this.last = null;
                this.first = null;
            } else {
                this.last.prev.next = null;
                this.last = this.last.prev;
            }
            if (this.first == null || this.first == this.last) {
                this.first = this.last = edit;
            } else {
                edit.prev = this.last.prev;
                this.last.prev.next = edit;
                this.last = edit;
            }
        }
    }

    private static class Insert
    extends Edit {
        int offset;
        String str;

        Insert(int offset, String str) {
            this.offset = offset;
            this.str = str;
        }

        @Override
        Selection[] undo(UndoManager mgr) {
            mgr.buffer.remove(this.offset, this.str.length());
            if (mgr.undoClearDirty == this) {
                mgr.buffer.setDirty(false);
            }
            return new Selection[]{new Selection.Range(this.offset, this.offset)};
        }

        @Override
        Selection[] redo(UndoManager mgr) {
            mgr.buffer.insert(this.offset, this.str);
            if (mgr.redoClearDirty == this) {
                mgr.buffer.setDirty(false);
            }
            int caret = this.offset + this.str.length();
            return new Selection[]{new Selection.Range(caret, caret)};
        }
    }

    private static class Remove
    extends Edit {
        int offset;
        String str;

        Remove(int offset, String str) {
            this.offset = offset;
            this.str = str;
        }

        @Override
        Selection[] undo(UndoManager mgr) {
            mgr.buffer.insert(this.offset, this.str);
            if (mgr.undoClearDirty == this) {
                mgr.buffer.setDirty(false);
            }
            return new Selection[]{new Selection.Range(this.offset, this.offset + this.str.length())};
        }

        @Override
        Selection[] redo(UndoManager mgr) {
            mgr.buffer.remove(this.offset, this.str.length());
            if (mgr.redoClearDirty == this) {
                mgr.buffer.setDirty(false);
            }
            return new Selection[]{new Selection.Range(this.offset, this.offset)};
        }
    }

    private static class Replace
    extends Edit {
        int offset;
        String strRemove;
        String strInsert;

        Replace(int offset, String strRemove, String strInsert) {
            this.offset = offset;
            this.strRemove = strRemove;
            this.strInsert = strInsert;
        }

        @Override
        Selection[] undo(UndoManager mgr) {
            mgr.buffer.remove(this.offset, this.strInsert.length());
            mgr.buffer.insert(this.offset, this.strRemove);
            assert (mgr.undoClearDirty != this);
            return new Selection[]{new Selection.Range(this.offset, this.offset + this.strRemove.length())};
        }

        @Override
        Selection[] redo(UndoManager mgr) {
            mgr.buffer.remove(this.offset, this.strRemove.length());
            mgr.buffer.insert(this.offset, this.strInsert);
            if (mgr.redoClearDirty == this) {
                mgr.buffer.setDirty(false);
            }
            int caret = this.offset + this.strInsert.length();
            return new Selection[]{new Selection.Range(caret, caret)};
        }
    }

    private static class CompressedReplace
    extends Replace {
        IntegerArray offsets = new IntegerArray(4);

        CompressedReplace(Replace r1) {
            super(r1.offset, r1.strRemove, r1.strInsert);
            this.offsets.add(r1.offset);
        }

        CompressedReplace add(Replace rep) {
            if (this.strInsert.equals(rep.strInsert) && this.strRemove.equals(rep.strRemove)) {
                this.offsets.add(rep.offset);
                return this;
            }
            return null;
        }

        @Override
        Selection[] undo(UndoManager mgr) {
            Selection[] s = null;
            for (int i = this.offsets.getSize() - 1; i >= 0; --i) {
                this.offset = this.offsets.get(i);
                s = super.undo(mgr);
            }
            return s;
        }

        @Override
        Selection[] redo(UndoManager mgr) {
            Selection[] s = null;
            for (int i = 0; i < this.offsets.getSize(); ++i) {
                this.offset = this.offsets.get(i);
                s = super.redo(mgr);
            }
            return s;
        }
    }
}

