/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.Capabilities;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.SimpleNode;

public class TargetError
extends EvalError {
    Throwable target;
    boolean inNativeCode;

    public TargetError(String msg, Throwable t, SimpleNode node, CallStack callstack, boolean inNativeCode) {
        super(msg, node, callstack);
        this.target = t;
        this.inNativeCode = inNativeCode;
    }

    public TargetError(Throwable t, SimpleNode node, CallStack callstack) {
        this("TargetError", t, node, callstack, false);
    }

    public Throwable getTarget() {
        if (this.target instanceof InvocationTargetException) {
            return ((InvocationTargetException)this.target).getTargetException();
        }
        return this.target;
    }

    @Override
    public String toString() {
        return super.toString() + "\nTarget exception: " + this.printTargetError(this.target);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(false, System.err);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        this.printStackTrace(false, out);
    }

    public void printStackTrace(boolean debug, PrintStream out) {
        if (debug) {
            super.printStackTrace(out);
            out.println("--- Target Stack Trace ---");
        }
        this.target.printStackTrace(out);
    }

    public String printTargetError(Throwable t) {
        Object s = this.target.toString();
        if (Capabilities.canGenerateInterfaces()) {
            s = (String)s + "\n" + this.xPrintTargetError(t);
        }
        return s;
    }

    public String xPrintTargetError(Throwable t) {
        String getTarget = "import java.lang.reflect.UndeclaredThrowableException;String result=\"\";while ( target instanceof UndeclaredThrowableException ) {\ttarget=target.getUndeclaredThrowable(); \tresult+=\"Nested: \"+target.toString();}return result;";
        Interpreter i = new Interpreter();
        try {
            i.set("target", t);
            return (String)i.eval(getTarget);
        }
        catch (EvalError e) {
            throw new InterpreterError("xprintarget: " + e.toString());
        }
    }

    public boolean inNativeCode() {
        return this.inNativeCode;
    }
}

