/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.BrowserCommandsMenu;
import org.gjt.sp.jedit.browser.BrowserListener;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.DeleteBrowserTask;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.MkDirBrowserTask;
import org.gjt.sp.jedit.browser.RenameBrowserTask;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTable;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.datatransfer.ListVFSFileTransferable;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindow;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.FilePropertiesDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.CopyFileWorker;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.GlobVFSFileFilter;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSFileFilter;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class VFSBrowser
extends JPanel
implements DefaultFocusComponent,
DockableWindow {
    public static final String NAME = "vfs.browser";
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int BROWSER_DIALOG = 4;
    public static final int CHOOSE_DIRECTORY_DIALOG = 3;
    public static final int BROWSER = 2;
    public static final int M_OPEN = 0;
    public static final int M_OPEN_NEW_VIEW = 1;
    public static final int M_OPEN_NEW_PLAIN_VIEW = 2;
    public static final int M_OPEN_NEW_SPLIT = 3;
    public static final int M_INSERT = 4;
    String currentEncoding;
    boolean autoDetectEncoding;
    private static final ActionContext actionContext = new BrowserActionContext();
    private final EventListenerList listenerList;
    private final View view;
    private boolean horizontalLayout;
    private String path;
    private final JPanel pathAndFilterPanel;
    private final HistoryTextField pathField;
    private JComponent defaultFocusComponent;
    private final JCheckBox filterCheckbox;
    private final HistoryComboBoxEditor filterEditor;
    private final JComboBox<VFSFileFilter> filterField;
    private Box toolbarBox;
    private final Box topBox;
    private FavoritesMenuButton favorites;
    private PluginsMenuButton plugins;
    private final BrowserView browserView;
    private final int mode;
    private final boolean multipleSelection;
    private boolean showHiddenFiles;
    private boolean sortMixFilesAndDirs;
    private boolean sortIgnoreCase;
    private boolean doubleClickClose;
    private boolean requestRunning;
    private boolean maybeReloadRequestRunning;
    private final Stack<String> historyStack = new Stack();
    private final Stack<String> nextDirectoryStack = new Stack();

    public static void browseDirectoryInNewWindow(View view, String path) {
        DockableWindowManager wm = view.getDockableWindowManager();
        if (path != null) {
            jEdit.setTemporaryProperty("vfs.browser.path.tmp", path);
        }
        wm.floatDockableWindow(NAME);
        jEdit.unsetProperty("vfs.browser.path.tmp");
    }

    public static void browseDirectory(View view, String path) {
        DockableWindowManager wm = view.getDockableWindowManager();
        VFSBrowser browser = (VFSBrowser)wm.getDockable(NAME);
        if (browser != null) {
            wm.showDockableWindow(NAME);
            browser.setDirectory(path);
        } else {
            if (path != null) {
                jEdit.setTemporaryProperty("vfs.browser.path.tmp", path);
            }
            wm.addDockableWindow(NAME);
            jEdit.unsetProperty("vfs.browser.path.tmp");
        }
    }

    public static ActionContext getActionContext() {
        return actionContext;
    }

    public VFSBrowser(View view, String position) {
        this(view, null, 2, true, position);
    }

    public VFSBrowser(View view, String path, int mode, boolean multipleSelection, String position) {
        super(new BorderLayout());
        Object filter;
        this.listenerList = new EventListenerList();
        this.mode = mode;
        this.multipleSelection = multipleSelection;
        this.view = view;
        this.currentEncoding = null;
        this.autoDetectEncoding = jEdit.getBooleanProperty("buffer.encodingAutodetect");
        ActionHandler actionHandler = new ActionHandler();
        this.topBox = new Box(1);
        this.horizontalLayout = mode != 2 || "top".equals(position) || "bottom".equals(position);
        this.toolbarBox = new Box(this.horizontalLayout ? 0 : 1);
        this.topBox.add(this.toolbarBox);
        GridBagLayout layout = new GridBagLayout();
        this.pathAndFilterPanel = new JPanel(layout);
        if (this.isHorizontalLayout()) {
            this.pathAndFilterPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        }
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridy = 0;
        cons.gridx = 0;
        cons.fill = 1;
        cons.anchor = 13;
        JLabel label = new JLabel(jEdit.getProperty("vfs.browser.path"), 4);
        label.setBorder(new EmptyBorder(0, 0, 0, 12));
        layout.setConstraints(label, cons);
        this.pathAndFilterPanel.add(label);
        this.pathField = new HistoryTextField("vfs.browser.path");
        this.pathField.setName("path");
        this.pathField.setInstantPopups(true);
        this.pathField.setEnterAddsToHistory(false);
        this.pathField.setSelectAllOnFocus(true);
        label.setLabelFor(this.pathField);
        Dimension prefSize = this.pathField.getPreferredSize();
        prefSize.width = 0;
        this.pathField.setPreferredSize(prefSize);
        this.pathField.addActionListener(actionHandler);
        cons.gridx = 1;
        cons.weightx = 1.0;
        cons.gridwidth = 0;
        layout.setConstraints(this.pathField, cons);
        this.pathAndFilterPanel.add(this.pathField);
        this.filterCheckbox = new JCheckBox(jEdit.getProperty("vfs.browser.filter"));
        this.filterCheckbox.putClientProperty("AccessibleName", "Filter enabled");
        this.filterCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.filterCheckbox.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.filterCheckbox.setSelected(jEdit.getBooleanProperty("vfs.browser.filter-enabled"));
        this.filterCheckbox.addActionListener(actionHandler);
        this.filterCheckbox.setName("filter-checkbox");
        if (mode != 3) {
            cons.gridwidth = 1;
            cons.gridx = 0;
            cons.weightx = 0.0;
            cons.gridy = 1;
            layout.setConstraints(this.filterCheckbox, cons);
            this.pathAndFilterPanel.add(this.filterCheckbox);
        }
        String filterTooltip = jEdit.getProperty("vfs.browser.filter") + " " + jEdit.getProperty("glob.tooltip");
        this.filterField = new JComboBox();
        this.filterEditor = new HistoryComboBoxEditor("vfs.browser.filter");
        this.filterEditor.putClientProperty("AccessibleName", filterTooltip);
        this.filterEditor.setToolTipText(filterTooltip);
        this.filterEditor.setInstantPopups(true);
        this.filterEditor.setSelectAllOnFocus(true);
        this.filterEditor.addActionListener(actionHandler);
        this.filterField.setName("filter-field");
        if (mode == 2) {
            DockableWindowManager dwm = view.getDockableWindowManager();
            KeyListener keyListener = dwm.closeListener(NAME);
            this.filterCheckbox.addKeyListener(keyListener);
            this.addKeyListener(keyListener);
            this.filterEditor.addKeyListener(keyListener);
            this.pathField.addKeyListener(keyListener);
            this.pathField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        VFSBrowser.this.pathField.setText(VFSBrowser.this.path);
                    }
                }
            });
        }
        if (mode == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) {
            filter = jEdit.getProperty("vfs.browser.last-filter");
            if (filter == null) {
                filter = jEdit.getProperty("vfs.browser.default-filter");
            }
        } else {
            String ext = MiscUtilities.getFileExtension(view.getBuffer().getName());
            filter = ext.isEmpty() ? jEdit.getProperty("vfs.browser.default-filter") : "*" + ext;
        }
        this.filterEditor.setItem(new GlobVFSFileFilter((String)filter));
        this.filterField.addItem((VFSFileFilter)this.filterEditor.getItem());
        this.filterField.addItemListener(actionHandler);
        this.filterField.setRenderer(new VFSFileFilterRenderer());
        String[] _filters = ServiceManager.getServiceNames(VFSFileFilter.SERVICE_NAME);
        for (int i = 0; i < _filters.length; ++i) {
            VFSFileFilter _filter = (VFSFileFilter)ServiceManager.getService(VFSFileFilter.SERVICE_NAME, _filters[i]);
            this.filterField.addItem(_filter);
        }
        if (mode != 3) {
            cons.gridwidth = 0;
            cons.fill = 2;
            cons.gridx = 1;
            cons.weightx = 1.0;
            if (this.filterField.getItemCount() > 1) {
                this.filterField.setEditor(this.filterEditor);
                this.filterField.setEditable(true);
                layout.setConstraints(this.filterField, cons);
                this.pathAndFilterPanel.add(this.filterField);
            } else {
                layout.setConstraints(this.filterEditor, cons);
                this.pathAndFilterPanel.add(this.filterEditor);
            }
        }
        this.topBox.add(this.pathAndFilterPanel);
        this.add("North", this.topBox);
        this.browserView = new BrowserView(this);
        this.add("Center", this.browserView);
        if (this.isHorizontalLayout()) {
            this.browserView.setBorder(new EmptyBorder(0, 12, 0, 12));
        }
        this.defaultFocusComponent = this.browserView.getTable();
        this.propertiesChanged();
        this.updateFilterEnabled();
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        if (path == null) {
            path = jEdit.getProperty("vfs.browser.path.tmp");
        }
        if (path == null || path.isEmpty()) {
            String userHome = System.getProperty("user.home");
            String defaultPath = jEdit.getProperty("vfs.browser.defaultPath");
            if ("home".equals(defaultPath)) {
                path = userHome;
            } else if ("working".equals(defaultPath)) {
                path = System.getProperty("user.dir");
            } else if ("buffer".equals(defaultPath)) {
                boolean browseable;
                Buffer buffer = view.getBuffer();
                boolean bl = browseable = (buffer.getVFS().getCapabilities() & 4) != 0;
                if (browseable) {
                    path = buffer.getDirectory();
                }
            } else if ("last".equals(defaultPath)) {
                path = VFSBrowser.getLastVisitedPath();
                if (path == null) {
                    path = "~";
                }
            } else if ("favorites".equals(defaultPath)) {
                path = "favorites:";
            }
            if (path == null || path.isEmpty()) {
                path = userHome;
            }
        }
        final String _path = path;
        ThreadUtilities.runInDispatchThread(new Runnable(){

            @Override
            public void run() {
                VFSBrowser.this.setDirectory(_path);
            }
        });
    }

    @Override
    public void focusOnDefaultComponent() {
        this.defaultFocusComponent.requestFocus();
    }

    void setDefaultFocusComponent(JComponent c) {
        this.defaultFocusComponent = c;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        VFSFileFilter selectedFilter;
        super.removeNotify();
        jEdit.setBooleanProperty("vfs.browser.filter-enabled", this.filterCheckbox.isSelected());
        if ((this.mode == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) && (selectedFilter = (VFSFileFilter)this.filterField.getSelectedItem()) instanceof GlobVFSFileFilter) {
            jEdit.setProperty("vfs.browser.last-filter", ((GlobVFSFileFilter)selectedFilter).getGlob());
        }
        EditBus.removeFromBus(this);
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bmsg) {
        if (bmsg.getWhat() == BufferUpdate.CREATED || bmsg.getWhat() == BufferUpdate.CLOSED) {
            this.browserView.updateFileView();
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pmsg) {
        if ((pmsg.getWhat() == PluginUpdate.LOADED || pmsg.getWhat() == PluginUpdate.UNLOADED) && this.plugins != null) {
            this.plugins.updatePopupMenu();
        }
    }

    @EditBus.EBHandler
    public void handleVFSUpdate(VFSUpdate msg) {
        this.maybeReloadDirectory(msg.getPath());
    }

    public View getView() {
        return this.view;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isMultipleSelectionEnabled() {
        return this.multipleSelection;
    }

    public boolean isHorizontalLayout() {
        return this.horizontalLayout;
    }

    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
    }

    public VFSFileFilter getVFSFileFilter() {
        if (this.mode == 3) {
            return new DirectoriesOnlyFilter();
        }
        return (VFSFileFilter)this.filterField.getSelectedItem();
    }

    public void addVFSFileFilter(VFSFileFilter filter) {
        this.filterField.addItem(filter);
        if (this.filterField.getItemCount() == 2) {
            this.filterField.setEditor(this.filterEditor);
            this.filterField.setEditable(true);
            GridBagLayout layout = (GridBagLayout)this.pathAndFilterPanel.getLayout();
            GridBagConstraints cons = layout.getConstraints(this.filterEditor);
            cons.gridwidth = 0;
            cons.fill = 2;
            cons.gridx = 1;
            cons.weightx = 1.0;
            this.pathAndFilterPanel.remove(this.filterEditor);
            layout.setConstraints(this.filterField, cons);
            this.pathAndFilterPanel.add(this.filterField);
            this.pathAndFilterPanel.validate();
            this.pathAndFilterPanel.repaint();
        }
    }

    public void setFilenameFilter(@Nullable String filter) {
        if (filter == null || filter.isEmpty() || "*".equals(filter)) {
            this.filterCheckbox.setSelected(false);
        } else {
            this.filterCheckbox.setSelected(true);
            this.filterEditor.setItem(new GlobVFSFileFilter(filter));
        }
    }

    public HistoryTextField getDirectoryField() {
        return this.pathField;
    }

    public String getDirectory() {
        return this.path;
    }

    public void previousDirectory() {
        if (this.historyStack.size() > 1) {
            this.historyStack.pop();
            this.nextDirectoryStack.push(this.path);
            this.setDirectory(this.historyStack.peek());
            this.historyStack.pop();
        }
    }

    public void nextDirectory() {
        if (!this.nextDirectoryStack.isEmpty()) {
            this.setDirectory(this.nextDirectoryStack.pop());
        }
    }

    public static String getLastVisitedPath() {
        HistoryModel pathModel = HistoryModel.getModel("vfs.browser.path");
        if (pathModel.getSize() == 0) {
            return null;
        }
        return pathModel.getItem(0);
    }

    public void setDirectory(String path) {
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        path = MiscUtilities.expandVariables(path);
        this.pathField.setText(path);
        if (!this.startRequest()) {
            return;
        }
        this.historyStack.push(path);
        this.browserView.saveExpansionState();
        this.browserView.loadDirectory(null, path, true, this::endRequest);
        this.path = path;
    }

    public static String getRootDirectory() {
        if (OperatingSystem.isMacOS() || OperatingSystem.isWindows()) {
            return "roots:";
        }
        return "/";
    }

    public void rootDirectory() {
        this.setDirectory(VFSBrowser.getRootDirectory());
    }

    public void reloadDirectory() {
        VFSManager.getVFSForPath(this.path).reloadDirectory(this.path);
        this.browserView.saveExpansionState();
        this.browserView.loadDirectory(null, this.path, false);
    }

    public void delete(VFSFile[] files) {
        String dialogType = MiscUtilities.isURL(files[0].getDeletePath()) && "favorites".equals(MiscUtilities.getProtocolOfURL(files[0].getDeletePath())) ? "vfs.browser.delete-favorites" : "vfs.browser.delete-confirm";
        String typeStr = "files";
        for (VFSFile file : files) {
            if (file.getType() != 1) continue;
            typeStr = "directories and their contents";
            break;
        }
        Object[] args = new Object[]{"", typeStr};
        JList<VFSFile> list = new JList<VFSFile>(files);
        list.setVisibleRowCount(10);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new JScrollPane(list));
        panel.add((Component)new JLabel(jEdit.getProperty(dialogType + ".message", args)), "First");
        int result = JOptionPane.showConfirmDialog(this, panel, jEdit.getProperty(dialogType + ".title"), 2, 3);
        if (result != 0) {
            return;
        }
        VFS vfs = VFSManager.getVFSForPath(files[0].getDeletePath());
        if (!this.startRequest()) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(files.length);
        for (int i = 0; i < files.length; ++i) {
            Object session = vfs.createVFSSession(files[i].getDeletePath(), this);
            if (session == null) {
                latch.countDown();
                continue;
            }
            final DeleteBrowserTask task = new DeleteBrowserTask(this, session, vfs, files[i].getDeletePath());
            TaskManager.instance.addTaskListener(new TaskListener(){

                @Override
                public void done(Task t) {
                    if (task == t) {
                        latch.countDown();
                        TaskManager.instance.removeTaskListener(this);
                    }
                }
            });
            ThreadUtilities.runInBackground(task);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Log.log(9, this, e, e);
        }
        EventQueue.invokeLater(this::endRequest);
    }

    public void rename(VFSFile from) {
        String filename;
        if (from instanceof FavoritesVFS.Favorite) {
            FavoritesVFS.Favorite favorite = (FavoritesVFS.Favorite)from;
            filename = favorite.getLabel();
        } else {
            filename = from.getName();
        }
        Object[] args = new String[]{filename};
        String to = GUIUtilities.input(this, "vfs.browser.rename", args, filename);
        if (to == null) {
            return;
        }
        this.rename(from.getVFS(), from.getPath(), to);
    }

    public void rename(VFSFile from, String to) {
        this.rename(from.getVFS(), from.getPath(), to);
    }

    public void rename(String from) {
        VFS vfs = VFSManager.getVFSForPath(from);
        String filename = vfs.getFileName(from);
        Object[] args = new String[]{filename};
        String to = GUIUtilities.input(this, "vfs.browser.rename", args, filename);
        if (to == null) {
            return;
        }
        this.rename(from, to);
    }

    private void rename(VFS vfs, String from, String newname) {
        Object session;
        String filename = vfs.getFileName(from);
        String to = newname;
        if (to == null) {
            return;
        }
        if (!(vfs instanceof FavoritesVFS)) {
            if (filename.equals(newname)) {
                return;
            }
            to = MiscUtilities.constructPath(vfs.getParentOfPath(from), to);
        }
        if ((session = vfs.createVFSSession(from, this)) == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        RenameBrowserTask renameTask = new RenameBrowserTask(this, session, vfs, from, to, this::endRequest);
        ThreadUtilities.runInBackground(renameTask);
    }

    public void rename(String from, String newname) {
        VFS vfs = VFSManager.getVFSForPath(from);
        this.rename(vfs, from, newname);
    }

    public void mkdir() {
        String parent;
        String newDirectory = GUIUtilities.input(this, "vfs.browser.mkdir", null);
        if (newDirectory == null) {
            return;
        }
        VFSFile[] selected = this.getSelectedFiles();
        if (selected.length == 0) {
            parent = this.path;
        } else if (selected[0].getType() == 0) {
            parent = selected[0].getPath();
            parent = VFSManager.getVFSForPath(parent).getParentOfPath(parent);
        } else {
            parent = selected[0].getPath();
        }
        VFS vfs = VFSManager.getVFSForPath(parent);
        newDirectory = MiscUtilities.constructPath(parent, newDirectory);
        Object session = vfs.createVFSSession(newDirectory, this);
        if (session == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        Runnable runnable = () -> {
            this.endRequest();
            if (selected.length != 0 && selected[0].getType() != 0) {
                VFSDirectoryEntryTable directoryEntryTable = this.browserView.getTable();
                int selectedRow = directoryEntryTable.getSelectedRow();
                VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)directoryEntryTable.getModel();
                VFSDirectoryEntryTableModel.Entry entry = model.files[selectedRow];
                if (!entry.expanded) {
                    this.browserView.clearExpansionState();
                    this.browserView.loadDirectory(entry, entry.dirEntry.getPath(), false);
                }
            }
        };
        MkDirBrowserTask mkdirTask = new MkDirBrowserTask(this, session, vfs, newDirectory, runnable);
        ThreadUtilities.runInBackground(mkdirTask);
    }

    public void newFile() {
        VFSFile[] selected = this.getSelectedFiles();
        if (selected.length >= 1) {
            VFSFile file = selected[0];
            if (file.getType() == 1) {
                jEdit.newFile(this.view, file.getPath());
            } else {
                VFS vfs = VFSManager.getVFSForPath(file.getPath());
                jEdit.newFile(this.view, vfs.getParentOfPath(file.getPath()));
            }
        } else {
            jEdit.newFile(this.view, this.path);
        }
    }

    public void fileProperties(VFSFile[] files) {
        new FilePropertiesDialog(this.view, this, files);
    }

    public void searchInDirectory() {
        VFSFile[] selected = this.getSelectedFiles();
        if (selected.length >= 1) {
            VFSFile file = selected[0];
            this.searchInDirectory(file.getPath(), file.getType() != 0);
        } else {
            this.searchInDirectory(this.path, true);
        }
    }

    public void searchInDirectory(String path, boolean directory) {
        VFSFileFilter vfsff = this.getVFSFileFilter();
        Object filter = vfsff instanceof GlobVFSFileFilter ? ((GlobVFSFileFilter)vfsff).getGlob() : "*";
        if (!directory) {
            String name = MiscUtilities.getFileName(path);
            String ext = MiscUtilities.getFileExtension(name);
            filter = ext.isEmpty() ? filter : "*" + ext;
            path = MiscUtilities.getParentOfPath(path);
        }
        SearchAndReplace.setSearchFileSet(new DirectoryListSet(path, (String)filter, true));
        SearchDialog.showSearchDialog(this.view, null, 2);
    }

    BrowserView getBrowserView() {
        return this.browserView;
    }

    public VFSFile[] getSelectedFiles() {
        return this.browserView.getSelectedFiles();
    }

    public VFSFile[] getSelectedFiles(Component source) {
        if (GUIUtilities.getComponentParent(source, BrowserView.ParentDirectoryList.class) != null) {
            Object[] selected = this.getBrowserView().getParentDirectoryList().getSelectedValuesList().toArray();
            VFSFile[] returnValue = new VFSFile[selected.length];
            System.arraycopy(selected, 0, returnValue, 0, selected.length);
            return returnValue;
        }
        return this.getSelectedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paste(VFSFile file) throws IOException, UnsupportedFlavorException {
        String targetPath;
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        switch (file.getType()) {
            case 2: {
                return;
            }
            case 0: {
                targetPath = MiscUtilities.getParentOfPath(file.getPath());
                break;
            }
            case 1: {
                targetPath = file.getPath();
                break;
            }
            default: {
                Log.log(9, this, "Unknown file type " + file.getType());
                return;
            }
        }
        VFS vfs = VFSManager.getVFSForPath(targetPath);
        Object vfsSession = null;
        try {
            Iterable copiedFiles;
            vfsSession = vfs.createVFSSession(targetPath, this);
            if (vfsSession == null) {
                Log.log(9, this, "Unable to create session for " + targetPath);
                return;
            }
            Transferable transferable = Registers.getRegister('$').getTransferable();
            ArrayList<String> sources = new ArrayList<String>();
            if (transferable.isDataFlavorSupported(ListVFSFileTransferable.jEditFileList)) {
                copiedFiles = (Iterable)StandardUtilities.castUnchecked(transferable.getTransferData(ListVFSFileTransferable.jEditFileList));
                for (VFSFile copiedFile : copiedFiles) {
                    sources.add(copiedFile.getPath());
                }
            } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                copiedFiles = (Iterable)StandardUtilities.castUnchecked(transferable.getTransferData(DataFlavor.javaFileListFlavor));
                for (File copiedFile : copiedFiles) {
                    sources.add(copiedFile.getAbsolutePath());
                }
            }
            CopyFileWorker worker = new CopyFileWorker((Component)this, sources, targetPath, CopyFileWorker.Behavior.RENAME);
            ThreadUtilities.runInBackground(worker);
        }
        finally {
            if (vfsSession != null) {
                vfs._endVFSSession(vfsSession, this);
            }
        }
    }

    public void locateFile(String path) {
        VFSFileFilter filter = this.getVFSFileFilter();
        if (!filter.accept(MiscUtilities.getFileName(path))) {
            this.setFilenameFilter(null);
        }
        this.setDirectory(MiscUtilities.getParentOfPath(path));
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(() -> this.browserView.getTable().selectFile(path));
    }

    public JComponent createPluginsMenu(JComponent pluginMenu, boolean showManagerOptions) {
        if (showManagerOptions && this.getMode() == 2) {
            pluginMenu.add(GUIUtilities.loadMenuItem("plugin-manager", false));
            pluginMenu.add(GUIUtilities.loadMenuItem("plugin-options", false));
            if (pluginMenu instanceof JMenu) {
                ((JMenu)pluginMenu).addSeparator();
            } else if (pluginMenu instanceof JPopupMenu) {
                ((JPopupMenu)pluginMenu).addSeparator();
            }
        }
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        EditPlugin[] plugins = jEdit.getPlugins();
        for (EditPlugin plugin : plugins) {
            JMenuItem menuItem = plugin.createBrowserMenuItems();
            if (menuItem == null) continue;
            list.add(menuItem);
        }
        if (!list.isEmpty()) {
            list.sort(new MenuItemTextComparator());
            for (JMenuItem item : list) {
                pluginMenu.add(item);
            }
        } else {
            JMenuItem mi = new JMenuItem(jEdit.getProperty("vfs.browser.plugins.no-plugins.label"));
            mi.setEnabled(false);
            pluginMenu.add(mi);
        }
        return pluginMenu;
    }

    public void addBrowserListener(BrowserListener l) {
        this.listenerList.add(BrowserListener.class, l);
    }

    public void removeBrowserListener(BrowserListener l) {
        this.listenerList.remove(BrowserListener.class, l);
    }

    public void filesActivated(int mode, boolean canDoubleClickClose) {
        VFSFile[] selectedFiles = this.browserView.getSelectedFiles();
        Buffer buffer = null;
        String bufferMarker = null;
        for (VFSFile file : selectedFiles) {
            if (file.getType() == 1 || file.getType() == 2) {
                if (mode == 1 && this.mode == 2) {
                    VFSBrowser.browseDirectoryInNewWindow(this.view, file.getPath());
                    continue;
                }
                if (selectedFiles.length != 1) continue;
                this.setDirectory(file.getPath());
                continue;
            }
            if (this.mode != 2 && this.mode != 4) continue;
            if (mode == 4) {
                this.view.getBuffer().insertFile(this.view, file.getPath());
                continue;
            }
            Buffer _buffer = jEdit.getBufferManager().getBuffer(file.getPath()).orElse(null);
            if (_buffer == null) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                if (this.currentEncoding != null) {
                    props.put("encoding", this.currentEncoding);
                }
                props.put("encodingAutodetect", this.autoDetectEncoding);
                _buffer = jEdit.openFile(this.view, null, file.getPath(), false, props);
            } else if (this.doubleClickClose && canDoubleClickClose && this.mode != 4 && selectedFiles.length == 1) {
                EditPane[] editPanes;
                for (EditPane editPane : editPanes = this.view.getEditPanes()) {
                    if (editPane.getBuffer() != _buffer) continue;
                    jEdit.closeBuffer(this.view, _buffer);
                    return;
                }
            }
            if (_buffer == null) continue;
            buffer = _buffer;
            bufferMarker = file.getPathMarker();
        }
        if (buffer != null) {
            View gotoView = null;
            switch (mode) {
                case 0: {
                    this.view.setBuffer(buffer);
                    gotoView = this.view;
                    break;
                }
                case 1: {
                    gotoView = jEdit.newView(this.view, buffer, false);
                    break;
                }
                case 2: {
                    gotoView = jEdit.newView(this.view, buffer, true);
                    break;
                }
                case 3: {
                    this.view.splitHorizontally().setBuffer(buffer);
                    gotoView = this.view;
                }
            }
            if (gotoView != null && bufferMarker != null) {
                jEdit.gotoMarker(gotoView, buffer, bufferMarker);
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != BrowserListener.class) continue;
            BrowserListener l = (BrowserListener)listeners[i + 1];
            l.filesActivated(this, selectedFiles);
        }
    }

    public void dispose() {
        if (this.mode == 2) {
            this.view.getDockableWindowManager().hideDockableWindow(NAME);
        } else {
            GenericGUIUtilities.getParentDialog(this).dispose();
        }
    }

    @Override
    public void move(String newPosition) {
        boolean horz;
        boolean bl = horz = this.mode != 2 || "top".equals(newPosition) || "bottom".equals(newPosition);
        if (horz == this.horizontalLayout) {
            return;
        }
        this.horizontalLayout = horz;
        this.topBox.remove(this.toolbarBox);
        this.toolbarBox = new Box(this.horizontalLayout ? 0 : 1);
        this.topBox.add((Component)this.toolbarBox, 0);
        this.propertiesChanged();
    }

    void directoryLoaded(Object node, Object[] loadInfo, boolean addToHistory) {
        String path = (String)loadInfo[0];
        if (path == null) {
            return;
        }
        VFSFile[] list = (VFSFile[])loadInfo[1];
        if (node == null) {
            this.path = path;
            if (!this.pathField.getText().equals(path)) {
                this.pathField.setText(path);
            }
            if (path.endsWith("/") || path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (addToHistory) {
                HistoryModel.getModel("vfs.browser.path").addItem(path);
            }
        }
        boolean filterEnabled = this.filterCheckbox.isSelected();
        ArrayList<VFSFile> directoryList = new ArrayList<VFSFile>();
        if (list != null) {
            VFSFileFilter filter = this.getVFSFileFilter();
            for (VFSFile file : list) {
                if (file.isHidden() && !this.showHiddenFiles || filter != null && (filterEnabled || filter instanceof DirectoriesOnlyFilter) && !filter.accept(file)) continue;
                directoryList.add(file);
            }
            directoryList.sort(new VFS.DirectoryEntryCompare(this.sortMixFilesAndDirs, this.sortIgnoreCase));
        }
        this.browserView.directoryLoaded(node, path, directoryList);
        if (this.mode == 3) {
            this.filesSelected();
        }
    }

    void filesSelected() {
        VFSFile[] selectedFiles = this.browserView.getSelectedFiles();
        if (this.mode == 2 && this.view != null) {
            BufferManager bufferManager = jEdit.getBufferManager();
            Arrays.stream(selectedFiles).map(VFSFile::getPath).map(bufferManager::getBuffer).flatMap(Optional::stream).forEach(this.view::setBuffer);
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != BrowserListener.class) continue;
            BrowserListener l = (BrowserListener)listeners[i + 1];
            l.filesSelected(this, selectedFiles);
        }
    }

    void endRequest() {
        this.requestRunning = false;
    }

    private Container createMenuBar() {
        JToolBar menuBar = new JToolBar();
        menuBar.setFloatable(false);
        menuBar.add(new CommandsMenuButton());
        menuBar.add(Box.createHorizontalStrut(3));
        this.plugins = new PluginsMenuButton();
        menuBar.add(this.plugins);
        menuBar.add(Box.createHorizontalStrut(3));
        this.favorites = new FavoritesMenuButton();
        menuBar.add(this.favorites);
        return menuBar;
    }

    private Container createToolBar() {
        if (this.mode == 2) {
            return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-browser");
        }
        return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-dialog");
    }

    private void propertiesChanged() {
        this.showHiddenFiles = jEdit.getBooleanProperty("vfs.browser.showHiddenFiles");
        this.sortMixFilesAndDirs = jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs");
        this.sortIgnoreCase = jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase");
        this.doubleClickClose = jEdit.getBooleanProperty("vfs.browser.doubleClickClose");
        this.browserView.propertiesChanged();
        this.toolbarBox.removeAll();
        if (jEdit.getBooleanProperty("vfs.browser.showToolbar")) {
            Container toolbar = this.createToolBar();
            this.toolbarBox.add(toolbar);
        }
        if (jEdit.getBooleanProperty("vfs.browser.showMenubar")) {
            Container menubar = this.createMenuBar();
            if (this.horizontalLayout) {
                this.toolbarBox.add((Component)menubar, 0);
            } else {
                menubar.add(Box.createGlue());
                this.toolbarBox.add(menubar);
            }
        } else {
            this.plugins = null;
            this.favorites = null;
        }
        this.revalidate();
        if (this.path != null) {
            this.reloadDirectory();
        }
    }

    private boolean startRequest() {
        if (this.requestRunning) {
            Log.log(1, this, new Throwable("For debugging purposes"));
            GUIUtilities.error(this, "browser-multiple-io", null);
            return false;
        }
        this.requestRunning = true;
        return true;
    }

    private void updateFilterEnabled() {
        this.filterField.setEnabled(this.filterCheckbox.isSelected());
        this.filterEditor.setEnabled(this.filterCheckbox.isSelected());
    }

    private void maybeReloadDirectory(String dir2) {
        if (MiscUtilities.isURL(dir2) && MiscUtilities.getProtocolOfURL(dir2).equals("favorites") && this.favorites != null) {
            this.favorites.popup = null;
        }
        if (this.maybeReloadRequestRunning) {
            return;
        }
        if (this.path != null) {
            try {
                this.maybeReloadRequestRunning = true;
                this.browserView.maybeReloadDirectory(dir2);
                AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

                    @Override
                    public void run() {
                        VFSBrowser.this.maybeReloadRequestRunning = false;
                    }
                });
            }
            catch (Throwable throwable) {
                AwtRunnableQueue.INSTANCE.runAfterIoTasks(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    static {
        ActionSet builtInActionSet = new ActionSet(null, null, null, jEdit.class.getResource("browser.actions.xml"));
        builtInActionSet.setLabel(jEdit.getProperty("action-set.browser"));
        builtInActionSet.load();
        actionContext.addActionSet(builtInActionSet);
    }

    class ActionHandler
    implements ActionListener,
    ItemListener {
        private boolean isProcessingEvent;

        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.isProcessingEvent) {
                return;
            }
            Object source = evt.getSource();
            if (source == VFSBrowser.this.pathField || source == VFSBrowser.this.filterCheckbox) {
                this.isProcessingEvent = true;
                this.resetLater();
                VFSBrowser.this.updateFilterEnabled();
                String p = VFSBrowser.this.pathField.getText();
                if (p != null) {
                    VFSBrowser.this.setDirectory(p);
                }
                VFSBrowser.this.browserView.focusOnFileView();
            } else if (source == VFSBrowser.this.filterField.getEditor()) {
                VFSBrowser.this.filterField.getEditor().setItem(VFSBrowser.this.filterField.getEditor().getItem());
            } else if (source == VFSBrowser.this.filterEditor) {
                VFSBrowser.this.filterEditor.setItem(VFSBrowser.this.filterEditor.getItem());
                VFSBrowser.this.filterField.setSelectedItem(VFSBrowser.this.filterEditor.getItem());
                this.itemStateChanged(new ItemEvent(VFSBrowser.this.filterField, 701, VFSBrowser.this.filterEditor.getItem(), 1));
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.isProcessingEvent) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.isProcessingEvent = true;
            this.resetLater();
            VFSBrowser.this.filterField.setEditable(e.getItem() instanceof GlobVFSFileFilter);
            VFSBrowser.this.updateFilterEnabled();
            String path = VFSBrowser.this.pathField.getText();
            if (path != null) {
                VFSBrowser.this.setDirectory(path);
            }
            VFSBrowser.this.browserView.focusOnFileView();
        }

        private void resetLater() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionHandler.this.isProcessingEvent = false;
                }
            });
        }
    }

    private static class HistoryComboBoxEditor
    extends HistoryTextField
    implements ComboBoxEditor {
        private GlobVFSFileFilter current;

        HistoryComboBoxEditor(String key) {
            super(key);
        }

        @Override
        public Object getItem() {
            if (this.current == null) {
                this.current = new GlobVFSFileFilter(this.getText());
            }
            if (!this.current.getGlob().equals(this.getText())) {
                this.current.setGlob(this.getText());
            }
            return this.current;
        }

        @Override
        public void setItem(Object item) {
            if (item == this.current) {
                if (item != null) {
                    GlobVFSFileFilter filter = (GlobVFSFileFilter)item;
                    this.current = new GlobVFSFileFilter(filter.getGlob());
                    this.setText(this.current.getGlob());
                }
                return;
            }
            if (item != null) {
                if (!(item instanceof GlobVFSFileFilter)) {
                    return;
                }
                GlobVFSFileFilter filter = (GlobVFSFileFilter)item;
                filter = new GlobVFSFileFilter(filter.getGlob());
                this.setText(filter.getGlob());
                this.addCurrentToHistory();
                this.current = filter;
            } else {
                this.setText("*");
                this.current = new GlobVFSFileFilter("*");
            }
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() != 1005) {
                super.processFocusEvent(e);
            } else {
                this.setCaretPosition(0);
                this.getCaret().setVisible(false);
            }
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }
    }

    private static class VFSFileFilterRenderer
    extends DefaultListCellRenderer {
        private VFSFileFilterRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            assert (value instanceof VFSFileFilter) : "Filter is not a VFSFileFilter";
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(((VFSFileFilter)value).getDescription());
            return this;
        }
    }

    class PluginsMenuButton
    extends MenuButton {
        PluginsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.plugins.label"));
            GenericGUIUtilities.setAutoMnemonic(this);
            this.setName("plugins");
            this.setMargin(new Insets(1, 1, 1, 1));
            this.popup = null;
            this.createPopupMenu();
        }

        void updatePopupMenu() {
            this.popup = null;
        }

        @Override
        void doPopup() {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            GenericGUIUtilities.showPopupMenu(this.popup, this, 0, this.getHeight(), false);
        }

        private void createPopupMenu() {
            if (this.popup != null) {
                return;
            }
            this.popup = (JPopupMenu)VFSBrowser.this.createPluginsMenu(new JPopupMenu(), true);
        }
    }

    public static class DirectoriesOnlyFilter
    implements VFSFileFilter {
        @Override
        public boolean accept(VFSFile file) {
            return file.getType() == 1 || file.getType() == 2;
        }

        @Override
        public boolean accept(String url) {
            return false;
        }

        @Override
        public String getDescription() {
            return jEdit.getProperty("vfs.browser.file_filter.dir_only");
        }
    }

    class CommandsMenuButton
    extends MenuButton {
        CommandsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.commands.label"));
            GenericGUIUtilities.setAutoMnemonic(this);
            this.setName("commands");
            this.popup = new BrowserCommandsMenu(VFSBrowser.this, null);
        }

        @Override
        void doPopup() {
            ((BrowserCommandsMenu)this.popup).update();
            GenericGUIUtilities.showPopupMenu(this.popup, this, 0, this.getHeight(), false);
        }
    }

    class FavoritesMenuButton
    extends MenuButton {
        FavoritesMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.favorites.label"));
            GenericGUIUtilities.setAutoMnemonic(this);
            this.setName("favorites");
            this.createPopupMenu();
        }

        @Override
        void doPopup() {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            GenericGUIUtilities.showPopupMenu(this.popup, this, 0, this.getHeight(), false);
        }

        void createPopupMenu() {
            this.popup = new JPopupMenu();
            ActionHandler actionHandler = new ActionHandler();
            JMenuItem mi = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.add-to-favorites.label"));
            mi.setActionCommand("add-to-favorites");
            mi.addActionListener(actionHandler);
            this.popup.add(mi);
            mi = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.edit-favorites.label"));
            mi.setActionCommand("dir@favorites:");
            mi.addActionListener(actionHandler);
            this.popup.add(mi);
            this.popup.addSeparator();
            VFSFile[] favorites = FavoritesVFS.getFavorites();
            if (favorites.length == 0) {
                mi = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.no-favorites.label"));
                mi.setEnabled(false);
                this.popup.add(mi);
            } else {
                Arrays.sort(favorites, new VFS.DirectoryEntryCompare(VFSBrowser.this.sortMixFilesAndDirs, VFSBrowser.this.sortIgnoreCase));
                for (int i = 0; i < favorites.length; ++i) {
                    FavoritesVFS.Favorite favorite = (FavoritesVFS.Favorite)favorites[i];
                    mi = new JMenuItem(favorite.getLabel());
                    mi.setIcon(FileCellRenderer.getIconForFile(favorite, false));
                    String cmd = (favorite.getType() == 0 ? "file@" : "dir@") + favorite.getPath();
                    mi.setActionCommand(cmd);
                    mi.addActionListener(actionHandler);
                    this.popup.add(mi);
                }
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                String actionCommand = evt.getActionCommand();
                if ("add-to-favorites".equals(actionCommand)) {
                    VFSFile[] selected = VFSBrowser.this.getSelectedFiles();
                    if (selected == null || selected.length == 0) {
                        if (VFSBrowser.this.path.equals("favorites:")) {
                            GUIUtilities.error(VFSBrowser.this, "vfs.browser.recurse-favorites", null);
                        } else {
                            FavoritesVFS.addToFavorites(VFSBrowser.this.path, 1);
                        }
                    } else {
                        for (VFSFile file : selected) {
                            FavoritesVFS.addToFavorites(file.getPath(), file.getType());
                        }
                    }
                } else if (actionCommand.startsWith("dir@")) {
                    VFSBrowser.this.setDirectory(actionCommand.substring(4));
                } else if (actionCommand.startsWith("file@")) {
                    switch (VFSBrowser.this.getMode()) {
                        case 2: {
                            jEdit.openFile(VFSBrowser.this.view, actionCommand.substring(5));
                            break;
                        }
                        default: {
                            VFSBrowser.this.locateFile(actionCommand.substring(5));
                        }
                    }
                }
            }
        }
    }

    static class BrowserActionContext
    extends ActionContext {
        BrowserActionContext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invokeAction(EventObject evt, EditAction action) {
            Component source = (Component)evt.getSource();
            VFSBrowser browser = (VFSBrowser)GUIUtilities.getComponentParent(source, VFSBrowser.class);
            VFSFile[] files = browser.getSelectedFiles(source);
            NameSpace global = BeanShell.getNameSpace();
            try {
                global.setVariable("browser", browser);
                global.setVariable("files", files);
                View view = browser.getView();
                if (view == null) {
                    view = jEdit.getActiveView();
                }
                action.invoke(view);
            }
            catch (UtilEvalError err) {
                Log.log(9, this, err);
            }
            finally {
                try {
                    global.setVariable("browser", null);
                    global.setVariable("files", null);
                }
                catch (UtilEvalError err) {
                    Log.log(9, this, err);
                }
            }
        }
    }

    static abstract class MenuButton
    extends RolloverButton
    implements KeyListener {
        JPopupMenu popup;

        MenuButton() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getThemeProperty("dropdown-arrow.icon")));
            this.setHorizontalTextPosition(10);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            this.addKeyListener(this);
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
            this.setAction(new Action());
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 40 || e.getKeyCode() == 10) {
                this.doPopup();
                e.consume();
            }
        }

        abstract void doPopup();

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (MenuButton.this.popup == null || !MenuButton.this.popup.isVisible()) {
                    MenuButton.this.doPopup();
                } else {
                    MenuButton.this.popup.setVisible(false);
                }
            }
        }

        class Action
        extends AbstractAction {
            Action() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                MenuButton.this.doPopup();
            }
        }
    }
}

