/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class ServiceListHandler
extends DefaultHandler {
    public static final ServiceManager.Descriptor[] EMPTY_DESCRIPTORS = new ServiceManager.Descriptor[0];
    private final PluginJAR plugin;
    private URL uri;
    private String serviceName;
    private String serviceClass;
    private final StringBuilder code;
    private final Stack<String> stateStack;
    private final List<ServiceManager.Descriptor> cachedServices;

    ServiceListHandler(PluginJAR plugin, URL uri) {
        this.plugin = plugin;
        this.uri = uri;
        this.code = new StringBuilder();
        this.stateStack = new Stack();
        this.cachedServices = new LinkedList<ServiceManager.Descriptor>();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return XMLUtilities.findEntity(systemId, "services.dtd", this.getClass());
    }

    @Override
    public void characters(char[] c, int off, int len) {
        String tag = this.peekElement();
        if ("SERVICE".equals(tag)) {
            this.code.append(c, off, len);
        }
    }

    @Override
    public void startElement(String uri, String localName, String tag, Attributes attrs) {
        this.pushElement(tag);
        this.serviceName = attrs.getValue("NAME");
        this.serviceClass = attrs.getValue("CLASS");
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        String tag = this.peekElement();
        if (name.equals(tag)) {
            if ("SERVICE".equals(tag)) {
                ServiceManager.Descriptor d = new ServiceManager.Descriptor(this.serviceClass, this.serviceName, this.code.toString(), this.plugin);
                ServiceManager.registerService(d);
                this.cachedServices.add(d);
                this.code.setLength(0);
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    @Override
    public void startDocument() {
        this.pushElement(null);
    }

    public ServiceManager.Descriptor[] getCachedServices() {
        return this.cachedServices.toArray(EMPTY_DESCRIPTORS);
    }

    private void pushElement(String name) {
        this.stateStack.push(name);
    }

    @Nullable
    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }
}

