/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.hypersearch.HyperSearchResultValue;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.HyperSearchResult;
import org.gjt.sp.jedit.search.HyperSearchResults;

public class HighlightHypersearchResults
implements HighlightChangeListener {
    public static final String HYPERSEARCH = "hypersearch-results";
    private final View view;

    public HighlightHypersearchResults(View view) {
        this.view = view;
    }

    private JTree getHyperSearchTree() {
        JComponent dockable = this.view.getDockableWindowManager().getDockable(HYPERSEARCH);
        if (dockable == null) {
            return null;
        }
        if (!(dockable instanceof HyperSearchResults)) {
            return null;
        }
        HyperSearchResults hrd = (HyperSearchResults)dockable;
        return hrd.getTree();
    }

    public void start() {
        HighlightManagerTableModel.getManager().addHighlightChangeListener(this);
        JTree tree = this.getHyperSearchTree();
        if (tree == null) {
            return;
        }
        TreeCellRenderer renderer = tree.getCellRenderer();
        if (!(renderer instanceof HighlightTreeCellRenderer)) {
            tree.setCellRenderer(new HighlightTreeCellRenderer(renderer));
        }
    }

    public void stop() {
        HighlightManagerTableModel.getManager().removeHighlightChangeListener(this);
        JTree tree = this.getHyperSearchTree();
        if (tree == null) {
            return;
        }
        TreeCellRenderer renderer = tree.getCellRenderer();
        if (renderer instanceof HighlightTreeCellRenderer) {
            tree.setCellRenderer(((HighlightTreeCellRenderer)renderer).getOriginal());
        }
    }

    @Override
    public void highlightUpdated(boolean highlightEnabled) {
        JTree tree = this.getHyperSearchTree();
        if (tree != null) {
            tree.repaint();
        }
    }

    private static class HighlightTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private final TreeCellRenderer renderer;

        HighlightTreeCellRenderer(TreeCellRenderer renderer) {
            this.renderer = renderer;
        }

        public TreeCellRenderer getOriginal() {
            return this.renderer;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object obj;
            Component defaultComponent = this.renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && jEdit.getBooleanProperty((String)"gatchan.highlight.hyperSearchResults") && (obj = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof HyperSearchResult) {
                HyperSearchResult result = (HyperSearchResult)obj;
                return this.renderer.getTreeCellRendererComponent(tree, new DefaultMutableTreeNode(new HyperSearchResultValue(result.toString())), sel, expanded, leaf, row, hasFocus);
            }
            return defaultComponent;
        }
    }
}

