/*
 * Decompiled with CFR 0.152.
 */
package isabelle.find_facts;

import isabelle.File$;
import isabelle.HTML$;
import isabelle.Isabelle_System$;
import isabelle.JSON$;
import isabelle.JSON$Format$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.SHA1;
import isabelle.SHA1$;
import isabelle.XML;
import isabelle.XML$;
import isabelle.find_facts.Elm$;
import isabelle.find_facts.Elm$Project$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;

public final class Elm {
    public static Path elm_home() {
        return Elm$.MODULE$.elm_home();
    }

    public static class Project {
        private final Path dir;
        private final Path main;
        private final List<XML.Tree> head;
        private final Object definition;
        private final List src_dirs;

        public static Project apply(String string, Path path, Path path2, List<XML.Tree> list) {
            return Elm$Project$.MODULE$.apply(string, path, path2, list);
        }

        public static SHA1.Digest get_digest(Path path) {
            return Elm$Project$.MODULE$.get_digest(path);
        }

        public static Path apply$default$3() {
            return Elm$Project$.MODULE$.apply$default$3();
        }

        public static List<XML.Tree> apply$default$4() {
            return Elm$Project$.MODULE$.apply$default$4();
        }

        public Project(String name, Path dir, Path main, List<XML.Tree> head) {
            this.dir = dir;
            this.main = main;
            this.head = head;
            this.definition = JSON$.MODULE$.parse(File$.MODULE$.read(dir.$plus(Path$.MODULE$.basic("elm.json"))), JSON$.MODULE$.parse$default$2());
            this.src_dirs = (List)JSON$.MODULE$.strings(this.definition(), "source-directories").getOrElse(this::$init$$$anonfun$1);
        }

        public Object definition() {
            return this.definition;
        }

        public List<String> src_dirs() {
            return this.src_dirs;
        }

        public List<Path> sources() {
            return this.src_dirs().map((Function1 & Serializable)src_dir -> {
                Path path = this.dir.$plus(Path$.MODULE$.explode((String)src_dir));
                return Tuple2$.MODULE$.apply(src_dir, (Object)path);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String src_dir = (String)tuple2._1();
                    Path path = (Path)tuple2._2();
                    return File$.MODULE$.find_files(path.file(), (Function1<File, Object>)((Function1 & Serializable)Elm$::isabelle$find_facts$Elm$Project$$_$sources$$anonfun$2$$anonfun$1), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).flatMap((Function1 & Serializable)file -> File$.MODULE$.relative_path(this.dir, File$.MODULE$.path((File)file)).map(Elm$::isabelle$find_facts$Elm$Project$$_$sources$$anonfun$2$$anonfun$2$$anonfun$1));
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public SHA1.Shasum sources_shasum() {
            SHA1.Shasum meta_info = SHA1$.MODULE$.shasum_meta_info(SHA1$.MODULE$.digest(JSON$Format$.MODULE$.apply(this.definition())));
            SHA1.Shasum head_digest = SHA1$.MODULE$.shasum(SHA1$.MODULE$.digest(XML$.MODULE$.string_of_body(this.head)), "head");
            SHA1.Shasum source_digest = SHA1$.MODULE$.shasum_sorted((List<Tuple2<SHA1.Digest, String>>)this.sources().map((Function1 & Serializable)src -> {
                SHA1.Digest digest = (SHA1.Digest)Predef$.MODULE$.ArrowAssoc((Object)SHA1$.MODULE$.digest(this.dir.$plus((Path)src)));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)digest, (Object)src.implode());
            }));
            return source_digest.$colon$colon$colon(head_digest).$colon$colon$colon(meta_info);
        }

        public void build_html(Path output_file, Progress progress) {
            SHA1.Digest digest;
            SHA1.Digest digest2 = digest = this.sources_shasum().digest();
            SHA1.Digest digest3 = Elm$Project$.MODULE$.get_digest(output_file);
            if (digest2 == null ? digest3 != null : !((Object)digest2).equals(digest3)) {
                progress.echo("Building web application " + output_file.absolute() + " ...", progress.echo$default$2());
                String cmd = File$.MODULE$.bash_path(Elm$.MODULE$.elm_home().$plus(Path$.MODULE$.basic("elm"))) + " make " + File$.MODULE$.bash_path(this.main) + " --optimize --output=" + output_file;
                Process_Result res = Isabelle_System$.MODULE$.bash(cmd, Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), this.dir, Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12());
                if (!res.ok()) {
                    progress.echo_error_message(res.err(), progress.echo_error_message$default$2());
                    package$.MODULE$.error().apply((Object)"Failed to compile Elm sources");
                }
                Document file = HTML$.MODULE$.parse_document(File$.MODULE$.read(output_file));
                file.head().appendChild((Node)new Element("meta").attr("name", "shasum").attr("content", digest.toString()));
                file.head().append(XML$.MODULE$.string_of_body(this.head));
                String html = file.html();
                File$.MODULE$.write(output_file, html);
                return;
            }
        }

        public Progress build_html$default$2() {
            return new Progress();
        }

        private final List $init$$$anonfun$1() {
            return (List)package$.MODULE$.error().apply((Object)"Missing source directories in elm.json");
        }
    }
}

