/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Compress;
import isabelle.Doc;
import isabelle.Doc$;
import isabelle.Exn;
import isabelle.Exn$;
import isabelle.Exn$Exn$;
import isabelle.Exn$Res$;
import isabelle.File$;
import isabelle.File_Store$;
import isabelle.HTML$;
import isabelle.HTTP$;
import isabelle.HTTP$Browser_Info$;
import isabelle.HTTP$CSS$;
import isabelle.HTTP$Content$;
import isabelle.HTTP$Docs$;
import isabelle.HTTP$Fonts$;
import isabelle.HTTP$PDFjs$;
import isabelle.HTTP$REST_Service$;
import isabelle.HTTP$Response$;
import isabelle.HTTP$Service$;
import isabelle.HTTP$Welcome$;
import isabelle.Isabelle_Fonts;
import isabelle.Isabelle_Fonts$;
import isabelle.Isabelle_System$;
import isabelle.JSON$;
import isabelle.JSON$Format$;
import isabelle.Library$;
import isabelle.Output$;
import isabelle.Path;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.SHA1$;
import isabelle.UUID$;
import isabelle.Url$;
import isabelle.package$;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class HTTP {
    public static String NEWLINE() {
        return HTTP$.MODULE$.NEWLINE();
    }

    public static List<Service> isabelle_services() {
        return HTTP$.MODULE$.isabelle_services();
    }

    public static Process_Result pdfjs_demo(String string) {
        return HTTP$.MODULE$.pdfjs_demo(string);
    }

    public static Server server(int n, String string, List<Service> list) {
        return HTTP$.MODULE$.server(n, string, list);
    }

    public static String url_path(Seq<String> seq) {
        return HTTP$.MODULE$.url_path(seq);
    }

    public static int server$default$1() {
        return HTTP$.MODULE$.server$default$1();
    }

    public static String server$default$2() {
        return HTTP$.MODULE$.server$default$2();
    }

    public static List<Service> server$default$3() {
        return HTTP$.MODULE$.server$default$3();
    }

    public static class Browser_Info
    extends Service {
        private final Path database;
        private final Compress.Cache compress_cache;

        public static String $lessinit$greater$default$1() {
            return HTTP$Browser_Info$.MODULE$.$lessinit$greater$default$1();
        }

        public static Path $lessinit$greater$default$2() {
            return HTTP$Browser_Info$.MODULE$.$lessinit$greater$default$2();
        }

        public static Compress.Cache $lessinit$greater$default$3() {
            return HTTP$Browser_Info$.MODULE$.$lessinit$greater$default$3();
        }

        public Browser_Info(String name, Path database, Compress.Cache compress_cache) {
            this.database = database;
            this.compress_cache = compress_cache;
            super(name, HTTP$Service$.MODULE$.$lessinit$greater$default$2());
        }

        private String name$accessor() {
            return super.name();
        }

        @Override
        public Option<Response> apply(Request request) {
            String entry_name = (String)request.uri_path().map(HTTP$::isabelle$HTTP$Browser_Info$$_$_$$anonfun$3).getOrElse(HTTP$::isabelle$HTTP$Browser_Info$$_$_$$anonfun$4);
            Option proper_response = File_Store$.MODULE$.database_entry(this.database, entry_name).map((Function1 & Serializable)entry -> {
                Bytes bytes = entry.content(this.compress_cache);
                String mime_type = HTTP$Content$.MODULE$.bytes_mime_type(bytes, Url$.MODULE$.get_ext(entry_name));
                return HTTP$Response$.MODULE$.content(HTTP$Content$.MODULE$.apply(bytes, HTTP$Content$.MODULE$.apply$default$2(), mime_type, HTTP$Content$.MODULE$.apply$default$4(), HTTP$Content$.MODULE$.apply$default$5()));
            });
            return Some$.MODULE$.apply(proper_response.getOrElse(() -> this.apply$$anonfun$11(entry_name)));
        }

        private final Response error_response$1(String entry_name$2) {
            String msg = "Cannot access database " + this.database.expand() + " entry " + package$.MODULE$.quote().apply((Object)entry_name$2);
            return HTTP$Response$.MODULE$.text(Output$.MODULE$.error_message_text(msg));
        }

        private final Response apply$$anonfun$11(String entry_name$3) {
            return this.error_response$1(entry_name$3);
        }
    }

    public static class CSS
    extends Service {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CSS.class.getDeclaredField("css$lzy1"));
        private final String fonts;
        private volatile Object css$lzy1;

        public static String $lessinit$greater$default$1() {
            return HTTP$CSS$.MODULE$.$lessinit$greater$default$1();
        }

        public static String $lessinit$greater$default$2() {
            return HTTP$CSS$.MODULE$.$lessinit$greater$default$2();
        }

        public CSS(String name, String fonts) {
            this.fonts = fonts;
            super(name, HTTP$Service$.MODULE$.$lessinit$greater$default$2());
        }

        private String name$accessor() {
            return super.name();
        }

        private String css() {
            Object object = this.css$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.css$lzyINIT1();
        }

        private Object css$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.css$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = HTML$.MODULE$.fonts_css((Function1<String, String>)(Function1 & Serializable)_$4 -> this.fonts + "/" + _$4) + "\n\n" + File$.MODULE$.read(HTML$.MODULE$.isabelle_css());
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.css$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public Option<Response> apply(Request request) {
            return Some$.MODULE$.apply((Object)HTTP$Response$.MODULE$.apply(Bytes$.MODULE$.apply(this.css()), HTTP$Content$.MODULE$.mime_type_css()));
        }
    }

    public static class Content {
        private final Bytes bytes;
        private final String file_name;
        private final String mime_type;
        private final String encoding;
        private final long elapsed_time;

        public static Content apply(Bytes bytes, String string, String string2, String string3, long l) {
            return HTTP$Content$.MODULE$.apply(bytes, string, string2, string3, l);
        }

        public static String bytes_mime_type(Bytes bytes, String string) {
            return HTTP$Content$.MODULE$.bytes_mime_type(bytes, string);
        }

        public static String default_encoding() {
            return HTTP$Content$.MODULE$.default_encoding();
        }

        public static String default_mime_type() {
            return HTTP$Content$.MODULE$.default_mime_type();
        }

        public static String file_mime_type(File file) {
            return HTTP$Content$.MODULE$.file_mime_type(file);
        }

        public static String mime_type_bytes() {
            return HTTP$Content$.MODULE$.mime_type_bytes();
        }

        public static String mime_type_css() {
            return HTTP$Content$.MODULE$.mime_type_css();
        }

        public static String mime_type_html() {
            return HTTP$Content$.MODULE$.mime_type_html();
        }

        public static String mime_type_js() {
            return HTTP$Content$.MODULE$.mime_type_js();
        }

        public static String mime_type_text() {
            return HTTP$Content$.MODULE$.mime_type_text();
        }

        public static Content read(File file) {
            return HTTP$Content$.MODULE$.read(file);
        }

        public static Content read(Path path) {
            return HTTP$Content$.MODULE$.read(path);
        }

        public static String apply$default$2() {
            return HTTP$Content$.MODULE$.apply$default$2();
        }

        public static String bytes_mime_type$default$2() {
            return HTTP$Content$.MODULE$.bytes_mime_type$default$2();
        }

        public static String apply$default$3() {
            return HTTP$Content$.MODULE$.apply$default$3();
        }

        public static String apply$default$4() {
            return HTTP$Content$.MODULE$.apply$default$4();
        }

        public static long apply$default$5() {
            return HTTP$Content$.MODULE$.apply$default$5();
        }

        public Content(Bytes bytes, String file_name, String mime_type, String encoding, long elapsed_time) {
            this.bytes = bytes;
            this.file_name = file_name;
            this.mime_type = mime_type;
            this.encoding = encoding;
            this.elapsed_time = elapsed_time;
        }

        public Bytes bytes() {
            return this.bytes;
        }

        public String file_name() {
            return this.file_name;
        }

        public String mime_type() {
            return this.mime_type;
        }

        public String encoding() {
            return this.encoding;
        }

        public long elapsed_time() {
            return this.elapsed_time;
        }

        public String text() {
            return new String(this.bytes().make_array(), this.encoding());
        }

        public Object json() {
            return JSON$.MODULE$.parse(this.text(), JSON$.MODULE$.parse$default$2());
        }
    }

    public static class Docs
    extends PDFjs {
        private final Doc.Contents doc_contents = Doc$.MODULE$.main_contents();

        public static String $lessinit$greater$default$1() {
            return HTTP$Docs$.MODULE$.$lessinit$greater$default$1();
        }

        public Docs(String name) {
            super(name);
        }

        private String name$accessor() {
            return super.name();
        }

        public Option<Response> doc_request(Request request) {
            return request.uri_path().withFilter(HTTP$::isabelle$HTTP$Docs$$_$doc_request$$anonfun$1).map(HTTP$::isabelle$HTTP$Docs$$_$doc_request$$anonfun$2).withFilter(HTTP$::isabelle$HTTP$Docs$$_$doc_request$$anonfun$3).map(HTTP$::isabelle$HTTP$Docs$$_$doc_request$$anonfun$4).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Path p = (Path)tuple2._1();
                    String s = (String)tuple2._2();
                    String name = (String)tuple22._2();
                    return this.doc_contents.entries((Function1<String, Object>)((Function1 & Serializable)arg_0 -> HTTP$.isabelle$HTTP$Docs$$_$doc_request$$anonfun$5$$anonfun$1(name, arg_0)), true).headOption().map(HTTP$::isabelle$HTTP$Docs$$_$doc_request$$anonfun$5$$anonfun$2);
                }
                throw new MatchError((Object)tuple22);
            });
        }

        @Override
        public Option<Response> apply(Request request) {
            return this.doc_request(request).orElse(() -> this.apply$$anonfun$10(request));
        }

        private final Option apply$$anonfun$10(Request request$3) {
            return super.apply(request$3);
        }
    }

    public static class Fonts
    extends Service {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Fonts.class.getDeclaredField("html_fonts$lzy1"));
        private volatile Object html_fonts$lzy1;

        public static String $lessinit$greater$default$1() {
            return HTTP$Fonts$.MODULE$.$lessinit$greater$default$1();
        }

        public Fonts(String name) {
            super(name, HTTP$Service$.MODULE$.$lessinit$greater$default$2());
        }

        private String name$accessor() {
            return super.name();
        }

        private List<Isabelle_Fonts.Entry> html_fonts() {
            Object object = this.html_fonts$lzy1;
            if (object instanceof List) {
                return (List)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (List)this.html_fonts$lzyINIT1();
        }

        private Object html_fonts$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.html_fonts$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        List<Isabelle_Fonts.Entry> list = null;
                        List<Isabelle_Fonts.Entry> list2 = null;
                        try {
                            list2 = Isabelle_Fonts$.MODULE$.fonts(true);
                            list = list2 == null ? LazyVals.NullValue$.MODULE$ : list2;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, list)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.html_fonts$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, list);
                                waiting.countDown();
                            }
                        }
                        return list2;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public Option<Response> apply(Request request) {
            if (request.toplevel()) {
                return Some$.MODULE$.apply((Object)HTTP$Response$.MODULE$.text((String)package$.MODULE$.cat_lines().apply((Object)this.html_fonts().map(HTTP$::isabelle$HTTP$Fonts$$_$apply$$anonfun$3))));
            }
            return request.uri_path().flatMap((Function1 & Serializable)path -> this.html_fonts().collectFirst((PartialFunction)new Serializable((Path)path){
                private final Path path$1;
                {
                    this.path$1 = path$2;
                }

                public final boolean isDefinedAt(Isabelle_Fonts.Entry x) {
                    Isabelle_Fonts.Entry entry;
                    Isabelle_Fonts.Entry entry2 = entry = x;
                    Path path = this.path$1;
                    Path path2 = entry2.path().base();
                    return !(path != null ? !((Object)path).equals(path2) : path2 != null);
                }

                public final Object applyOrElse(Isabelle_Fonts.Entry x, Function1 function1) {
                    Isabelle_Fonts.Entry entry;
                    Isabelle_Fonts.Entry entry2 = entry = x;
                    Path path = this.path$1;
                    Path path2 = entry2.path().base();
                    if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                        return HTTP$Response$.MODULE$.apply(entry2.bytes(), HTTP$Response$.MODULE$.apply$default$2());
                    }
                    return function1.apply((Object)x);
                }
            }));
        }
    }

    public static class PDFjs
    extends Service {
        public static String $lessinit$greater$default$1() {
            return HTTP$PDFjs$.MODULE$.$lessinit$greater$default$1();
        }

        public PDFjs(String name) {
            super(name, HTTP$Service$.MODULE$.$lessinit$greater$default$2());
        }

        private String name$accessor() {
            return super.name();
        }

        @Override
        public Option<Response> apply(Request request) {
            return request.uri_path().map(HTTP$::isabelle$HTTP$PDFjs$$_$apply$$anonfun$5).withFilter(HTTP$::isabelle$HTTP$PDFjs$$_$apply$$anonfun$6).map(HTTP$::isabelle$HTTP$PDFjs$$_$apply$$anonfun$7).withFilter(HTTP$::isabelle$HTTP$PDFjs$$_$apply$$anonfun$8).map(HTTP$::isabelle$HTTP$PDFjs$$_$apply$$anonfun$9);
        }
    }

    public static abstract class REST_Service
    extends Service {
        private final Progress progress;

        public static Progress $lessinit$greater$default$2() {
            return HTTP$REST_Service$.MODULE$.$lessinit$greater$default$2();
        }

        public static String $lessinit$greater$default$3() {
            return HTTP$REST_Service$.MODULE$.$lessinit$greater$default$3();
        }

        public REST_Service(String name, Progress progress, String method) {
            this.progress = progress;
            super(name, method);
        }

        private String name$accessor() {
            return super.name();
        }

        public abstract Option<Object> handle(Object var1);

        @Override
        public Option<Response> apply(Request request) {
            Some some;
            try {
                None$ none$;
                Exn.Result result = Exn$.MODULE$.capture(() -> HTTP$.isabelle$HTTP$REST_Service$$_$apply$$anonfun$1(request));
                if (result instanceof Exn.Res) {
                    Object a;
                    Exn.Res res = Exn$Res$.MODULE$.unapply((Exn.Res)result);
                    Object json2 = a = res._1();
                    none$ = Some$.MODULE$.apply(json2);
                } else {
                    this.progress.echo("Could not parse: " + package$.MODULE$.quote().apply((Object)request.input().text()), true);
                    none$ = None$.MODULE$;
                }
                some = none$.flatMap((Function1 & Serializable)json -> {
                    Some some;
                    Option<Object> option = this.handle(json);
                    if (option instanceof Some) {
                        Object res = ((Some)option).value();
                        some = Some$.MODULE$.apply(res);
                    } else if (None$.MODULE$.equals(option)) {
                        this.progress.echo("Invalid request: " + JSON$Format$.MODULE$.apply(json), true);
                        some = None$.MODULE$;
                    } else {
                        throw new MatchError(option);
                    }
                    return some.map(HTTP$::isabelle$HTTP$REST_Service$$_$apply$$anonfun$2$$anonfun$1);
                });
            }
            catch (Throwable exn) {
                UUID uuid = UUID$.MODULE$.random();
                this.progress.echo_error_message("Server error <" + uuid + ">: " + exn, this.progress.echo_error_message$default$2());
                some = Some$.MODULE$.apply((Object)HTTP$Response$.MODULE$.text("internal server error: " + uuid));
            }
            return some;
        }
    }

    public static class Request {
        private final String server_name;
        private final String service_name;
        private final URI uri;
        private final Bytes input;
        private final String uri_name;

        public Request(String server_name, String service_name, URI uri, Bytes input) {
            this.server_name = server_name;
            this.service_name = service_name;
            this.uri = uri;
            this.input = input;
            this.uri_name = uri.toString();
        }

        public String server_name() {
            return this.server_name;
        }

        public String service_name() {
            return this.service_name;
        }

        public URI uri() {
            return this.uri;
        }

        public Bytes input() {
            return this.input;
        }

        public String home() {
            return HTTP$.MODULE$.url_path((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.server_name(), this.service_name()}));
        }

        public String root() {
            return this.home() + "/";
        }

        public String query() {
            return this.home() + "?";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean toplevel() {
            String string = this.uri_name();
            String string2 = this.home();
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
            String string3 = this.uri_name();
            String string4 = this.root();
            if (string3 != null) {
                if (!string3.equals(string4)) return false;
                return true;
            }
            if (string4 == null) return true;
            return false;
        }

        public String uri_name() {
            return this.uri_name;
        }

        public Option<Path> uri_path() {
            return Option$.MODULE$.apply((Object)this.uri().getPath()).flatMap((Function1 & Serializable)_$2 -> Library$.MODULE$.try_unprefix(this.root(), (String)_$2)).withFilter(HTTP$::isabelle$HTTP$Request$$_$uri_path$$anonfun$2).map(HTTP$::isabelle$HTTP$Request$$_$uri_path$$anonfun$3).withFilter(HTTP$::isabelle$HTTP$Request$$_$uri_path$$anonfun$4).map(HTTP$::isabelle$HTTP$Request$$_$uri_path$$anonfun$5);
        }

        public Option<String> decode_query() {
            return Library$.MODULE$.try_unprefix(this.query(), this.uri_name()).map(HTTP$::isabelle$HTTP$Request$$_$decode_query$$anonfun$1);
        }

        public List<Tuple2<String, String>> decode_properties() {
            return ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)'&'), (Object)this.input().text())).map(HTTP$::isabelle$HTTP$Request$$_$decode_properties$$anonfun$1);
        }
    }

    public static class Response {
        private final Bytes output;
        private final String content_type;

        public static Response apply(Bytes bytes, String string) {
            return HTTP$Response$.MODULE$.apply(bytes, string);
        }

        public static Response content(Content content) {
            return HTTP$Response$.MODULE$.content(content);
        }

        public static Response empty() {
            return HTTP$Response$.MODULE$.empty();
        }

        public static Response html(String string) {
            return HTTP$Response$.MODULE$.html(string);
        }

        public static Response read(File file) {
            return HTTP$Response$.MODULE$.read(file);
        }

        public static Response read(Path path) {
            return HTTP$Response$.MODULE$.read(path);
        }

        public static Response text(String string) {
            return HTTP$Response$.MODULE$.text(string);
        }

        public static Bytes apply$default$1() {
            return HTTP$Response$.MODULE$.apply$default$1();
        }

        public static String apply$default$2() {
            return HTTP$Response$.MODULE$.apply$default$2();
        }

        public Response(Bytes output, String content_type) {
            this.output = output;
            this.content_type = content_type;
        }

        public Bytes output() {
            return this.output;
        }

        public String content_type() {
            return this.content_type;
        }

        public String toString() {
            return this.output().toString();
        }

        public void write(HttpExchange http, int code, boolean is_head) {
            http.getResponseHeaders().set("Content-Type", this.content_type());
            if (is_head) {
                String digest_base64 = SHA1$.MODULE$.digest(this.output()).base64();
                http.getResponseHeaders().set("Content-Digest", "sha=:" + digest_base64 + ":");
            }
            http.sendResponseHeaders(code, is_head ? -1L : this.output().size());
            if (!is_head) {
                package$.MODULE$.using(http.getResponseBody(), (JProcedure1 & Serializable)stream -> this.output().write_stream((OutputStream)stream));
                return;
            }
        }

        public boolean write$default$3() {
            return false;
        }
    }

    public static class Server {
        private final String name;
        private final HttpServer http_server;

        public Server(String name, HttpServer http_server) {
            this.name = name;
            this.http_server = http_server;
        }

        public String name() {
            return this.name;
        }

        public HttpServer http_server() {
            return this.http_server;
        }

        public void $plus$eq(Service service) {
            this.http_server().createContext(service.context(this.name()), service.handler(this.name()));
        }

        public void $minus$eq(Service service) {
            this.http_server().removeContext(service.context(this.name()));
        }

        public void start() {
            this.http_server().start();
        }

        public void stop() {
            this.http_server().stop(0);
        }

        public InetSocketAddress address() {
            return this.http_server().getAddress();
        }

        public String url() {
            return "http://" + this.address().getHostName() + ":" + this.address().getPort() + HTTP$.MODULE$.url_path((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.name()}));
        }

        public String toString() {
            return this.url();
        }
    }

    public static abstract class Service {
        private final String name;
        private final String method;

        public static String $lessinit$greater$default$2() {
            return HTTP$Service$.MODULE$.$lessinit$greater$default$2();
        }

        public Service(String name, String method) {
            this.name = name;
            this.method = method;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name();
        }

        public String index_path(String prefix, String index) {
            return Url$.MODULE$.index_path(prefix, index);
        }

        public String index_path$default$1() {
            return this.name();
        }

        public String index_path$default$2() {
            return "";
        }

        public abstract Option<Response> apply(Request var1);

        public String context(String server_name) {
            return (String)((Option)package$.MODULE$.proper_string().apply((Object)HTTP$.MODULE$.url_path((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{server_name, this.name()})))).getOrElse(HTTP$::isabelle$HTTP$Service$$_$context$$anonfun$1);
        }

        public HttpHandler handler(String server_name) {
            return arg_0 -> this.handler$$anonfun$1(server_name, arg_0);
        }

        private final Option handler$$anonfun$1$$anonfun$1(Request request$1) {
            return this.apply(request$1);
        }

        /*
         * Unable to fully structure code
         */
        private final /* synthetic */ void handler$$anonfun$1(String server_name$1, HttpExchange http) {
            uri = http.getRequestURI();
            input = (Bytes)package$.MODULE$.using(http.getRequestBody(), (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isabelle$HTTP$Service$$_$_$$anonfun$2(java.io.InputStream ), (Ljava/io/InputStream;)Lisabelle/Bytes;)());
            v0 = http.getRequestMethod();
            var6_5 = "HEAD";
            if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
            v1 = this.method;
            var7_6 = "GET";
            if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            is_head = v2;
            v3 = http.getRequestMethod();
            var8_8 = this.method;
            if (!(v3 == null ? var8_8 != null : v3.equals(var8_8) == false) || is_head) {
                request = new Request(server_name$1, this.name(), uri, input);
                var10_10 = Exn$.MODULE$.result((Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, handler$$anonfun$1$$anonfun$1(isabelle.HTTP$Request ), ()Lscala/Option;)((Service)this, (Request)request));
                if (var10_10 instanceof Exn.Res) {
                    var11_11 = Exn$Res$.MODULE$.unapply((Exn.Res)var10_10);
                    var12_12 = (Option)var11_11._1();
                    if (var12_12 instanceof Some) {
                        response = (Response)((Some)var12_12).value();
                        response.write(http, 200, is_head);
                        return;
                    }
                    if (None$.MODULE$.equals(var12_12)) {
                        HTTP$Response$.MODULE$.empty().write(http, 404, is_head);
                        return;
                    }
                }
                if (var10_10 instanceof Exn.Exn) {
                    var14_14 = Exn$Exn$.MODULE$.unapply((Exn.Exn)var10_10);
                    var15_15 = var14_14._1();
                    if (var15_15 != null && !(var16_16 = package$.MODULE$.ERROR().unapply(var15_15)).isEmpty()) {
                        msg = var17_17 = (String)var16_16.get();
                        HTTP$Response$.MODULE$.text(Output$.MODULE$.error_message_text(msg)).write(http, 500, is_head);
                        return;
                    }
                    exn = var15_15;
                    throw exn;
                }
                throw new MatchError(var10_10);
            }
            HTTP$Response$.MODULE$.empty().write(http, 400, HTTP$Response$.MODULE$.empty().write$default$3());
        }
    }

    public static class Welcome
    extends Service {
        public static String $lessinit$greater$default$1() {
            return HTTP$Welcome$.MODULE$.$lessinit$greater$default$1();
        }

        public Welcome(String name) {
            super(name, HTTP$Service$.MODULE$.$lessinit$greater$default$2());
        }

        private String name$accessor() {
            return super.name();
        }

        @Override
        public Option<Response> apply(Request request) {
            if (request.toplevel()) {
                return Some$.MODULE$.apply((Object)HTTP$Response$.MODULE$.text("Welcome to " + Isabelle_System$.MODULE$.identification()));
            }
            return None$.MODULE$;
        }
    }
}

