/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Delay;
import isabelle.Delay$;
import isabelle.Exn$Interrupt$;
import isabelle.File_Watcher$;
import isabelle.File_Watcher$State$;
import isabelle.Isabelle_Thread;
import isabelle.Isabelle_Thread$;
import isabelle.Synchronized;
import isabelle.Synchronized$;
import isabelle.Time;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class File_Watcher {
    public static File_Watcher apply(Function1<Set<File>, BoxedUnit> function1, Function0<Time> function0) {
        return File_Watcher$.MODULE$.apply(function1, function0);
    }

    public static File_Watcher none() {
        return File_Watcher$.MODULE$.none();
    }

    public static long apply$default$2() {
        return File_Watcher$.MODULE$.apply$default$2();
    }

    public void register(File dir) {
    }

    public void register_parent(File file) {
    }

    public void deregister(File dir) {
    }

    public void purge(Set<File> retain) {
    }

    public void shutdown() {
    }

    public static class Impl
    extends File_Watcher {
        private final Function1<Set<File>, BoxedUnit> handle;
        private final long delay;
        private final Synchronized<State> state;
        private final WatchService watcher;
        private final Delay delay_changed;
        private final Isabelle_Thread watcher_thread;

        public Impl(Function1<Set<File>, BoxedUnit> handle, long delay) {
            this.handle = handle;
            this.delay = delay;
            this.state = Synchronized$.MODULE$.apply(File_Watcher$State$.MODULE$.apply(File_Watcher$State$.MODULE$.$lessinit$greater$default$1(), File_Watcher$State$.MODULE$.$lessinit$greater$default$2()));
            this.watcher = FileSystems.getDefault().newWatchService();
            this.delay_changed = Delay$.MODULE$.last((Function0<Time>)(Function0 & Serializable)() -> new Time(this.$init$$$anonfun$1(delay)), Delay$.MODULE$.last$default$2(), Delay$.MODULE$.last$default$3(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.$init$$$anonfun$2(handle);
                return BoxedUnit.UNIT;
            });
            this.watcher_thread = Isabelle_Thread$.MODULE$.fork("file_watcher", Isabelle_Thread$.MODULE$.fork$default$2(), Isabelle_Thread$.MODULE$.fork$default$3(), true, Isabelle_Thread$.MODULE$.fork$default$5(), Isabelle_Thread$.MODULE$.fork$default$6(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.$init$$$anonfun$3();
                return BoxedUnit.UNIT;
            });
        }

        public String toString() {
            return this.state.value().dirs().keySet().mkString("File_Watcher(", ", ", ")");
        }

        @Override
        public void register(File dir) {
            this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
                WatchKey key;
                Option option = st.dirs().get((Object)dir);
                if (option instanceof Some && (key = (WatchKey)((Some)option).value()).isValid()) {
                    return st;
                }
                WatchKey key2 = dir.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                File file = (File)Predef$.MODULE$.ArrowAssoc((Object)dir);
                return st.copy((Map<File, WatchKey>)((Map)st.dirs().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)file, (Object)key2))), st.copy$default$2());
            });
        }

        @Override
        public void register_parent(File file) {
            File dir = file.getParentFile();
            if (dir != null && dir.isDirectory()) {
                this.register(dir);
                return;
            }
        }

        @Override
        public void deregister(File dir) {
            this.state.change((Function1<State, State>)((Function1 & Serializable)arg_0 -> File_Watcher$.isabelle$File_Watcher$Impl$$_$deregister$$anonfun$1(dir, arg_0)));
        }

        @Override
        public void purge(Set<File> retain) {
            this.state.change((Function1<State, State>)((Function1 & Serializable)arg_0 -> File_Watcher$.isabelle$File_Watcher$Impl$$_$purge$$anonfun$1(retain, arg_0)));
        }

        @Override
        public void shutdown() {
            this.watcher_thread.interrupt();
            this.watcher_thread.join();
            this.delay_changed.revoke(this.delay_changed.revoke$default$1());
        }

        private final long $init$$$anonfun$1(long delay$1) {
            return delay$1;
        }

        private final void $init$$$anonfun$2(Function1 handle$1) {
            Set changed = (Set)this.state.change_result((Function1 & Serializable)st -> {
                Set set = Predef$.MODULE$.Set().empty();
                Map<File, WatchKey> map = st.copy$default$1();
                return Tuple2$.MODULE$.apply(st.changed(), (Object)st.copy(map, (Set<File>)set));
            });
            handle$1.apply((Object)changed);
        }

        private final void $init$$$anonfun$3() {
            block3: {
                try {
                    while (true) {
                        WatchKey key = this.watcher.take();
                        boolean has_changed = BoxesRunTime.unboxToBoolean(this.state.change_result((Function1 & Serializable)st -> {
                            Tuple2 tuple2;
                            Option option = st.dirs().collectFirst((PartialFunction)new Serializable(key){
                                private final WatchKey key$2;
                                {
                                    this.key$2 = key$3;
                                }

                                public final boolean isDefinedAt(Tuple2 x) {
                                    Tuple2 tuple2 = x;
                                    if (tuple2 != null) {
                                        File dir = (File)tuple2._1();
                                        WatchKey key1 = (WatchKey)tuple2._2();
                                        WatchKey watchKey = this.key$2;
                                        WatchKey watchKey2 = key1;
                                        if (!(watchKey != null ? !watchKey.equals(watchKey2) : watchKey2 != null)) {
                                            return true;
                                        }
                                    }
                                    return false;
                                }

                                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                                    Tuple2 tuple2 = x;
                                    if (tuple2 != null) {
                                        File dir = (File)tuple2._1();
                                        WatchKey key1 = (WatchKey)tuple2._2();
                                        WatchKey watchKey = this.key$2;
                                        WatchKey watchKey2 = key1;
                                        if (!(watchKey != null ? !watchKey.equals(watchKey2) : watchKey2 != null)) {
                                            return dir;
                                        }
                                    }
                                    return function1.apply((Object)x);
                                }
                            });
                            if (option instanceof Some) {
                                File dir = (File)((Some)option).value();
                                Buffer events = CollectionConverters$.MODULE$.ListHasAsScala(key.pollEvents()).asScala();
                                None$ remove = key.reset() ? None$.MODULE$ : Some$.MODULE$.apply((Object)dir);
                                Set changed = (Set)events.iterator().foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(x$1, x$2) -> {
                                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                                    if (tuple2 != null) {
                                        Set set = (Set)tuple2._1();
                                        WatchEvent event = (WatchEvent)tuple2._2();
                                        return (Set)set.$plus((Object)dir.toPath().resolve((Path)event.context()).toFile());
                                    }
                                    throw new MatchError((Object)tuple2);
                                });
                                tuple2 = Tuple2$.MODULE$.apply((Object)remove, (Object)changed);
                            } else if (None$.MODULE$.equals(option)) {
                                key.pollEvents();
                                key.reset();
                                tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)Predef$.MODULE$.Set().empty());
                            } else {
                                throw new MatchError((Object)option);
                            }
                            Tuple2 tuple22 = tuple2;
                            Option remove = (Option)tuple22._1();
                            Set changed = (Set)tuple22._2();
                            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)changed.nonEmpty()), (Object)st.copy((Map<File, WatchKey>)((Map)st.dirs().$minus$minus((IterableOnce)remove)), (Set<File>)((Set)st.changed().$plus$plus((IterableOnce)changed))));
                        }));
                        if (!has_changed) continue;
                        this.delay_changed.invoke(this.delay_changed.invoke$default$1());
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && Exn$Interrupt$.MODULE$.unapply(throwable2)) break block3;
                    throw throwable;
                }
            }
        }
    }

    public static class State
    implements Product,
    Serializable {
        private final Map dirs;
        private final Set changed;

        public static State apply(Map<File, WatchKey> map, Set<File> set) {
            return File_Watcher$State$.MODULE$.apply(map, set);
        }

        public static State fromProduct(Product product) {
            return File_Watcher$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return File_Watcher$State$.MODULE$.unapply(state);
        }

        public static Map<File, WatchKey> $lessinit$greater$default$1() {
            return File_Watcher$State$.MODULE$.$lessinit$greater$default$1();
        }

        public static Set<File> $lessinit$greater$default$2() {
            return File_Watcher$State$.MODULE$.$lessinit$greater$default$2();
        }

        public State(Map<File, WatchKey> dirs, Set<File> changed) {
            this.dirs = dirs;
            this.changed = changed;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            Map<File, WatchKey> map = this.dirs();
            Map<File, WatchKey> map2 = state.dirs();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Set<File> set = this.changed();
            Set<File> set2 = state.changed();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "dirs";
            }
            if (1 == n2) {
                return "changed";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<File, WatchKey> dirs() {
            return this.dirs;
        }

        public Set<File> changed() {
            return this.changed;
        }

        public State copy(Map<File, WatchKey> dirs, Set<File> changed) {
            return new State(dirs, changed);
        }

        public Map<File, WatchKey> copy$default$1() {
            return this.dirs();
        }

        public Set<File> copy$default$2() {
            return this.changed();
        }

        public Map<File, WatchKey> _1() {
            return this.dirs();
        }

        public Set<File> _2() {
            return this.changed();
        }
    }
}

