/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash;
import isabelle.Bash$;
import isabelle.Component_Windows_App;
import isabelle.Component_Windows_App$Seven_Zip_Platform$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.Url$;
import isabelle.package$;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_Windows_App$
implements Serializable {
    private static final Path base_path;
    private static final String sfx_name;
    private static final Path sfx_path;
    private static final String sfx_txt;
    public static final Component_Windows_App$Seven_Zip_Platform$ Seven_Zip_Platform;
    private static final List<Component_Windows_App.Seven_Zip_Platform> seven_zip_platforms;
    private static final String default_launch4j_url;
    private static final String default_binutils_url;
    private static final String default_sfx_url;
    private static final String default_seven_zip_version;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Windows_App$ MODULE$;

    private Component_Windows_App$() {
    }

    static {
        MODULE$ = new Component_Windows_App$();
        base_path = Path$.MODULE$.basic("windows_app");
        sfx_name = "7zsd_All_x64.sfx";
        sfx_path = MODULE$.base_path().$plus(Path$.MODULE$.basic(MODULE$.sfx_name()));
        sfx_txt = ";!@Install@!UTF-8!\nGUIFlags=\"64\"\nInstallPath=\"%UserDesktop%\"\nBeginPrompt=\"Unpack {ISABELLE_NAME}?\"\nExtractPathText=\"Target directory\"\nExtractTitle=\"Unpacking {ISABELLE_NAME} ...\"\nShortcut=\"Du,{%%T\\{ISABELLE_NAME}\\{ISABELLE_NAME}.exe},{},{},{},{{ISABELLE_NAME}},{%%T\\{ISABELLE_NAME}}\"\nRunProgram=\"\\\"%%T\\{ISABELLE_NAME}\\{ISABELLE_NAME}.exe\\\"\"\nAutoInstall=\"\\\"%%T\\{ISABELLE_NAME}\\{ISABELLE_NAME}.exe\\\" -init\"\n;!@InstallEnd@!\n";
        seven_zip_platforms = (List)new .colon.colon((Object)Component_Windows_App$Seven_Zip_Platform$.MODULE$.apply("arm64-linux", "https://www.7-zip.org/a/7z{V}-linux-arm64.tar.xz"), (List)new .colon.colon((Object)Component_Windows_App$Seven_Zip_Platform$.MODULE$.apply("x86_64-darwin", "https://www.7-zip.org/a/7z{V}-mac.tar.xz"), (List)new .colon.colon((Object)Component_Windows_App$Seven_Zip_Platform$.MODULE$.apply("x86_64-linux", "https://www.7-zip.org/a/7z{V}-linux-x64.tar.xz"), (List)Nil$.MODULE$)));
        default_launch4j_url = "https://deac-riga.dl.sourceforge.net/project/launch4j/launch4j-3/3.50/launch4j-3.50-linux-x64.tgz";
        default_binutils_url = "https://ftp.gnu.org/gnu/binutils/binutils-2.26.1.tar.gz";
        default_sfx_url = "https://github.com/chrislake/7zsfxmm/releases/download/1.7.1.3901/7zsd_extra_171_3901.7z";
        default_seven_zip_version = "2409";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_windows_app", "build windows_app component from GNU binutils and launch4j", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef launch4j_url = ObjectRef.create((Object)this.default_launch4j_url());
            ObjectRef binutils_url = ObjectRef.create((Object)this.default_binutils_url());
            ObjectRef sfx_url = ObjectRef.create((Object)this.default_sfx_url());
            ObjectRef seven_zip_version = ObjectRef.create((Object)this.default_seven_zip_version());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[6];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                launch4j_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                binutils_url$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"W:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                sfx_url$1.elem = arg;
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"X:");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
                seven_zip_version$1.elem = arg;
            });
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)_$3 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_windows_app((String)launch4j_url.elem, (String)binutils_url.elem, (String)sfx_url.elem, (String)seven_zip_version.elem, progress, (Path)target_dir.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Windows_App$.class);
    }

    public String tool_platform() {
        Predef$.MODULE$.require(Platform$.MODULE$.is_unix(), Component_Windows_App$::tool_platform$$anonfun$1);
        return Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM64();
    }

    public Path tool_platform_path() {
        return Path$.MODULE$.basic(this.tool_platform());
    }

    public Path base_path() {
        return base_path;
    }

    public Path launch4j_jar(Path base) {
        return base.$plus(this.tool_platform_path()).$plus(Path$.MODULE$.basic("launch4j.jar"));
    }

    public Path launch4j_jar$default$1() {
        return this.base_path();
    }

    public Path seven_zip(Path base, boolean exe) {
        return base.$plus(this.tool_platform_path()).$plus(Path$.MODULE$.basic("7zip")).$plus(exe ? Path$.MODULE$.basic("7zz") : Path$.MODULE$.current());
    }

    public Path seven_zip$default$1() {
        return this.base_path();
    }

    public boolean seven_zip$default$2() {
        return false;
    }

    public String sfx_name() {
        return sfx_name;
    }

    public Path sfx_path() {
        return sfx_path;
    }

    public String sfx_txt() {
        return sfx_txt;
    }

    public String default_launch4j_url() {
        return default_launch4j_url;
    }

    public String default_binutils_url() {
        return default_binutils_url;
    }

    public String default_sfx_url() {
        return default_sfx_url;
    }

    public String default_seven_zip_version() {
        return default_seven_zip_version;
    }

    public void build_windows_app(String launch4j_url, String binutils_url, String sfx_url, String seven_zip_version, Progress progress, Path target_dir) {
        String platform_name = this.tool_platform();
        Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)tmp_dir -> {
            Path download_tar = tmp_dir.$plus(Path$.MODULE$.basic("download.tar.gz"));
            Components.Directory directory = Components$Directory$.MODULE$.apply(tmp_dir.$plus(Path$.MODULE$.basic("windows_app")), Components$Directory$.MODULE$.apply$default$2());
            Components.Directory component_dir = directory.create(directory.create$default$1(), directory.create$default$2());
            Path platform_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic(platform_name)));
            Path platform_bin_dir = platform_dir.$plus(Path$.MODULE$.basic("bin"));
            Isabelle_System$.MODULE$.download_file(launch4j_url, download_tar, progress);
            Isabelle_System$.MODULE$.extract(download_tar, platform_dir, true);
            Isabelle_System$.MODULE$.download_file(binutils_url, download_tar, progress);
            Isabelle_System$.MODULE$.extract(download_tar, (Path)tmp_dir, true);
            progress.echo("Building GNU binutils for " + platform_name + " ...", progress.echo$default$2());
            List build_script = (List)new .colon.colon((Object)"./configure --prefix=\"$PWD/target\" --target=x86_64-w64-mingw32", (List)new .colon.colon((Object)"make", (List)new .colon.colon((Object)"make install", (List)Nil$.MODULE$)));
            String string = build_script.mkString(" && ");
            JProcedure1 & Serializable intersect = (JProcedure1 & Serializable)_$1 -> progress.echo((String)_$1, true);
            JProcedure1 & Serializable intersect2 = (JProcedure1 & Serializable)_$2 -> progress.echo((String)_$2, true);
            String string2 = Isabelle_System$.MODULE$.bash$default$2();
            SSH.System system = Isabelle_System$.MODULE$.bash$default$3();
            Map<String, String> map = Isabelle_System$.MODULE$.bash$default$5();
            boolean bl = Isabelle_System$.MODULE$.bash$default$6();
            String string3 = Isabelle_System$.MODULE$.bash$default$7();
            Bash.Watchdog watchdog = Isabelle_System$.MODULE$.bash$default$10();
            boolean bl2 = Isabelle_System$.MODULE$.bash$default$11();
            Function0<BoxedUnit> function0 = Isabelle_System$.MODULE$.bash$default$12();
            Isabelle_System$.MODULE$.bash(string, string2, system, (Path)tmp_dir, map, bl, string3, (Function1<String, BoxedUnit>)intersect, (Function1<String, BoxedUnit>)intersect2, watchdog, bl2, function0).check();
            ((List)new .colon.colon((Object)"ld", (List)new .colon.colon((Object)"windres", (List)Nil$.MODULE$))).foreach((Function1)(JProcedure1 & Serializable)name -> Isabelle_System$.MODULE$.copy_file(tmp_dir.$plus(Path$.MODULE$.explode("target/bin")).$plus(Path$.MODULE$.basic("x86_64-w64-mingw32-" + name)), platform_bin_dir.$plus(Path$.MODULE$.basic((String)name))));
            Option option = seven_zip_platforms.find((Function1 & Serializable)platform -> {
                String string = platform.name();
                String string2 = platform_name;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (option instanceof Some) {
                Component_Windows_App.Seven_Zip_Platform platform2 = (Component_Windows_App.Seven_Zip_Platform)((Some)option).value();
                String url = platform2.url(seven_zip_version);
                String name2 = (String)Url$.MODULE$.get_base_name(url, Url$.MODULE$.get_base_name$default$2()).getOrElse(() -> Component_Windows_App$.$anonfun$10(url));
                Path download = tmp_dir.$plus(Path$.MODULE$.basic(name2));
                Isabelle_System$.MODULE$.download_file(url, download, progress);
                Isabelle_System$.MODULE$.extract(download, Isabelle_System$.MODULE$.make_directory(this.seven_zip(component_dir.path(), this.seven_zip$default$2())), Isabelle_System$.MODULE$.extract$default$3());
            } else if (None$.MODULE$.equals(option)) {
                package$.MODULE$.error().apply((Object)("No 7zip for platform " + package$.MODULE$.quote().apply((Object)platform_name)));
            } else {
                throw new MatchError((Object)option);
            }
            String sfx_archive_name = (String)Url$.MODULE$.get_base_name(sfx_url, Url$.MODULE$.get_base_name$default$2()).get();
            Isabelle_System$.MODULE$.download_file(sfx_url, tmp_dir.$plus(Path$.MODULE$.basic(sfx_archive_name)), progress);
            String string4 = File$.MODULE$.bash_path(this.seven_zip(component_dir.path(), true)) + " x " + Bash$.MODULE$.string(sfx_archive_name);
            String string5 = Isabelle_System$.MODULE$.bash$default$2();
            SSH.System system2 = Isabelle_System$.MODULE$.bash$default$3();
            Map<String, String> map2 = Isabelle_System$.MODULE$.bash$default$5();
            boolean bl3 = Isabelle_System$.MODULE$.bash$default$6();
            String string6 = Isabelle_System$.MODULE$.bash$default$7();
            Function1<String, BoxedUnit> function1 = Isabelle_System$.MODULE$.bash$default$8();
            Function1<String, BoxedUnit> function12 = Isabelle_System$.MODULE$.bash$default$9();
            Bash.Watchdog watchdog2 = Isabelle_System$.MODULE$.bash$default$10();
            boolean bl4 = Isabelle_System$.MODULE$.bash$default$11();
            Function0<BoxedUnit> function02 = Isabelle_System$.MODULE$.bash$default$12();
            Isabelle_System$.MODULE$.bash(string4, string5, system2, (Path)tmp_dir, map2, bl3, string6, function1, function12, watchdog2, bl4, function02).check();
            Isabelle_System$.MODULE$.copy_file(tmp_dir.$plus(Path$.MODULE$.basic(this.sfx_name())), component_dir.path());
            File$.MODULE$.write(component_dir.README(), "Auxiliary parts for Isabelle as Windows application\n===================================================\n\n* Application launcher: http://launch4j.sourceforge.net\n\n* Platform binaries \"ld\" and \"windres\" from GNU binutils:\n  " + binutils_url + build_script.mkString("\n\n    ", "\n    ", "") + "\n\n* Self-extracting installer:\n  " + sfx_url + "\n\nSee also Isabelle/Admin/Windows/.\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
            Path component_archive = Isabelle_System$.MODULE$.make_directory(target_dir).$plus(Path$.MODULE$.basic("windows_app-" + Date$Format$.MODULE$.alt_date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1()))).tar().gz());
            Isabelle_System$.MODULE$.gnutar("-czf " + File$.MODULE$.bash_path(component_archive) + " windows_app", (Path)tmp_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4(), Isabelle_System$.MODULE$.gnutar$default$5()).check();
            progress.echo("Component archive " + component_archive, progress.echo$default$2());
        });
    }

    public String build_windows_app$default$1() {
        return this.default_launch4j_url();
    }

    public String build_windows_app$default$2() {
        return this.default_binutils_url();
    }

    public String build_windows_app$default$3() {
        return this.default_sfx_url();
    }

    public String build_windows_app$default$4() {
        return this.default_seven_zip_version();
    }

    public Progress build_windows_app$default$5() {
        return new Progress();
    }

    public Path build_windows_app$default$6() {
        return Path$.MODULE$.current();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_windows_app [OPTIONS]\n\n  Options are:\n    -B           build GNU binutils from sources\n    -D DIR       target directory (default \".\")\n    -U URL       download URL for launch4j, default:\n                 " + this.default_launch4j_url() + "\n    -V URL       download URL for GNU binutils, default:\n                 " + this.default_binutils_url() + "\n    -W URL       download URL for 7zip sfx module, default:\n                 " + this.default_sfx_url() + "\n    -X VERSION   version for 7zip download (default: " + this.default_seven_zip_version() + ")\n    -v           verbose\n\n  Build Isabelle windows_app component from GNU binutils and launch4j.\n";
    }

    private static final Object tool_platform$$anonfun$1() {
        return "Linux or macOS platform required";
    }

    private static final String $anonfun$10(String url$1) {
        return (String)package$.MODULE$.error().apply((Object)("No base name in " + package$.MODULE$.quote().apply((Object)url$1)));
    }
}

