/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public final class Component_Minisat$
implements Serializable {
    private static final String default_download_url;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Minisat$ MODULE$;

    private Component_Minisat$() {
    }

    static {
        MODULE$ = new Component_Minisat$();
        default_download_url = "https://github.com/stp/minisat/archive/releases/2.2.1.tar.gz";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_minisat", "build prover component from sources", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef download_url = ObjectRef.create((Object)this.default_download_url());
            ObjectRef component_name = ObjectRef.create((Object)"");
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                download_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"n:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                component_name$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)_$2 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_minisat((String)download_url.elem, (String)component_name.elem, progress, (Path)target_dir.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Minisat$.class);
    }

    public String default_download_url() {
        return default_download_url;
    }

    public String make_component_name(String version) {
        return "minisat-" + version;
    }

    public void build_minisat(String download_url, String component_name, Progress progress, Path target_dir) {
        Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)tmp_dir -> {
            String string;
            String version;
            List list;
            Option option;
            String string2;
            String name;
            List list2;
            Option option2;
            String archive_name;
            Regex Archive_Name = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^.*?([^/]+)$"));
            Regex Version2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^v?([0-9.]+)\\.tar.gz$"));
            String string3 = download_url;
            String string4 = archive_name = string3 != null && !(option2 = Archive_Name.unapplySeq((CharSequence)string3)).isEmpty() && (list2 = (List)option2.get()).lengthCompare(1) == 0 ? (name = (string2 = (String)list2.apply(0))) : (String)package$.MODULE$.error().apply((Object)("Failed to determine source archive name from " + package$.MODULE$.quote().apply((Object)download_url)));
            String version2 = string4 != null && !(option = Version2.unapplySeq((CharSequence)string4)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0 ? (version = (string = (String)list.apply(0))) : (String)package$.MODULE$.error().apply((Object)("Failed to determine component version from " + package$.MODULE$.quote().apply((Object)archive_name)));
            String component = (String)((Option)package$.MODULE$.proper_string().apply((Object)component_name)).getOrElse(() -> Component_Minisat$.$anonfun$6(version2));
            Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component)), Components$Directory$.MODULE$.apply$default$2());
            Components.Directory component_dir = directory.create(progress, directory.create$default$2());
            String platform_name = Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM$default$1(), true);
            Path platform_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic(platform_name)));
            Path archive_path = tmp_dir.$plus(Path$.MODULE$.basic(archive_name));
            Isabelle_System$.MODULE$.download_file(download_url, archive_path, progress);
            Isabelle_System$.MODULE$.extract(archive_path, (Path)tmp_dir, Isabelle_System$.MODULE$.extract$default$3());
            Path source_dir = File$.MODULE$.get_dir((Path)tmp_dir, download_url);
            Isabelle_System$.MODULE$.extract(archive_path, component_dir.src(), true);
            progress.echo("Building Minisat for " + platform_name + " ...", progress.echo$default$2());
            Isabelle_System$.MODULE$.copy_file(source_dir.$plus(Path$.MODULE$.explode("LICENSE")), component_dir.path());
            if (Platform$.MODULE$.is_macos()) {
                File$.MODULE$.change(source_dir.$plus(Path$.MODULE$.explode("Makefile")), File$.MODULE$.change$default$2(), File$.MODULE$.change$default$3(), (Function1<String, String>)(Function1 & Serializable)_$1 -> _$1.replaceAll("--static", "").replaceAll("-Wl,-soname\\S+", ""));
            }
            boolean bl = progress.verbose();
            SSH.System system = progress.bash$default$2();
            Map<String, String> map = progress.bash$default$4();
            boolean bl2 = progress.bash$default$5();
            long l = progress.bash$default$7();
            boolean bl3 = progress.bash$default$8();
            progress.bash("make r", system, source_dir, map, bl2, bl, l, bl3).check();
            Isabelle_System$.MODULE$.copy_file(source_dir.$plus(Path$.MODULE$.explode("build/release/bin/minisat").platform_exe()), platform_dir);
            if (Platform$.MODULE$.is_windows()) {
                Isabelle_System$.MODULE$.copy_file(Path$.MODULE$.explode("/bin/cygwin1.dll"), platform_dir);
            }
            component_dir.write_settings("\nMINISAT_HOME=\"$COMPONENT/${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}\"\n\nISABELLE_MINISAT=\"$MINISAT_HOME/minisat\"\n");
            File$.MODULE$.write(component_dir.README(), "This Isabelle component provides Minisat " + version2 + " using the\nsources from " + download_url + "\n\nThe executables have been built via \"make r\"; macOS requires to\nremove options \"--static\" and \"-Wl,-soname,...\" from the Makefile.\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        });
    }

    public String build_minisat$default$1() {
        return this.default_download_url();
    }

    public String build_minisat$default$2() {
        return "";
    }

    public Progress build_minisat$default$3() {
        return new Progress();
    }

    public Path build_minisat$default$4() {
        return Path$.MODULE$.current();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_minisat [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       download URL\n                 (default: \"" + this.default_download_url() + "\")\n    -n NAME      component name (default: \"" + this.make_component_name("VERSION") + "\")\n    -v           verbose\n\n  Build prover component from official download.\n";
    }

    private static final String $anonfun$6(String version$1) {
        return MODULE$.make_component_name(version$1);
    }
}

