{- generated by Isabelle -}

{-  Title:      Isabelle/Time.hs
    Author:     Makarius
    LICENSE:    BSD 3-clause (Isabelle)

Time based on milliseconds.

See "$ISABELLE_HOME/src/Pure/General/time.scala"
-}

{-# LANGUAGE OverloadedStrings #-}

module Isabelle.Time (
  Time, seconds, minutes, ms, zero, is_zero, is_relevant,
  get_seconds, get_minutes, get_ms, message, now
)
where

import Text.Printf (printf)
import Data.Time.Clock.POSIX (getPOSIXTime)
import Isabelle.Bytes (Bytes)
import Isabelle.Library


newtype Time = Time Int

instance Eq Time where Time a == Time b = a == b
instance Ord Time where compare (Time a) (Time b) = compare a b
instance Num Time where
  fromInteger = Time . fromInteger
  Time a + Time b = Time (a + b)
  Time a - Time b = Time (a - b)
  Time a * Time b = Time (a * b)
  abs (Time a) = Time (abs a)
  signum (Time a) = Time (signum a)

seconds :: Double -> Time
seconds s = Time (round (s * 1000.0))

minutes :: Double -> Time
minutes m = Time (round (m * 60000.0))

ms :: Int -> Time
ms = Time

zero :: Time
zero = ms 0

is_zero :: Time -> Bool
is_zero (Time ms) = ms == 0

is_relevant :: Time -> Bool
is_relevant (Time ms) = ms >= 1

get_seconds :: Time -> Double
get_seconds (Time ms) = fromIntegral ms / 1000.0

get_minutes :: Time -> Double
get_minutes (Time ms) = fromIntegral ms / 60000.0

get_ms :: Time -> Int
get_ms (Time ms) = ms

instance Show Time where
  show t = printf "%.3f" (get_seconds t)

message :: Time -> Bytes
message t = make_bytes (show t) <> "s"

now :: IO Time
now = do
  t <- getPOSIXTime
  return $ Time (round (realToFrac t * 1000.0 :: Double))
