/*
 * Decompiled with CFR 0.152.
 */
package isabelle.vscode;

import isabelle.Command;
import isabelle.Document;
import isabelle.Document$Blobs$;
import isabelle.Document$Node$Name$;
import isabelle.Document$Pending_Edits$;
import isabelle.File$;
import isabelle.File_Watcher;
import isabelle.Line;
import isabelle.Line$;
import isabelle.Logger;
import isabelle.Markup;
import isabelle.Options;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Pretty$;
import isabelle.Rendering;
import isabelle.Resources;
import isabelle.Resources$;
import isabelle.Scan$;
import isabelle.Sessions;
import isabelle.Sessions$;
import isabelle.Spell_Checker_Variable;
import isabelle.Symbol$;
import isabelle.Symbol$Metric$;
import isabelle.Synchronized;
import isabelle.Synchronized$;
import isabelle.Text;
import isabelle.Thy_Header$;
import isabelle.XML;
import isabelle.XML$Elem$;
import isabelle.XML$Text$;
import isabelle.package$;
import isabelle.vscode.Channel;
import isabelle.vscode.LSP$PublishDiagnostics$;
import isabelle.vscode.Language_Server;
import isabelle.vscode.VSCode_Model;
import isabelle.vscode.VSCode_Model$;
import isabelle.vscode.VSCode_Rendering;
import isabelle.vscode.VSCode_Resources$;
import isabelle.vscode.VSCode_Resources$Caret$;
import isabelle.vscode.VSCode_Resources$State$;
import isabelle.vscode.VSCode_Session;
import java.io.File;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.parsing.input.Reader;

public class VSCode_Resources
extends Resources {
    private final Options options;
    private final Synchronized<State> state;
    private final Spell_Checker_Variable spell_checker;

    public static Logger $lessinit$greater$default$3() {
        return VSCode_Resources$.MODULE$.$lessinit$greater$default$3();
    }

    public VSCode_Resources(Options options, Sessions.Background session_background, Logger log) {
        this.options = options;
        super(session_background, log, Resources$.MODULE$.$lessinit$greater$default$3());
        this.state = Synchronized$.MODULE$.apply(VSCode_Resources$State$.MODULE$.apply(VSCode_Resources$State$.MODULE$.$lessinit$greater$default$1(), VSCode_Resources$State$.MODULE$.$lessinit$greater$default$2(), VSCode_Resources$State$.MODULE$.$lessinit$greater$default$3(), VSCode_Resources$State$.MODULE$.$lessinit$greater$default$4(), VSCode_Resources$State$.MODULE$.$lessinit$greater$default$5()));
        this.spell_checker = new Spell_Checker_Variable();
        this.spell_checker().update(options);
    }

    public Options options() {
        return this.options;
    }

    private Sessions.Background session_background$accessor() {
        return super.session_background();
    }

    public boolean pide_extensions() {
        return BoxesRunTime.unboxToBoolean((Object)this.options().bool().apply("vscode_pide_extensions"));
    }

    public boolean html_output() {
        return BoxesRunTime.unboxToBoolean((Object)this.options().bool().apply("vscode_html_output"));
    }

    public int tooltip_margin() {
        return BoxesRunTime.unboxToInt((Object)this.options().int().apply("vscode_tooltip_margin"));
    }

    public int message_margin() {
        return BoxesRunTime.unboxToInt((Object)this.options().int().apply("vscode_message_margin"));
    }

    public long output_delay() {
        return this.options().seconds("vscode_output_delay");
    }

    public boolean unicode_symbols_output() {
        return BoxesRunTime.unboxToBoolean((Object)this.options().bool().apply("vscode_unicode_symbols_output"));
    }

    public boolean unicode_symbols_edits() {
        return BoxesRunTime.unboxToBoolean((Object)this.options().bool().apply("vscode_unicode_symbols_edits"));
    }

    public File node_file(Document.Node.Name name) {
        return new File(name.node());
    }

    public Document.Node.Name node_name(File file) {
        return (Document.Node.Name)this.find_theory(file).getOrElse(() -> this.node_name$$anonfun$1(file));
    }

    @Override
    public Document.Node.Name migrate_name(Document.Node.Name standard_name) {
        return this.node_name(Path$.MODULE$.explode(standard_name.node()).canonical_file());
    }

    @Override
    public String append_path(String prefix, Path source_path) {
        Path path = source_path.expand();
        String string = prefix;
        String string2 = "";
        if (!(string == null ? string2 != null : !string.equals(string2)) || path.is_absolute()) {
            return File$.MODULE$.platform_path(path);
        }
        if (path.is_current()) {
            return prefix;
        }
        if (path.is_basic() && !prefix.endsWith("/") && !prefix.endsWith(File.separator)) {
            return prefix + File.separator + File$.MODULE$.platform_path(path);
        }
        if (path.is_basic()) {
            return prefix + File$.MODULE$.platform_path(path);
        }
        return File$.MODULE$.absolute(new File(prefix + File.separator + File$.MODULE$.platform_path(path))).getPath();
    }

    @Override
    public List<String> read_dir(String dir) {
        return File$.MODULE$.read_dir(Path$.MODULE$.explode(File$.MODULE$.standard_path(dir)));
    }

    public Iterable<VSCode_Model> get_models() {
        return this.state.value().models().values();
    }

    public Option<VSCode_Model> get_model(File file) {
        return this.state.value().models().get((Object)file);
    }

    public Option<VSCode_Model> get_model(Document.Node.Name name) {
        return this.get_model(this.node_file(name));
    }

    public Document.Snapshot snapshot(VSCode_Model model) {
        return model.session().snapshot(model.node_name(), Document$Pending_Edits$.MODULE$.make(this.get_models()));
    }

    public Option<Document.Snapshot> get_snapshot(File file) {
        return this.get_model(file).map((Function1 & Serializable)model -> this.snapshot((VSCode_Model)model));
    }

    public Option<Document.Snapshot> get_snapshot(Document.Node.Name name) {
        return this.get_model(name).map((Function1 & Serializable)model -> this.snapshot((VSCode_Model)model));
    }

    public VSCode_Rendering rendering(Document.Snapshot snapshot, VSCode_Model model) {
        return new VSCode_Rendering(snapshot, model);
    }

    public VSCode_Rendering rendering(VSCode_Model model) {
        return this.rendering(this.snapshot(model), model);
    }

    public Option<VSCode_Rendering> get_rendering(File file) {
        return this.get_model(file).map((Function1 & Serializable)model -> this.rendering((VSCode_Model)model));
    }

    public Option<VSCode_Rendering> get_rendering(Document.Node.Name name) {
        return this.get_model(name).map((Function1 & Serializable)model -> this.rendering((VSCode_Model)model));
    }

    public Option<String> read_file_content(Document.Node.Name name) {
        return this.make_theory_content(name).orElse(() -> this.read_file_content$$anonfun$1(name));
    }

    public Option<String> get_file_content(Document.Node.Name name) {
        Option<VSCode_Model> option = this.get_model(name);
        if (option instanceof Some) {
            VSCode_Model model = (VSCode_Model)((Some)option).value();
            return Some$.MODULE$.apply((Object)model.content().text());
        }
        if (None$.MODULE$.equals(option)) {
            return this.read_file_content(name);
        }
        throw new MatchError(option);
    }

    @Override
    public <A> A with_thy_reader(Document.Node.Name name, Function1<Reader<Object>, A> f) {
        File file = this.node_file(name);
        Option<VSCode_Model> option = this.get_model(file);
        if (option instanceof Some) {
            VSCode_Model model = (VSCode_Model)((Some)option).value();
            return (A)f.apply((Object)Scan$.MODULE$.char_reader(model.content().text()));
        }
        if (None$.MODULE$.equals(option)) {
            if (file.isFile()) {
                return package$.MODULE$.using(Scan$.MODULE$.byte_reader(file), f);
            }
            return (A)package$.MODULE$.error().apply((Object)("No such file: " + package$.MODULE$.quote().apply((Object)file.toString())));
        }
        throw new MatchError(option);
    }

    public boolean visible_node(Document.Node.Name name) {
        Option<VSCode_Model> option = this.get_model(name);
        if (option instanceof Some) {
            VSCode_Model model = (VSCode_Model)((Some)option).value();
            return model.node_visible();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public void change_model(VSCode_Session session, Language_Server.Editor editor, File file, long version, String text, Option<Line.Range> range) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            VSCode_Model model = (VSCode_Model)st.models().getOrElse((Object)file, () -> this.$anonfun$1(session, editor, file));
            VSCode_Model model1 = ((VSCode_Model)model.change_text(text, range).getOrElse(() -> VSCode_Resources.$anonfun$2(model))).set_version(version).external(false);
            File file = (File)Predef$.MODULE$.ArrowAssoc((Object)file);
            return st.update_models((Iterable<Tuple2<File, VSCode_Model>>)Option$.MODULE$.option2Iterable((Option)Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)file, (Object)model1))));
        });
    }

    public Option<Line.Range> change_model$default$6() {
        return None$.MODULE$;
    }

    public boolean close_model(File file) {
        return BoxesRunTime.unboxToBoolean(this.state.change_result((Function1 & Serializable)st -> {
            Option option = st.models().get((Object)file);
            if (None$.MODULE$.equals(option)) {
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), st);
            }
            if (option instanceof Some) {
                VSCode_Model model = (VSCode_Model)((Some)option).value();
                File file = (File)Predef$.MODULE$.ArrowAssoc((Object)file);
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)st.update_models((Iterable<Tuple2<File, VSCode_Model>>)Option$.MODULE$.option2Iterable((Option)Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)file, (Object)model.external(true))))));
            }
            throw new MatchError((Object)option);
        }));
    }

    public void sync_models(Set<File> changed_files) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            List changed_models = st.models().iterator().withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    VSCode_Model model = (VSCode_Model)tuple2._2();
                    return true;
                }
                return false;
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    VSCode_Model model = (VSCode_Model)tuple2._2();
                    return changed_files.apply((Object)file) && model.external_file();
                }
                throw new MatchError((Object)tuple2);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    VSCode_Model model = (VSCode_Model)tuple2._2();
                    return this.read_file_content(model.node_name()).flatMap((Function1 & Serializable)text -> model.change_text((String)text, model.change_text$default$2()).map((Function1 & Serializable)model1 -> Tuple2$.MODULE$.apply((Object)file, model1)));
                }
                throw new MatchError((Object)tuple2);
            }).toList();
            return st.update_models((Iterable<Tuple2<File, VSCode_Model>>)changed_models);
        });
    }

    public Document.Node.Overlays node_overlays(Document.Node.Name name) {
        return this.state.value().overlays().apply(name);
    }

    public void insert_overlay(Command command, String fn, List<String> args) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)_$3 -> _$3.change_overlay(true, this.node_file(command.node_name()), command, fn, args));
    }

    public void remove_overlay(Command command, String fn, List<String> args) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)_$4 -> _$4.change_overlay(false, this.node_file(command.node_name()), command, fn, args));
    }

    public Tuple2<Object, Object> resolve_dependencies(VSCode_Session session, Language_Server.Editor editor, File_Watcher file_watcher) {
        return (Tuple2)this.state.change_result((Function1 & Serializable)st -> {
            Option<Document.Version> stable_tip_version = session.stable_tip_version((Iterable<Document.Model>)st.models().values());
            List<Document.Node.Name> thy_files = this.resolve_dependencies((Iterable<Document.Model>)st.models().values(), editor.document_required());
            List aux_files = stable_tip_version.toList().flatMap((Function1 & Serializable)version -> this.undefined_blobs((Document.Version)version));
            List loaded_models = thy_files.iterator().$plus$plus(() -> VSCode_Resources.$anonfun$7(aux_files)).map((Function1 & Serializable)node_name -> {
                File file = this.node_file((Document.Node.Name)node_name);
                return Tuple2$.MODULE$.apply(node_name, (Object)file);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Document.Node.Name node_name = (Document.Node.Name)tuple2._1();
                    File file = (File)tuple2._2();
                    return !st.models().isDefinedAt((Object)file);
                }
                throw new MatchError((Object)tuple2);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Document.Node.Name node_name = (Document.Node.Name)tuple2._1();
                    File file = (File)tuple2._2();
                    file_watcher.register_parent(file);
                    return this.read_file_content(node_name).map((Function1 & Serializable)text -> {
                        VSCode_Model model = VSCode_Model$.MODULE$.init(session, editor, node_name);
                        VSCode_Model model1 = ((VSCode_Model)model.change_text((String)text, model.change_text$default$2()).getOrElse(() -> VSCode_Resources.$anonfun$11(model))).external(true);
                        return Tuple2$.MODULE$.apply((Object)file, (Object)model1);
                    });
                }
                throw new MatchError((Object)tuple2);
            }).toList();
            boolean invoke_input = loaded_models.nonEmpty();
            boolean invoke_load = stable_tip_version.isEmpty();
            return Tuple2$.MODULE$.apply((Object)new Tuple2.mcZZ.sp(invoke_input, invoke_load), (Object)st.update_models((Iterable<Tuple2<File, VSCode_Model>>)loaded_models));
        });
    }

    public void flush_input(VSCode_Session session, Channel channel) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            List changed_models = st.pending_input().iterator().flatMap((Function1 & Serializable)file -> st.models().get(file).flatMap((Function1 & Serializable)model -> model.flush_edits(st.document_blobs(), (File)file, st.get_caret((File)file)).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    List edits = (List)tuple2._1();
                    VSCode_Model model1 = (VSCode_Model)tuple2._2();
                    return true;
                }
                return false;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    List edits = (List)tuple2._1();
                    VSCode_Model model1 = (VSCode_Model)tuple2._2();
                    return Tuple2$.MODULE$.apply((Object)edits, (Object)Tuple2$.MODULE$.apply(file, (Object)model1));
                }
                throw new MatchError((Object)tuple2);
            }))).toList();
            session.update(st.document_blobs(), (List<Tuple2<Document.Node.Name, Document.Node.Edit<Text.Edit, Text.Perspective>>>)changed_models.flatMap((Function1 & Serializable)_$5 -> (IterableOnce)_$5._1()));
            Map map = (Map)st.models().$plus$plus((IterableOnce)changed_models.iterator().map((Function1 & Serializable)_$6 -> (Tuple2)_$6._2()));
            Set set = Predef$.MODULE$.Set().empty();
            Option<Tuple2<File, Line.Position>> option = st.copy$default$2();
            Document.Overlays overlays = st.copy$default$3();
            Set<File> set2 = st.copy$default$5();
            return st.copy((Map<File, VSCode_Model>)map, option, overlays, (Set<File>)set, set2);
        });
    }

    public void update_output(Iterable<File> changed_nodes) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            Set set = (Set)st.pending_output().$plus$plus((IterableOnce)changed_nodes);
            Map<File, VSCode_Model> map = st.copy$default$1();
            Option<Tuple2<File, Line.Position>> option = st.copy$default$2();
            Document.Overlays overlays = st.copy$default$3();
            Set<File> set2 = st.copy$default$4();
            return st.copy(map, option, overlays, set2, (Set<File>)set);
        });
    }

    public void update_output_visible() {
        this.state.change((Function1<State, State>)(Function1 & Serializable)st -> {
            Set set = (Set)st.pending_output().$plus$plus((IterableOnce)st.models().iterator().withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    VSCode_Model model = (VSCode_Model)tuple2._2();
                    return true;
                }
                return false;
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    VSCode_Model model = (VSCode_Model)tuple2._2();
                    return model.node_visible();
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    VSCode_Model model = (VSCode_Model)tuple2._2();
                    return file;
                }
                throw new MatchError((Object)tuple2);
            }));
            Map<File, VSCode_Model> map = st.copy$default$1();
            Option<Tuple2<File, Line.Position>> option = st.copy$default$2();
            Document.Overlays overlays = st.copy$default$3();
            Set<File> set2 = st.copy$default$4();
            return st.copy(map, option, overlays, set2, (Set<File>)set);
        });
    }

    public boolean flush_output(Channel channel) {
        return BoxesRunTime.unboxToBoolean(this.state.change_result((Function1 & Serializable)st -> {
            Tuple2 tuple2 = st.pending_output().iterator().flatMap((Function1 & Serializable)file -> st.models().get(file).map((Function1 & Serializable)model -> Tuple3$.MODULE$.apply(file, model, (Object)this.rendering((VSCode_Model)model)))).toList().partition((Function1 & Serializable)_$7 -> ((Rendering)_$7._3()).snapshot().is_outdated());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List postponed = (List)tuple2._1();
            List flushed = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)postponed, (Object)flushed);
            List postponed2 = (List)tuple22._1();
            List flushed2 = (List)tuple22._2();
            Iterator changed_iterator = flushed2.iterator().withFilter((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    File file = (File)tuple3._1();
                    VSCode_Model model = (VSCode_Model)tuple3._2();
                    VSCode_Rendering rendering = (VSCode_Rendering)tuple3._3();
                    Tuple3 $2$ = tuple3;
                    return true;
                }
                return false;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    File file = (File)tuple3._1();
                    VSCode_Model model = (VSCode_Model)tuple3._2();
                    VSCode_Rendering rendering = (VSCode_Rendering)tuple3._3();
                    Tuple3 $2$ = tuple3;
                    Tuple3<Option<List<Text.Info<Command.Results>>>, Option<List<VSCode_Model.Decoration>>, VSCode_Model> tuple32 = model.publish(rendering);
                    if (tuple32 == null) {
                        throw new MatchError(tuple32);
                    }
                    Option changed_diags = (Option)tuple32._1();
                    Option changed_decos = (Option)tuple32._2();
                    VSCode_Model model1 = (VSCode_Model)tuple32._3();
                    Tuple3<Option<List<Text.Info<Command.Results>>>, Option<List<VSCode_Model.Decoration>>, VSCode_Model> $3$ = tuple32;
                    Tuple4 tuple4 = Tuple4$.MODULE$.apply($3$, (Object)changed_diags, (Object)changed_decos, (Object)model1);
                    Tuple3 $3$2 = (Tuple3)tuple4._1();
                    Option changed_diags2 = (Option)tuple4._2();
                    Option changed_decos2 = (Option)tuple4._3();
                    VSCode_Model model12 = (VSCode_Model)tuple4._4();
                    return Tuple2$.MODULE$.apply((Object)$2$, (Object)$3$2);
                }
                throw new MatchError((Object)tuple3);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    Tuple3 tuple32 = (Tuple3)tuple2._2();
                    if (tuple3 != null) {
                        File file = (File)tuple3._1();
                        VSCode_Model model = (VSCode_Model)tuple3._2();
                        VSCode_Rendering rendering = (VSCode_Rendering)tuple3._3();
                        if (tuple32 != null) {
                            Option changed_diags = (Option)tuple32._1();
                            Option changed_decos = (Option)tuple32._2();
                            VSCode_Model model1 = (VSCode_Model)tuple32._3();
                            return changed_diags.isDefined() || changed_decos.isDefined();
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    Tuple3 tuple32 = (Tuple3)tuple2._2();
                    if (tuple3 != null) {
                        File file = (File)tuple3._1();
                        VSCode_Model model = (VSCode_Model)tuple3._2();
                        VSCode_Rendering rendering = (VSCode_Rendering)tuple3._3();
                        if (tuple32 != null) {
                            Option changed_diags = (Option)tuple32._1();
                            Option changed_decos = (Option)tuple32._2();
                            VSCode_Model model1 = (VSCode_Model)tuple32._3();
                            changed_diags.foreach((Function1)(JProcedure1 & Serializable)diags -> channel.write(LSP$PublishDiagnostics$.MODULE$.apply(file, rendering.diagnostics_output((List<Text.Info<Command.Results>>)diags))));
                            if (this.pide_extensions()) {
                                changed_decos.foreach((Function1)(JProcedure1 & Serializable)decos -> channel.write(rendering.decoration_output((List<VSCode_Model.Decoration>)decos).json(file)));
                            }
                            return Tuple2$.MODULE$.apply((Object)file, (Object)model1);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            Map map = (Map)st.models().$plus$plus((IterableOnce)changed_iterator);
            Set set = postponed2.map((Function1 & Serializable)_$8 -> (File)_$8._1()).toSet();
            Option<Tuple2<File, Line.Position>> option = st.copy$default$2();
            Document.Overlays overlays = st.copy$default$3();
            Set<File> set2 = st.copy$default$4();
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)postponed2.nonEmpty()), (Object)st.copy((Map<File, VSCode_Model>)map, option, overlays, set2, (Set<File>)set));
        }));
    }

    public String output_text(String content) {
        return Symbol$.MODULE$.output(this.unicode_symbols_output(), content);
    }

    public String output_edit(String content) {
        return Symbol$.MODULE$.output(this.unicode_symbols_edits(), content);
    }

    public List<XML.Tree> output_text_xml(List<XML.Tree> body) {
        return body.map((Function1 & Serializable)x$1 -> {
            XML.Tree tree;
            XML.Tree tree2 = x$1;
            if (tree2 instanceof XML.Elem) {
                XML.Elem elem = XML$Elem$.MODULE$.unapply((XML.Elem)tree2);
                Markup markup = elem._1();
                List<XML.Tree> list = elem._2();
                Markup markup2 = markup;
                List<XML.Tree> body = list;
                tree = XML$Elem$.MODULE$.apply(markup2, this.output_text_xml(body));
            } else if (tree2 instanceof XML.Text) {
                String string;
                XML.Text text = XML$Text$.MODULE$.unapply((XML.Text)tree2);
                String content = string = text._1();
                tree = XML$Text$.MODULE$.apply(this.output_text(content));
            } else {
                throw new MatchError((Object)tree2);
            }
            return tree;
        });
    }

    public String output_pretty(List<XML.Tree> body, double margin) {
        Symbol$Metric$ symbol$Metric$ = Symbol$Metric$.MODULE$;
        Function1<String, String> function1 = Pretty$.MODULE$.string_of$default$2();
        double d = Pretty$.MODULE$.string_of$default$4();
        boolean bl = Pretty$.MODULE$.string_of$default$6();
        return this.output_text(Pretty$.MODULE$.string_of(body, function1, margin, d, symbol$Metric$, bl));
    }

    public String output_pretty_tooltip(List<XML.Tree> body) {
        return this.output_pretty(body, Int$.MODULE$.int2double(this.tooltip_margin()));
    }

    public String output_pretty_message(List<XML.Tree> body) {
        return this.output_pretty(body, Int$.MODULE$.int2double(this.message_margin()));
    }

    public void update_caret(Option<Tuple2<File, Line.Position>> caret) {
        this.state.change((Function1<State, State>)(Function1 & Serializable)_$9 -> _$9.update_caret(caret));
    }

    public Option<Caret> get_caret() {
        State st = this.state.value();
        return st.caret().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                Line.Position pos = (Line.Position)tuple2._2();
                return true;
            }
            return false;
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                Line.Position pos = (Line.Position)tuple2._2();
                return st.models().get((Object)file).flatMap((Function1 & Serializable)model -> model.content().doc().offset(pos).map((Function1 & Serializable)offset -> VSCode_Resources$Caret$.MODULE$.apply(file, model, BoxesRunTime.unboxToInt((Object)offset))));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void force_decorations(Channel channel, File file) {
        VSCode_Rendering rendering1;
        VSCode_Model model = (VSCode_Model)this.state.value().models().apply((Object)file);
        Tuple3<List<Text.Info<Command.Results>>, List<VSCode_Model.Decoration>, VSCode_Model> tuple3 = model.publish_full(rendering1 = this.rendering(model));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        List decos = (List)tuple3._2();
        VSCode_Model model1 = (VSCode_Model)tuple3._3();
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)decos, (Object)model1);
        List decos2 = (List)tuple2._1();
        VSCode_Model model12 = (VSCode_Model)tuple2._2();
        if (this.pide_extensions()) {
            channel.write(rendering1.decoration_output((List<VSCode_Model.Decoration>)decos2).json(file));
            return;
        }
    }

    public Spell_Checker_Variable spell_checker() {
        return this.spell_checker;
    }

    private final Document.Node.Name node_name$$anonfun$1(File file$1) {
        String node = file$1.getPath();
        String theory = this.theory_name(Sessions$.MODULE$.DRAFT(), Thy_Header$.MODULE$.theory_name(node));
        if (this.loaded_theory(theory)) {
            return Document$Node$Name$.MODULE$.loaded_theory(theory);
        }
        return Document$Node$Name$.MODULE$.apply(node, theory);
    }

    private final Option read_file_content$$anonfun$1(Document.Node.Name name$1) {
        Some some;
        try {
            some = Some$.MODULE$.apply((Object)Line$.MODULE$.normalize(File$.MODULE$.read(this.node_file(name$1))));
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    private final VSCode_Model $anonfun$1(VSCode_Session session$2, Language_Server.Editor editor$2, File file$3) {
        return VSCode_Model$.MODULE$.init(session$2, editor$2, this.node_name(file$3));
    }

    private static final VSCode_Model $anonfun$2(VSCode_Model model$1) {
        return model$1;
    }

    private static final IterableOnce $anonfun$7(List aux_files$1) {
        return aux_files$1.iterator();
    }

    private static final VSCode_Model $anonfun$11(VSCode_Model model$3) {
        return model$3;
    }

    public static class Caret
    implements Product,
    Serializable {
        private final File file;
        private final VSCode_Model model;
        private final int offset;

        public static Caret apply(File file, VSCode_Model vSCode_Model, int n) {
            return VSCode_Resources$Caret$.MODULE$.apply(file, vSCode_Model, n);
        }

        public static Caret fromProduct(Product product) {
            return VSCode_Resources$Caret$.MODULE$.fromProduct(product);
        }

        public static Caret unapply(Caret caret) {
            return VSCode_Resources$Caret$.MODULE$.unapply(caret);
        }

        public Caret(File file, VSCode_Model model, int offset) {
            this.file = file;
            this.model = model;
            this.offset = offset;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.file()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.model()));
            n = Statics.mix((int)n, (int)this.offset());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Caret)) return false;
            Caret caret = (Caret)object;
            File file = this.file();
            File file2 = caret.file();
            if (file == null) {
                if (file2 != null) {
                    return false;
                }
            } else if (!((Object)file).equals(file2)) return false;
            VSCode_Model vSCode_Model = this.model();
            VSCode_Model vSCode_Model2 = caret.model();
            if (vSCode_Model == null) {
                if (vSCode_Model2 != null) {
                    return false;
                }
            } else if (!((Object)vSCode_Model).equals(vSCode_Model2)) return false;
            if (this.offset() != caret.offset()) return false;
            if (!caret.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Caret;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Caret";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "file";
                }
                case 1: {
                    return "model";
                }
                case 2: {
                    return "offset";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public File file() {
            return this.file;
        }

        public VSCode_Model model() {
            return this.model;
        }

        public int offset() {
            return this.offset;
        }

        public Document.Node.Name node_name() {
            return this.model().node_name();
        }

        public Caret copy(File file, VSCode_Model model, int offset) {
            return new Caret(file, model, offset);
        }

        public File copy$default$1() {
            return this.file();
        }

        public VSCode_Model copy$default$2() {
            return this.model();
        }

        public int copy$default$3() {
            return this.offset();
        }

        public File _1() {
            return this.file();
        }

        public VSCode_Model _2() {
            return this.model();
        }

        public int _3() {
            return this.offset();
        }
    }

    public static class State
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(State.class.getDeclaredField("document_blobs$lzy1"));
        private final Map models;
        private final Option caret;
        private final Document.Overlays overlays;
        private final Set pending_input;
        private final Set pending_output;
        private volatile Object document_blobs$lzy1;

        public static State apply(Map<File, VSCode_Model> map, Option<Tuple2<File, Line.Position>> option, Document.Overlays overlays, Set<File> set, Set<File> set2) {
            return VSCode_Resources$State$.MODULE$.apply(map, option, overlays, set, set2);
        }

        public static State fromProduct(Product product) {
            return VSCode_Resources$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return VSCode_Resources$State$.MODULE$.unapply(state);
        }

        public static Map<File, VSCode_Model> $lessinit$greater$default$1() {
            return VSCode_Resources$State$.MODULE$.$lessinit$greater$default$1();
        }

        public static Option<Tuple2<File, Line.Position>> $lessinit$greater$default$2() {
            return VSCode_Resources$State$.MODULE$.$lessinit$greater$default$2();
        }

        public static Document.Overlays $lessinit$greater$default$3() {
            return VSCode_Resources$State$.MODULE$.$lessinit$greater$default$3();
        }

        public static Set<File> $lessinit$greater$default$4() {
            return VSCode_Resources$State$.MODULE$.$lessinit$greater$default$4();
        }

        public static Set<File> $lessinit$greater$default$5() {
            return VSCode_Resources$State$.MODULE$.$lessinit$greater$default$5();
        }

        public State(Map<File, VSCode_Model> models, Option<Tuple2<File, Line.Position>> caret, Document.Overlays overlays, Set<File> pending_input, Set<File> pending_output) {
            this.models = models;
            this.caret = caret;
            this.overlays = overlays;
            this.pending_input = pending_input;
            this.pending_output = pending_output;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            Map<File, VSCode_Model> map = this.models();
            Map<File, VSCode_Model> map2 = state.models();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<Tuple2<File, Line.Position>> option = this.caret();
            Option<Tuple2<File, Line.Position>> option2 = state.caret();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Document.Overlays overlays = this.overlays();
            Document.Overlays overlays2 = state.overlays();
            if (overlays == null) {
                if (overlays2 != null) {
                    return false;
                }
            } else if (!overlays.equals(overlays2)) return false;
            Set<File> set = this.pending_input();
            Set<File> set2 = state.pending_input();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<File> set3 = this.pending_output();
            Set<File> set4 = state.pending_output();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "models";
                }
                case 1: {
                    return "caret";
                }
                case 2: {
                    return "overlays";
                }
                case 3: {
                    return "pending_input";
                }
                case 4: {
                    return "pending_output";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<File, VSCode_Model> models() {
            return this.models;
        }

        public Option<Tuple2<File, Line.Position>> caret() {
            return this.caret;
        }

        public Document.Overlays overlays() {
            return this.overlays;
        }

        public Set<File> pending_input() {
            return this.pending_input;
        }

        public Set<File> pending_output() {
            return this.pending_output;
        }

        public State update_models(Iterable<Tuple2<File, VSCode_Model>> changed) {
            Map map = (Map)this.models().$plus$plus(changed);
            Set set = (Set)changed.foldLeft(this.pending_input(), VSCode_Resources$::isabelle$vscode$VSCode_Resources$State$$_$_$$anonfun$24);
            Set set2 = (Set)changed.foldLeft(this.pending_output(), VSCode_Resources$::isabelle$vscode$VSCode_Resources$State$$_$_$$anonfun$25);
            Option<Tuple2<File, Line.Position>> option = this.copy$default$2();
            Document.Overlays overlays = this.copy$default$3();
            return this.copy((Map<File, VSCode_Model>)map, option, overlays, (Set<File>)set, (Set<File>)set2);
        }

        public State update_caret(Option<Tuple2<File, Line.Position>> new_caret) {
            Option<Tuple2<File, Line.Position>> option = this.caret();
            Option<Tuple2<File, Line.Position>> option2 = new_caret;
            if (!(option != null ? !option.equals(option2) : option2 != null)) {
                return this;
            }
            Set set = (Set)this.pending_input().$plus$plus((IterableOnce)this.caret().map(VSCode_Resources$::isabelle$vscode$VSCode_Resources$State$$_$_$$anonfun$26)).$plus$plus((IterableOnce)new_caret.map(VSCode_Resources$::isabelle$vscode$VSCode_Resources$State$$_$_$$anonfun$27));
            Map<File, VSCode_Model> map = this.copy$default$1();
            Document.Overlays overlays = this.copy$default$3();
            Set<File> set2 = this.copy$default$5();
            return this.copy(map, new_caret, overlays, (Set<File>)set, set2);
        }

        public Option<Line.Position> get_caret(File file) {
            Tuple2 tuple2;
            Option<Tuple2<File, Line.Position>> option = this.caret();
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                File caret_file = (File)tuple2._1();
                Line.Position caret_pos = (Line.Position)tuple2._2();
                File file2 = caret_file;
                File file3 = file;
                if (!(file2 != null ? !((Object)file2).equals(file3) : file3 != null)) {
                    return Some$.MODULE$.apply((Object)caret_pos);
                }
            }
            return None$.MODULE$;
        }

        public Document.Blobs document_blobs() {
            Object object = this.document_blobs$lzy1;
            if (object instanceof Document.Blobs) {
                return (Document.Blobs)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Document.Blobs)this.document_blobs$lzyINIT1();
        }

        private Object document_blobs$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.document_blobs$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Document.Blobs blobs = null;
                        try {
                            blobs = Document$Blobs$.MODULE$.apply((Map<Document.Node.Name, Document.Blobs.Item>)this.models().iterator().withFilter(VSCode_Resources$::isabelle$vscode$VSCode_Resources$State$$_$document_blobs$lzyINIT1$$anonfun$1).flatMap(VSCode_Resources$::isabelle$vscode$VSCode_Resources$State$$_$document_blobs$lzyINIT1$$anonfun$2).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                            object2 = blobs == null ? LazyVals.NullValue$.MODULE$ : blobs;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.document_blobs$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return blobs;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public State change_overlay(boolean insert, File file, Command command, String fn, List<String> args) {
            Document.Overlays overlays = insert ? this.overlays().insert(command, fn, args) : this.overlays().remove(command, fn, args);
            Set set = (Set)this.pending_input().$plus((Object)file);
            Map<File, VSCode_Model> map = this.copy$default$1();
            Option<Tuple2<File, Line.Position>> option = this.copy$default$2();
            Set<File> set2 = this.copy$default$5();
            return this.copy(map, option, overlays, (Set<File>)set, set2);
        }

        public State copy(Map<File, VSCode_Model> models, Option<Tuple2<File, Line.Position>> caret, Document.Overlays overlays, Set<File> pending_input, Set<File> pending_output) {
            return new State(models, caret, overlays, pending_input, pending_output);
        }

        public Map<File, VSCode_Model> copy$default$1() {
            return this.models();
        }

        public Option<Tuple2<File, Line.Position>> copy$default$2() {
            return this.caret();
        }

        public Document.Overlays copy$default$3() {
            return this.overlays();
        }

        public Set<File> copy$default$4() {
            return this.pending_input();
        }

        public Set<File> copy$default$5() {
            return this.pending_output();
        }

        public Map<File, VSCode_Model> _1() {
            return this.models();
        }

        public Option<Tuple2<File, Line.Position>> _2() {
            return this.caret();
        }

        public Document.Overlays _3() {
            return this.overlays();
        }

        public Set<File> _4() {
            return this.pending_input();
        }

        public Set<File> _5() {
            return this.pending_output();
        }
    }
}

