/*
 * Decompiled with CFR 0.152.
 */
package isabelle.vscode;

import isabelle.Command;
import isabelle.Document;
import isabelle.Editor;
import isabelle.Editor$Output$;
import isabelle.Session;
import isabelle.Session$Caret_Focus$;
import isabelle.Session$Consumer$;
import isabelle.Synchronized;
import isabelle.Synchronized$;
import isabelle.package$;
import isabelle.vscode.Dynamic_Output$;
import isabelle.vscode.LSP;
import isabelle.vscode.LSP$Dynamic_Output$;
import isabelle.vscode.Language_Server;
import isabelle.vscode.Pretty_Text_Panel;
import isabelle.vscode.Pretty_Text_Panel$;
import isabelle.vscode.VSCode_Resources;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Set;
import scala.runtime.function.JProcedure1;

public class Dynamic_Output {
    private final Language_Server server;
    private final Synchronized<Option<Pretty_Text_Panel>> pretty_panel_;
    private final Session.Consumer<Object> main;

    public static Dynamic_Output apply(Language_Server language_Server) {
        return Dynamic_Output$.MODULE$.apply(language_Server);
    }

    public Dynamic_Output(Language_Server server) {
        this.server = server;
        this.pretty_panel_ = Synchronized$.MODULE$.apply(None$.MODULE$);
        this.main = Session$Consumer$.MODULE$.apply(this.getClass().getName(), (JProcedure1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof Session.Commands_Changed) {
                Session.Commands_Changed changed = (Session.Commands_Changed)object;
                this.handle_update((Option<Set<Command>>)(changed.assignment() ? None$.MODULE$ : Some$.MODULE$.apply(changed.commands())));
                return;
            }
            if (Session$Caret_Focus$.MODULE$.equals(object)) {
                this.handle_update(this.handle_update$default$1());
                return;
            }
            throw new MatchError(object);
        });
    }

    public Pretty_Text_Panel pretty_panel() {
        return (Pretty_Text_Panel)this.pretty_panel_.value().getOrElse(Dynamic_Output::pretty_panel$$anonfun$1);
    }

    private void handle_update(Option<Set<Command>> restriction) {
        Editor.Output output;
        Option<VSCode_Resources.Caret> option = this.server.resources().get_caret();
        if (None$.MODULE$.equals(option)) {
            output = Editor$Output$.MODULE$.init();
        } else if (option instanceof Some) {
            VSCode_Resources.Caret caret = (VSCode_Resources.Caret)((Some)option).value();
            Document.Snapshot snapshot = this.server.resources().snapshot(caret.model());
            output = this.server.editor().output(snapshot, caret.offset(), this.server.editor().output$default$3());
        } else {
            throw new MatchError(option);
        }
        Editor.Output output2 = output;
        if (output2.defined()) {
            this.pretty_panel().refresh(output2.messages());
            return;
        }
    }

    private Option<Set<Command>> handle_update$default$1() {
        return None$.MODULE$;
    }

    public void init() {
        this.server.session().commands_changed().$plus$eq(this.main);
        this.server.session().caret_focus().$plus$eq(this.main);
        this.pretty_panel_.change((Function1<Option<Pretty_Text_Panel>, Option<Pretty_Text_Panel>>)(Function1 & Serializable)_$1 -> Some$.MODULE$.apply((Object)Pretty_Text_Panel$.MODULE$.apply(this.server.session(), this.server.channel(), (Function2<String, Option<LSP.Decoration>, Object>)(Function2 & Serializable)(content, decorations) -> LSP$Dynamic_Output$.MODULE$.apply((String)content, (Option<LSP.Decoration>)decorations))));
        this.handle_update(this.handle_update$default$1());
    }

    public void exit() {
        this.server.session().commands_changed().$minus$eq(this.main);
        this.server.session().caret_focus().$minus$eq(this.main);
    }

    public void set_margin(double margin) {
        this.pretty_panel().update_margin(margin);
    }

    private static final Pretty_Text_Panel pretty_panel$$anonfun$1() {
        return (Pretty_Text_Panel)package$.MODULE$.error().apply((Object)"No Pretty Panel for Dynamic Output");
    }
}

