/*
 * Decompiled with CFR 0.152.
 */
package isabelle.graphview;

import isabelle.Delay;
import isabelle.Delay$;
import isabelle.GUI;
import isabelle.GUI$Style_HTML$;
import isabelle.Graph_Display;
import isabelle.Library$;
import isabelle.Logger;
import isabelle.Time;
import isabelle.Tree_View;
import isabelle.Tree_View$;
import isabelle.Tree_View$Node$;
import isabelle.Wrap_Panel;
import isabelle.Wrap_Panel$;
import isabelle.graphview.Graph_Panel;
import isabelle.graphview.Graphview;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.swing.Action$;
import scala.swing.BorderPanel;
import scala.swing.Button;
import scala.swing.Component;
import scala.swing.Component$;
import scala.swing.ScrollPane;
import scala.swing.TextField;
import scala.util.matching.Regex;

public class Tree_Panel
extends BorderPanel {
    private final Graphview graphview;
    private final Graph_Panel graph_panel;
    private List<Graph_Display.Node> nodes;
    private final Tree_View tree;
    private final ScrollPane tree_pane;
    private Option<Regex> selection_pattern;
    public final String isabelle$graphview$Tree_Panel$$selection_tooltip;
    public final TextField isabelle$graphview$Tree_Panel$$selection_field;
    private final Color selection_field_foreground;
    public final Delay isabelle$graphview$Tree_Panel$$selection_delay;

    public Tree_Panel(Graphview graphview, Graph_Panel graph_panel) {
        this.graphview = graphview;
        this.graph_panel = graph_panel;
        this.nodes = package$.MODULE$.List().empty();
        this.tree = new Tree_View(Tree_View$Node$.MODULE$.apply("Nodes"), Tree_View$.MODULE$.$lessinit$greater$default$2(), Tree_View$.MODULE$.$lessinit$greater$default$3());
        this.tree().addKeyListener(new KeyAdapter(this){
            private final /* synthetic */ Tree_Panel $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void keyPressed(KeyEvent e) {
                if (!e.isConsumed() && e.getKeyCode() == 10) {
                    e.consume();
                    this.$outer.isabelle$graphview$Tree_Panel$$selection_action();
                    return;
                }
            }
        });
        this.tree().addMouseListener(new MouseAdapter(this){
            private final /* synthetic */ Tree_Panel $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mousePressed(MouseEvent e) {
                if (!e.isConsumed() && e.getClickCount() == 2) {
                    e.consume();
                    this.$outer.isabelle$graphview$Tree_Panel$$point_action(this.$outer.tree().getPathForLocation(e.getX(), e.getY()));
                    return;
                }
            }
        });
        this.tree_pane = new ScrollPane(Component$.MODULE$.wrap((JComponent)this.tree()));
        this.tree_pane.horizontalScrollBarPolicy_$eq(ScrollPane.BarPolicy$.MODULE$.Always());
        this.tree_pane.verticalScrollBarPolicy_$eq(ScrollPane.BarPolicy$.MODULE$.Always());
        this.tree_pane.minimumSize_$eq(new Dimension(200, 100));
        this.tree_pane.peer().getVerticalScrollBar().setUnitIncrement(10);
        this.selection_pattern = None$.MODULE$;
        this.isabelle$graphview$Tree_Panel$$selection_tooltip = "Selection of nodes via regular expression";
        this.isabelle$graphview$Tree_Panel$$selection_field = new TextField(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(10);
                this.tooltip_$eq($outer.isabelle$graphview$Tree_Panel$$selection_tooltip);
            }
        };
        this.selection_field_foreground = this.isabelle$graphview$Tree_Panel$$selection_field.foreground();
        GUI.Label selection_label = new GUI.Label(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super("Selection:", (Component)$outer.isabelle$graphview$Tree_Panel$$selection_field);
                this.tooltip_$eq($outer.isabelle$graphview$Tree_Panel$$selection_tooltip);
            }
        };
        Logger logger = Delay$.MODULE$.last$default$2();
        this.isabelle$graphview$Tree_Panel$$selection_delay = Delay$.MODULE$.last((Function0<Time>)(Function0 & Serializable)() -> new Time(Tree_Panel.$init$$$anonfun$1(graphview)), logger, true, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$2(graphview);
            return BoxedUnit.UNIT;
        });
        this.isabelle$graphview$Tree_Panel$$selection_field.peer().getDocument().addDocumentListener(new DocumentListener(this){
            private final /* synthetic */ Tree_Panel $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void changedUpdate(DocumentEvent e) {
                this.$outer.isabelle$graphview$Tree_Panel$$selection_delay.invoke(this.$outer.isabelle$graphview$Tree_Panel$$selection_delay.invoke$default$1());
            }

            public void insertUpdate(DocumentEvent e) {
                this.$outer.isabelle$graphview$Tree_Panel$$selection_delay.invoke(this.$outer.isabelle$graphview$Tree_Panel$$selection_delay.invoke$default$1());
            }

            public void removeUpdate(DocumentEvent e) {
                this.$outer.isabelle$graphview$Tree_Panel$$selection_delay.invoke(this.$outer.isabelle$graphview$Tree_Panel$$selection_delay.invoke$default$1());
            }
        });
        Button selection_apply = new Button(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.action_$eq(Action$.MODULE$.apply(GUI$Style_HTML$.MODULE$.enclose_bold("Apply"), () -> Tree_Panel.isabelle$graphview$Tree_Panel$$anon$6$$_$$lessinit$greater$$anonfun$adapted$3($outer)));
                this.tooltip_$eq("Apply tree selection to graph");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{isabelle$graphview$Tree_Panel$$anon$6$$_$$lessinit$greater$$anonfun$adapted$3(isabelle.graphview.Tree_Panel )}, serializedLambda);
            }
        };
        Wrap_Panel controls = Wrap_Panel$.MODULE$.apply((List<Component>)((List)new .colon.colon((Object)selection_label, (List)new .colon.colon((Object)this.isabelle$graphview$Tree_Panel$$selection_field, (List)new .colon.colon((Object)selection_apply, (List)Nil$.MODULE$)))), Wrap_Panel$.MODULE$.apply$default$2());
        this.layout().update((Object)this.tree_pane, (Object)BorderPanel.Position$.MODULE$.Center());
        this.layout().update((Object)controls, (Object)BorderPanel.Position$.MODULE$.North());
        this.refresh();
    }

    public Graphview graphview() {
        return this.graphview;
    }

    public void isabelle$graphview$Tree_Panel$$selection_action() {
        if (this.tree() != null) {
            this.graphview().current_node_$eq((Option<Graph_Display.Node>)None$.MODULE$);
            this.graphview().Selection().clear();
            Object[] paths = this.tree().getSelectionPaths();
            if (paths != null) {
                Object object = Predef$.MODULE$.refArrayOps(paths);
                ArrayOps$.MODULE$.withFilter$extension(object, (Function1 & Serializable)path -> path != null).foreach((Function1)(JProcedure1 & Serializable)path -> {
                    Object object;
                    Object object2;
                    Option<Object> option;
                    Object object3 = path.getLastPathComponent();
                    if (object3 instanceof MutableTreeNode && !(option = Tree_View$Node$.MODULE$.unapply((MutableTreeNode)object3)).isEmpty() && (object2 = (object = option.get())) instanceof Graph_Display.Node) {
                        Graph_Display.Node node = (Graph_Display.Node)object2;
                        this.graphview().Selection().add(node);
                        return;
                    }
                });
            }
            this.graph_panel.repaint();
            return;
        }
    }

    public void isabelle$graphview$Tree_Panel$$point_action(TreePath path) {
        if (this.tree_pane != null && path != null) {
            None$ none$;
            Object object;
            Object object2;
            Option<Object> option;
            Object object3 = path.getLastPathComponent();
            if (object3 instanceof MutableTreeNode && !(option = Tree_View$Node$.MODULE$.unapply((MutableTreeNode)object3)).isEmpty() && (object2 = (object = option.get())) instanceof Graph_Display.Node) {
                Graph_Display.Node node = (Graph_Display.Node)object2;
                none$ = Some$.MODULE$.apply((Object)node);
            } else {
                none$ = None$.MODULE$;
            }
            None$ action_node = none$;
            action_node.foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.graph_panel.scroll_to_node((Graph_Display.Node)_$1));
            this.graphview().current_node_$eq((Option<Graph_Display.Node>)action_node);
            this.graph_panel.repaint();
            return;
        }
    }

    public Tree_View tree() {
        return this.tree;
    }

    private boolean selection_filter(Graph_Display.Node node) {
        Option<Regex> option = this.selection_pattern;
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            Regex re = (Regex)((Some)option).value();
            return re.findFirstIn((CharSequence)node.toString()).isDefined();
        }
        throw new MatchError(option);
    }

    public void refresh() {
        List<Graph_Display.Node> new_nodes = this.graphview().visible_graph().topological_order();
        List<Graph_Display.Node> list = this.nodes;
        List<Graph_Display.Node> list2 = new_nodes;
        if (list == null ? list2 != null : !list.equals(list2)) {
            this.nodes = new_nodes;
            this.tree().init_model((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.refresh$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }
        this.revalidate();
        this.repaint();
    }

    private static final long delay$1$1(Graphview graphview$1) {
        return graphview$1.options().seconds("editor_input_delay");
    }

    private static final long $init$$$anonfun$1(Graphview graphview$3) {
        return Tree_Panel.delay$1$1(graphview$3);
    }

    private final void $init$$$anonfun$2(Graphview graphview$2) {
        Tuple2 tuple2;
        String string = this.isabelle$graphview$Tree_Panel$$selection_field.text();
        if (string == null || "".equals(string)) {
            tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            String s = string;
            Option<Regex> pattern = Library$.MODULE$.make_regex(s);
            tuple2 = Tuple2$.MODULE$.apply(pattern, (Object)BoxesRunTime.boxToBoolean((boolean)pattern.isDefined()));
        }
        Tuple2 tuple22 = tuple2;
        Option pattern = (Option)tuple22._1();
        boolean ok = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        Option<Regex> option = this.selection_pattern;
        Option option2 = pattern;
        if (option == null ? option2 != null : !option.equals((Object)option2)) {
            this.selection_pattern = pattern;
            this.tree().setSelectionRows((int[])this.nodes.iterator().zipWithIndex().withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Graph_Display.Node node = (Graph_Display.Node)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return true;
                }
                return false;
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Graph_Display.Node node = (Graph_Display.Node)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return this.selection_filter(node);
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Graph_Display.Node node = (Graph_Display.Node)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return i + 1;
                }
                throw new MatchError((Object)tuple2);
            }).toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
            this.tree().repaint();
        }
        this.isabelle$graphview$Tree_Panel$$selection_field.foreground_$eq(ok ? this.selection_field_foreground : graphview$2.error_color());
    }

    private static final void $init$$$anonfun$3(Tree_Panel $outer$1) {
        $outer$1.isabelle$graphview$Tree_Panel$$selection_action();
    }

    public static /* bridge */ /* synthetic */ Object isabelle$graphview$Tree_Panel$$anon$6$$_$$lessinit$greater$$anonfun$adapted$3(Tree_Panel $outer$2) {
        Tree_Panel.$init$$$anonfun$3($outer$2);
        return BoxedUnit.UNIT;
    }

    private final void refresh$$anonfun$1() {
        this.nodes.foreach((Function1)(JProcedure1 & Serializable)node -> this.tree().root().add(Tree_View$Node$.MODULE$.apply(node)));
    }
}

