/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash;
import isabelle.Byte_Message$;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Consumer_Thread;
import isabelle.Consumer_Thread$;
import isabelle.Exn;
import isabelle.Future;
import isabelle.Future$;
import isabelle.Isabelle_Thread;
import isabelle.Isabelle_Thread$;
import isabelle.Markup$;
import isabelle.Markup$Process_Result$;
import isabelle.Output$;
import isabelle.Pretty$;
import isabelle.Process_Result;
import isabelle.Process_Result$;
import isabelle.Properties$Eq$;
import isabelle.Protocol;
import isabelle.Protocol_Message$;
import isabelle.Prover$;
import isabelle.Symbol$;
import isabelle.Symbol$Metric$;
import isabelle.System_Channel;
import isabelle.Time$;
import isabelle.Timing;
import isabelle.Value$Nat$;
import isabelle.XML;
import isabelle.XML$;
import isabelle.XML$Elem$;
import isabelle.XML$Text$;
import isabelle.package$;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class Prover
implements Protocol {
    private final Function1<Message, BoxedUnit> receiver;
    private final XML.Cache cache;
    private final System_Channel channel;
    private final Bash.Process process;
    private final Future<Process_Result> process_result;
    private final Isabelle_Thread process_manager;
    private Option<Consumer_Thread<List<Bytes>>> command_input;
    private boolean trace;

    public static Nothing$ bad_chunks() {
        return Prover$.MODULE$.bad_chunks();
    }

    public static Nothing$ bad_header(String string) {
        return Prover$.MODULE$.bad_header(string);
    }

    public static Bytes the_chunk(List<Bytes> list, Function0<String> function0) {
        return Prover$.MODULE$.the_chunk(list, function0);
    }

    public Prover(Function1<Message, BoxedUnit> receiver, XML.Cache cache, System_Channel channel, Bash.Process process) {
        this.receiver = receiver;
        this.cache = cache;
        this.channel = channel;
        this.process = process;
        this.process_result = Future$.MODULE$.thread("process_result", Future$.MODULE$.thread$default$2(), Future$.MODULE$.thread$default$3(), Future$.MODULE$.thread$default$4(), Future$.MODULE$.thread$default$5(), Future$.MODULE$.thread$default$6(), () -> Prover.$init$$$anonfun$1(process));
        this.process_manager = Isabelle_Thread$.MODULE$.fork("process_manager", Isabelle_Thread$.MODULE$.fork$default$2(), Isabelle_Thread$.MODULE$.fork$default$3(), Isabelle_Thread$.MODULE$.fork$default$4(), Isabelle_Thread$.MODULE$.fork$default$5(), Isabelle_Thread$.MODULE$.fork$default$6(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$2(process, channel);
            return BoxedUnit.UNIT;
        });
        this.command_input = None$.MODULE$;
        this.trace = false;
    }

    private void system_output(String text) {
        this.receiver.apply((Object)new System_Output(text));
    }

    private void protocol_output(List<Tuple2<String, String>> props, List<Bytes> chunks) {
        this.receiver.apply((Object)new Protocol_Output(props, chunks));
    }

    private void output(String kind, List<Tuple2<String, String>> props, List<XML.Tree> body) {
        XML.Elem main = XML$Elem$.MODULE$.apply(Markup$.MODULE$.apply(kind, props), Protocol_Message$.MODULE$.clean_reports(body));
        List<XML.Elem> reports = Protocol_Message$.MODULE$.reports(props, body);
        reports.$colon$colon((Object)main).foreach((Function1)(JProcedure1 & Serializable)msg -> this.receiver.apply((Object)new Output(this.cache.elem((XML.Elem)msg))));
    }

    private void exit_message(Process_Result result) {
        this.output(Markup$.MODULE$.EXIT(), Markup$Process_Result$.MODULE$.apply(result), (List<XML.Tree>)((List)new .colon.colon((Object)XML$Text$.MODULE$.apply(result.print_return_code()), (List)Nil$.MODULE$)));
    }

    private void terminate_process() {
        try {
            this.process.terminate();
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                Throwable exn = throwable2;
                this.system_output("Failed to terminate prover process: " + exn.getMessage());
            }
            throw throwable;
        }
    }

    public void join() {
        this.process_manager.join();
    }

    public void terminate() {
        this.system_output("Terminating prover process");
        this.command_input_close();
        for (int count = 10; !this.process_result.is_finished() && count > 0; --count) {
            Time$.MODULE$.sleep$extension(Time$.MODULE$.seconds(0.1));
        }
        if (!this.process_result.is_finished()) {
            this.terminate_process();
            return;
        }
    }

    private void command_input_close() {
        this.command_input.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.shutdown());
    }

    private void command_input_init(OutputStream raw_stream) {
        String name = "command_input";
        BufferedOutputStream stream = new BufferedOutputStream(raw_stream);
        boolean bl = Consumer_Thread$.MODULE$.fork$default$2();
        this.command_input = Some$.MODULE$.apply(Consumer_Thread$.MODULE$.fork(name, bl, (Function1 & Serializable)x$1 -> {
            boolean bl;
            List list;
            List chunks = list = x$1;
            try {
                Bytes$.MODULE$.apply(chunks.map((Function1 & Serializable)_$3 -> _$3.size()).mkString("", ",", "\n")).write_stream(stream);
                chunks.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.write_stream(stream));
                stream.flush();
                bl = true;
            }
            catch (IOException e) {
                this.system_output(name + ": " + e.getMessage());
                bl = false;
            }
            return bl;
        }, Consumer_Thread$.MODULE$.fork$default$4(name, bl), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            BoxedUnit boxedUnit3 = boxedUnit;
            if (!(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit3) : boxedUnit3 != null)) {
                stream.close();
                this.system_output(name + " terminated");
                return;
            }
            throw new MatchError((Object)boxedUnit);
        }));
    }

    private Thread physical_output(boolean err) {
        Tuple3 tuple3 = err ? Tuple3$.MODULE$.apply((Object)"standard_error", (Object)this.process.stderr(), (Object)Markup$.MODULE$.STDERR()) : Tuple3$.MODULE$.apply((Object)"standard_output", (Object)this.process.stdout(), (Object)Markup$.MODULE$.STDOUT());
        String name = (String)tuple3._1();
        BufferedReader reader = (BufferedReader)tuple3._2();
        String markup = (String)tuple3._3();
        return Isabelle_Thread$.MODULE$.fork(name, Isabelle_Thread$.MODULE$.fork$default$2(), Isabelle_Thread$.MODULE$.fork$default$3(), Isabelle_Thread$.MODULE$.fork$default$4(), Isabelle_Thread$.MODULE$.fork$default$5(), Isabelle_Thread$.MODULE$.fork$default$6(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.physical_output$$anonfun$1(reader, markup, name);
            return BoxedUnit.UNIT;
        });
    }

    private Thread message_output(InputStream stream) {
        String thread_name = "message_output";
        return Isabelle_Thread$.MODULE$.fork(thread_name, Isabelle_Thread$.MODULE$.fork$default$2(), Isabelle_Thread$.MODULE$.fork$default$3(), Isabelle_Thread$.MODULE$.fork$default$4(), Isabelle_Thread$.MODULE$.fork$default$5(), Isabelle_Thread$.MODULE$.fork$default$6(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.message_output$$anonfun$1(stream, thread_name);
            return BoxedUnit.UNIT;
        });
    }

    public boolean trace() {
        return this.trace;
    }

    public void trace_$eq(boolean x$1) {
        this.trace = x$1;
    }

    @Override
    public void protocol_command_raw(String name, List<Bytes> args) {
        Consumer_Thread thread;
        Option<Consumer_Thread<List<Bytes>>> option = this.command_input;
        if (option instanceof Some && (thread = (Consumer_Thread)((Some)option).value()).is_active()) {
            if (this.trace()) {
                long payload = BoxesRunTime.unboxToLong((Object)args.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(x$1, x$2) -> Prover.$anonfun$2(BoxesRunTime.unboxToLong((Object)x$1), (Bytes)x$2)));
                Output$.MODULE$.writeln("protocol_command " + name + ", args = " + args.length() + ", payload = " + payload, Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
            }
            Bytes bytes = Bytes$.MODULE$.apply(name);
            thread.send(args.$colon$colon((Object)bytes));
            return;
        }
        package$.MODULE$.error().apply((Object)("Inactive prover input thread for command " + package$.MODULE$.quote().apply((Object)name)));
    }

    @Override
    public void protocol_command_args(String name, List<List<XML.Tree>> args) {
        this.receiver.apply((Object)new Input(name, args));
        this.protocol_command_raw(name, (List<Bytes>)args.map((Function1 & Serializable)arg -> Bytes$.MODULE$.apply(Symbol$.MODULE$.encode_yxml((List<XML.Tree>)arg))));
    }

    @Override
    public void protocol_command(String name, Seq<List<XML.Tree>> args) {
        this.protocol_command_args(name, (List<List<XML.Tree>>)args.toList());
    }

    private static final Process_Result $init$$$anonfun$1(Bash.Process process$1) {
        int rc = process$1.join();
        Timing timing = process$1.get_timing();
        return Process_Result$.MODULE$.apply(rc, Process_Result$.MODULE$.$lessinit$greater$default$2(), Process_Result$.MODULE$.$lessinit$greater$default$3(), timing);
    }

    private final void $init$$$anonfun$2(Bash.Process process$2, System_Channel channel$1) {
        String startup_errors;
        Thread stdout = this.physical_output(false);
        None$ finished = None$.MODULE$;
        StringBuilder result = new StringBuilder(100);
        while (finished.isEmpty() && (process$2.stderr().ready() || !this.process_result.is_finished())) {
            while (finished.isEmpty() && process$2.stderr().ready()) {
                try {
                    int c = process$2.stderr().read();
                    if (c == 2) {
                        finished = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        continue;
                    }
                    result.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)((char)c)));
                }
                catch (IOException iOException) {
                    finished = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
            }
            Time$.MODULE$.sleep$extension(Time$.MODULE$.seconds(0.05));
        }
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((finished.isEmpty() || !BoxesRunTime.unboxToBoolean((Object)finished.get()) ? 1 : 0) != 0), (Object)result.toString().trim());
        boolean startup_failed = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
        String string = startup_errors = (String)tuple2._2();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.system_output(startup_errors);
        }
        if (startup_failed) {
            this.terminate_process();
            this.process_result.join();
            stdout.join();
            this.exit_message(Process_Result$.MODULE$.startup_failure());
        } else {
            Tuple2<OutputStream, InputStream> tuple22 = channel$1.rendezvous();
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            OutputStream command_stream = (OutputStream)tuple22._1();
            InputStream message_stream = (InputStream)tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)command_stream, (Object)message_stream);
            OutputStream command_stream2 = (OutputStream)tuple23._1();
            InputStream message_stream2 = (InputStream)tuple23._2();
            this.command_input_init(command_stream2);
            Thread stderr = this.physical_output(true);
            Thread message = this.message_output(message_stream2);
            Process_Result result2 = this.process_result.join();
            this.system_output("process terminated");
            this.command_input_close();
            ((List)new .colon.colon((Object)stdout, (List)new .colon.colon((Object)stderr, (List)new .colon.colon((Object)message, (List)Nil$.MODULE$)))).foreach((Function1)(JProcedure1 & Serializable)thread -> thread.join());
            this.system_output("process_manager terminated");
            this.exit_message(result2);
        }
        channel$1.shutdown();
    }

    private final void physical_output$$anonfun$1(BufferedReader reader$1, String markup$1, String name$3) {
        try {
            StringBuilder result = new StringBuilder(100);
            boolean finished = false;
            while (!finished) {
                int c = -1;
                boolean done = false;
                while (!done && (result.isEmpty() || reader$1.ready())) {
                    c = reader$1.read();
                    if (c >= 0) {
                        result.append((char)c);
                        continue;
                    }
                    done = true;
                }
                if (result.nonEmpty()) {
                    this.output(markup$1, (List<Tuple2<String, String>>)scala.package$.MODULE$.Nil(), (List<XML.Tree>)((List)new .colon.colon((Object)XML$Text$.MODULE$.apply(Symbol$.MODULE$.decode(result.toString())), (List)Nil$.MODULE$)));
                    result.clear();
                    continue;
                }
                reader$1.close();
                finished = true;
            }
        }
        catch (IOException e) {
            this.system_output(name$3 + ": " + e.getMessage());
        }
        this.system_output(name$3 + " terminated");
    }

    private static final Tuple2 decode_prop$1(Bytes bytes) {
        Tuple2<String, String> tuple2 = Properties$Eq$.MODULE$.parse(bytes.text());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String a = (String)tuple2._1();
        String b = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)a, (Object)b);
        String a2 = (String)tuple22._1();
        String b2 = (String)tuple22._2();
        return Tuple2$.MODULE$.apply((Object)Symbol$.MODULE$.decode(a2), (Object)Symbol$.MODULE$.decode(b2));
    }

    private final List decode_xml$1(Bytes bytes) {
        return Symbol$.MODULE$.decode_yxml_failsafe(bytes.text(), this.cache);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void message_output$$anonfun$1(InputStream stream$4, String thread_name$1) {
        try {
            boolean finished = false;
            while (!finished) {
                int n;
                Option<Object> option;
                Option<List<Bytes>> option2 = Byte_Message$.MODULE$.read_message(stream$4);
                if (None$.MODULE$.equals(option2)) {
                    finished = true;
                    continue;
                }
                if (!(option2 instanceof Some)) throw new MatchError(option2);
                List list = (List)((Some)option2).value();
                if (!(list instanceof .colon.colon)) throw Prover$.MODULE$.bad_chunks();
                .colon.colon colon2 = (.colon.colon)list;
                List list2 = colon2.next$access$1();
                Bytes k = (Bytes)colon2.head();
                if (!(list2 instanceof .colon.colon)) throw Prover$.MODULE$.bad_chunks();
                .colon.colon colon3 = (.colon.colon)list2;
                Bytes bytes2 = (Bytes)colon3.head();
                List list3 = colon3.next$access$1();
                if (bytes2 == null || (option = Value$Nat$.MODULE$.unapply(bytes2)).isEmpty()) throw Prover$.MODULE$.bad_chunks();
                int props_length = n = BoxesRunTime.unboxToInt((Object)option.get());
                List rest = list3;
                String kind = k.text();
                List props = rest.take(props_length).map((Function1 & Serializable)bytes -> Prover.decode_prop$1(bytes));
                List chunks = (List)rest.drop(props_length);
                String string = kind;
                String string2 = Markup$.MODULE$.PROTOCOL();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.protocol_output((List<Tuple2<String, String>>)props, (List<Bytes>)chunks);
                    continue;
                }
                this.output(kind, (List<Tuple2<String, String>>)props, (List<XML.Tree>)chunks.flatMap((Function1 & Serializable)bytes -> this.decode_xml$1((Bytes)bytes)));
            }
        }
        catch (IOException e) {
            this.system_output("Cannot read message:\n" + e.getMessage());
        }
        catch (Malformed e) {
            this.system_output(e.getMessage());
        }
        stream$4.close();
        this.system_output(thread_name$1 + " terminated");
    }

    private static final /* synthetic */ long $anonfun$2(long x$1, Bytes x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)x$1), (Object)x$2);
        if (tuple2 != null) {
            long n = BoxesRunTime.unboxToLong((Object)tuple2._1());
            Bytes b = (Bytes)tuple2._2();
            return n + b.size();
        }
        throw new MatchError((Object)tuple2);
    }

    public static class Input
    extends Message {
        private final String name;
        private final List args;

        public Input(String name, List<List<XML.Tree>> args) {
            this.name = name;
            this.args = args;
        }

        public String name() {
            return this.name;
        }

        public List<List<XML.Tree>> args() {
            return this.args;
        }

        public String toString() {
            return XML$Elem$.MODULE$.apply(Markup$.MODULE$.apply(Markup$.MODULE$.PROVER_COMMAND(), (List<Tuple2<String, String>>)((List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)Markup$.MODULE$.NAME(), (Object)this.name()), (List)Nil$.MODULE$))), (List<XML.Tree>)this.args().flatMap(Prover$::isabelle$Prover$Input$$_$toString$$anonfun$1)).toString();
        }
    }

    public static class Malformed
    extends Exn.User_Error {
        public Malformed(String msg) {
            super("Malformed prover message: " + msg);
        }
    }

    public static abstract class Message {
    }

    public static class Output
    extends Message {
        private final XML.Elem message;

        public Output(XML.Elem message) {
            this.message = message;
        }

        public XML.Elem message() {
            return this.message;
        }

        public String kind() {
            return this.message().markup().name();
        }

        public List<Tuple2<String, String>> properties() {
            return this.message().markup().properties();
        }

        public List<XML.Tree> body() {
            return this.message().body();
        }

        public boolean is_init() {
            String string = this.kind();
            String string2 = Markup$.MODULE$.INIT();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public boolean is_exit() {
            String string = this.kind();
            String string2 = Markup$.MODULE$.EXIT();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public boolean is_stdout() {
            String string = this.kind();
            String string2 = Markup$.MODULE$.STDOUT();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public boolean is_stderr() {
            String string = this.kind();
            String string2 = Markup$.MODULE$.STDERR();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public boolean is_system() {
            String string = this.kind();
            String string2 = Markup$.MODULE$.SYSTEM();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public boolean is_status() {
            String string = this.kind();
            String string2 = Markup$.MODULE$.STATUS();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public boolean is_report() {
            String string = this.kind();
            String string2 = Markup$.MODULE$.REPORT();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public boolean is_syslog() {
            return this.is_init() || this.is_exit() || this.is_system() || this.is_stderr();
        }

        public String toString() {
            String res;
            if (this.is_status() || this.is_report()) {
                v0 = this.message().body().map(Prover$::isabelle$Prover$Output$$_$_$$anonfun$3).mkString();
            } else {
                Symbol$Metric$ symbol$Metric$ = Symbol$Metric$.MODULE$;
                Function1<String, String> function1 = Pretty$.MODULE$.string_of$default$2();
                double d = Pretty$.MODULE$.string_of$default$3();
                double d2 = Pretty$.MODULE$.string_of$default$4();
                boolean bl = Pretty$.MODULE$.string_of$default$6();
                v0 = res = Pretty$.MODULE$.string_of(this.message().body(), function1, d, d2, symbol$Metric$, bl);
            }
            if (this.properties().isEmpty()) {
                return this.kind() + " [[" + res + "]]";
            }
            return this.kind() + " " + this.properties().map(Prover$::isabelle$Prover$Output$$_$toString$$anonfun$2).mkString("{", ",", "}") + " [[" + res + "]]";
        }
    }

    public static class Protocol_Output
    extends Output {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Protocol_Output.class.getDeclaredField("text$lzy1"));
        private final List chunks;
        private volatile Object text$lzy1;

        public Protocol_Output(List<Tuple2<String, String>> props, List<Bytes> chunks) {
            this.chunks = chunks;
            super(XML$.MODULE$.elem(Markup$.MODULE$.apply(Markup$.MODULE$.PROTOCOL(), props)));
        }

        public List<Bytes> chunks() {
            return this.chunks;
        }

        public Bytes chunk() {
            return Prover$.MODULE$.the_chunk(this.chunks(), (Function0<String>)((Function0 & Serializable)this::chunk$$anonfun$1));
        }

        public String text() {
            Object object = this.text$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.text$lzyINIT1();
        }

        private Object text$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.text$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = this.chunk().text();
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.text$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private final String chunk$$anonfun$1() {
            return this.toString();
        }
    }

    public static class System_Output
    extends Output {
        public System_Output(String text) {
            super(XML$Elem$.MODULE$.apply(Markup$.MODULE$.apply(Markup$.MODULE$.SYSTEM(), (List<Tuple2<String, String>>)scala.package$.MODULE$.Nil()), (List<XML.Tree>)((List)new .colon.colon((Object)XML$Text$.MODULE$.apply(text), (List)Nil$.MODULE$))));
        }
    }
}

