/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Components;
import isabelle.Components$;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.Dotnet_Setup;
import isabelle.Dotnet_Setup$Platform_Info$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$Info$;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public final class Dotnet_Setup$
implements Serializable {
    public static final Dotnet_Setup$Platform_Info$ Platform_Info;
    private static final List all_platforms;
    private static final Isabelle_Tool isabelle_tool;
    public static final Dotnet_Setup$ MODULE$;

    private Dotnet_Setup$() {
    }

    static {
        MODULE$ = new Dotnet_Setup$();
        all_platforms = (List)new .colon.colon((Object)Dotnet_Setup$Platform_Info$.MODULE$.apply("arm64-linux", "linux", "arm64", Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$4(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$5(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$6()), (List)new .colon.colon((Object)Dotnet_Setup$Platform_Info$.MODULE$.apply("x86_64-linux", "linux", Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$3(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$4(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$5(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$6()), (List)new .colon.colon((Object)Dotnet_Setup$Platform_Info$.MODULE$.apply("arm64-darwin", "osx", "arm64", Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$4(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$5(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$6()), (List)new .colon.colon((Object)Dotnet_Setup$Platform_Info$.MODULE$.apply("x86_64-darwin", "osx", Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$3(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$4(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$5(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$6()), (List)new .colon.colon((Object)Dotnet_Setup$Platform_Info$.MODULE$.apply("x86_64-windows", Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$2(), Dotnet_Setup$Platform_Info$.MODULE$.$lessinit$greater$default$3(), "ps1", "powershell -ExecutionPolicy ByPass", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> Isabelle_System$.MODULE$.require_command("powershell", "-NoProfile -Command Out-Null")), (List)Nil$.MODULE$)))));
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("dotnet_setup", "dynamic setup of Dotnet component (for Fsharp)", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)this.default_target_dir());
            ObjectRef install_url = ObjectRef.create((Object)this.default_install_url());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            BooleanRef force = BooleanRef.create((boolean)false);
            BooleanRef dry_run = BooleanRef.create((boolean)false);
            ObjectRef platforms = ObjectRef.create((Object)((List)new .colon.colon((Object)this.default_platform(), (List)Nil$.MODULE$)));
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[7];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"I:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                install_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"f");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)_$2 -> {
                force$1.elem = true;
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"n");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)_$3 -> {
                dry_run$1.elem = true;
            });
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"p:");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)arg -> {
                platforms$1.elem = ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)','), arg)).map((Function1 & Serializable)spec -> this.check_platform((String)spec));
            });
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (JProcedure1 & Serializable)_$4 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.dotnet_setup((List<String>)((List)platforms.elem), (Path)target_dir.elem, (String)install_url.elem, (String)version.elem, force.elem, dry_run.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Dotnet_Setup$.class);
    }

    public List<Dotnet_Setup.Platform_Info> all_platforms() {
        return all_platforms;
    }

    public String check_platform(String spec) {
        return Platform$Info$.MODULE$.check(this.all_platforms(), spec);
    }

    public String default_platform() {
        return Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(true, true);
    }

    public Path default_target_dir() {
        return Components$.MODULE$.default_components_base();
    }

    public String default_install_url() {
        return "https://dot.net/v1/dotnet-install";
    }

    public String default_version() {
        return Isabelle_System$.MODULE$.getenv_strict("ISABELLE_DOTNET_SETUP_VERSION", Isabelle_System$.MODULE$.getenv_strict$default$2());
    }

    public void dotnet_setup(List<String> platforms, Path target_dir, String install_url, String version, boolean force, boolean dry_run, Progress progress) {
        platforms.foreach((Function1 & Serializable)spec -> MODULE$.check_platform((String)spec));
        Components.Directory component_dir = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.explode((String)(version.isEmpty() ? "dotnet-latest" : "dotnet-" + version))), Components$Directory$.MODULE$.apply$default$2());
        if (!dry_run) {
            progress.echo("Component directory " + component_dir, progress.echo$default$2());
            component_dir.create(component_dir.create$default$1(), true);
            component_dir.write_settings("\nISABELLE_DOTNET_ROOT=\"$COMPONENT\"\n\nif [ -n \"$ISABELLE_WINDOWS_PLATFORM64\" -a -d \"$ISABELLE_DOTNET_ROOT/$ISABELLE_WINDOWS_PLATFORM64\" ]; then\n  ISABELLE_DOTNET=\"$ISABELLE_DOTNET_ROOT/$ISABELLE_WINDOWS_PLATFORM64/dotnet.exe\"\nelif [ -n \"$ISABELLE_APPLE_PLATFORM64\" -a -d \"$ISABELLE_DOTNET_ROOT/$ISABELLE_APPLE_PLATFORM64\" ]; then\n  ISABELLE_DOTNET=\"$ISABELLE_DOTNET_ROOT/$ISABELLE_APPLE_PLATFORM64/dotnet\"\nelif [ -d \"$ISABELLE_DOTNET_ROOT/$ISABELLE_PLATFORM64\" ]; then\n  ISABELLE_DOTNET=\"$ISABELLE_DOTNET_ROOT/$ISABELLE_PLATFORM64/dotnet\"\nfi\n\nDOTNET_CLI_TELEMETRY_OPTOUT=\"true\"\nDOTNET_CLI_HOME=\"$(platform_path \"$ISABELLE_HOME_USER/dotnet\")\"\n");
            File$.MODULE$.write(component_dir.README(), "This installation of Dotnet has been produced via \"isabelle dotnet_setup\".\n\n\n      Makarius\n      " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
            ((Option)package$.MODULE$.proper_string().apply((Object)Isabelle_System$.MODULE$.getenv("ISABELLE_DOTNET_ROOT", Isabelle_System$.MODULE$.getenv$default$2()))).foreach((Function1)(JProcedure1 & Serializable)old -> Components$.MODULE$.update_components(false, Path$.MODULE$.explode((String)old), Components$.MODULE$.update_components$default$3()));
            Components$.MODULE$.update_components(true, component_dir.path(), Components$.MODULE$.update_components$default$3());
        }
        this.all_platforms().withFilter((Function1 & Serializable)platform -> platforms.exists((Function1 & Serializable)spec -> platform.is((String)spec))).foreach((Function1)(JProcedure1 & Serializable)platform -> {
            progress.expose_interrupt();
            Isabelle_System$.MODULE$.with_tmp_file("install", platform.ext(), Isabelle_System$.MODULE$.with_tmp_file$default$3(), (JProcedure1 & Serializable)install -> {
                Isabelle_System$.MODULE$.download_file(install_url + "." + platform.ext(), (Path)install, Isabelle_System$.MODULE$.download_file$default$3());
                Path platform_dir = component_dir.path().$plus(platform.path());
                if (platform_dir.is_dir() && !force) {
                    progress.echo_warning("Platform " + platform + " already installed", progress.echo_warning$default$2());
                    return;
                }
                progress.echo("Platform " + platform + " ...", progress.echo$default$2());
                platform.check().apply$mcV$sp();
                if (platform_dir.is_dir() && force) {
                    Isabelle_System$.MODULE$.rm_tree(platform_dir);
                }
                String script = platform.exec() + " " + File$.MODULE$.bash_platform_path((Path)install) + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(version), (Function0<String>)((Function0 & Serializable)() -> Dotnet_Setup$.$anonfun$9(version))) + " -Architecture " + Bash$.MODULE$.string(platform.arch()) + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(platform.os()), (Function0<String>)((Function0 & Serializable)() -> Dotnet_Setup$.$anonfun$10(platform))) + " -InstallDir " + File$.MODULE$.bash_path(platform.path()) + (dry_run ? " -DryRun" : "") + " -NoPath";
                boolean bl = progress.verbose();
                Path path = dry_run ? Path$.MODULE$.current() : component_dir.path();
                SSH.System system = progress.bash$default$2();
                Map<String, String> map = progress.bash$default$4();
                boolean bl2 = progress.bash$default$5();
                long l = progress.bash$default$7();
                boolean bl3 = progress.bash$default$8();
                progress.bash(script, system, path, map, bl2, bl, l, bl3).check();
                File$.MODULE$.find_files(platform_dir.file(), (Function1<File, Object>)(Function1 & Serializable)_$1 -> _$1.getName().endsWith(".exe"), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).foreach((Function1)(JProcedure1 & Serializable)exe -> File$.MODULE$.set_executable(File$.MODULE$.path((File)exe), File$.MODULE$.set_executable$default$2()));
            });
        });
    }

    public List<String> dotnet_setup$default$1() {
        return (List)new .colon.colon((Object)this.default_platform(), (List)Nil$.MODULE$);
    }

    public Path dotnet_setup$default$2() {
        return this.default_target_dir();
    }

    public String dotnet_setup$default$3() {
        return this.default_install_url();
    }

    public String dotnet_setup$default$4() {
        return this.default_version();
    }

    public boolean dotnet_setup$default$5() {
        return false;
    }

    public boolean dotnet_setup$default$6() {
        return false;
    }

    public Progress dotnet_setup$default$7() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle dotnet_setup [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default: " + this.default_target_dir().expand() + ")\n    -I URL       URL for install script without extension\n                 (default: " + package$.MODULE$.quote().apply((Object)this.default_install_url()) + ")\n    -V VERSION   version: empty means \"latest\"\n                 (default: ISABELLE_DOTNET_SETUP_VERSION=" + package$.MODULE$.quote().apply((Object)this.default_version()) + ")\n    -f           force fresh installation of specified platforms\n    -n           dry run: try download without installation\n    -p PLATFORMS comma-separated list of platform specifications: \"all\" or\n                 as family or formal name (default: " + package$.MODULE$.quote().apply((Object)this.default_platform()) + ")\n    -v           verbose\n\n  Download the Dotnet / Fsharp platform and configure it as Isabelle component.\n\n  See also:\n    https://fsharp.org\n    https://learn.microsoft.com/en-us/dotnet/core/tools/dotnet-install-script\n    https://learn.microsoft.com/en-us/dotnet/core/tools/telemetry\n";
    }

    public static final /* synthetic */ void isabelle$Dotnet_Setup$Platform_Info$$$_$$lessinit$greater$default$6$$anonfun$1() {
    }

    private static final String $anonfun$9(String version$4) {
        return " -Version " + Bash$.MODULE$.string(version$4);
    }

    private static final String $anonfun$10(Dotnet_Setup.Platform_Info platform$3) {
        return " -OS " + Bash$.MODULE$.string(platform$3.os());
    }
}

