/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_E$
implements Serializable {
    private static final String default_version;
    private static final String default_download_url;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_E$ MODULE$;

    private Component_E$() {
    }

    static {
        MODULE$ = new Component_E$();
        default_version = "3.2";
        default_download_url = "https://wwwlehre.dhbw-stuttgart.de/~sschulz/WORK/E_DOWNLOAD";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_e", "build prover component from source distribution", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            ObjectRef download_url = ObjectRef.create((Object)this.default_download_url());
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                download_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)_$5 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (scala.collection.immutable.Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_e((String)version.elem, (String)download_url.elem, progress, (Path)target_dir.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_E$.class);
    }

    public String default_version() {
        return default_version;
    }

    public String default_download_url() {
        return default_download_url;
    }

    public void build_e(String version, String download_url, Progress progress, Path target_dir) {
        Isabelle_System$.MODULE$.with_tmp_dir("build", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)tmp_dir -> {
            String component_name = "e-" + version;
            Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
            Components.Directory component_dir = directory.create(progress, directory.create$default$2());
            String platform_name = Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM$default$1(), true);
            Path platform_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic(platform_name)));
            String archive_url = download_url + "/V_" + version + "/E.tgz";
            Path archive_path = tmp_dir.$plus(Path$.MODULE$.explode("E.tgz"));
            Isabelle_System$.MODULE$.download_file(archive_url, archive_path, progress);
            Isabelle_System$.MODULE$.extract(archive_path, (Path)tmp_dir, Isabelle_System$.MODULE$.extract$default$3());
            Path source_dir = File$.MODULE$.get_dir((Path)tmp_dir, archive_url);
            Isabelle_System$.MODULE$.extract(archive_path, component_dir.src(), true);
            progress.echo("Building E prover for " + platform_name + " ...", progress.echo$default$2());
            if (Platform$.MODULE$.is_windows()) {
                Path path = source_dir.$plus(Path$.MODULE$.explode("PROVER/eprover.c"));
                boolean bl = File$.MODULE$.change_lines$default$2();
                File$.MODULE$.change_lines(path, bl, true, (Function1<List<String>, List<String>>)(Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)line -> {
                    if (Predef$.MODULE$.wrapString(line).containsSlice((Seq)Predef$.MODULE$.wrapString("setpgid(0, 0)"))) {
                        return "";
                    }
                    return line;
                }));
            }
            String build_script = "./configure --enable-ho && make";
            Isabelle_System$.MODULE$.bash(build_script, Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), source_dir, Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> progress.echo((String)_$2, true), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> progress.echo((String)_$3, true), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
            Isabelle_System$.MODULE$.copy_file(source_dir.$plus(Path$.MODULE$.basic("COPYING")), component_dir.LICENSE());
            List install_files = (List)new .colon.colon((Object)"epclextract", (List)new .colon.colon((Object)"eprover-ho", (List)Nil$.MODULE$));
            install_files.map((Function1 & Serializable)_$4 -> _$4 + ".exe").$colon$colon$colon(install_files).foreach((Function1)(JProcedure1 & Serializable)name -> {
                Path path = source_dir.$plus(Path$.MODULE$.basic("PROVER")).$plus(Path$.MODULE$.basic((String)name));
                if (path.is_file()) {
                    Isabelle_System$.MODULE$.copy_file(path, platform_dir);
                    return;
                }
            });
            Isabelle_System$.MODULE$.bash("mv eprover-ho eprover", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), platform_dir, Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
            component_dir.write_settings("\nE_HOME=\"$COMPONENT/${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}\"\nE_VERSION=" + package$.MODULE$.quote().apply((Object)version) + "\n");
            File$.MODULE$.write(component_dir.README(), "This is E prover " + version + " from\n" + archive_url + "\n\n* On Windows/Cygwin, the sources have been patched to remove setpgid in\n  PROVER/eprover.c\n\n* The distribution has been built like this:\n\n    cd src && " + build_script + "\n\n* Some executables from PROVERS/ have been moved to the platform-specific\nIsabelle component directory: x86_64-linux etc.\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        });
    }

    public String build_e$default$1() {
        return this.default_version();
    }

    public String build_e$default$2() {
        return this.default_download_url();
    }

    public Progress build_e$default$3() {
        return new Progress();
    }

    public Path build_e$default$4() {
        return Path$.MODULE$.current();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_e [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       download URL\n                 (default: \"" + this.default_download_url() + "\")\n    -V VERSION   version (default: " + this.default_version() + ")\n    -v           verbose\n\n  Build prover component from the specified source distribution.\n";
    }
}

