/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_Bash_Process$
implements Serializable {
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Bash_Process$ MODULE$;

    private Component_Bash_Process$() {
    }

    static {
        MODULE$ = new Component_Bash_Process$();
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_bash_process", "build bash_process component from C source", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_bash_process(progress, (Path)target_dir.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Bash_Process$.class);
    }

    public Path home() {
        return Path$.MODULE$.explode("$ISABELLE_BASH_PROCESS_HOME");
    }

    public Path remote_program(Components.Directory directory) {
        Isabelle_Platform isabelle_Platform = directory.ssh().isabelle_platform();
        String platform = isabelle_Platform.ISABELLE_PLATFORM(isabelle_Platform.ISABELLE_PLATFORM$default$1(), true);
        return directory.path().$plus(Path$.MODULE$.basic(platform)).$plus(Path$.MODULE$.basic("bash_process"));
    }

    public void build_bash_process(Progress progress, Path target_dir) {
        Isabelle_System$.MODULE$.require_command("cc", Isabelle_System$.MODULE$.require_command$default$2());
        String component_date = Date$Format$.MODULE$.alt_date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1()));
        String component_name = "bash_process-" + component_date;
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory directory2 = directory.create(progress, directory.create$default$2());
        Components.Directory component_dir = directory2.write_platforms(directory2.write_platforms$default$1());
        String platform_name = Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM$default$1(), true);
        Path platform_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic(platform_name)));
        Path source_file = Path$.MODULE$.explode("bash_process.c");
        File$.MODULE$.write(component_dir.path().$plus(source_file), "/*  Author:     Makarius\n    License:    Isabelle BSD-3\n\nBash process with separate process group id.\n*/\n\n#include <signal.h>\n#include <stdio.h>\n#include <stdlib.h>\n#include <string.h>\n#include <sys/resource.h>\n#include <sys/time.h>\n#include <sys/types.h>\n#include <sys/wait.h>\n#include <time.h>\n#include <unistd.h>\n\nstatic void fail(const char *msg)\n{\n  fprintf(stderr, \"%s\\n\", msg);\n  fflush(stderr);\n  exit(2);\n}\n\nstatic time_t now()\n{\n  struct timeval tv;\n  if (gettimeofday(&tv, NULL) == 0) {\n    return tv.tv_sec * 1000 + tv.tv_usec / 1000;\n  }\n  else {\n    return time(NULL) * 1000;\n  }\n}\n\n\nint main(int argc, char *argv[])\n{\n  /* args */\n\n  if (argc < 2) {\n    fprintf(stderr, \"Bad arguments: missing TIMING_FILE\\n\");\n    fflush(stderr);\n    exit(1);\n  }\n  char *timing_name = argv[1];\n\n\n  /* potential fork */\n\n  time_t time_start = now();\n\n  if (strlen(timing_name) > 0 || setsid() == -1) {\n    pid_t pid = fork();\n\n    if (pid == -1) fail(\"Cannot set session id (failed to fork)\");\n    else if (pid != 0) {\n      int status;\n\n      // ingore SIGINT\n      struct sigaction sa;\n      memset(&sa, 0, sizeof(sa));\n      sa.sa_handler = SIG_IGN;\n      sigaction(SIGINT, &sa, 0);\n\n      if (waitpid(pid, &status, 0) == -1) {\n        fail(\"Cannot join forked process\");\n      }\n\n      /* report timing */\n\n      if (strlen(timing_name) > 0) {\n        long long timing_elapsed = now() - time_start;\n\n        struct rusage ru;\n        getrusage(RUSAGE_CHILDREN, &ru);\n\n        long long timing_cpu =\n          ru.ru_utime.tv_sec * 1000 + ru.ru_utime.tv_usec / 1000 +\n          ru.ru_stime.tv_sec * 1000 + ru.ru_stime.tv_usec / 1000;\n\n        FILE *timing_file = fopen(timing_name, \"w\");\n        if (timing_file == NULL) fail(\"Cannot open timing file\");\n        fprintf(timing_file, \"%lld %lld\", timing_elapsed, timing_cpu);\n        fclose(timing_file);\n      }\n\n      if (WIFEXITED(status)) {\n        exit(WEXITSTATUS(status));\n      }\n      else if (WIFSIGNALED(status)) {\n        exit(128 + WTERMSIG(status));\n      }\n      else {\n        fail(\"Unknown status of forked process\");\n      }\n    }\n    else if (setsid() == -1) fail(\"Cannot set session id (after fork)\");\n  }\n\n\n  /* report pid */\n\n  fprintf(stdout, \"%d\\n\", getpid());\n  fflush(stdout);\n\n\n  /* shift command line */\n\n  int i;\n  for (i = 2; i < argc; i++) {\n    argv[i - 2] = argv[i];\n  }\n  argv[argc - 2] = NULL;\n  argv[argc - 1] = NULL;\n\n\n  /* exec */\n\n  execvp(\"bash\", argv);\n  fail(\"Cannot exec process\");\n}\n");
        progress.echo("Building bash_process for " + platform_name + " ...", progress.echo$default$2());
        progress.bash("cc ../bash_process.c -o bash_process", progress.bash$default$2(), platform_dir, progress.bash$default$4(), progress.bash$default$5(), progress.bash$default$6(), progress.bash$default$7(), progress.bash$default$8()).check();
        component_dir.write_settings("\nISABELLE_BASH_PROCESS_HOME=\"$COMPONENT\"\nISABELLE_BASH_PROCESS=\"$ISABELLE_BASH_PROCESS_HOME/${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}/bash_process\"\n");
        File$.MODULE$.write(component_dir.README(), "The bash_process executable has been built like this:\n\n  cc -Wall bash_process.c -o bash_process\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
    }

    public Progress build_bash_process$default$1() {
        return new Progress();
    }

    public Path build_bash_process$default$2() {
        return Path$.MODULE$.current();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_bash_process [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n\n  Build prover component from official download.\n";
    }
}

