/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractIntSet;
import kodkod.util.ints.IntCollection;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.IntTree;

public final class IntTreeSet
extends AbstractIntSet
implements Cloneable {
    private final IntTree<Range> tree;
    private int size;

    public IntTreeSet() {
        this.tree = new IntTree();
        this.size = 0;
    }

    public IntTreeSet(IntSet intSet) {
        this();
        this.addAll(intSet);
    }

    private IntTreeSet(IntTreeSet intTreeSet) {
        this.size = intTreeSet.size;
        try {
            this.tree = intTreeSet.tree.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public IntIterator iterator(int n, int n2) {
        return n <= n2 ? new AscendingIterator(n, n2) : new DescendingIterator(n, n2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(int n) {
        Range range = this.tree.searchGTE(n);
        return range != null && range.min <= n;
    }

    @Override
    public int min() {
        this.checkNonEmpty();
        return this.tree.min().min;
    }

    @Override
    public int max() {
        this.checkNonEmpty();
        return this.tree.max().key;
    }

    @Override
    public int floor(int n) {
        this.checkNonEmpty();
        Range range = this.tree.searchGTE(n);
        if (range == null || range.min > n) {
            range = this.tree.searchLTE(n);
            return range == null ? null : Integer.valueOf(range.key);
        }
        return n;
    }

    @Override
    public int ceil(int n) {
        this.checkNonEmpty();
        Range range = this.tree.searchGTE(n);
        return range == null ? null : Integer.valueOf(StrictMath.max(n, range.min));
    }

    @Override
    public boolean add(int n) {
        Range range = this.tree.searchGTE(n);
        if (range == null || range.min > n) {
            Range range2 = this.tree.searchLTE(n);
            if (range2 != null && range2.key == n - 1) {
                if (range != null && range.min == n + 1) {
                    this.tree.delete(range);
                    range2.key = range.key;
                } else {
                    range2.key = n;
                }
            } else if (range != null && range.min == n + 1) {
                range.min = n;
            } else {
                this.tree.insert(new Range(n, n));
            }
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int n) {
        Range range = this.tree.searchGTE(n);
        if (range != null && n >= range.min) {
            if (range.min == range.key) {
                this.tree.delete(range);
            } else if (n == range.min) {
                range.min++;
            } else if (n == range.key) {
                range.key = n - 1;
            } else {
                this.tree.insert(new Range(range.min, n - 1));
                range.min = n + 1;
            }
            --this.size;
            assert (this.size >= 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(IntCollection intCollection) {
        if (intCollection instanceof IntTreeSet) {
            IntTreeSet intTreeSet = (IntTreeSet)intCollection;
            if (this.size >= intTreeSet.size) {
                Range range = intTreeSet.tree.min();
                while (range != null) {
                    Range range2 = this.tree.searchGTE(range.key);
                    if (range2 == null || range.min < range2.min) {
                        return false;
                    }
                    range = intTreeSet.tree.successor(range);
                }
                return true;
            }
            return false;
        }
        return super.containsAll(intCollection);
    }

    @Override
    public void clear() {
        this.tree.clear();
        this.size = 0;
    }

    @Override
    public IntTreeSet clone() {
        return new IntTreeSet(this);
    }

    private final class DescendingIterator
    implements IntIterator {
        private Range next;
        private final int endpoint;
        private int currentMin;
        private int cursor;
        private int lastReturned;
        private boolean canRemove;

        DescendingIterator(int n, int n2) {
            this.endpoint = n2;
            this.lastReturned = Integer.MAX_VALUE;
            this.canRemove = false;
            this.next = (Range)IntTreeSet.this.tree.searchGTE(n);
            if (this.next == null || this.next.min > n) {
                this.next = (Range)IntTreeSet.this.tree.searchLTE(n);
                if (this.next == null) {
                    this.cursor = -1;
                    this.currentMin = 0;
                } else {
                    this.cursor = StrictMath.min(this.next.key, n);
                    this.currentMin = this.next.min;
                }
            } else {
                this.cursor = StrictMath.min(this.next.key, n);
                this.currentMin = this.next.min;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.cursor < this.currentMin) {
                if (this.next == null) {
                    return false;
                }
                this.cursor = this.next.key;
                this.currentMin = this.next.min;
                this.next = IntTreeSet.this.tree.predecessor(this.next);
            }
            return this.lastReturned > Integer.MIN_VALUE && this.cursor >= this.endpoint;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.canRemove = true;
            this.lastReturned = this.cursor--;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntTreeSet.this.remove(this.lastReturned);
            this.next = (Range)IntTreeSet.this.tree.searchLTE(this.cursor);
            this.canRemove = false;
        }
    }

    private final class AscendingIterator
    implements IntIterator {
        private Range next;
        private final int endpoint;
        private int currentMax;
        private int cursor;
        private int lastReturned;
        private boolean canRemove;

        AscendingIterator(int n, int n2) {
            this.endpoint = n2;
            this.lastReturned = Integer.MIN_VALUE;
            this.canRemove = false;
            this.next = (Range)IntTreeSet.this.tree.searchGTE(n);
            if (this.next == null) {
                this.cursor = 0;
                this.currentMax = -1;
            } else {
                this.cursor = StrictMath.max(this.next.min, n);
                this.currentMax = this.next.key;
                this.next = IntTreeSet.this.tree.successor(this.next);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.cursor > this.currentMax) {
                if (this.next == null) {
                    return false;
                }
                this.cursor = this.next.min;
                this.currentMax = this.next.key;
                this.next = IntTreeSet.this.tree.successor(this.next);
            }
            return this.lastReturned < Integer.MAX_VALUE && this.cursor <= this.endpoint;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.canRemove = true;
            this.lastReturned = this.cursor++;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntTreeSet.this.remove(this.lastReturned);
            this.next = (Range)IntTreeSet.this.tree.searchGTE(this.cursor);
            this.canRemove = false;
        }
    }

    private static final class Range
    extends IntTree.Node<Range>
    implements Cloneable {
        private int min;

        Range(int n, int n2) {
            super(n2);
            this.min = n;
        }

        @Override
        protected Range clone() throws CloneNotSupportedException {
            return (Range)super.clone();
        }
    }
}

