/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.Iterator;
import kodkod.util.ints.AbstractSparseSequence;
import kodkod.util.ints.EntryView;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.IntTreeSet;
import kodkod.util.ints.SparseSequence;

public final class HomogenousSequence<V>
extends AbstractSparseSequence<V> {
    private final IntSet indices;
    private final V value;
    private final EntryView<V> view;

    public HomogenousSequence(V v) {
        this.value = v;
        this.indices = new IntTreeSet();
        this.view = new EntryView<V>(Integer.MIN_VALUE, v);
    }

    public HomogenousSequence(V v, IntSet intSet) {
        this.value = v;
        this.indices = intSet;
        this.view = new EntryView<V>(Integer.MIN_VALUE, v);
    }

    private HomogenousSequence(HomogenousSequence<V> homogenousSequence) {
        this.value = homogenousSequence.value;
        this.view = new EntryView<V>(Integer.MIN_VALUE, this.value);
        try {
            this.indices = homogenousSequence.indices.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public HomogenousSequence(SparseSequence<? extends V> sparseSequence) {
        if (sparseSequence.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.indices = new IntTreeSet();
        this.value = sparseSequence.first().value();
        this.view = new EntryView<V>(Integer.MIN_VALUE, this.value);
        for (IndexedEntry<V> indexedEntry : sparseSequence) {
            if (!this.value.equals(indexedEntry.value())) {
                throw new IllegalArgumentException();
            }
            this.indices.add(indexedEntry.index());
        }
    }

    @Override
    public IntSet indices() {
        return this.indices;
    }

    @Override
    public Iterator<IndexedEntry<V>> iterator(int n, int n2) {
        return new HomogenousIterator<V>(this.indices.iterator(n, n2), this.value);
    }

    @Override
    public int size() {
        return this.indices.size();
    }

    @Override
    public void clear() {
        this.indices.clear();
    }

    @Override
    public V put(int n, V v) {
        if (!HomogenousSequence.equal(this.value, v)) {
            throw new IllegalArgumentException();
        }
        return this.indices.add(n) ? null : (V)v;
    }

    @Override
    public V get(int n) {
        return this.indices.contains(n) ? (V)this.value : null;
    }

    @Override
    public V remove(int n) {
        return this.indices.remove(n) ? (V)this.value : null;
    }

    @Override
    public boolean containsIndex(int n) {
        return this.indices.contains(n);
    }

    @Override
    public boolean contains(Object object) {
        return !this.indices.isEmpty() && HomogenousSequence.equal(this.value, object);
    }

    @Override
    public IndexedEntry<V> first() {
        return this.indices.isEmpty() ? null : this.view.setIndexView(this.indices.min());
    }

    @Override
    public IndexedEntry<V> last() {
        return this.indices.isEmpty() ? null : this.view.setIndexView(this.indices.max());
    }

    @Override
    public IndexedEntry<V> ceil(int n) {
        if (this.indices.isEmpty() || n > this.indices.max()) {
            return null;
        }
        return this.view.setIndexView(this.indices.ceil(n));
    }

    @Override
    public IndexedEntry<V> floor(int n) {
        if (this.indices.isEmpty() || n < this.indices.min()) {
            return null;
        }
        return this.view.setIndexView(this.indices.floor(n));
    }

    @Override
    public HomogenousSequence<V> clone() {
        return new HomogenousSequence<V>(this);
    }

    private static final class HomogenousIterator<V>
    extends EntryView<V>
    implements Iterator<IndexedEntry<V>> {
        private final IntIterator iter;

        HomogenousIterator(IntIterator intIterator, V v) {
            super(Integer.MIN_VALUE, v);
            this.iter = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public IndexedEntry<V> next() {
            return this.setIndexView(this.iter.next());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

