/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import kodkod.util.ints.IntCollection;
import kodkod.util.ints.IntIterator;

public abstract class AbstractIntCollection
implements IntCollection {
    protected AbstractIntCollection() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(int n) {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (n != intIterator.next()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(int n) {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (n != intIterator.next()) continue;
            intIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(IntCollection intCollection) {
        if (this.size() >= intCollection.size()) {
            IntIterator intIterator = intCollection.iterator();
            while (intIterator.hasNext()) {
                if (this.contains(intIterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        boolean bl = false;
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            if (!this.add(intIterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(IntCollection intCollection) {
        boolean bl = false;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intCollection.contains(intIterator.next())) continue;
            bl = true;
            intIterator.remove();
        }
        return bl;
    }

    @Override
    public boolean removeAll(IntCollection intCollection) {
        boolean bl = false;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (!intCollection.contains(intIterator.next())) continue;
            bl = true;
            intIterator.remove();
        }
        return bl;
    }

    @Override
    public void clear() {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            intIterator.next();
            intIterator.remove();
        }
    }

    @Override
    public int[] toArray() {
        return this.toArray(new int[this.size()]);
    }

    @Override
    public int[] toArray(int[] nArray) {
        if (nArray.length < this.size()) {
            nArray = new int[this.size()];
        }
        int n = 0;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            nArray[n++] = intIterator.next();
        }
        return nArray;
    }
}

