/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.collections;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kodkod.util.collections.Containers;
import kodkod.util.collections.Indexer;

public final class FixedMap<K, V>
extends AbstractMap<K, V>
implements Indexer<K> {
    private final Object[] keys;
    private final Object[] values;

    public FixedMap(Map<K, V> map) {
        this(map.keySet());
        int n = map.size();
        for (int i = 0; i < n; ++i) {
            this.values[i] = map.get(this.keys[i]);
        }
    }

    public FixedMap(Set<K> set) {
        int n = set.size();
        this.keys = Containers.identitySort(set.toArray(new Object[n]));
        this.values = new Object[n];
    }

    public FixedMap(K[] KArray) {
        this.keys = KArray;
        this.values = new Object[KArray.length];
    }

    @Override
    public final int indexOf(K k) {
        return Containers.identityBinarySearch(this.keys, k);
    }

    @Override
    public final K keyAt(int n) {
        try {
            return (K)this.keys[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public final boolean containsValue(Object object) {
        for (Object object2 : this.values) {
            if (object2 != object) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public boolean contains(Object object) {
                Map.Entry entry = (Map.Entry)object;
                int n = FixedMap.this.indexOf(entry.getKey());
                return n < 0 ? false : FixedMap.this.values[n] == entry.getValue();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return FixedMap.this.keys.length;
            }

            @Override
            public Object[] toArray() {
                int n = this.size();
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new Entry(i);
                }
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] objectArray) {
                int n = this.size();
                if (objectArray.length < n) {
                    objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
                }
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new Entry(i);
                }
                if (objectArray.length > n) {
                    objectArray[n] = null;
                }
                return objectArray;
            }
        };
    }

    @Override
    public final V get(Object object) {
        int n = this.indexOf(object);
        return (V)(n < 0 ? null : this.values[n]);
    }

    public final V get(int n) {
        try {
            return (V)this.values[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.keys.length == 0;
    }

    @Override
    public final V put(K k, V v) {
        int n = this.indexOf(k);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.values[n];
        this.values[n] = v;
        return (V)object;
    }

    @Override
    public final V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        return this.keys.length;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            n += System.identityHashCode(this.keys[i]) ^ System.identityHashCode(this.values[i]);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FixedMap) {
            FixedMap fixedMap = (FixedMap)object;
            if (fixedMap.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == fixedMap.keys[i] && this.values[i] == fixedMap.values[i]) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((Object)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    private final class EntryIterator
    extends Entry
    implements Iterator<Map.Entry<K, V>> {
        int next;

        EntryIterator() {
            super(-1);
            this.next = 0;
        }

        @Override
        public V setValue(V v) {
            Object object = FixedMap.this.values[this.index];
            ((FixedMap)FixedMap.this).values[this.index] = v;
            return object;
        }

        @Override
        public boolean hasNext() {
            return this.next < FixedMap.this.keys.length;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.index = this.next++;
            return this;
        }

        @Override
        public int hashCode() {
            return this.index < 0 ? System.identityHashCode(this) : super.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this.index < 0 ? this == object : super.equals(object);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.index < 0 ? "[]" : super.toString();
        }
    }

    private class Entry
    implements Map.Entry<K, V> {
        int index;

        Entry(int n) {
            this.index = n;
        }

        @Override
        public final K getKey() {
            return FixedMap.this.keys[this.index];
        }

        @Override
        public final V getValue() {
            return FixedMap.this.values[this.index];
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(FixedMap.this.keys[this.index]) ^ System.identityHashCode(FixedMap.this.values[this.index]);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return FixedMap.this.keys[this.index] == entry.getKey() && FixedMap.this.values[this.index] == entry.getValue();
            }
            return false;
        }

        public String toString() {
            return FixedMap.this.keys[this.index] + "=" + FixedMap.this.values[this.index];
        }
    }
}

