/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.collections;

import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kodkod.util.collections.Stack;

public class ArrayStack<T>
extends Stack<T> {
    private T[] elems;
    private int size;

    public ArrayStack() {
        this(10);
    }

    public ArrayStack(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(n + "<0");
        }
        this.elems = new Object[n];
        this.size = 0;
    }

    public void ensureCapacity(int n) {
        int n2 = this.elems.length;
        if (n > n2) {
            T[] TArray = this.elems;
            this.elems = new Object[StrictMath.max(n, n2 * 3 / 2)];
            System.arraycopy(TArray, 0, this.elems, 0, this.size);
        }
    }

    public void trimToSize() {
        int n = this.elems.length;
        if (this.size < n) {
            T[] TArray = this.elems;
            this.elems = new Object[this.size];
            System.arraycopy(TArray, 0, this.elems, 0, this.size);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T push(T t) {
        this.ensureCapacity(this.size + 1);
        this.elems[this.size++] = t;
        return t;
    }

    @Override
    public T pop() {
        if (this.empty()) {
            throw new EmptyStackException();
        }
        T t = this.elems[--this.size];
        this.elems[this.size] = null;
        return t;
    }

    @Override
    public T peek() {
        if (this.empty()) {
            throw new EmptyStackException();
        }
        return this.elems[this.size - 1];
    }

    @Override
    public int search(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!ArrayStack.equal(object, this.elems[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean empty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int cursor;
            int lastReturned;
            {
                this.cursor = ArrayStack.this.size - 1;
                this.lastReturned = -1;
            }

            @Override
            public boolean hasNext() {
                return this.cursor >= 0;
            }

            @Override
            public T next() {
                if (this.cursor < 0) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.cursor;
                return ArrayStack.this.elems[this.cursor--];
            }

            @Override
            public void remove() {
                if (this.lastReturned < 0) {
                    throw new UnsupportedOperationException();
                }
                ArrayStack.this.size--;
                System.arraycopy(ArrayStack.this.elems, this.lastReturned + 1, ArrayStack.this.elems, this.lastReturned, ArrayStack.this.size - this.lastReturned);
                ((ArrayStack)ArrayStack.this).elems[((ArrayStack)ArrayStack.this).size] = null;
                this.lastReturned = -1;
            }
        };
    }
}

