/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.ucore;

import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.engine.satlab.ResolutionTrace;
import kodkod.engine.ucore.StrategyUtils;
import kodkod.util.ints.IntCollection;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

public class RCEStrategy
implements ReductionStrategy {
    private final IntCollection varsToTry;
    private final int dist;

    public RCEStrategy(TranslationLog translationLog) {
        this(translationLog, Integer.MAX_VALUE);
    }

    public RCEStrategy(TranslationLog translationLog, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Resolution distance must be non-negative: " + n);
        }
        this.varsToTry = StrategyUtils.rootVars(translationLog);
        this.dist = n;
    }

    @Override
    public IntSet next(ResolutionTrace resolutionTrace) {
        if (this.varsToTry.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        IntSet intSet = StrategyUtils.coreTailUnits(resolutionTrace);
        IntIterator intIterator = this.varsToTry.iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            intIterator.remove();
            if (!intSet.remove(n)) continue;
            if (intSet.isEmpty()) break;
            IntSet intSet2 = this.clausesFor(resolutionTrace, intSet);
            assert (!intSet2.isEmpty() && !intSet2.contains(resolutionTrace.size() - 1));
            return intSet2;
        }
        this.varsToTry.clear();
        return Ints.EMPTY_SET;
    }

    private IntSet clausesFor(ResolutionTrace resolutionTrace, IntSet intSet) {
        IntSet intSet2 = StrategyUtils.clausesFor(resolutionTrace, intSet);
        if (this.dist < resolutionTrace.resolvents().size()) {
            IntSet intSet3 = intSet2;
            int n = 0;
            for (int i = 0; n < intSet3.size() && i < this.dist; ++i) {
                n = intSet3.size();
                intSet3 = resolutionTrace.directlyLearnable(intSet3);
            }
            return intSet3;
        }
        return resolutionTrace.learnable(intSet2);
    }
}

