/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.satlab;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kodkod.engine.satlab.Clause;
import kodkod.engine.satlab.ResolutionTrace;
import kodkod.util.collections.Containers;
import kodkod.util.ints.IntBitSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

final class LazyTrace
implements ResolutionTrace {
    private final int[][] trace;
    private final int axioms;
    private final IntSet core;
    private final IntSet resolved;

    LazyTrace(int[][] nArray, int n) {
        this.axioms = n;
        IntSet intSet = LazyTrace.reachable(nArray, n);
        this.core = LazyTrace.core(intSet, n);
        this.trace = LazyTrace.compress(nArray, n, intSet, this.core);
        this.resolved = new IntBitSet(this.trace.length - n);
    }

    LazyTrace(LazyTrace lazyTrace, IntSet intSet, int[][] nArray) {
        this.axioms = LazyTrace.reconstruct(lazyTrace, intSet, nArray);
        IntSet intSet2 = LazyTrace.reachable(nArray, this.axioms);
        this.core = LazyTrace.core(intSet2, this.axioms);
        this.trace = LazyTrace.compress(nArray, this.axioms, intSet2, this.core);
        this.resolved = new IntBitSet(this.trace.length - this.axioms);
    }

    private static int reconstruct(LazyTrace lazyTrace, IntSet intSet, int[][] nArray) {
        int n = intSet.size();
        int[][] nArray2 = lazyTrace.trace;
        int[] nArray3 = new int[intSet.max() + 1];
        IntIterator intIterator = intSet.iterator();
        int n2 = intSet.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = intIterator.next();
            nArray3[n3] = i;
            if (lazyTrace.axiom(n3)) {
                nArray[i] = nArray2[n3];
                continue;
            }
            int n4 = nArray2[n3][0];
            int[] nArray4 = new int[n4];
            for (int j = 0; j < n4; ++j) {
                nArray4[j] = nArray3[nArray2[n3][j + 1]];
            }
            nArray[i] = nArray4;
            --n;
        }
        return n;
    }

    private static IntSet reachable(int[][] nArray, int n) {
        IntBitSet intBitSet = new IntBitSet(nArray.length);
        intBitSet.add(nArray.length - 1);
        for (int i = nArray.length - 1; i >= n; --i) {
            if (!intBitSet.contains(i)) continue;
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                intBitSet.add(nArray2[j]);
            }
        }
        return intBitSet;
    }

    private static IntSet core(IntSet intSet, int n) {
        IntBitSet intBitSet = new IntBitSet(n);
        IntIterator intIterator = intSet.iterator(0, n - 1);
        while (intIterator.hasNext()) {
            intBitSet.add(intIterator.next());
        }
        return Ints.unmodifiableIntSet(intBitSet);
    }

    private static int[][] compress(int[][] nArray, int n, IntSet intSet, IntSet intSet2) {
        int[][] nArrayArray = new int[intSet.size() - intSet2.size() + n][];
        System.arraycopy(nArray, 0, nArrayArray, 0, n);
        int[] nArray2 = new int[nArray.length - n];
        IntIterator intIterator = intSet.iterator(n, nArray.length);
        int n2 = n;
        while (intIterator.hasNext()) {
            int n3 = intIterator.next();
            nArray2[n3 - n] = n2;
            int[] nArray3 = nArray[n3];
            nArrayArray[n2] = nArray3;
            for (int n4 : nArray3) {
                nArray3[var10_10] = n4 < n ? n4 : nArray2[n4 - n];
            }
            ++n2;
        }
        return nArrayArray;
    }

    private static int[] resolve(int[] nArray, boolean bl, int[] nArray2, boolean bl2) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = bl ? 0 : nArray[0] + 1;
        int n5 = bl2 ? 0 : nArray2[0] + 1;
        int n6 = 0;
        int[] nArray3 = new int[n2 - n4 + n3 - n5 - 2];
        while (n4 < n2 && n5 < n3) {
            int n7;
            n = nArray[n4];
            int n8 = nArray2[n5];
            int n9 = StrictMath.abs(n);
            if (n9 == (n7 = StrictMath.abs(n8))) {
                if (n == n8) {
                    nArray3[n6++] = n;
                }
                ++n4;
                ++n5;
                continue;
            }
            if (n9 < n7) {
                nArray3[n6++] = n;
                ++n4;
                continue;
            }
            nArray3[n6++] = n8;
            ++n5;
        }
        if (n4 < n2) {
            n = n2 - n4;
            System.arraycopy(nArray, n4, nArray3, n6, n);
            n6 += n;
        }
        if (n5 < n3) {
            n = n3 - n5;
            System.arraycopy(nArray2, n5, nArray3, n6, n);
            n6 += n;
        }
        if (n6 == nArray3.length) {
            return nArray3;
        }
        int[] nArray4 = new int[n6];
        System.arraycopy(nArray3, 0, nArray4, 0, n6);
        return nArray4;
    }

    private int[] resolve(int n) {
        if (n < this.axioms || this.resolved(n)) {
            return this.trace[n];
        }
        int[] nArray = this.trace[n];
        int[] nArray2 = LazyTrace.resolve(this.resolve(nArray[0]), nArray[0] < this.axioms, this.resolve(nArray[1]), nArray[1] < this.axioms);
        for (int i = 2; i < nArray.length; ++i) {
            nArray2 = LazyTrace.resolve(nArray2, true, this.resolve(nArray[i]), nArray[i] < this.axioms);
        }
        int[] nArray3 = new int[nArray.length + nArray2.length + 1];
        nArray3[0] = nArray.length;
        System.arraycopy(nArray, 0, nArray3, 1, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length + 1, nArray2.length);
        this.trace[n] = nArray3;
        this.resolved.add(n - this.axioms);
        return nArray3;
    }

    private boolean resolved(int n) {
        return this.resolved.contains(n - this.axioms);
    }

    private boolean axiom(int n) {
        return n < this.axioms;
    }

    private int litOffset(int n) {
        return this.axiom(n) ? 0 : (this.resolved(n) ? this.trace[n][0] + 1 : -1);
    }

    @Override
    public int size() {
        return this.trace.length;
    }

    @Override
    public IntSet core() {
        return this.core;
    }

    @Override
    public IntSet axioms() {
        return Ints.rangeSet(Ints.range(0, this.axioms - 1));
    }

    @Override
    public IntSet resolvents() {
        return Ints.rangeSet(Ints.range(this.axioms, this.trace.length - 1));
    }

    @Override
    public Clause get(final int n) {
        if (n >= 0 && n < this.trace.length) {
            if (this.axiom(n)) {
                return new Clause(){
                    final int[] literals;
                    final int hashCode;
                    {
                        this.literals = LazyTrace.this.trace[n];
                        this.hashCode = Ints.superFastHash(this.literals);
                    }

                    @Override
                    public Iterator<Clause> antecedents() {
                        return Containers.emptyIterator();
                    }

                    @Override
                    public IntIterator literals() {
                        return new IntArrayIterator(this.literals, 0, this.literals.length);
                    }

                    @Override
                    public int maxVariable() {
                        return StrictMath.abs(this.literals[this.literals.length - 1]);
                    }

                    @Override
                    public int numberOfAntecedents() {
                        return 0;
                    }

                    @Override
                    public int size() {
                        return this.literals.length;
                    }

                    @Override
                    public int[] toArray(int[] nArray) {
                        if (nArray.length < this.literals.length) {
                            nArray = new int[this.literals.length];
                        }
                        System.arraycopy(this.literals, 0, nArray, 0, this.literals.length);
                        return nArray;
                    }

                    @Override
                    public int hashCode() {
                        return this.hashCode;
                    }
                };
            }
            return new ClauseView(n);
        }
        throw new IndexOutOfBoundsException("invalid index: " + n);
    }

    @Override
    public Iterator<Clause> iterator() {
        return new ClauseIterator(new IntIterator(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index >= 0 && this.index < LazyTrace.this.trace.length;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.index++;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    private boolean valid(IntSet intSet) {
        return intSet.min() >= 0 && intSet.max() < this.trace.length;
    }

    @Override
    public Iterator<Clause> iterator(IntSet intSet) {
        if (intSet.isEmpty() || this.valid(intSet)) {
            return new ClauseIterator(intSet.iterator());
        }
        throw new IndexOutOfBoundsException("invalid indices: " + intSet);
    }

    @Override
    public Iterator<Clause> reverseIterator(IntSet intSet) {
        if (intSet.isEmpty() || this.valid(intSet)) {
            return new ClauseIterator(intSet.iterator(Integer.MAX_VALUE, Integer.MIN_VALUE));
        }
        throw new IndexOutOfBoundsException("invalid indices: " + intSet);
    }

    @Override
    public IntSet reachable(IntSet intSet) {
        if (intSet.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        if (this.valid(intSet)) {
            IntBitSet intBitSet = new IntBitSet(this.trace.length);
            intBitSet.addAll(intSet);
            for (int i = intSet.max(); i >= this.axioms; --i) {
                int n;
                if (!intBitSet.contains(i)) continue;
                int[] nArray = this.trace[i];
                if (this.resolved(i)) {
                    int n2 = nArray[0];
                    for (n = 1; n <= n2; ++n) {
                        intBitSet.add(nArray[n]);
                    }
                    continue;
                }
                for (n = 0; n < nArray.length; ++n) {
                    intBitSet.add(nArray[n]);
                }
            }
            return intBitSet;
        }
        throw new IndexOutOfBoundsException("invalid indices: " + intSet);
    }

    @Override
    public IntSet backwardReachable(IntSet intSet) {
        if (intSet.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        if (this.valid(intSet)) {
            IntBitSet intBitSet = new IntBitSet(this.trace.length);
            intBitSet.addAll(intSet);
            int n = this.trace.length;
            block0: for (int i = this.axioms; i < n; ++i) {
                int n2;
                int[] nArray = this.trace[i];
                if (this.resolved(i)) {
                    int n3 = nArray[0];
                    for (n2 = 1; n2 <= n3; ++n2) {
                        if (!intBitSet.contains(nArray[n2])) continue;
                        intBitSet.add(i);
                        continue block0;
                    }
                    continue;
                }
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (!intBitSet.contains(nArray[n2])) continue;
                    intBitSet.add(i);
                    continue block0;
                }
            }
            return intBitSet;
        }
        throw new IndexOutOfBoundsException("invalid indices: " + intSet);
    }

    @Override
    public IntSet learnable(IntSet intSet) {
        if (intSet.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        if (this.valid(intSet)) {
            IntBitSet intBitSet = new IntBitSet(this.trace.length);
            intBitSet.addAll(intSet);
            int n = this.trace.length;
            block0: for (int i = this.axioms; i < n; ++i) {
                int n2;
                int[] nArray = this.trace[i];
                if (this.resolved(i)) {
                    int n3 = nArray[0];
                    for (n2 = 1; n2 <= n3; ++n2) {
                        if (!intBitSet.contains(nArray[n2])) continue block0;
                    }
                } else {
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (!intBitSet.contains(nArray[n2])) continue block0;
                    }
                }
                intBitSet.add(i);
            }
            return intBitSet;
        }
        throw new IndexOutOfBoundsException("invalid indices: " + intSet);
    }

    @Override
    public IntSet directlyLearnable(IntSet intSet) {
        if (intSet.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        if (this.valid(intSet)) {
            IntBitSet intBitSet = new IntBitSet(this.trace.length);
            intBitSet.addAll(intSet);
            int n = this.trace.length;
            block0: for (int i = this.axioms; i < n; ++i) {
                int n2;
                int[] nArray = this.trace[i];
                if (this.resolved(i)) {
                    int n3 = nArray[0];
                    for (n2 = 1; n2 <= n3; ++n2) {
                        if (!intSet.contains(nArray[n2])) continue block0;
                    }
                } else {
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (!intSet.contains(nArray[n2])) continue block0;
                    }
                }
                intBitSet.add(i);
            }
            return intBitSet;
        }
        throw new IndexOutOfBoundsException("invalid indices: " + intSet);
    }

    public String toString() {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < this.axioms; ++n2) {
            stringBuilder.append("AXIOM.  Literals: ");
            int[] nArray = this.trace[n2];
            n = nArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(nArray[i]);
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n");
        }
        int n3 = this.trace.length;
        for (n2 = this.axioms; n2 < n3; ++n2) {
            stringBuilder.append("RESOLVENT.  Antecedents:  ");
            int[] nArray = this.trace[n2];
            if (this.resolved(n2)) {
                int n4 = nArray[0];
                for (n = 1; n <= n4; ++n) {
                    stringBuilder.append(nArray[n]);
                    stringBuilder.append(" ");
                }
            } else {
                for (n = 0; n < nArray.length; ++n) {
                    stringBuilder.append(nArray[n]);
                    stringBuilder.append(" ");
                }
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static final class IntArrayIterator
    implements IntIterator {
        private final int[] array;
        private int from;
        private final int to;

        IntArrayIterator(int[] nArray, int n, int n2) {
            this.array = nArray;
            this.from = n;
            this.to = n2;
        }

        @Override
        public boolean hasNext() {
            return this.from >= 0 && this.from < this.to;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.from++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ClauseIterator
    extends ClauseView
    implements Iterator<Clause> {
        private final IntIterator itr;

        ClauseIterator(IntIterator intIterator) {
            this.itr = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Clause next() {
            return this.set(this.itr.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ClauseView
    extends Clause {
        private int[] clause;
        private int litOffset;
        private int index;

        ClauseView(int n) {
            this.index = n;
            this.clause = LazyTrace.this.trace[n];
            this.litOffset = LazyTrace.this.litOffset(n);
        }

        ClauseView() {
            this(0);
        }

        ClauseView set(int n) {
            this.index = n;
            this.clause = LazyTrace.this.trace[n];
            this.litOffset = LazyTrace.this.litOffset(n);
            return this;
        }

        void ensureLiterals() {
            if (this.litOffset < 0) {
                LazyTrace.this.resolve(this.index);
                this.clause = LazyTrace.this.trace[this.index];
                this.litOffset = LazyTrace.this.litOffset(this.index);
            }
        }

        @Override
        public int maxVariable() {
            this.ensureLiterals();
            return StrictMath.abs(this.clause[this.clause.length - 1]);
        }

        @Override
        public int numberOfAntecedents() {
            return this.litOffset < 0 ? this.clause.length : StrictMath.max(0, this.litOffset - 1);
        }

        @Override
        public int size() {
            this.ensureLiterals();
            return this.clause.length - this.litOffset;
        }

        @Override
        public Iterator<Clause> antecedents() {
            return new ClauseIterator(new IntArrayIterator(this.clause, 1, this.litOffset));
        }

        @Override
        public IntIterator literals() {
            this.ensureLiterals();
            return new IntArrayIterator(this.clause, this.litOffset, this.clause.length);
        }

        @Override
        public int[] toArray(int[] nArray) {
            int n = this.size();
            if (nArray.length < n) {
                nArray = new int[n];
            }
            System.arraycopy(this.clause, this.litOffset, nArray, 0, n);
            return nArray;
        }
    }
}

