/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IntExpression;
import kodkod.ast.Node;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.ast.visitor.AbstractReplacer;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanFactory;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.Int;
import kodkod.engine.bool.Operator;
import kodkod.engine.config.Options;
import kodkod.engine.fol2sat.Bool2CNFTranslator;
import kodkod.engine.fol2sat.BooleanFormulaFlattener;
import kodkod.engine.fol2sat.Environment;
import kodkod.engine.fol2sat.FOL2BoolTranslator;
import kodkod.engine.fol2sat.FileLogger;
import kodkod.engine.fol2sat.FormulaFlattener;
import kodkod.engine.fol2sat.LeafInterpreter;
import kodkod.engine.fol2sat.MemoryLogger;
import kodkod.engine.fol2sat.Skolemizer;
import kodkod.engine.fol2sat.SymmetryBreaker;
import kodkod.engine.fol2sat.Translation;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.fol2sat.TranslationLogger;
import kodkod.engine.fol2sat.TrivialFormulaException;
import kodkod.engine.satlab.SATSolver;
import kodkod.instance.Bounds;
import kodkod.instance.Instance;
import kodkod.util.ints.IntSet;
import kodkod.util.nodes.AnnotatedNode;

public final class Translator {
    private final Formula formula;
    private final Bounds bounds;
    private final Options options;
    private TranslationLog log;

    public static BooleanMatrix approximate(Expression expression, Bounds bounds, Options options) {
        return FOL2BoolTranslator.approximate(AnnotatedNode.annotate(expression), LeafInterpreter.overapproximating(bounds, options), Environment.EMPTY);
    }

    public static BooleanConstant evaluate(Formula formula, Instance instance, Options options) {
        return (BooleanConstant)FOL2BoolTranslator.translate(AnnotatedNode.annotate(formula), LeafInterpreter.exact(instance, options));
    }

    public static BooleanMatrix evaluate(Expression expression, Instance instance, Options options) {
        return (BooleanMatrix)FOL2BoolTranslator.translate(AnnotatedNode.annotate(expression), LeafInterpreter.exact(instance, options));
    }

    public static Int evaluate(IntExpression intExpression, Instance instance, Options options) {
        return (Int)FOL2BoolTranslator.translate(AnnotatedNode.annotate(intExpression), LeafInterpreter.exact(instance, options));
    }

    public static Translation translate(Formula formula, Bounds bounds, Options options) throws TrivialFormulaException {
        return new Translator(formula, bounds, options).translate();
    }

    private Translator(Formula formula, Bounds bounds, Options options) {
        this.formula = formula;
        this.bounds = bounds.clone();
        this.options = options;
        this.log = null;
    }

    private Translation translate() throws TrivialFormulaException {
        AnnotatedNode<Formula> annotatedNode = this.options.logTranslation() > 0 ? AnnotatedNode.annotateRoots(this.formula) : AnnotatedNode.annotate(this.formula);
        SymmetryBreaker symmetryBreaker = this.optimizeBounds(annotatedNode);
        return this.toBoolean(this.optimizeFormula(annotatedNode, symmetryBreaker), symmetryBreaker);
    }

    private SymmetryBreaker optimizeBounds(AnnotatedNode<Formula> annotatedNode) {
        this.bounds.relations().retainAll(annotatedNode.relations());
        if (!annotatedNode.usesInts()) {
            this.bounds.ints().clear();
        }
        return new SymmetryBreaker(this.bounds, this.options.reporter());
    }

    private AnnotatedNode<Formula> optimizeFormula(AnnotatedNode<Formula> annotatedNode, SymmetryBreaker symmetryBreaker) {
        this.options.reporter().optimizingBoundsAndFormula();
        if (this.options.logTranslation() == 0) {
            annotatedNode = this.inlinePredicates(annotatedNode, symmetryBreaker.breakMatrixSymmetries(annotatedNode.predicates(), true).keySet());
            return this.options.skolemDepth() >= 0 ? Skolemizer.skolemize(annotatedNode, this.bounds, this.options) : annotatedNode;
        }
        if (this.options.coreGranularity() == 1) {
            annotatedNode = FormulaFlattener.flatten(annotatedNode, false);
        }
        if (this.options.skolemDepth() >= 0) {
            annotatedNode = Skolemizer.skolemize(annotatedNode, this.bounds, this.options);
        }
        if (this.options.coreGranularity() > 1) {
            annotatedNode = FormulaFlattener.flatten(annotatedNode, this.options.coreGranularity() == 3);
        }
        return this.inlinePredicates(annotatedNode, symmetryBreaker.breakMatrixSymmetries(annotatedNode.predicates(), false));
    }

    private AnnotatedNode<Formula> inlinePredicates(AnnotatedNode<Formula> annotatedNode, final Set<RelationPredicate> set) {
        AbstractReplacer abstractReplacer = new AbstractReplacer(annotatedNode.sharedNodes()){

            @Override
            public Formula visit(RelationPredicate relationPredicate) {
                Formula formula = this.lookup(relationPredicate);
                if (formula != null) {
                    return formula;
                }
                return set.contains(relationPredicate) ? this.cache(relationPredicate, Formula.TRUE) : this.cache(relationPredicate, relationPredicate.toConstraints());
            }
        };
        return AnnotatedNode.annotate((Node)annotatedNode.node().accept(abstractReplacer));
    }

    private AnnotatedNode<Formula> inlinePredicates(final AnnotatedNode<Formula> annotatedNode, final Map<RelationPredicate, Formula> map) {
        final IdentityHashMap identityHashMap = new IdentityHashMap();
        AbstractReplacer abstractReplacer = new AbstractReplacer(annotatedNode.sharedNodes()){
            private RelationPredicate source;
            {
                super(set);
                this.source = null;
            }

            @Override
            protected <N extends Node> N cache(N n, N n2) {
                if (n2 instanceof Formula) {
                    if (this.source == null) {
                        Node node = annotatedNode.sourceOf(n);
                        if (n2 != node) {
                            identityHashMap.put(n2, node);
                        }
                    } else {
                        identityHashMap.put(n2, this.source);
                    }
                }
                return super.cache(n, n2);
            }

            @Override
            public Formula visit(RelationPredicate relationPredicate) {
                Formula formula = this.lookup(relationPredicate);
                if (formula != null) {
                    return formula;
                }
                this.source = relationPredicate;
                formula = map.containsKey(relationPredicate) ? ((Formula)map.get(relationPredicate)).accept(this) : relationPredicate.toConstraints().accept(this);
                this.source = null;
                return this.cache(relationPredicate, formula);
            }
        };
        return AnnotatedNode.annotate((Node)annotatedNode.node().accept(abstractReplacer), identityHashMap);
    }

    private Translation toBoolean(AnnotatedNode<Formula> annotatedNode, SymmetryBreaker symmetryBreaker) throws TrivialFormulaException {
        this.options.reporter().translatingToBoolean(annotatedNode.node(), this.bounds);
        LeafInterpreter leafInterpreter = LeafInterpreter.exact(this.bounds, this.options);
        if (this.options.logTranslation() > 0) {
            TranslationLogger translationLogger = this.options.logTranslation() == 1 ? new MemoryLogger(annotatedNode, this.bounds) : new FileLogger(annotatedNode, this.bounds);
            BooleanAccumulator booleanAccumulator = FOL2BoolTranslator.translate(annotatedNode, leafInterpreter, translationLogger);
            this.log = translationLogger.log();
            if (booleanAccumulator.isShortCircuited()) {
                throw new TrivialFormulaException(annotatedNode.node(), this.bounds, booleanAccumulator.op().shortCircuit(), this.log);
            }
            if (booleanAccumulator.size() == 0) {
                throw new TrivialFormulaException(annotatedNode.node(), this.bounds, booleanAccumulator.op().identity(), this.log);
            }
            return this.generateSBP(booleanAccumulator, leafInterpreter, symmetryBreaker);
        }
        BooleanValue booleanValue = (BooleanValue)FOL2BoolTranslator.translate(annotatedNode, leafInterpreter);
        if (booleanValue.op() == Operator.CONST) {
            throw new TrivialFormulaException(annotatedNode.node(), this.bounds, (BooleanConstant)booleanValue, null);
        }
        return this.generateSBP(annotatedNode, (BooleanFormula)booleanValue, leafInterpreter, symmetryBreaker);
    }

    private Translation generateSBP(BooleanAccumulator booleanAccumulator, LeafInterpreter leafInterpreter, SymmetryBreaker symmetryBreaker) {
        this.options.reporter().generatingSBP();
        BooleanFactory booleanFactory = leafInterpreter.factory();
        booleanAccumulator.add(symmetryBreaker.generateSBP(leafInterpreter, this.options.symmetryBreaking()));
        return this.toCNF((BooleanFormula)booleanFactory.accumulate(booleanAccumulator), booleanFactory.numberOfVariables(), leafInterpreter.vars());
    }

    private Translation generateSBP(AnnotatedNode<Formula> annotatedNode, BooleanFormula booleanFormula, LeafInterpreter leafInterpreter, SymmetryBreaker symmetryBreaker) throws TrivialFormulaException {
        this.options.reporter().generatingSBP();
        BooleanFactory booleanFactory = leafInterpreter.factory();
        BooleanValue booleanValue = symmetryBreaker.generateSBP(leafInterpreter, this.options.symmetryBreaking());
        return this.flatten(annotatedNode, (BooleanFormula)booleanFactory.and(booleanFormula, booleanValue), leafInterpreter);
    }

    private Translation flatten(AnnotatedNode<Formula> annotatedNode, BooleanFormula booleanFormula, LeafInterpreter leafInterpreter) throws TrivialFormulaException {
        BooleanFactory booleanFactory = leafInterpreter.factory();
        if (this.options.flatten()) {
            this.options.reporter().flattening(booleanFormula);
            BooleanValue booleanValue = BooleanFormulaFlattener.flatten(booleanFormula, booleanFactory);
            if (booleanValue.op() == Operator.CONST) {
                throw new TrivialFormulaException(annotatedNode.node(), this.bounds, (BooleanConstant)booleanValue, null);
            }
            return this.toCNF((BooleanFormula)booleanValue, booleanFactory.numberOfVariables(), leafInterpreter.vars());
        }
        return this.toCNF(booleanFormula, booleanFactory.numberOfVariables(), leafInterpreter.vars());
    }

    private Translation toCNF(BooleanFormula booleanFormula, int n, Map<Relation, IntSet> map) {
        this.options.reporter().translatingToCNF(booleanFormula);
        SATSolver sATSolver = Bool2CNFTranslator.translate(booleanFormula, this.options.solver(), n);
        return new Translation(sATSolver, this.bounds, map, n, this.log);
    }
}

