/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.Map;
import kodkod.ast.Relation;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.satlab.SATSolver;
import kodkod.instance.Bounds;
import kodkod.instance.Instance;
import kodkod.instance.TupleFactory;
import kodkod.instance.TupleSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

public final class Translation {
    private final Bounds bounds;
    private final SATSolver solver;
    private final Map<Relation, IntSet> primaryVarUsage;
    private final TranslationLog log;
    private final int maxPrimaryLit;

    Translation(SATSolver sATSolver, Bounds bounds, Map<Relation, IntSet> map, int n, TranslationLog translationLog) {
        this.solver = sATSolver;
        this.bounds = bounds;
        this.primaryVarUsage = map;
        this.maxPrimaryLit = n;
        this.log = translationLog;
    }

    public SATSolver cnf() {
        return this.solver;
    }

    public Instance interpret() {
        TupleFactory tupleFactory = this.bounds.universe().factory();
        Instance instance = new Instance(this.bounds.universe());
        for (Relation relation : this.bounds.relations()) {
            TupleSet tupleSet = this.bounds.lowerBound(relation);
            IntSet intSet = Ints.bestSet(tupleSet.capacity());
            intSet.addAll(tupleSet.indexView());
            IntSet intSet2 = this.primaryVarUsage.get(relation);
            if (intSet2 != null) {
                int n = intSet2.min();
                IntIterator intIterator = this.bounds.upperBound(relation).indexView().iterator();
                while (intIterator.hasNext()) {
                    int n2 = intIterator.next();
                    if (intSet.contains(n2) || !this.solver.valueOf(n++)) continue;
                    intSet.add(n2);
                }
            }
            instance.add(relation, tupleFactory.setOf(relation.arity(), intSet));
        }
        return instance;
    }

    public IntSet primaryVariables(Relation relation) {
        return this.primaryVarUsage.get(relation);
    }

    public int numPrimaryVariables() {
        return this.maxPrimaryLit;
    }

    public TranslationLog log() {
        return this.log;
    }
}

