/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanFactory;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.Dimensions;
import kodkod.engine.bool.Int;
import kodkod.engine.bool.Operator;
import kodkod.util.collections.Containers;
import kodkod.util.ints.ArraySequence;
import kodkod.util.ints.HomogenousSequence;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;
import kodkod.util.ints.RangeSequence;
import kodkod.util.ints.SparseSequence;
import kodkod.util.ints.TreeSequence;

public final class BooleanMatrix
implements Iterable<IndexedEntry<BooleanValue>>,
Cloneable {
    private final Dimensions dims;
    private final BooleanFactory factory;
    private final SparseSequence<BooleanValue> cells;

    private BooleanMatrix(Dimensions dimensions, BooleanFactory booleanFactory, SparseSequence<BooleanValue> sparseSequence) {
        this.dims = dimensions;
        this.factory = booleanFactory;
        this.cells = sparseSequence;
    }

    private BooleanMatrix(Dimensions dimensions, BooleanFactory booleanFactory, SparseSequence<BooleanValue> sparseSequence, SparseSequence<BooleanValue> sparseSequence2) {
        this.dims = dimensions;
        this.factory = booleanFactory;
        Class<?> clazz = sparseSequence.getClass();
        Class<?> clazz2 = sparseSequence2.getClass();
        this.cells = clazz != clazz2 || clazz == RangeSequence.class ? new RangeSequence<BooleanValue>() : (clazz == HomogenousSequence.class ? new HomogenousSequence<BooleanConstant>(BooleanConstant.TRUE, Ints.bestSet(dimensions.capacity())) : new TreeSequence<BooleanValue>());
    }

    private BooleanMatrix(Dimensions dimensions, BooleanMatrix booleanMatrix, BooleanMatrix ... booleanMatrixArray) {
        this.dims = dimensions;
        this.factory = booleanMatrix.factory;
        Class<HomogenousSequence> clazz = HomogenousSequence.class;
        Class<TreeSequence> clazz2 = TreeSequence.class;
        boolean bl = dimensions.equals(booleanMatrix);
        Class<?> clazz3 = booleanMatrix.cells.getClass();
        int n = clazz3 == clazz ? 1 : (clazz3 == clazz2 ? 2 : 4);
        for (BooleanMatrix booleanMatrix2 : booleanMatrixArray) {
            BooleanMatrix.checkFactory(this.factory, booleanMatrix2.factory);
            if (bl) {
                BooleanMatrix.checkDimensions(dimensions, booleanMatrix2.dims);
            }
            n |= (clazz3 = booleanMatrix2.cells.getClass()) == clazz ? 1 : (clazz3 == clazz2 ? 2 : 4);
        }
        switch (n) {
            case 1: {
                this.cells = new HomogenousSequence<BooleanConstant>(BooleanConstant.TRUE, Ints.bestSet(dimensions.capacity()));
                break;
            }
            case 2: {
                this.cells = new TreeSequence<BooleanValue>();
                break;
            }
            default: {
                this.cells = new RangeSequence<BooleanValue>();
            }
        }
    }

    BooleanMatrix(Dimensions dimensions, BooleanFactory booleanFactory) {
        this.dims = dimensions;
        this.factory = booleanFactory;
        this.cells = new RangeSequence<BooleanValue>();
    }

    BooleanMatrix(Dimensions dimensions, BooleanFactory booleanFactory, IntSet intSet, IntSet intSet2) {
        this.dims = dimensions;
        this.factory = booleanFactory;
        int n = intSet2.size();
        int n2 = intSet.size();
        if (n == n2) {
            this.cells = new HomogenousSequence<BooleanConstant>(BooleanConstant.TRUE, intSet2);
        } else {
            this.cells = n == 0 || n2 / n >= 2 ? new ArraySequence<BooleanValue>(intSet) : new RangeSequence();
            IntIterator intIterator = intSet2.iterator();
            while (intIterator.hasNext()) {
                this.cells.put(intIterator.next(), BooleanConstant.TRUE);
            }
        }
    }

    public final Dimensions dimensions() {
        return this.dims;
    }

    public final BooleanFactory factory() {
        return this.factory;
    }

    public final int density() {
        return this.cells.size();
    }

    @Override
    public final Iterator<IndexedEntry<BooleanValue>> iterator() {
        return this.cells.iterator();
    }

    public final IntSet denseIndices() {
        return this.cells.indices();
    }

    private final BooleanValue maskNull(BooleanValue booleanValue) {
        return booleanValue == null ? BooleanConstant.FALSE : booleanValue;
    }

    private final BooleanValue fastGet(int n) {
        return this.maskNull(this.cells.get(n));
    }

    public final BooleanValue get(int n) {
        if (!this.dims.validate(n)) {
            throw new IndexOutOfBoundsException(n + " is not a valid index.");
        }
        return this.maskNull(this.cells.get(n));
    }

    public final BooleanMatrix not() {
        BooleanMatrix booleanMatrix = new BooleanMatrix(this.dims, this.factory, this.cells, this.cells);
        int n = this.dims.capacity();
        for (int i = 0; i < n; ++i) {
            BooleanValue booleanValue = this.cells.get(i);
            if (booleanValue == null) {
                booleanMatrix.cells.put(i, BooleanConstant.TRUE);
                continue;
            }
            if (booleanValue == BooleanConstant.TRUE) continue;
            booleanMatrix.cells.put(i, booleanValue.negation());
        }
        return booleanMatrix;
    }

    private static final void checkFactory(BooleanFactory booleanFactory, BooleanFactory booleanFactory2) {
        if (booleanFactory != booleanFactory2) {
            throw new IllegalArgumentException("Incompatible factories: " + booleanFactory + " and " + booleanFactory2);
        }
    }

    private static final void checkDimensions(Dimensions dimensions, Dimensions dimensions2) {
        if (!dimensions.equals(dimensions2)) {
            throw new IllegalArgumentException("Incompatible dimensions: " + dimensions + " and " + dimensions2);
        }
    }

    public final BooleanMatrix and(BooleanMatrix booleanMatrix) {
        BooleanMatrix.checkFactory(this.factory, booleanMatrix.factory);
        BooleanMatrix.checkDimensions(this.dims, booleanMatrix.dims);
        BooleanMatrix booleanMatrix2 = new BooleanMatrix(this.dims, this.factory, this.cells, booleanMatrix.cells);
        SparseSequence<BooleanValue> sparseSequence = booleanMatrix.cells;
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            BooleanValue booleanValue = sparseSequence.get(indexedEntry.index());
            if (booleanValue == null) continue;
            booleanMatrix2.fastSet(indexedEntry.index(), this.factory.and(indexedEntry.value(), booleanValue));
        }
        return booleanMatrix2;
    }

    public final BooleanMatrix and(BooleanMatrix ... booleanMatrixArray) {
        BooleanMatrix booleanMatrix = new BooleanMatrix(this.dims, this, booleanMatrixArray);
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND, indexedEntry.value());
            for (BooleanMatrix booleanMatrix2 : booleanMatrixArray) {
                if (booleanAccumulator.add(booleanMatrix2.fastGet(indexedEntry.index())) == BooleanConstant.FALSE) break;
            }
            if (booleanAccumulator.isShortCircuited()) continue;
            booleanMatrix.fastSet(indexedEntry.index(), this.factory.accumulate(booleanAccumulator));
        }
        return booleanMatrix;
    }

    public final BooleanMatrix or(BooleanMatrix booleanMatrix) {
        BooleanMatrix.checkFactory(this.factory, booleanMatrix.factory);
        BooleanMatrix.checkDimensions(this.dims, booleanMatrix.dims);
        BooleanMatrix booleanMatrix2 = new BooleanMatrix(this.dims, this.factory, this.cells, booleanMatrix.cells);
        SparseSequence<BooleanValue> sparseSequence = booleanMatrix2.cells;
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            BooleanValue booleanValue = booleanMatrix.cells.get(indexedEntry.index());
            if (booleanValue == null) {
                sparseSequence.put(indexedEntry.index(), indexedEntry.value());
                continue;
            }
            sparseSequence.put(indexedEntry.index(), this.factory.or(indexedEntry.value(), booleanValue));
        }
        for (IndexedEntry<BooleanValue> indexedEntry : booleanMatrix.cells) {
            if (this.cells.containsIndex(indexedEntry.index())) continue;
            sparseSequence.put(indexedEntry.index(), indexedEntry.value());
        }
        return booleanMatrix2;
    }

    public final BooleanMatrix or(BooleanMatrix ... booleanMatrixArray) {
        int n;
        BooleanMatrix booleanMatrix = new BooleanMatrix(this.dims, this, booleanMatrixArray);
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            BooleanMatrix booleanMatrix2;
            BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.OR, indexedEntry.value());
            BooleanMatrix[] object = booleanMatrixArray;
            int n2 = object.length;
            for (n = 0; n < n2 && booleanAccumulator.add((booleanMatrix2 = object[n]).fastGet(indexedEntry.index())) != BooleanConstant.TRUE; ++n) {
            }
            booleanMatrix.fastSet(indexedEntry.index(), this.factory.accumulate(booleanAccumulator));
        }
        int n3 = booleanMatrixArray.length;
        for (int i = 0; i < n3; ++i) {
            for (IndexedEntry indexedEntry : booleanMatrixArray[i].cells) {
                if (booleanMatrix.cells.containsIndex(indexedEntry.index())) continue;
                BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.OR, (BooleanValue)indexedEntry.value());
                for (n = i + 1; n < n3 && booleanAccumulator.add(booleanMatrixArray[n].fastGet(indexedEntry.index())) != BooleanConstant.TRUE; ++n) {
                }
                booleanMatrix.fastSet(indexedEntry.index(), this.factory.accumulate(booleanAccumulator));
            }
        }
        return booleanMatrix;
    }

    public final BooleanMatrix cross(BooleanMatrix booleanMatrix) {
        BooleanMatrix.checkFactory(this.factory, booleanMatrix.factory);
        BooleanMatrix booleanMatrix2 = new BooleanMatrix(this.dims.cross(booleanMatrix.dims), this.factory, this.cells, booleanMatrix.cells);
        if (this.cells.isEmpty() || booleanMatrix.cells.isEmpty()) {
            return booleanMatrix2;
        }
        int n = booleanMatrix.dims.capacity();
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            int n2 = n * indexedEntry.index();
            for (IndexedEntry<BooleanValue> indexedEntry2 : booleanMatrix.cells) {
                BooleanValue booleanValue = this.factory.and(indexedEntry.value(), indexedEntry2.value());
                if (booleanValue == BooleanConstant.FALSE) continue;
                booleanMatrix2.cells.put(n2 + indexedEntry2.index(), booleanValue);
            }
        }
        return booleanMatrix2;
    }

    private static int nextCross(BooleanMatrix[] booleanMatrixArray, IntIterator[] intIteratorArray, int[] nArray, int n) {
        int n2 = 1;
        for (int i = intIteratorArray.length - 1; i >= 0; --i) {
            int n3;
            if (intIteratorArray[i].hasNext()) {
                n3 = nArray[i];
                nArray[i] = intIteratorArray[i].next();
                return n - n2 * n3 + n2 * nArray[i];
            }
            intIteratorArray[i] = booleanMatrixArray[i].cells.indices().iterator();
            n3 = nArray[i];
            nArray[i] = intIteratorArray[i].next();
            n = n - n2 * n3 + n2 * nArray[i];
            n2 *= booleanMatrixArray[i].dims.capacity();
        }
        return -1;
    }

    private static int initCross(BooleanMatrix[] booleanMatrixArray, IntIterator[] intIteratorArray, int[] nArray) {
        int n = 1;
        int n2 = 0;
        for (int i = booleanMatrixArray.length - 1; i >= 0; --i) {
            intIteratorArray[i] = booleanMatrixArray[i].cells.indices().iterator();
            nArray[i] = intIteratorArray[i].next();
            n2 += n * nArray[i];
            n *= booleanMatrixArray[i].dims.capacity();
        }
        return n2;
    }

    public final BooleanMatrix cross(BooleanMatrix ... booleanMatrixArray) {
        Dimensions dimensions = this.dims;
        boolean bl = this.cells.isEmpty();
        for (BooleanMatrix booleanMatrix : booleanMatrixArray) {
            dimensions = dimensions.cross(booleanMatrix.dims);
            bl = bl || booleanMatrix.cells.isEmpty();
        }
        BooleanMatrix booleanMatrix = new BooleanMatrix(dimensions, this, booleanMatrixArray);
        if (bl) {
            return booleanMatrix;
        }
        IntIterator[] intIteratorArray = new IntIterator[booleanMatrixArray.length];
        int[] nArray = new int[booleanMatrixArray.length];
        int n = dimensions.capacity() / this.dims.capacity();
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            int n2 = n * indexedEntry.index();
            int n3 = BooleanMatrix.initCross(booleanMatrixArray, intIteratorArray, nArray);
            while (n3 >= 0) {
                BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND, indexedEntry.value());
                for (int i = booleanMatrixArray.length - 1; i >= 0 && booleanAccumulator.add(booleanMatrixArray[i].fastGet(nArray[i])) != BooleanConstant.FALSE; --i) {
                }
                if (!booleanAccumulator.isShortCircuited()) {
                    super.fastSet(n2 + n3, this.factory.accumulate(booleanAccumulator));
                }
                n3 = BooleanMatrix.nextCross(booleanMatrixArray, intIteratorArray, nArray, n3);
            }
        }
        return booleanMatrix;
    }

    private final void fastSet(int n, BooleanValue booleanValue) {
        if (booleanValue == BooleanConstant.FALSE) {
            this.cells.remove(n);
        } else {
            this.cells.put(n, booleanValue);
        }
    }

    public final BooleanMatrix dot(BooleanMatrix booleanMatrix) {
        BooleanMatrix.checkFactory(this.factory, booleanMatrix.factory);
        BooleanMatrix booleanMatrix2 = new BooleanMatrix(this.dims.dot(booleanMatrix.dims), this.factory, this.cells, booleanMatrix.cells);
        if (this.cells.isEmpty() || booleanMatrix.cells.isEmpty()) {
            return booleanMatrix2;
        }
        SparseSequence<BooleanValue> sparseSequence = booleanMatrix2.cells;
        int n = booleanMatrix.dims.dimension(0);
        int n2 = booleanMatrix.dims.capacity() / n;
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            int n3 = indexedEntry.index();
            BooleanValue booleanValue = indexedEntry.value();
            int n4 = n3 % n * n2;
            int n5 = n4 + n2 - 1;
            Iterator<IndexedEntry<BooleanValue>> iterator = booleanMatrix.cells.iterator(n4, n5);
            while (iterator.hasNext()) {
                IndexedEntry<BooleanValue> indexedEntry2 = iterator.next();
                BooleanValue booleanValue2 = this.factory.and(booleanValue, indexedEntry2.value());
                if (booleanValue2 == BooleanConstant.FALSE) continue;
                int n6 = n3 / n * n2 + indexedEntry2.index() % n2;
                if (booleanValue2 == BooleanConstant.TRUE) {
                    sparseSequence.put(n6, BooleanConstant.TRUE);
                    continue;
                }
                BooleanValue booleanValue3 = sparseSequence.get(n6);
                if (booleanValue3 == BooleanConstant.TRUE) continue;
                if (booleanValue3 == null) {
                    booleanValue3 = BooleanAccumulator.treeGate(Operator.OR);
                    sparseSequence.put(n6, booleanValue3);
                }
                ((BooleanAccumulator)booleanValue3).add(booleanValue2);
            }
        }
        for (IndexedEntry<BooleanValue> indexedEntry : booleanMatrix2.cells) {
            if (indexedEntry.value() == BooleanConstant.TRUE) continue;
            booleanMatrix2.cells.put(indexedEntry.index(), this.factory.accumulate((BooleanAccumulator)indexedEntry.value()));
        }
        return booleanMatrix2;
    }

    public final BooleanValue subset(BooleanMatrix booleanMatrix) {
        BooleanMatrix.checkFactory(this.factory, booleanMatrix.factory);
        BooleanMatrix.checkDimensions(this.dims, booleanMatrix.dims);
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            if (booleanAccumulator.add(this.factory.or(indexedEntry.value().negation(), booleanMatrix.fastGet(indexedEntry.index()))) != BooleanConstant.FALSE) continue;
            return BooleanConstant.FALSE;
        }
        return this.factory.accumulate(booleanAccumulator);
    }

    public final BooleanValue eq(BooleanMatrix booleanMatrix) {
        return this.factory.and(this.subset(booleanMatrix), booleanMatrix.subset(this));
    }

    public final BooleanMatrix difference(BooleanMatrix booleanMatrix) {
        BooleanMatrix.checkFactory(this.factory, booleanMatrix.factory);
        BooleanMatrix.checkDimensions(this.dims, booleanMatrix.dims);
        BooleanMatrix booleanMatrix2 = new BooleanMatrix(this.dims, this.factory, this.cells, booleanMatrix.cells);
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            booleanMatrix2.fastSet(indexedEntry.index(), this.factory.and(indexedEntry.value(), booleanMatrix.fastGet(indexedEntry.index()).negation()));
        }
        return booleanMatrix2;
    }

    public final BooleanMatrix closure() {
        if (this.dims.numDimensions() != 2 || !this.dims.isSquare()) {
            throw new UnsupportedOperationException("#this.diensions != 2 || !this.dimensions.square()");
        }
        if (this.cells.isEmpty()) {
            return this.clone();
        }
        BooleanMatrix booleanMatrix = this;
        int n = 0;
        int n2 = this.dims.dimension(1);
        IndexedEntry<BooleanValue> indexedEntry = this.cells.first();
        while (indexedEntry != null) {
            ++n;
            indexedEntry = this.cells.ceil((indexedEntry.index() / n2 + 1) * n2);
        }
        for (int i = 1; i < n; i *= 2) {
            booleanMatrix = booleanMatrix.or(booleanMatrix.dot(booleanMatrix));
        }
        return booleanMatrix == this ? this.clone() : booleanMatrix;
    }

    public final BooleanMatrix transpose() {
        BooleanMatrix booleanMatrix = new BooleanMatrix(this.dims.transpose(), this.factory, this.cells, this.cells);
        int n = this.dims.dimension(0);
        int n2 = this.dims.dimension(1);
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            booleanMatrix.cells.put(indexedEntry.index() % n2 * n + indexedEntry.index() / n2, indexedEntry.value());
        }
        return booleanMatrix;
    }

    public final BooleanMatrix choice(BooleanValue booleanValue, BooleanMatrix booleanMatrix) {
        BooleanMatrix.checkFactory(this.factory, booleanMatrix.factory);
        BooleanMatrix.checkDimensions(this.dims, booleanMatrix.dims);
        if (booleanValue == BooleanConstant.TRUE) {
            return this.clone();
        }
        if (booleanValue == BooleanConstant.FALSE) {
            return booleanMatrix.clone();
        }
        BooleanMatrix booleanMatrix2 = new BooleanMatrix(this.dims, this.factory);
        SparseSequence<BooleanValue> sparseSequence = booleanMatrix.cells;
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            BooleanValue booleanValue2 = sparseSequence.get(indexedEntry.index());
            if (booleanValue2 == null) {
                booleanMatrix2.fastSet(indexedEntry.index(), this.factory.and(booleanValue, indexedEntry.value()));
                continue;
            }
            booleanMatrix2.fastSet(indexedEntry.index(), this.factory.ite(booleanValue, indexedEntry.value(), booleanValue2));
        }
        for (IndexedEntry<BooleanValue> indexedEntry : booleanMatrix.cells) {
            if (this.cells.containsIndex(indexedEntry.index())) continue;
            booleanMatrix2.fastSet(indexedEntry.index(), this.factory.and(booleanValue.negation(), indexedEntry.value()));
        }
        return booleanMatrix2;
    }

    public final BooleanMatrix project(Int[] intArray) {
        int n;
        if (!this.dims.isSquare()) {
            throw new IllegalArgumentException("!this.dimensions.isSquare()");
        }
        int n2 = intArray.length;
        if (n2 < 1) {
            throw new IllegalArgumentException("columns.length < 1");
        }
        Dimensions dimensions = Dimensions.square(this.dims.dimension(0), n2);
        BooleanMatrix booleanMatrix = new BooleanMatrix(dimensions, this.factory, this.cells, this.cells);
        int n3 = this.dims.numDimensions();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int n4 = 1;
        for (n = 0; n < n2; ++n) {
            if (intArray[n].isConstant()) {
                int n5 = intArray[n].value();
                if (n5 < 0 || n5 >= n3) {
                    return booleanMatrix;
                }
                nArray2[n] = -n5;
                continue;
            }
            n4 *= n3;
        }
        block1: for (n = 0; n < n4; ++n) {
            int n6;
            BooleanValue booleanValue = BooleanConstant.TRUE;
            for (n6 = 0; n6 < n2; ++n6) {
                if (nArray2[n6] >= 0 && (booleanValue = this.factory.and(booleanValue, intArray[n6].eq(this.factory.integer(nArray2[n6])))) == BooleanConstant.FALSE) continue block1;
            }
            for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
                int n7;
                this.dims.convert(indexedEntry.index(), nArray);
                for (n7 = 0; n7 < n2; ++n7) {
                    nArray3[n7] = nArray[StrictMath.abs(nArray2[n7])];
                }
                n7 = dimensions.convert(nArray3);
                booleanMatrix.fastSet(n7, this.factory.or(this.factory.and(indexedEntry.value(), booleanValue), booleanMatrix.fastGet(n7)));
            }
            for (n6 = n2 - 1; n6 >= 0; --n6) {
                if (nArray2[n6] < 0) continue;
                if (nArray2[n6] + 1 == n3) {
                    nArray2[n6] = 0;
                    continue;
                }
                int n5 = n6;
                nArray2[n5] = nArray2[n5] + 1;
                continue block1;
            }
        }
        return booleanMatrix;
    }

    private final BooleanValue nand(int n, int n2) {
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
        Iterator<IndexedEntry<BooleanValue>> iterator = this.cells.iterator(n, n2 - 1);
        while (iterator.hasNext()) {
            if (booleanAccumulator.add(iterator.next().value().negation()) != BooleanConstant.FALSE) continue;
            return BooleanConstant.FALSE;
        }
        return this.factory.accumulate(booleanAccumulator);
    }

    public final BooleanMatrix override(BooleanMatrix booleanMatrix) {
        BooleanMatrix.checkFactory(this.factory, booleanMatrix.factory);
        BooleanMatrix.checkDimensions(this.dims, booleanMatrix.dims);
        if (booleanMatrix.cells.isEmpty()) {
            return this.clone();
        }
        BooleanMatrix booleanMatrix2 = new BooleanMatrix(this.dims, this.factory, this.cells, booleanMatrix.cells);
        booleanMatrix2.cells.putAll(booleanMatrix.cells);
        int n = this.dims.capacity() / this.dims.dimension(0);
        int n2 = -1;
        BooleanValue booleanValue = BooleanConstant.TRUE;
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            int n3 = indexedEntry.index() / n;
            if (n2 != n3) {
                n2 = n3;
                booleanValue = booleanMatrix.nand(n2 * n, (n2 + 1) * n);
            }
            booleanMatrix2.fastSet(indexedEntry.index(), this.factory.or(booleanMatrix2.fastGet(indexedEntry.index()), this.factory.and(indexedEntry.value(), booleanValue)));
        }
        return booleanMatrix2;
    }

    public final BooleanMatrix override(BooleanMatrix ... booleanMatrixArray) {
        if (booleanMatrixArray.length == 0) {
            return this.clone();
        }
        BooleanMatrix[] booleanMatrixArray2 = Containers.copy(booleanMatrixArray, 0, new BooleanMatrix[booleanMatrixArray.length + 1], 1, booleanMatrixArray.length);
        booleanMatrixArray2[0] = this;
        for (int i = booleanMatrixArray2.length; i > 1; i -= i / 2) {
            int n = i - 1;
            for (int j = 0; j < n; j += 2) {
                booleanMatrixArray2[j / 2] = booleanMatrixArray2[j].override(booleanMatrixArray2[j + 1]);
            }
            if (n % 2 != 0) continue;
            booleanMatrixArray2[n / 2] = booleanMatrixArray2[n];
        }
        return booleanMatrixArray2[0];
    }

    public final Int cardinality() {
        return this.factory.sum(this.cells.values());
    }

    public final BooleanValue some() {
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.OR);
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            if (booleanAccumulator.add(indexedEntry.value()) != BooleanConstant.TRUE) continue;
            return BooleanConstant.TRUE;
        }
        return this.factory.accumulate(booleanAccumulator);
    }

    public final BooleanValue lone() {
        if (this.cells.isEmpty()) {
            return BooleanConstant.TRUE;
        }
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
        BooleanValue booleanValue = BooleanConstant.FALSE;
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            if (booleanAccumulator.add(this.factory.or(indexedEntry.value().negation(), ((BooleanValue)booleanValue).negation())) == BooleanConstant.FALSE) {
                return BooleanConstant.FALSE;
            }
            booleanValue = this.factory.or(booleanValue, indexedEntry.value());
        }
        return this.factory.accumulate(booleanAccumulator);
    }

    public final BooleanValue one() {
        if (this.cells.isEmpty()) {
            return BooleanConstant.FALSE;
        }
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
        BooleanValue booleanValue = BooleanConstant.FALSE;
        for (IndexedEntry<BooleanValue> indexedEntry : this.cells) {
            if (booleanAccumulator.add(this.factory.or(indexedEntry.value().negation(), ((BooleanValue)booleanValue).negation())) == BooleanConstant.FALSE) {
                return BooleanConstant.FALSE;
            }
            booleanValue = this.factory.or(booleanValue, indexedEntry.value());
        }
        booleanAccumulator.add(booleanValue);
        return this.factory.accumulate(booleanAccumulator);
    }

    public final BooleanValue none() {
        return this.some().negation();
    }

    public final void set(int n, BooleanValue booleanValue) {
        if (!this.dims.validate(n)) {
            throw new IndexOutOfBoundsException("index < 0 || index >= this.dimensions.capacity");
        }
        if (booleanValue == null) {
            throw new NullPointerException("formula=null");
        }
        if (booleanValue == BooleanConstant.FALSE) {
            this.cells.remove(n);
        } else {
            this.cells.put(n, booleanValue);
        }
    }

    public BooleanMatrix clone() {
        try {
            return new BooleanMatrix(this.dims, this.factory, this.cells.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("dimensions: ");
        stringBuilder.append(this.dims);
        stringBuilder.append(", elements: ");
        stringBuilder.append(this.cells);
        return stringBuilder.toString();
    }
}

