/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.Operator;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.SparseSequence;
import kodkod.util.ints.TreeSequence;

public final class BooleanAccumulator
extends BooleanValue
implements Iterable<BooleanValue> {
    final Operator.Nary op;
    private final SparseSequence<BooleanValue> inputs;

    private BooleanAccumulator(Operator.Nary nary) {
        this.op = nary;
        this.inputs = new TreeSequence<BooleanValue>();
    }

    public static BooleanAccumulator treeGate(Operator.Nary nary) {
        if (nary == null) {
            throw new NullPointerException();
        }
        return new BooleanAccumulator(nary);
    }

    public static BooleanAccumulator treeGate(Operator.Nary nary, BooleanValue ... booleanValueArray) {
        if (nary == null) {
            throw new NullPointerException();
        }
        BooleanAccumulator booleanAccumulator = new BooleanAccumulator(nary);
        for (BooleanValue booleanValue : booleanValueArray) {
            if (booleanAccumulator.add(booleanValue) != booleanAccumulator) break;
        }
        return booleanAccumulator;
    }

    @Override
    public Operator.Nary op() {
        return this.op;
    }

    public BooleanValue add(BooleanValue booleanValue) {
        if (this.isShortCircuited()) {
            return this.op.shortCircuit();
        }
        int n = booleanValue.label();
        if (booleanValue == this.op.shortCircuit() || this.inputs.containsIndex(-n)) {
            this.inputs.clear();
            this.inputs.put(this.op.shortCircuit().label, this.op.shortCircuit());
            return this.op.shortCircuit();
        }
        if (booleanValue != this.op.identity() && !this.inputs.containsIndex(n)) {
            this.inputs.put(n, booleanValue);
        }
        return this;
    }

    public boolean isShortCircuited() {
        return this.inputs.size() == 1 && this.inputs.first().value() == this.op.shortCircuit();
    }

    int digest(Operator operator) {
        if (this.op != operator) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        Iterator<BooleanValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            n += ((BooleanFormula)iterator.next()).hash(operator);
        }
        return n;
    }

    public int size() {
        return this.inputs.size();
    }

    @Override
    public Iterator<BooleanValue> iterator() {
        return new Iterator<BooleanValue>(){
            final Iterator<IndexedEntry<BooleanValue>> iter;
            {
                this.iter = BooleanAccumulator.this.inputs.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public BooleanValue next() {
                return this.iter.next().value();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    BooleanValue negation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int label() {
        return 0;
    }

    public String toString() {
        return this.inputs.toString();
    }
}

