/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.BinaryFormula;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Decl;
import kodkod.ast.Formula;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryFormula;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.RelationPredicate;
import kodkod.ast.Variable;
import kodkod.ast.visitor.AbstractVoidVisitor;
import kodkod.engine.Proof;
import kodkod.engine.fol2sat.RecordFilter;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.fol2sat.TranslationRecord;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.instance.TupleSet;
import kodkod.util.collections.IdentityHashSet;
import kodkod.util.ints.TreeSequence;

final class TrivialProof
extends Proof {
    private Map<Formula, Node> coreRoots = null;
    private RecordFilter coreFilter = null;

    TrivialProof(TranslationLog translationLog) {
        super(translationLog);
    }

    @Override
    public final Iterator<TranslationRecord> core() {
        if (this.coreFilter == null) {
            this.coreFilter = new RecordFilter(){
                final Set<Node> coreNodes;
                {
                    this.coreNodes = NodePruner.relevantNodes(TrivialProof.this.log(), TrivialProof.this.coreRoots == null ? TrivialProof.this.log().roots() : TrivialProof.this.coreRoots.keySet());
                }

                @Override
                public boolean accept(Node node, Formula formula, int n, Map<Variable, TupleSet> map) {
                    return this.coreNodes.contains(formula);
                }
            };
        }
        return this.log().replay(this.coreFilter);
    }

    @Override
    public final Map<Formula, Node> highLevelCore() {
        if (this.coreRoots == null) {
            Iterator<TranslationRecord> iterator = this.core();
            Set<Formula> set = this.log().roots();
            this.coreRoots = new LinkedHashMap<Formula, Node>();
            while (iterator.hasNext()) {
                TranslationRecord translationRecord = iterator.next();
                if (!set.contains(translationRecord.translated())) continue;
                this.coreRoots.put(translationRecord.translated(), translationRecord.node());
            }
            this.coreRoots = Collections.unmodifiableMap(this.coreRoots);
        }
        return this.coreRoots;
    }

    @Override
    public void minimize(ReductionStrategy reductionStrategy) {
        Object object;
        Object object2;
        LinkedHashMap<Formula, Object> linkedHashMap = new LinkedHashMap<Formula, Object>();
        LinkedHashMap<Formula, Node> linkedHashMap2 = new LinkedHashMap<Formula, Node>();
        Set<Formula> set = this.log().roots();
        Object object3 = this.core();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (!set.contains(((TranslationRecord)object2).translated())) continue;
            object = (int[])linkedHashMap.get(((TranslationRecord)object2).translated());
            if (object == null) {
                object = new int[1];
                linkedHashMap.put(((TranslationRecord)object2).translated(), object);
            }
            object[0] = ((TranslationRecord)object2).literal();
            linkedHashMap2.put(((TranslationRecord)object2).translated(), ((TranslationRecord)object2).node());
        }
        object3 = new TreeSequence();
        object2 = linkedHashMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            int n = ((int[])object.getValue())[0];
            if (n == -2147483647) {
                this.coreRoots = Collections.singletonMap(object.getKey(), linkedHashMap2.get(object.getKey()));
                break;
            }
            if (object3.containsIndex(-n)) {
                Formula formula = (Formula)object3.get(-n);
                Formula formula2 = (Formula)object.getKey();
                this.coreRoots = new LinkedHashMap<Formula, Node>(3);
                this.coreRoots.put(formula, (Node)linkedHashMap2.get(formula));
                this.coreRoots.put(formula2, (Node)linkedHashMap2.get(formula2));
                this.coreRoots = Collections.unmodifiableMap(this.coreRoots);
                break;
            }
            object3.put(n, object.getKey());
        }
        this.coreFilter = null;
        assert (this.coreRoots.size() == 1 && ((int[])linkedHashMap.get(this.coreRoots.keySet().iterator().next()))[0] == -2147483647 || this.coreRoots.size() == 2);
    }

    private static final class NodePruner
    extends AbstractVoidVisitor {
        private final Set<Node> visited = new IdentityHashSet<Node>();
        private final Set<Node> relevant = new IdentityHashSet<Node>();
        private final Map<Formula, Boolean> constNodes;

        NodePruner(TranslationLog translationLog) {
            RecordFilter recordFilter = new RecordFilter(){

                @Override
                public boolean accept(Node node, Formula formula, int n, Map<Variable, TupleSet> map) {
                    return map.isEmpty();
                }
            };
            this.constNodes = new LinkedHashMap<Formula, Boolean>();
            Iterator<TranslationRecord> iterator = translationLog.replay(recordFilter);
            while (iterator.hasNext()) {
                TranslationRecord translationRecord = iterator.next();
                int n = translationRecord.literal();
                if (Math.abs(n) != Integer.MAX_VALUE) {
                    this.constNodes.remove(translationRecord.translated());
                    continue;
                }
                if (n == Integer.MAX_VALUE) {
                    this.constNodes.put(translationRecord.translated(), Boolean.TRUE);
                    continue;
                }
                this.constNodes.put(translationRecord.translated(), Boolean.FALSE);
            }
        }

        static Set<Node> relevantNodes(TranslationLog translationLog, Set<Formula> set) {
            NodePruner nodePruner = new NodePruner(translationLog);
            for (Formula formula : set) {
                if (nodePruner.isTrue(formula)) continue;
                formula.accept(nodePruner);
            }
            return nodePruner.relevant;
        }

        @Override
        protected boolean visited(Node node) {
            return !this.visited.add(node);
        }

        final boolean isTrue(Node node) {
            return this.constNodes.get(node) == Boolean.TRUE;
        }

        @Override
        public void visit(Decl decl) {
            if (this.visited(decl)) {
                return;
            }
            this.relevant.add(decl);
        }

        @Override
        public void visit(QuantifiedFormula quantifiedFormula) {
            if (this.visited(quantifiedFormula)) {
                return;
            }
            this.relevant.add(quantifiedFormula);
        }

        @Override
        public void visit(ComparisonFormula comparisonFormula) {
            if (this.visited(comparisonFormula)) {
                return;
            }
            this.relevant.add(comparisonFormula);
        }

        @Override
        public void visit(MultiplicityFormula multiplicityFormula) {
            if (this.visited(multiplicityFormula)) {
                return;
            }
            this.relevant.add(multiplicityFormula);
        }

        @Override
        public void visit(RelationPredicate relationPredicate) {
            if (this.visited(relationPredicate)) {
                return;
            }
            this.relevant.add(relationPredicate);
        }

        @Override
        public void visit(IntComparisonFormula intComparisonFormula) {
            if (this.visited(intComparisonFormula)) {
                return;
            }
            this.relevant.add(intComparisonFormula);
        }

        @Override
        public void visit(ConstantFormula constantFormula) {
            this.relevant.add(constantFormula);
        }

        @Override
        public void visit(NotFormula notFormula) {
            if (this.visited(notFormula)) {
                return;
            }
            this.relevant.add(notFormula);
            notFormula.formula().accept(this);
        }

        @Override
        public void visit(BinaryFormula binaryFormula) {
            boolean bl;
            boolean bl2;
            if (this.visited(binaryFormula)) {
                return;
            }
            this.relevant.add(binaryFormula);
            Formula formula = binaryFormula.left();
            Formula formula2 = binaryFormula.right();
            Boolean bl3 = this.constNodes.get(formula);
            Boolean bl4 = this.constNodes.get(formula2);
            switch (binaryFormula.op()) {
                case AND: {
                    bl2 = bl3 == Boolean.FALSE || bl3 == null && bl4 != Boolean.FALSE;
                    bl = bl4 != Boolean.TRUE && bl3 != Boolean.FALSE;
                    break;
                }
                case OR: {
                    bl2 = bl3 == Boolean.TRUE || bl3 == null && bl4 != Boolean.TRUE;
                    bl = bl4 != Boolean.FALSE && bl3 != Boolean.TRUE;
                    break;
                }
                case IMPLIES: {
                    bl2 = bl3 == Boolean.FALSE || bl3 == null && bl4 != Boolean.TRUE;
                    bl = bl4 != Boolean.FALSE && bl3 != Boolean.FALSE;
                    break;
                }
                case IFF: {
                    bl = true;
                    bl2 = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)binaryFormula.op()));
                }
            }
            if (bl2) {
                formula.accept(this);
            }
            if (bl) {
                formula2.accept(this);
            }
        }

        @Override
        public void visit(NaryFormula naryFormula) {
            Boolean bl;
            if (this.visited(naryFormula)) {
                return;
            }
            this.relevant.add(naryFormula);
            Boolean bl2 = this.constNodes.get(naryFormula);
            switch (naryFormula.op()) {
                case AND: {
                    bl = Boolean.FALSE;
                    break;
                }
                case OR: {
                    bl = Boolean.TRUE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown nary operator: " + (Object)((Object)naryFormula.op()));
                }
            }
            Boolean bl3 = bl == false;
            if (bl2 != bl3) {
                for (Formula formula : naryFormula) {
                    if (this.constNodes.get(formula) != bl) continue;
                    formula.accept(this);
                    return;
                }
                for (Formula formula : naryFormula) {
                    if (this.constNodes.get(formula) == bl3) continue;
                    formula.accept(this);
                }
                return;
            }
            for (Formula formula : naryFormula) {
                formula.accept(this);
            }
        }
    }
}

