/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast.visitor;

import kodkod.ast.BinaryExpression;
import kodkod.ast.BinaryFormula;
import kodkod.ast.BinaryIntExpression;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.Comprehension;
import kodkod.ast.ConstantExpression;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.ExprToIntCast;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IfExpression;
import kodkod.ast.IfIntExpression;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.IntConstant;
import kodkod.ast.IntExpression;
import kodkod.ast.IntToExprCast;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryExpression;
import kodkod.ast.NaryFormula;
import kodkod.ast.NaryIntExpression;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.ProjectExpression;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.ast.SumExpression;
import kodkod.ast.UnaryExpression;
import kodkod.ast.UnaryIntExpression;
import kodkod.ast.Variable;
import kodkod.ast.visitor.VoidVisitor;

public abstract class AbstractVoidVisitor
implements VoidVisitor {
    protected AbstractVoidVisitor() {
    }

    protected abstract boolean visited(Node var1);

    @Override
    public void visit(Decls decls) {
        if (this.visited(decls)) {
            return;
        }
        for (Decl decl : decls) {
            decl.accept(this);
        }
    }

    @Override
    public void visit(Decl decl) {
        if (this.visited(decl)) {
            return;
        }
        decl.variable().accept(this);
        decl.expression().accept(this);
    }

    @Override
    public void visit(Relation relation) {
    }

    @Override
    public void visit(Variable variable) {
    }

    @Override
    public void visit(ConstantExpression constantExpression) {
    }

    @Override
    public void visit(NaryExpression naryExpression) {
        if (this.visited(naryExpression)) {
            return;
        }
        for (Expression expression : naryExpression) {
            expression.accept(this);
        }
    }

    @Override
    public void visit(BinaryExpression binaryExpression) {
        if (this.visited(binaryExpression)) {
            return;
        }
        binaryExpression.left().accept(this);
        binaryExpression.right().accept(this);
    }

    @Override
    public void visit(UnaryExpression unaryExpression) {
        if (this.visited(unaryExpression)) {
            return;
        }
        unaryExpression.expression().accept(this);
    }

    @Override
    public void visit(Comprehension comprehension) {
        if (this.visited(comprehension)) {
            return;
        }
        comprehension.decls().accept(this);
        comprehension.formula().accept(this);
    }

    @Override
    public void visit(IfExpression ifExpression) {
        if (this.visited(ifExpression)) {
            return;
        }
        ifExpression.condition().accept(this);
        ifExpression.thenExpr().accept(this);
        ifExpression.elseExpr().accept(this);
    }

    @Override
    public void visit(ProjectExpression projectExpression) {
        if (this.visited(projectExpression)) {
            return;
        }
        projectExpression.expression().accept(this);
        int n = projectExpression.arity();
        for (int i = 0; i < n; ++i) {
            projectExpression.column(i).accept(this);
        }
    }

    @Override
    public void visit(IntToExprCast intToExprCast) {
        if (this.visited(intToExprCast)) {
            return;
        }
        intToExprCast.intExpr().accept(this);
    }

    @Override
    public void visit(IntConstant intConstant) {
    }

    @Override
    public void visit(IfIntExpression ifIntExpression) {
        if (this.visited(ifIntExpression)) {
            return;
        }
        ifIntExpression.condition().accept(this);
        ifIntExpression.thenExpr().accept(this);
        ifIntExpression.elseExpr().accept(this);
    }

    @Override
    public void visit(ExprToIntCast exprToIntCast) {
        if (this.visited(exprToIntCast)) {
            return;
        }
        exprToIntCast.expression().accept(this);
    }

    @Override
    public void visit(NaryIntExpression naryIntExpression) {
        if (this.visited(naryIntExpression)) {
            return;
        }
        for (IntExpression intExpression : naryIntExpression) {
            intExpression.accept(this);
        }
    }

    @Override
    public void visit(BinaryIntExpression binaryIntExpression) {
        if (this.visited(binaryIntExpression)) {
            return;
        }
        binaryIntExpression.left().accept(this);
        binaryIntExpression.right().accept(this);
    }

    @Override
    public void visit(UnaryIntExpression unaryIntExpression) {
        if (this.visited(unaryIntExpression)) {
            return;
        }
        unaryIntExpression.intExpr().accept(this);
    }

    @Override
    public void visit(SumExpression sumExpression) {
        if (this.visited(sumExpression)) {
            return;
        }
        sumExpression.decls().accept(this);
        sumExpression.intExpr().accept(this);
    }

    @Override
    public void visit(IntComparisonFormula intComparisonFormula) {
        if (this.visited(intComparisonFormula)) {
            return;
        }
        intComparisonFormula.left().accept(this);
        intComparisonFormula.right().accept(this);
    }

    @Override
    public void visit(QuantifiedFormula quantifiedFormula) {
        if (this.visited(quantifiedFormula)) {
            return;
        }
        quantifiedFormula.decls().accept(this);
        quantifiedFormula.formula().accept(this);
    }

    @Override
    public void visit(NaryFormula naryFormula) {
        if (this.visited(naryFormula)) {
            return;
        }
        for (Formula formula : naryFormula) {
            formula.accept(this);
        }
    }

    @Override
    public void visit(BinaryFormula binaryFormula) {
        if (this.visited(binaryFormula)) {
            return;
        }
        binaryFormula.left().accept(this);
        binaryFormula.right().accept(this);
    }

    @Override
    public void visit(NotFormula notFormula) {
        if (this.visited(notFormula)) {
            return;
        }
        notFormula.formula().accept(this);
    }

    @Override
    public void visit(ConstantFormula constantFormula) {
    }

    @Override
    public void visit(ComparisonFormula comparisonFormula) {
        if (this.visited(comparisonFormula)) {
            return;
        }
        comparisonFormula.left().accept(this);
        comparisonFormula.right().accept(this);
    }

    @Override
    public void visit(MultiplicityFormula multiplicityFormula) {
        if (this.visited(multiplicityFormula)) {
            return;
        }
        multiplicityFormula.expression().accept(this);
    }

    @Override
    public void visit(RelationPredicate relationPredicate) {
        if (this.visited(relationPredicate)) {
            return;
        }
        relationPredicate.relation().accept(this);
        if (relationPredicate.name() == RelationPredicate.Name.FUNCTION) {
            RelationPredicate.Function function = (RelationPredicate.Function)relationPredicate;
            function.domain().accept(this);
            function.range().accept(this);
        } else if (relationPredicate.name() == RelationPredicate.Name.TOTAL_ORDERING) {
            RelationPredicate.TotalOrdering totalOrdering = (RelationPredicate.TotalOrdering)relationPredicate;
            totalOrdering.ordered().accept(this);
            totalOrdering.first().accept(this);
            totalOrdering.last().accept(this);
        }
    }
}

