/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobHoldUntil;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PresentationDirection;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.gui.NumericTextField;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.print.BufferPrinter1_7;
import org.gjt.sp.jedit.print.Margins;
import org.gjt.sp.jedit.print.PrintPreview;
import org.gjt.sp.jedit.print.PrintRangeType;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.jedit.print.Reverse;
import org.gjt.sp.util.GenericGUIUtilities;

public class PrinterDialog
extends JDialog
implements ListSelectionListener {
    private View view;
    private String jobName;
    private PrintService selectedPrintService;
    private PrintRequestAttributeSet attributes;
    private JTabbedPane tabs;
    private JList<PrintService> printers;
    private JSpinner copies;
    private JComboBox<String> paperSize;
    private List<Media> paperSizes;
    private JComboBox<Priority> priority;
    private JComboBox<Finishings> finishing;
    private JComboBox<Sides> sides;
    private JComboBox<NumberUp> pagesPerSide;
    private JComboBox<PresentationDirection> pageOrdering;
    private JComboBox<MediaTray> paperSource;
    private JComboBox<OrientationRequested> orientation;
    private boolean pageSetupOnly;
    private boolean canceled = false;
    private Map<String, String> messageMap;
    private PageSetupPanel pageSetupPanel;
    public static int onlyPrintPages = PrintRangeType.ALL.getValue();
    private DocFlavor DOC_FLAVOR = DocFlavor.SERVICE_FORMATTED.PRINTABLE;

    public PrinterDialog(View owner, PrintRequestAttributeSet attributes, boolean pageSetupOnly) {
        super((Window)owner, Dialog.ModalityType.APPLICATION_MODAL);
        try {
            this.view = owner;
            this.pageSetupOnly = pageSetupOnly;
            this.setTitle(pageSetupOnly ? jEdit.getProperty("print.dialog.pageSetupTitle") : jEdit.getProperty("print.dialog.title"));
            this.attributes = attributes != null ? new HashPrintRequestAttributeSet(attributes) : new HashPrintRequestAttributeSet();
            Attribute jobNameAttr = this.attributes.get(JobName.class);
            if (jobNameAttr != null) {
                this.jobName = jobNameAttr.toString();
            }
            this.attributes.remove(Destination.class);
            this.initMessages();
            JPanel contents = new JPanel(new BorderLayout());
            contents.setBorder(BorderFactory.createEmptyBorder(11, 11, 12, 12));
            this.tabs = new JTabbedPane();
            this.tabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 11, 0));
            this.tabs.add(jEdit.getProperty("print.dialog.General", "General"), new GeneralPanel());
            this.pageSetupPanel = new PageSetupPanel();
            this.tabs.add(jEdit.getProperty("print.dialog.Page_Setup", "Page Setup"), this.pageSetupPanel);
            this.tabs.add(jEdit.getProperty("print.dialog.Job", "Job"), new JobPanel());
            this.tabs.add(jEdit.getProperty("print.dialog.Advanced", "Advanced"), new AdvancedPanel());
            this.tabs.add(jEdit.getProperty("print.dialog.jEdit", "jEdit"), new jEditPanel());
            if (pageSetupOnly) {
                this.tabs.setSelectedIndex(1);
                this.tabs.setEnabledAt(0, false);
                this.tabs.setEnabledAt(1, true);
                this.tabs.setEnabledAt(2, false);
                this.tabs.setEnabledAt(3, false);
                this.tabs.setEnabledAt(4, false);
            }
            contents.add((Component)this.tabs, "Center");
            JButton previewButton = new JButton(jEdit.getProperty("print.dialog.preview", "Preview"));
            previewButton.addActionListener(this.getPreviewButtonListener());
            JButton okButton = new JButton(jEdit.getProperty("common.ok"));
            okButton.addActionListener(this.getOkButtonListener());
            JButton cancelButton = new JButton(jEdit.getProperty("common.cancel"));
            cancelButton.addActionListener(this.getCancelButtonListener());
            JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 6));
            GenericGUIUtilities.makeSameSize(previewButton, okButton, cancelButton);
            buttonPanel.add(previewButton);
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            contents.add((Component)buttonPanel, "South");
            this.setContentPane(contents);
            PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
            if (defaultPrintService != null) {
                this.printers.setSelectedValue(defaultPrintService, true);
            } else {
                this.printers.setSelectedIndex(0);
            }
            this.valueChanged(null);
            this.pageSetupPanel.setDefaultMargins();
            this.pack();
            this.getRootPane().registerKeyboardAction(e -> {
                this.setVisible(false);
                this.dispose();
                this.canceled = true;
            }, KeyStroke.getKeyStroke(27, 0), 2);
            this.setLocationRelativeTo(jEdit.getActiveView().getTextArea());
            this.setVisible(true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private ActionListener getPreviewButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String checkMarginsMessage = PrinterDialog.this.pageSetupPanel.recalculate();
                if (checkMarginsMessage != null) {
                    JOptionPane.showMessageDialog(PrinterDialog.this, checkMarginsMessage, jEdit.getProperty("print-error.title"), 0);
                    return;
                }
                for (int i = 0; i < PrinterDialog.this.tabs.getTabCount(); ++i) {
                    PrinterPanel panel = (PrinterPanel)PrinterDialog.this.tabs.getComponentAt(i);
                    AttributeSet panelAttributes = panel.getAttributes();
                    if (panelAttributes == null) continue;
                    PrinterDialog.this.attributes.addAll(panelAttributes);
                }
                PageRanges pr = (PageRanges)PrinterDialog.this.attributes.get(PageRanges.class);
                try {
                    PageRanges mergedRanges = PrinterDialog.this.mergeRanges(pr);
                    if (mergedRanges != null) {
                        PrinterDialog.this.attributes.add(mergedRanges);
                    }
                }
                catch (PrintException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(PrinterDialog.this, jEdit.getProperty("print-error.message", new String[]{e.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                    return;
                }
                new PrintPreview(PrinterDialog.this.view, PrinterDialog.this.view.getBuffer(), PrinterDialog.this.getPrintService(), PrinterDialog.this.attributes);
            }
        };
    }

    private ActionListener getOkButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean isPDF;
                String checkMarginsMessage = PrinterDialog.this.pageSetupPanel.recalculate();
                if (checkMarginsMessage != null) {
                    JOptionPane.showMessageDialog(PrinterDialog.this, checkMarginsMessage, jEdit.getProperty("print-error.title"), 0);
                    return;
                }
                for (int i = 0; i < PrinterDialog.this.tabs.getTabCount(); ++i) {
                    PrinterPanel panel = (PrinterPanel)PrinterDialog.this.tabs.getComponentAt(i);
                    AttributeSet panelAttributes = panel.getAttributes();
                    if (panelAttributes == null) continue;
                    PrinterDialog.this.attributes.addAll(panelAttributes);
                }
                PageRanges pr = (PageRanges)PrinterDialog.this.attributes.get(PageRanges.class);
                try {
                    PageRanges mergedRanges = PrinterDialog.this.mergeRanges(pr);
                    if (mergedRanges != null) {
                        PrinterDialog.this.attributes.add(mergedRanges);
                    }
                }
                catch (PrintException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(PrinterDialog.this, jEdit.getProperty("print-error.message", new String[]{e.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                    return;
                }
                PrintService p = PrinterDialog.this.getPrintService();
                boolean bl = isPDF = p.toString().toLowerCase().indexOf("pdf") > 0;
                if (!PrinterDialog.this.pageSetupOnly && (p instanceof StreamPrintService || isPDF)) {
                    String filename = "out";
                    if (PrinterDialog.this.jobName != null) {
                        File f = new File(PrinterDialog.this.jobName);
                        filename = f.getName();
                    }
                    filename = filename + (isPDF ? ".pdf" : ".ps");
                    File initialFile = new File(System.getProperty("user.home"), filename);
                    String[] files = GUIUtilities.showVFSFileDialog(PrinterDialog.this, PrinterDialog.this.view, initialFile.getAbsolutePath(), 1, false);
                    if (files.length > 0) {
                        File file = new File(files[0]);
                        PrinterDialog.this.selectedPrintService = PrinterDialog.this.getPostscriptPrintService(file);
                    } else {
                        return;
                    }
                }
                PrinterDialog.this.setVisible(false);
                PrinterDialog.this.dispose();
            }
        };
    }

    private ActionListener getCancelButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PrinterDialog.this.setVisible(false);
                PrinterDialog.this.dispose();
                PrinterDialog.this.canceled = true;
            }
        };
    }

    public PrintService getPrintService() {
        return this.selectedPrintService;
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.attributes;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private PrintService[] getPrintServices() {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(this.DOC_FLAVOR, null);
        ArrayList<PrintService> services = new ArrayList<PrintService>(Arrays.asList(printServices));
        StreamPrintService service = this.getPostscriptPrintService(null);
        if (service != null) {
            services.add(service);
        }
        printServices = services.toArray(new PrintService[0]);
        return printServices;
    }

    private StreamPrintService getPostscriptPrintService(File outfile) {
        if (outfile == null) {
            outfile = new File(System.getProperty("user.home"), "out.ps");
        }
        String mimetype = "application/postscript";
        StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(this.DOC_FLAVOR, mimetype);
        StreamPrintService printService = null;
        if (factories.length > 0) {
            try {
                FileOutputStream fos = new FileOutputStream(outfile);
                printService = factories[0].getPrintService(fos);
            }
            catch (Exception e) {
                return null;
            }
        }
        return printService;
    }

    private PageRanges mergeRanges(PageRanges pr) throws PrintException {
        if (pr == null || onlyPrintPages == PrintRangeType.ALL.getValue()) {
            return pr;
        }
        ArrayList<Integer> pages = new ArrayList<Integer>();
        int[][] ranges = pr.getMembers();
        for (int i = 0; i < ranges.length; ++i) {
            int[] range = ranges[i];
            int start = range[0];
            int end = range.length == 1 ? range[0] : Math.min(range[0] + 500, range[1]);
            for (int pageIndex = start; pageIndex <= end; ++pageIndex) {
                if (pageIndex % 2 == 0 && onlyPrintPages == PrintRangeType.EVEN.getValue()) {
                    pages.add(pageIndex);
                    continue;
                }
                if (pageIndex % 2 != 1 || onlyPrintPages != PrintRangeType.ODD.getValue()) continue;
                pages.add(pageIndex);
            }
        }
        if (pages.isEmpty()) {
            throw new PrintException("No pages are selected to print.\nPlease check the 'Range' setting on the General tab and\nthe 'Only print' setting on the Page Setup tab.");
        }
        StringBuilder sb = new StringBuilder();
        for (Integer page : pages) {
            sb.append(page).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return new PageRanges(sb.toString());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Class<?>[] classes;
        this.selectedPrintService = this.printers.getSelectedValue();
        HashMap categoryValueMap = new HashMap();
        for (Class<?> clazz : classes = this.selectedPrintService.getSupportedAttributeCategories()) {
            Object values = this.selectedPrintService.getSupportedAttributeValues(clazz, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            categoryValueMap.put(clazz, values);
        }
        SpinnerNumberModel copiesModel = new SpinnerNumberModel(1, 1, 999, 1);
        Object value = categoryValueMap.get(Copies.class);
        if (value != null) {
            String maxCopies = value.toString();
            if (maxCopies.indexOf(45) > 0) {
                maxCopies = maxCopies.substring(maxCopies.indexOf(45) + 1);
            }
            copiesModel = new SpinnerNumberModel(1, 1, Integer.valueOf(maxCopies), 1);
        }
        this.copies.setModel(copiesModel);
        value = categoryValueMap.get(Media.class);
        HashSet<MediaSizeName> sizeNames = new HashSet<MediaSizeName>();
        for (Media m : (Media[])value) {
            if (!(m instanceof MediaSizeName)) continue;
            sizeNames.add((MediaSizeName)m);
        }
        MediaSizeName[] mediaSizeNameArray = sizeNames.toArray(new MediaSizeName[0]);
        Arrays.sort(mediaSizeNameArray, Comparator.comparing(EnumSyntax::toString));
        Media previousPaper = (Media)this.attributes.get(Media.class);
        MediaSizeName previousSize = null;
        if (previousPaper instanceof MediaSizeName) {
            previousSize = (MediaSizeName)previousPaper;
        }
        if (this.paperSize != null) {
            String[] paperNames = new String[mediaSizeNameArray.length];
            this.paperSizes = new ArrayList<Media>();
            int index = -1;
            int letterSizeIndex = 0;
            for (int i = 0; i < mediaSizeNameArray.length; ++i) {
                MediaSizeName mediaSizeName = mediaSizeNameArray[i];
                if (MediaSizeName.NA_LETTER.equals(mediaSizeName)) {
                    letterSizeIndex = i;
                } else if (mediaSizeName.equals(previousSize)) {
                    index = i;
                }
                this.paperSizes.add(mediaSizeName);
                paperNames[i] = this.getMessage(mediaSizeName.toString());
            }
            index = index == -1 ? letterSizeIndex : index;
            this.paperSize.setModel(new DefaultComboBoxModel<String>(paperNames));
            this.paperSize.setEnabled(true);
            this.paperSize.setSelectedIndex(index);
        }
        if (this.finishing != null) {
            value = categoryValueMap.get(Finishings.class);
            if (value == null) {
                this.finishing.setModel(new DefaultComboBoxModel());
                this.finishing.setEnabled(false);
            } else {
                Finishings[] finishings = (Finishings[])value;
                if (finishings.length == 0 || finishings.length == 1 && Finishings.NONE.equals(finishings[0])) {
                    this.finishing.setModel(new DefaultComboBoxModel());
                    this.finishing.setEnabled(false);
                } else {
                    this.finishing.setModel(new DefaultComboBoxModel<Finishings>(finishings));
                    this.finishing.setEnabled(true);
                }
            }
        }
        if (this.sides != null) {
            value = categoryValueMap.get(Sides.class);
            if (value == null) {
                this.sides.setEnabled(false);
            } else {
                this.sides.setModel(new DefaultComboBoxModel<Sides>((Sides[])value));
                Sides previousSides = (Sides)this.attributes.get(Sides.class);
                this.sides.setSelectedItem(previousSides == null ? Sides.ONE_SIDED : previousSides);
                this.sides.setEnabled(true);
            }
        }
        if (this.pagesPerSide != null) {
            value = categoryValueMap.get(NumberUp.class);
            if (value == null) {
                this.pagesPerSide.setEnabled(false);
            } else {
                NumberUp[] numberUp = (NumberUp[])value;
                Arrays.sort(numberUp, new Comparator<NumberUp>(){

                    @Override
                    public int compare(NumberUp a, NumberUp b) {
                        int n;
                        int m = a.getValue();
                        if (m < (n = b.getValue())) {
                            return -1;
                        }
                        if (m == n) {
                            return 0;
                        }
                        return 1;
                    }
                });
                this.pagesPerSide.setModel(new DefaultComboBoxModel<NumberUp>(numberUp));
                this.pagesPerSide.setEnabled(true);
            }
        }
        if (this.pageOrdering != null) {
            value = categoryValueMap.get(PresentationDirection.class);
            if (value == null) {
                this.pageOrdering.setEnabled(false);
            } else {
                PresentationDirection[] po = (PresentationDirection[])value;
                this.pageOrdering.setModel(new DefaultComboBoxModel<PresentationDirection>(po));
                this.pageOrdering.setEnabled(true);
            }
        }
        if (this.paperSource != null) {
            value = categoryValueMap.get(Media.class);
            if (value == null) {
                this.paperSource.setEnabled(false);
            } else {
                HashSet<MediaTray> trayNames = new HashSet<MediaTray>();
                for (Media media : (Media[])value) {
                    if (!(media instanceof MediaTray)) continue;
                    trayNames.add((MediaTray)media);
                }
                if (!trayNames.isEmpty()) {
                    MediaTray[] trays = trayNames.toArray(new MediaTray[0]);
                    this.paperSource.setModel(new DefaultComboBoxModel<MediaTray>(trays));
                    this.paperSource.setEnabled(true);
                    MediaTray lastUsedTray = (MediaTray)this.attributes.get(MediaTray.class);
                    this.paperSource.setSelectedItem(lastUsedTray == null ? trays[0] : lastUsedTray);
                } else {
                    this.paperSource.setEnabled(false);
                }
            }
        }
        if (this.orientation != null) {
            value = categoryValueMap.get(OrientationRequested.class);
            if (value == null) {
                this.orientation.setEnabled(false);
            } else {
                OrientationRequested[] or = (OrientationRequested[])value;
                this.orientation.setModel(new DefaultComboBoxModel<OrientationRequested>(or));
                this.orientation.setEnabled(true);
                OrientationRequested previousOrientation = (OrientationRequested)this.attributes.get(OrientationRequested.class);
                this.orientation.setSelectedItem(previousOrientation == null ? OrientationRequested.PORTRAIT : previousOrientation);
            }
        }
    }

    public void initMessages() {
        this.messageMap = new HashMap<String, String>();
        this.messageMap.put("Automatic-Feeder", jEdit.getProperty("print.dialog.Automatic-Feeder", "Automatic Feeder"));
        this.messageMap.put("Cassette", jEdit.getProperty("print.dialog.Cassette", "Cassette"));
        this.messageMap.put("Form-Source", jEdit.getProperty("print.dialog.Form-Source", "Form Source"));
        this.messageMap.put("Large-Format", jEdit.getProperty("print.dialog.Large-Format", "Large Format"));
        this.messageMap.put("Manual-Envelope", jEdit.getProperty("print.dialog.Manual-Envelope", "Manual Envelope"));
        this.messageMap.put("Small-Format", jEdit.getProperty("print.dialog.Small-Format", "Small Format"));
        this.messageMap.put("Tractor-Feeder", jEdit.getProperty("print.dialog.Tractor-Feeder", "Tractor Feeder"));
        this.messageMap.put("a", jEdit.getProperty("print.dialog.a", "Engineering A"));
        this.messageMap.put("accepting-jobs", jEdit.getProperty("print.dialog.accepting-jobs", "Accepting jobs"));
        this.messageMap.put("auto-select", jEdit.getProperty("print.dialog.auto-select", "Automatically Select"));
        this.messageMap.put("b", jEdit.getProperty("print.dialog.b", "Engineering B"));
        this.messageMap.put("c", jEdit.getProperty("print.dialog.c", "Engineering C"));
        this.messageMap.put("color", jEdit.getProperty("print.dialog.Color", "Color"));
        this.messageMap.put("d", jEdit.getProperty("print.dialog.d", "Engineering D"));
        this.messageMap.put("draft", jEdit.getProperty("print.dialog.Draft", "Draft"));
        this.messageMap.put("e", jEdit.getProperty("print.dialog.e", "Engineering E"));
        this.messageMap.put("envelope", jEdit.getProperty("print.dialog.envelope", "Envelope"));
        this.messageMap.put("executive", jEdit.getProperty("print.dialog.executive", "Executive"));
        this.messageMap.put("folio", jEdit.getProperty("print.dialog.folio", "Folio"));
        this.messageMap.put("high", jEdit.getProperty("print.dialog.High", "High"));
        this.messageMap.put("invite-envelope", jEdit.getProperty("print.dialog.invite-envelope", "Invitation Envelope"));
        this.messageMap.put("invoice", jEdit.getProperty("print.dialog.invoice", "Invoice"));
        this.messageMap.put("iso-2a0", jEdit.getProperty("print.dialog.iso-2a0", "2A0 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-4a0", jEdit.getProperty("print.dialog.iso-4a0", "4A0 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a0", jEdit.getProperty("print.dialog.iso-a0", "A0 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a1", jEdit.getProperty("print.dialog.iso-a1", "A1 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a2", jEdit.getProperty("print.dialog.iso-a2", "A2 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a3", jEdit.getProperty("print.dialog.iso-a3", "A3 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a4", jEdit.getProperty("print.dialog.iso-a4", "A4 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a5", jEdit.getProperty("print.dialog.iso-a5", "A5 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a6", jEdit.getProperty("print.dialog.iso-a6", "A6 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a7", jEdit.getProperty("print.dialog.iso-a7", "A7 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a8", jEdit.getProperty("print.dialog.iso-a8", "A8 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a9", jEdit.getProperty("print.dialog.iso-a9", "A9 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-a10", jEdit.getProperty("print.dialog.iso-a10", "A10 (ISO/DIN & JIS)"));
        this.messageMap.put("iso-b0", jEdit.getProperty("print.dialog.iso-b0", "B0 (ISO/DIN)"));
        this.messageMap.put("iso-b1", jEdit.getProperty("print.dialog.iso-b1", "B1 (ISO/DIN)"));
        this.messageMap.put("iso-b2", jEdit.getProperty("print.dialog.iso-b2", "B2 (ISO/DIN)"));
        this.messageMap.put("iso-b3", jEdit.getProperty("print.dialog.iso-b3", "B3 (ISO/DIN)"));
        this.messageMap.put("iso-b4", jEdit.getProperty("print.dialog.iso-b4", "B4 (ISO/DIN)"));
        this.messageMap.put("iso-b5", jEdit.getProperty("print.dialog.iso-b5", "B5 (ISO/DIN)"));
        this.messageMap.put("iso-b6", jEdit.getProperty("print.dialog.iso-b6", "B6 (ISO/DIN)"));
        this.messageMap.put("iso-b7", jEdit.getProperty("print.dialog.iso-b7", "B7 (ISO/DIN)"));
        this.messageMap.put("iso-b8", jEdit.getProperty("print.dialog.iso-b8", "B8 (ISO/DIN)"));
        this.messageMap.put("iso-b9", jEdit.getProperty("print.dialog.iso-b9", "B9 (ISO/DIN)"));
        this.messageMap.put("iso-b10", jEdit.getProperty("print.dialog.iso-b10", "B10 (ISO/DIN)"));
        this.messageMap.put("iso-c0", jEdit.getProperty("print.dialog.iso-c0", "C0 (ISO/DIN)"));
        this.messageMap.put("iso-c1", jEdit.getProperty("print.dialog.iso-c1", "C1 (ISO/DIN)"));
        this.messageMap.put("iso-c2", jEdit.getProperty("print.dialog.iso-c2", "C2 (ISO/DIN)"));
        this.messageMap.put("iso-c3", jEdit.getProperty("print.dialog.iso-c3", "C3 (ISO/DIN)"));
        this.messageMap.put("iso-c4", jEdit.getProperty("print.dialog.iso-c4", "C4 (ISO/DIN)"));
        this.messageMap.put("iso-c5", jEdit.getProperty("print.dialog.iso-c5", "C5 (ISO/DIN)"));
        this.messageMap.put("iso-c6", jEdit.getProperty("print.dialog.iso-c6", "C6 (ISO/DIN)"));
        this.messageMap.put("iso-c7", jEdit.getProperty("print.dialog.iso-c7", "C7 (ISO/DIN)"));
        this.messageMap.put("iso-c8", jEdit.getProperty("print.dialog.iso-c8", "C8 (ISO/DIN)"));
        this.messageMap.put("iso-c9", jEdit.getProperty("print.dialog.iso-c9", "C9 (ISO/DIN)"));
        this.messageMap.put("iso-c10", jEdit.getProperty("print.dialog.iso-c10", "C10 (ISO/DIN)"));
        this.messageMap.put("iso-designated-long", jEdit.getProperty("print.dialog.iso-designated-long", "ISO Designated Long"));
        this.messageMap.put("italian-envelope", jEdit.getProperty("print.dialog.italian-envelope", "Italy Envelope"));
        this.messageMap.put("italy-envelope", jEdit.getProperty("print.dialog.italy-envelope", "Italy Envelope"));
        this.messageMap.put("japanese-postcard", jEdit.getProperty("print.dialog.japanese-postcard", "Postcard (JIS)"));
        this.messageMap.put("jis-b0", jEdit.getProperty("print.dialog.jis-b0", "B0 (JIS)"));
        this.messageMap.put("jis-b1", jEdit.getProperty("print.dialog.jis-b1", "B1 (JIS)"));
        this.messageMap.put("jis-b2", jEdit.getProperty("print.dialog.jis-b2", "B2 (JIS)"));
        this.messageMap.put("jis-b3", jEdit.getProperty("print.dialog.jis-b3", "B3 (JIS)"));
        this.messageMap.put("jis-b4", jEdit.getProperty("print.dialog.jis-b4", "B4 (JIS)"));
        this.messageMap.put("jis-b5", jEdit.getProperty("print.dialog.jis-b5", "B5 (JIS)"));
        this.messageMap.put("jis-b6", jEdit.getProperty("print.dialog.jis-b6", "B6 (JIS)"));
        this.messageMap.put("jis-b7", jEdit.getProperty("print.dialog.jis-b7", "B7 (JIS)"));
        this.messageMap.put("jis-b8", jEdit.getProperty("print.dialog.jis-b8", "B8 (JIS)"));
        this.messageMap.put("jis-b9", jEdit.getProperty("print.dialog.jis-b9", "B9 (JIS)"));
        this.messageMap.put("jis-b10", jEdit.getProperty("print.dialog.jis-b10", "B10 (JIS)"));
        this.messageMap.put("landscape", jEdit.getProperty("print.dialog.landscape", "Landscape"));
        this.messageMap.put("main", jEdit.getProperty("print.dialog.main", "Main"));
        this.messageMap.put("manual", jEdit.getProperty("print.dialog.manual", "Manual"));
        this.messageMap.put("middle", jEdit.getProperty("print.dialog.middle", "Middle"));
        this.messageMap.put("monarch-envelope", jEdit.getProperty("print.dialog.monarch-envelope", "Monarch Envelope"));
        this.messageMap.put("monochrome", jEdit.getProperty("print.dialog.Monochrome", "Monochrome"));
        this.messageMap.put("na-5x7", jEdit.getProperty("print.dialog.na-5x7", "5\") x 7\" Paper"));
        this.messageMap.put("na-6x9-envelope", jEdit.getProperty("print.dialog.na-6x9-envelope", "6x9 Envelope"));
        this.messageMap.put("na-7x9-envelope", jEdit.getProperty("print.dialog.na-7x9-envelope", "6x7 Envelope"));
        this.messageMap.put("na-8x10", jEdit.getProperty("print.dialog.na-8x10", "8\") x 10\" Paper"));
        this.messageMap.put("na-9x11-envelope", jEdit.getProperty("print.dialog.na-9x11-envelope", "9x11 Envelope"));
        this.messageMap.put("na-9x12-envelope", jEdit.getProperty("print.dialog.na-9x12-envelope", "9x12 Envelope"));
        this.messageMap.put("na-10x13-envelope", jEdit.getProperty("print.dialog.na-10x13-envelope", "10x15 Envelope"));
        this.messageMap.put("na-10x14-envelope", jEdit.getProperty("print.dialog.na-10x14-envelope", "10x15 Envelope"));
        this.messageMap.put("na-10x15-envelope", jEdit.getProperty("print.dialog.na-10x15-envelope", "10x15 Envelope"));
        this.messageMap.put("na-legal", jEdit.getProperty("print.dialog.na-legal", "Legal"));
        this.messageMap.put("na-letter", jEdit.getProperty("print.dialog.na-letter", "Letter"));
        this.messageMap.put("na-number-9-envelope", jEdit.getProperty("print.dialog.na-number-9-envelope", "No. 9 Envelope"));
        this.messageMap.put("na-number-10-envelope", jEdit.getProperty("print.dialog.na-number-10-envelope", "No. 10 Envelope"));
        this.messageMap.put("na-number-11-envelope", jEdit.getProperty("print.dialog.na-number-11-envelope", "No. 11 Envelope"));
        this.messageMap.put("na-number-12-envelope", jEdit.getProperty("print.dialog.na-number-12-envelope", "No. 12 Envelope"));
        this.messageMap.put("na-number-14-envelope", jEdit.getProperty("print.dialog.na-number-14-envelope", "No. 14 Envelope"));
        this.messageMap.put("normal", jEdit.getProperty("print.dialog.Normal", "Normal"));
        this.messageMap.put("not-accepting-jobs", jEdit.getProperty("print.dialog.not-accepting-jobs", "Not accepting jobs"));
        this.messageMap.put("one-sided", jEdit.getProperty("print.dialog.one-sided", "One sided"));
        this.messageMap.put("oufuko-postcard", jEdit.getProperty("print.dialog.oufuko-postcard", "Double Postcard (JIS)"));
        this.messageMap.put("personal-envelope", jEdit.getProperty("print.dialog.personal-envelope", "Personal Envelope"));
        this.messageMap.put("portrait", jEdit.getProperty("print.dialog.portrait", "Portrait"));
        this.messageMap.put("quarto", jEdit.getProperty("print.dialog.quarto", "Quarto"));
        this.messageMap.put("reverse-landscape", jEdit.getProperty("print.dialog.reverse-landscape", "Reverse Landscape"));
        this.messageMap.put("reverse-portrait", jEdit.getProperty("print.dialog.reverse-portrait", "Reverse Portrait"));
        this.messageMap.put("side", jEdit.getProperty("print.dialog.side", "Side"));
        this.messageMap.put("tabloid", jEdit.getProperty("print.dialog.tabloid", "Tabloid"));
        this.messageMap.put("top", jEdit.getProperty("print.dialog.top", "Top"));
        this.messageMap.put("two-sided-long-edge", jEdit.getProperty("print.dialog.two-sided-long-edge", "Two Sided, Long Edge"));
        this.messageMap.put("two-sided-short-edge", jEdit.getProperty("print.dialog.two-sided-short-edge", "Two Sided, Short Edge"));
    }

    private String getMessage(String key) {
        String value = this.messageMap.get(key);
        return value == null ? key : value;
    }

    private class GeneralPanel
    extends PrinterPanel {
        JRadioButton allPages;
        JRadioButton pages;
        JRadioButton currentPage;
        JRadioButton selection;
        JCheckBox collate;
        JCheckBox reverse;
        JTextField pagesField;

        public GeneralPanel() {
            PrinterDialog.this.printers = new JList<PrintService>(PrinterDialog.this.getPrintServices());
            PrinterDialog.this.printers.setCellRenderer(new PrintServiceCellRenderer());
            PrinterDialog.this.printers.setSelectionMode(0);
            JPanel rangePanel = new JPanel(new GridLayout(4, 2, 6, 6));
            rangePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Range", "Range")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            this.allPages = new JRadioButton(jEdit.getProperty("print.dialog.All_pages", "All pages"));
            this.allPages.setSelected(true);
            this.pages = new JRadioButton(jEdit.getProperty("print.dialog.Pages", "Pages") + ":");
            this.pagesField = new JTextField();
            this.pagesField.setEnabled(false);
            this.currentPage = new JRadioButton(jEdit.getProperty("print.dialog.Current_page", "Current page"));
            this.selection = new JRadioButton(jEdit.getProperty("print.dialog.Selection", "Selection"));
            new MyButtonGroup(this.allPages, this.pages, this.currentPage, this.selection);
            Box pagesBox = Box.createHorizontalBox();
            pagesBox.add(this.pages);
            pagesBox.add(Box.createHorizontalStrut(6));
            pagesBox.add(this.pagesField);
            rangePanel.add(this.allPages);
            rangePanel.add(Box.createGlue());
            rangePanel.add(pagesBox);
            rangePanel.add(Box.createGlue());
            rangePanel.add(this.currentPage);
            rangePanel.add(Box.createGlue());
            rangePanel.add(this.selection);
            JPanel copiesPanel = new JPanel(new GridLayout(3, 2, 6, 6));
            copiesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Copies", "Copies")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            JLabel copiesLabel = new JLabel(jEdit.getProperty("print.dialog.Copies", "Copies:"));
            PrinterDialog.this.copies = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
            this.collate = new JCheckBox(jEdit.getProperty("print.dialog.Collate", "Collate"));
            this.collate.setSelected(false);
            this.collate.setEnabled(false);
            this.reverse = new JCheckBox(jEdit.getProperty("print.dialog.Reverse", "Reverse"));
            this.reverse.setSelected(false);
            this.reverse.setEnabled(true);
            copiesPanel.add(copiesLabel);
            copiesPanel.add(PrinterDialog.this.copies);
            copiesPanel.add(this.collate);
            copiesPanel.add(Box.createGlue());
            copiesPanel.add(this.reverse);
            JPanel content = new JPanel(new BorderLayout());
            JPanel top = new JPanel(new BorderLayout());
            JPanel bottom = new JPanel(new GridLayout(1, 2, 6, 6));
            top.add((Component)new JScrollPane(PrinterDialog.this.printers), "Center");
            bottom.add(rangePanel);
            bottom.add(copiesPanel);
            content.add((Component)top, "Center");
            content.add((Component)bottom, "South");
            this.add(content);
            PrinterDialog.this.printers.addListSelectionListener(PrinterDialog.this);
            this.allPages.addActionListener(ae -> this.pagesField.setEnabled(this.pages.isSelected()));
            this.pages.addActionListener(ae -> this.pagesField.setEnabled(this.pages.isSelected()));
            PrinterDialog.this.copies.addChangeListener(e -> {
                JSpinner spinner = (JSpinner)e.getSource();
                int value = (Integer)spinner.getValue();
                this.collate.setEnabled(value > 1);
                this.collate.setSelected(value > 1);
            });
            PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
            String lastUsedPrinterName = jEdit.getProperty("print.lastUsedPrinter");
            if (lastUsedPrinterName != null) {
                ListModel<PrintService> lm = PrinterDialog.this.printers.getModel();
                for (int i = 0; i < lm.getSize(); ++i) {
                    PrintService ps = lm.getElementAt(i);
                    if (!lastUsedPrinterName.equals(ps.getName())) continue;
                    PrinterDialog.this.printers.setSelectedValue(ps, true);
                    PrinterDialog.this.selectedPrintService = ps;
                    break;
                }
            } else if (defaultPrintService != null) {
                PrinterDialog.this.printers.setSelectedValue(defaultPrintService, true);
                PrinterDialog.this.selectedPrintService = defaultPrintService;
            }
            if (PrinterDialog.this.selectedPrintService == null) {
                PrinterDialog.this.selectedPrintService = PrinterDialog.this.printers.getModel().getElementAt(0);
            }
        }

        @Override
        public AttributeSet getAttributes() {
            jEdit.setProperty("print.lastUsedPrinter", PrinterDialog.this.printers.getSelectedValue().getName());
            HashAttributeSet as = new HashAttributeSet();
            if (this.allPages.isSelected()) {
                as.add(new PageRanges(1, 1000));
                as.add(PrintRangeType.ALL);
            } else if (this.pages.isSelected()) {
                String pageRange = this.pagesField.getText();
                if (pageRange != null) {
                    try {
                        as.add(new PageRanges(pageRange));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                as.add(PrintRangeType.RANGE);
            } else if (this.currentPage.isSelected()) {
                PrinterDialog.this.attributes.add(new PageRanges(1, 1000));
                HashMap<Integer, Range> currentPageRange = BufferPrinter1_7.getCurrentPageRange(PrinterDialog.this.view, PrinterDialog.this.view.getBuffer(), PrinterDialog.this.attributes);
                int page = 1;
                if (currentPageRange != null && !currentPageRange.isEmpty()) {
                    page = currentPageRange.keySet().iterator().next();
                }
                as.add(new PageRanges(page));
                as.add(PrintRangeType.CURRENT_PAGE);
            } else if (this.selection.isSelected()) {
                PrinterDialog.this.attributes.add(new PageRanges(1, 1000));
                as.add(PrintRangeType.SELECTION);
            }
            if (this.collate.isSelected()) {
                as.add(SheetCollate.COLLATED);
            }
            as.add(new Copies((Integer)PrinterDialog.this.copies.getValue()));
            if (this.reverse.isSelected()) {
                as.add(new Reverse());
            } else {
                PrinterDialog.this.attributes.remove(Reverse.class);
            }
            return as;
        }

        class PrintServiceCellRenderer
        extends JLabel
        implements ListCellRenderer<PrintService> {
            public PrintServiceCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends PrintService> list, PrintService value, int index, boolean isSelected, boolean cellHasFocus) {
                Color foreground;
                Color background;
                this.setText(value == null ? "" : value.getName());
                if (isSelected) {
                    background = jEdit.getColorProperty("view.selectionColor");
                    foreground = jEdit.getColorProperty("view.fgColor");
                } else {
                    background = jEdit.getColorProperty("view.bgColor");
                    foreground = jEdit.getColorProperty("view.fgColor");
                }
                this.setBackground(background);
                this.setForeground(foreground);
                Dimension d = new Dimension((int)this.getSize().getWidth(), (int)this.getSize().getHeight() + 5);
                this.setSize(d);
                return this;
            }
        }
    }

    private class PageSetupPanel
    extends PrinterPanel {
        private JComboBox<String> onlyPrint;
        private JComboBox<String> outputTray;
        NumericTextField topMarginField;
        NumericTextField leftMarginField;
        NumericTextField rightMarginField;
        NumericTextField bottomMarginField;

        public PageSetupPanel() {
            JPanel layoutPanel = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            layoutPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Layout", "Layout")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            PrinterDialog.this.sides = new JComboBox();
            PrinterDialog.this.sides.setEnabled(false);
            PrinterDialog.this.sides.setRenderer(new SidesCellRenderer());
            PrinterDialog.this.pagesPerSide = new JComboBox();
            PrinterDialog.this.pagesPerSide.setEnabled(false);
            PrinterDialog.this.pageOrdering = new JComboBox();
            PrinterDialog.this.pageOrdering.setEnabled(false);
            this.onlyPrint = new JComboBox();
            this.onlyPrint.addItem(jEdit.getProperty("print.dialog.All_sheets", "All sheets"));
            this.onlyPrint.addItem(jEdit.getProperty("print.dialog.Odd_sheets", "Odd sheets"));
            this.onlyPrint.addItem(jEdit.getProperty("print.dialog.Even_sheets", "Even sheets"));
            this.onlyPrint.setSelectedIndex(0);
            this.onlyPrint.setEnabled(true);
            layoutPanel.add(new JLabel(jEdit.getProperty("print.dialog.Two-sided", "Two-sided") + ":"));
            layoutPanel.add(PrinterDialog.this.sides);
            layoutPanel.add(new JLabel(jEdit.getProperty("print.dialog.Pages_per_side", "Pages per side") + ":"));
            layoutPanel.add(PrinterDialog.this.pagesPerSide);
            layoutPanel.add(new JLabel(jEdit.getProperty("print.dialog.Page_ordering", "Page ordering") + ":"));
            layoutPanel.add(PrinterDialog.this.pageOrdering);
            layoutPanel.add(new JLabel(jEdit.getProperty("print.dialog.Only_print", "Only print") + ":"));
            layoutPanel.add(this.onlyPrint);
            JPanel paperPanel = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            paperPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Paper", "Paper")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            PrinterDialog.this.paperSource = new JComboBox();
            PrinterDialog.this.paperSource.setEnabled(false);
            this.outputTray = new JComboBox();
            this.outputTray.setEnabled(false);
            PrinterDialog.this.paperSize = new JComboBox();
            PrinterDialog.this.paperSize.setEnabled(false);
            PrinterDialog.this.orientation = new JComboBox();
            PrinterDialog.this.orientation.setEnabled(false);
            PrinterDialog.this.orientation.setRenderer(new OrientationCellRenderer());
            paperPanel.add(new JLabel(jEdit.getProperty("print.dialog.Paper_source", "Paper source") + ":"));
            paperPanel.add(PrinterDialog.this.paperSource);
            paperPanel.add(new JLabel(jEdit.getProperty("print.dialog.Output_tray", "Output tray") + ":"));
            paperPanel.add(this.outputTray);
            paperPanel.add(new JLabel(jEdit.getProperty("print.dialog.Paper_size", "Paper size") + ":"));
            paperPanel.add(PrinterDialog.this.paperSize);
            paperPanel.add(new JLabel(jEdit.getProperty("print.dialog.Orientation", "Orientation") + ":"));
            paperPanel.add(PrinterDialog.this.orientation);
            JPanel marginPanel = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            marginPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Margins", "Margins")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            boolean unitIsMM = this.getUnits() == 1000;
            String topMargin = jEdit.getProperty("print.topMargin", unitIsMM ? "25" : "1.0");
            String leftMargin = jEdit.getProperty("print.leftMargin", unitIsMM ? "25" : "1.0");
            String rightMargin = jEdit.getProperty("print.rightMargin", unitIsMM ? "25" : "1.0");
            String bottomMargin = jEdit.getProperty("print.bottomMargin", unitIsMM ? "25" : "1.0");
            this.topMarginField = new NumericTextField(topMargin, true, unitIsMM);
            this.leftMarginField = new NumericTextField(leftMargin, true, unitIsMM);
            this.rightMarginField = new NumericTextField(rightMargin, true, unitIsMM);
            this.bottomMarginField = new NumericTextField(bottomMargin, true, unitIsMM);
            String unitsLabel = unitIsMM ? " (mm)" : " (in)";
            marginPanel.add(new JLabel(jEdit.getProperty("print.dialog.Top", "Top") + unitsLabel));
            marginPanel.add(this.topMarginField);
            marginPanel.add(new JLabel(jEdit.getProperty("print.dialog.Left", "Left") + unitsLabel));
            marginPanel.add(this.leftMarginField);
            marginPanel.add(new JLabel(jEdit.getProperty("print.dialog.Right", "Right") + unitsLabel));
            marginPanel.add(this.rightMarginField);
            marginPanel.add(new JLabel(jEdit.getProperty("print.dialog.Bottom", "Bottom") + unitsLabel));
            marginPanel.add(this.bottomMarginField);
            JPanel finishingPanel = new JPanel(new FlowLayout(0));
            finishingPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Finishing", "Finishing")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            PrinterDialog.this.finishing = new JComboBox();
            PrinterDialog.this.finishing.setEnabled(false);
            PrinterDialog.this.finishing.setRenderer(new FinishingCellRenderer());
            Box finishingBox = Box.createHorizontalBox();
            finishingBox.add(new JLabel(jEdit.getProperty("print.dialog.Finishing", "Finishing") + ":"));
            finishingBox.add(Box.createHorizontalStrut(6));
            finishingBox.add(PrinterDialog.this.finishing);
            finishingPanel.add(finishingBox);
            JPanel content = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            content.add(layoutPanel);
            content.add(paperPanel);
            content.add(marginPanel);
            content.add(finishingPanel);
            this.add(content);
            PrinterDialog.this.pagesPerSide.addActionListener(ae -> {
                NumberUp nu = (NumberUp)PrinterDialog.this.pagesPerSide.getSelectedItem();
                if (nu != null && nu.getValue() == 1) {
                    PrinterDialog.this.pageOrdering.setEnabled(false);
                }
            });
            PrinterDialog.this.paperSize.addActionListener(ae -> this.setDefaultMargins());
            PrinterDialog.this.orientation.addActionListener(ae -> this.setDefaultMargins());
        }

        @Override
        public AttributeSet getAttributes() {
            HashAttributeSet as = new HashAttributeSet();
            if (PrinterDialog.this.sides.isEnabled()) {
                as.add((Sides)PrinterDialog.this.sides.getSelectedItem());
            }
            if (PrinterDialog.this.pagesPerSide.isEnabled()) {
                as.add((NumberUp)PrinterDialog.this.pagesPerSide.getSelectedItem());
            }
            if (PrinterDialog.this.pageOrdering.isEnabled()) {
                as.add((PresentationDirection)PrinterDialog.this.pageOrdering.getSelectedItem());
            }
            onlyPrintPages = this.onlyPrint.getSelectedIndex();
            if (PrinterDialog.this.paperSource.isEnabled()) {
                as.add((MediaTray)PrinterDialog.this.paperSource.getSelectedItem());
            }
            if (PrinterDialog.this.paperSize.isEnabled()) {
                as.add(PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex()));
            }
            if (PrinterDialog.this.orientation.isEnabled()) {
                as.add((OrientationRequested)PrinterDialog.this.orientation.getSelectedItem());
            }
            Number topMargin = this.topMarginField.getValue();
            Number leftMargin = this.leftMarginField.getValue();
            Number rightMargin = this.rightMarginField.getValue();
            Number bottomMargin = this.bottomMarginField.getValue();
            Margins margins = new Margins(topMargin.floatValue(), leftMargin.floatValue(), rightMargin.floatValue(), bottomMargin.floatValue());
            as.add(margins);
            jEdit.setProperty("print.topMargin", topMargin.toString());
            jEdit.setProperty("print.leftMargin", leftMargin.toString());
            jEdit.setProperty("print.rightMargin", rightMargin.toString());
            jEdit.setProperty("print.bottomMargin", bottomMargin.toString());
            return as;
        }

        protected String recalculate() {
            if (!PrinterDialog.this.isShowing()) {
                return null;
            }
            int units = this.getUnits();
            MediaPrintableArea supportedArea = this.getSupportedPrintableArea();
            Media media = PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex());
            Size2DSyntax mediaSize = null;
            if (media instanceof MediaSizeName) {
                MediaSizeName name = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(name);
            }
            float paperWidth = mediaSize.getX(units);
            float paperHeight = mediaSize.getY(units);
            float topMargin = this.topMarginField.getValue().floatValue();
            float leftMargin = this.leftMarginField.getValue().floatValue();
            float rightMargin = this.rightMarginField.getValue().floatValue();
            float bottomMargin = this.bottomMarginField.getValue().floatValue();
            OrientationRequested orientationRequested = (OrientationRequested)PrinterDialog.this.orientation.getSelectedItem();
            this.rotateMargins(topMargin, leftMargin, rightMargin, bottomMargin, orientationRequested);
            float x = leftMargin;
            float y = topMargin;
            float width = paperWidth - leftMargin - rightMargin;
            float height = paperHeight - topMargin - bottomMargin;
            if (x < supportedArea.getX(units)) {
                return jEdit.getProperty("print.dialog.error.Invalid_left_margin", "Invalid left margin.");
            }
            if (y < supportedArea.getY(units)) {
                return jEdit.getProperty("print.dialog.error.Invalid_top_margin", "Invalid top margin.");
            }
            if (width <= 0.0f || x + width > supportedArea.getX(units) + supportedArea.getWidth(units)) {
                return jEdit.getProperty("print.dialog.error.Invalid_left_andor_right_margin.", "Invalid left and/or right margin.");
            }
            if (height <= 0.0f || y + height > supportedArea.getY(units) + supportedArea.getHeight(units)) {
                return jEdit.getProperty("print.dialog.error.Invalid_top_andor_bottom_margin", "Invalid top and/or bottom margin.");
            }
            MediaPrintableArea area = new MediaPrintableArea(x, y, width, height, units);
            PrinterDialog.this.attributes.add(area);
            return null;
        }

        private MediaPrintableArea getSupportedPrintableArea() {
            Object values;
            MediaPrintableArea supportedArea = null;
            HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
            if (PrinterDialog.this.paperSizes != null) {
                attrs.add(PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex()));
            }
            if (PrinterDialog.this.orientation != null && PrinterDialog.this.orientation.getSelectedItem() != null) {
                attrs.add((OrientationRequested)PrinterDialog.this.orientation.getSelectedItem());
            }
            if ((values = PrinterDialog.this.getPrintService().getSupportedAttributeValues(MediaPrintableArea.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, attrs)) != null) {
                MediaPrintableArea[] mpas = (MediaPrintableArea[])values;
                supportedArea = mpas[0];
            } else {
                supportedArea = (MediaPrintableArea)PrinterDialog.this.getPrintService().getDefaultAttributeValue(MediaPrintableArea.class);
            }
            return supportedArea;
        }

        private void rotateMargins(float topMargin, float leftMargin, float rightMargin, float bottomMargin, OrientationRequested orientationRequested) {
            if (OrientationRequested.REVERSE_PORTRAIT.equals(orientationRequested)) {
                float m = leftMargin;
                leftMargin = rightMargin;
                rightMargin = m;
                m = topMargin;
                topMargin = bottomMargin;
                bottomMargin = m;
            } else if (OrientationRequested.LANDSCAPE.equals(orientationRequested)) {
                float m = leftMargin;
                leftMargin = bottomMargin;
                bottomMargin = rightMargin;
                rightMargin = topMargin;
                topMargin = m;
            } else if (OrientationRequested.REVERSE_LANDSCAPE.equals(orientationRequested)) {
                float m = leftMargin;
                leftMargin = topMargin;
                topMargin = rightMargin;
                rightMargin = bottomMargin;
                bottomMargin = m;
            }
        }

        void setDefaultMargins() {
            int units = this.getUnits();
            boolean integerOnly = units == 1000;
            Margins margins = (Margins)PrinterDialog.this.attributes.get(Margins.class);
            float[] minMargins = this.getMinimumMargins();
            float[] maxMargins = this.getMaximumMargins();
            float[] marginValues = margins == null ? minMargins : margins.getMargins(units);
            NumericTextField[] numberFields = new NumericTextField[]{this.topMarginField, this.leftMarginField, this.rightMarginField, this.bottomMarginField};
            for (int i = 0; i < numberFields.length; ++i) {
                NumericTextField field = numberFields[i];
                Float currentUserMargin = null;
                String text = field.getText();
                if (text != null && !text.isEmpty()) {
                    currentUserMargin = Float.valueOf(text);
                }
                Float value = Float.valueOf(marginValues[i]);
                Float minMargin = Float.valueOf(minMargins[i]);
                Float maxMargin = Float.valueOf(maxMargins[i]);
                if (currentUserMargin == null || currentUserMargin.floatValue() < minMargin.floatValue() || currentUserMargin.floatValue() > maxMargin.floatValue()) {
                    field.setText(integerOnly ? String.valueOf(value.intValue()) : String.valueOf(value));
                }
                field.setMinValue(Float.valueOf(integerOnly ? (float)Integer.valueOf(minMargin.intValue()).intValue() : minMargin.floatValue()));
                field.setMaxValue(Float.valueOf(integerOnly ? (float)Integer.valueOf(maxMargin.intValue()).intValue() : maxMargin.floatValue()));
                field.setToolTipText("Min: " + minMargin + ", max: " + maxMargin);
            }
        }

        private float[] getMinimumMargins() {
            int units = this.getUnits();
            boolean integerOnly = units == 1000;
            MediaPrintableArea supportedArea = this.getSupportedPrintableArea();
            Media media = PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex());
            Size2DSyntax mediaSize = null;
            if (media instanceof MediaSizeName) {
                MediaSizeName name = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(name);
            }
            float paperWidth = mediaSize.getX(units);
            float paperHeight = mediaSize.getY(units);
            float topMargin = supportedArea.getY(units);
            topMargin = integerOnly ? Double.valueOf(Math.ceil(topMargin)).floatValue() : topMargin;
            float leftMargin = supportedArea.getX(units);
            leftMargin = integerOnly ? Double.valueOf(Math.ceil(leftMargin)).floatValue() : leftMargin;
            float rightMargin = Math.max(0.0f, paperWidth - leftMargin - supportedArea.getWidth(units));
            rightMargin = integerOnly ? Double.valueOf(Math.ceil(rightMargin)).floatValue() : rightMargin;
            float bottomMargin = Math.max(0.0f, paperHeight - topMargin - supportedArea.getHeight(units));
            bottomMargin = integerOnly ? Double.valueOf(Math.ceil(bottomMargin)).floatValue() : bottomMargin;
            OrientationRequested orientationRequested = (OrientationRequested)PrinterDialog.this.orientation.getSelectedItem();
            this.rotateMargins(topMargin, leftMargin, rightMargin, bottomMargin, orientationRequested);
            return new float[]{topMargin, leftMargin, rightMargin, bottomMargin};
        }

        private float[] getMaximumMargins() {
            int units = this.getUnits();
            boolean integerOnly = units == 1000;
            MediaPrintableArea supportedArea = this.getSupportedPrintableArea();
            Media media = PrinterDialog.this.paperSizes.get(PrinterDialog.this.paperSize.getSelectedIndex());
            Size2DSyntax mediaSize = null;
            if (media instanceof MediaSizeName) {
                MediaSizeName name = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(name);
            }
            float paperWidth = mediaSize.getX(units);
            float paperHeight = mediaSize.getY(units);
            float topMargin = supportedArea.getY(units) + supportedArea.getHeight(units);
            topMargin = integerOnly ? Double.valueOf(Math.ceil(topMargin)).floatValue() : topMargin;
            float leftMargin = supportedArea.getX(units) + supportedArea.getWidth(units);
            leftMargin = integerOnly ? Double.valueOf(Math.ceil(leftMargin)).floatValue() : leftMargin;
            float rightMargin = paperWidth - supportedArea.getX(units);
            rightMargin = integerOnly ? Double.valueOf(Math.ceil(rightMargin)).floatValue() : rightMargin;
            float bottomMargin = paperHeight - supportedArea.getY(units);
            bottomMargin = integerOnly ? Double.valueOf(Math.ceil(bottomMargin)).floatValue() : bottomMargin;
            OrientationRequested orientationRequested = (OrientationRequested)PrinterDialog.this.orientation.getSelectedItem();
            this.rotateMargins(topMargin, leftMargin, rightMargin, bottomMargin, orientationRequested);
            return new float[]{topMargin, leftMargin, rightMargin, bottomMargin};
        }

        private int getUnits() {
            String country = Locale.getDefault().getCountry();
            if ("".equals(country) || Locale.US.getCountry().equals(country) || Locale.CANADA.getCountry().equals(country)) {
                return 25400;
            }
            return 1000;
        }

        class SidesCellRenderer
        extends JLabel
        implements ListCellRenderer<Sides> {
            public SidesCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Sides> list, Sides value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value == null ? "" : PrinterDialog.this.getMessage(value.toString()));
                return this;
            }
        }

        class OrientationCellRenderer
        extends JLabel
        implements ListCellRenderer<OrientationRequested> {
            public OrientationCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends OrientationRequested> list, OrientationRequested value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value == null ? "" : PrinterDialog.this.getMessage(value.toString()));
                return this;
            }
        }

        class FinishingCellRenderer
        extends JLabel
        implements ListCellRenderer<Finishings> {
            public FinishingCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Finishings> list, Finishings value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value == null ? "" : PrinterDialog.this.getMessage(value.toString()));
                return this;
            }
        }
    }

    private class JobPanel
    extends PrinterPanel {
        private JRadioButton nowButton;
        private JRadioButton atButton;
        private JRadioButton holdButton;
        private JSpinner when;

        public JobPanel() {
            JPanel jobPanel = new JPanel(new FlowLayout(0));
            jobPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Job_Details", "Job Details")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            PrinterDialog.this.priority = new JComboBox();
            PrinterDialog.this.priority.addItem(Priority.LOW);
            PrinterDialog.this.priority.addItem(Priority.MEDIUM);
            PrinterDialog.this.priority.addItem(Priority.HIGH);
            PrinterDialog.this.priority.addItem(Priority.URGENT);
            PrinterDialog.this.priority.setSelectedItem(Priority.MEDIUM);
            Box priorityBox = Box.createHorizontalBox();
            priorityBox.add(new JLabel(jEdit.getProperty("print.dialog.Priority", "Priority") + ":"));
            priorityBox.add(Box.createHorizontalStrut(6));
            priorityBox.add(PrinterDialog.this.priority);
            jobPanel.add(priorityBox);
            JPanel printPanel = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            printPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), jEdit.getProperty("print.dialog.Print_Document", "Print Document")), BorderFactory.createEmptyBorder(11, 11, 11, 11)));
            this.nowButton = new JRadioButton(jEdit.getProperty("print.dialog.Now", "Now"));
            this.nowButton.setSelected(true);
            this.atButton = new JRadioButton(jEdit.getProperty("print.dialog.At", "At"));
            this.atButton.setEnabled(true);
            Calendar calendar = Calendar.getInstance(Locale.getDefault());
            Date initialDate = calendar.getTime();
            calendar.add(1, 1);
            Date latestDate = calendar.getTime();
            SpinnerDateModel dateModel = new SpinnerDateModel(initialDate, initialDate, latestDate, 1);
            this.when = new JSpinner(dateModel);
            this.when.setEnabled(true);
            this.holdButton = new JRadioButton(jEdit.getProperty("print.dialog.On_Hold", "On Hold"));
            this.holdButton.setEnabled(true);
            new MyButtonGroup(this.nowButton, this.atButton, this.holdButton);
            printPanel.add(this.nowButton);
            printPanel.add(Box.createGlue());
            printPanel.add(this.atButton);
            printPanel.add(this.when);
            printPanel.add(this.holdButton);
            printPanel.add(Box.createGlue());
            JPanel content = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            content.add(jobPanel);
            content.add(printPanel);
            this.add((Component)content, "North");
            this.atButton.addActionListener(ae -> this.when.setEnabled(this.atButton.isSelected()));
        }

        @Override
        public AttributeSet getAttributes() {
            HashAttributeSet as = new HashAttributeSet();
            as.add(new JobPriority(((Priority)PrinterDialog.this.priority.getSelectedItem()).getValue()));
            if (PrinterDialog.this.finishing.isEnabled()) {
                as.add((Finishings)PrinterDialog.this.finishing.getSelectedItem());
            }
            Date holdUntil = new Date(0L);
            if (this.atButton.isSelected()) {
                holdUntil = ((SpinnerDateModel)this.when.getModel()).getDate();
            } else if (this.holdButton.isSelected()) {
                Calendar later = Calendar.getInstance();
                later.add(1, 1);
                holdUntil = later.getTime();
            }
            as.add(new JobHoldUntil(holdUntil));
            return as;
        }
    }

    private class AdvancedPanel
    extends PrinterPanel {
        private JComboBox<PrintQuality> quality;
        private JComboBox<Chromaticity> chromaticity;

        public AdvancedPanel() {
            this.quality = new JComboBox();
            this.quality.addItem(PrintQuality.DRAFT);
            this.quality.addItem(PrintQuality.NORMAL);
            this.quality.addItem(PrintQuality.HIGH);
            PrintQuality pq = (PrintQuality)PrinterDialog.this.attributes.get(PrintQuality.class);
            this.quality.setSelectedItem(pq == null ? PrintQuality.NORMAL : pq);
            this.quality.setRenderer(new QualityCellRenderer());
            this.chromaticity = new JComboBox();
            this.chromaticity.addItem(Chromaticity.MONOCHROME);
            this.chromaticity.addItem(Chromaticity.COLOR);
            Chromaticity value = (Chromaticity)PrinterDialog.this.attributes.get(Chromaticity.class);
            this.chromaticity.setSelectedItem(value == null ? Chromaticity.MONOCHROME : value);
            this.chromaticity.setRenderer(new ChromaticityCellRenderer());
            JPanel content = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            content.add(new JLabel(jEdit.getProperty("print.dialog.Quality", "Quality")));
            content.add(this.quality);
            content.add(new JLabel(jEdit.getProperty("print.dialog.Ink", "Ink")));
            content.add(this.chromaticity);
            this.add((Component)content, "North");
        }

        @Override
        public AttributeSet getAttributes() {
            HashAttributeSet as = new HashAttributeSet();
            as.add((Chromaticity)this.chromaticity.getSelectedItem());
            as.add((PrintQuality)this.quality.getSelectedItem());
            return as;
        }

        class QualityCellRenderer
        extends JLabel
        implements ListCellRenderer<PrintQuality> {
            public QualityCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends PrintQuality> list, PrintQuality value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value == null ? "" : PrinterDialog.this.getMessage(value.toString()));
                return this;
            }
        }

        class ChromaticityCellRenderer
        extends JLabel
        implements ListCellRenderer<Chromaticity> {
            public ChromaticityCellRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Chromaticity> list, Chromaticity value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value == null ? "" : PrinterDialog.this.getMessage(value.toString()));
                return this;
            }
        }
    }

    private class jEditPanel
    extends PrinterPanel {
        private FontSelector font;
        private JCheckBox printHeader;
        private JCheckBox printFooter;
        private JCheckBox printLineNumbers;
        private JCheckBox printFolds;
        private JComboBox<String> tabSize;

        public jEditPanel() {
            this.font = new FontSelector(jEdit.getFontProperty("print.font"));
            this.printHeader = new JCheckBox(jEdit.getProperty("options.print.header"));
            this.printHeader.setSelected(jEdit.getBooleanProperty("print.header"));
            this.printFooter = new JCheckBox(jEdit.getProperty("options.print.footer"));
            this.printFooter.setSelected(jEdit.getBooleanProperty("print.footer"));
            this.printLineNumbers = new JCheckBox(jEdit.getProperty("options.print.lineNumbers"));
            this.printLineNumbers.setSelected(jEdit.getBooleanProperty("print.lineNumbers"));
            String[] tabSizes = new String[]{"2", "4", "8"};
            this.tabSize = new JComboBox<String>(tabSizes);
            this.tabSize.setEditor(new NumericTextField("", true, true));
            this.tabSize.setEditable(true);
            this.tabSize.setSelectedItem(jEdit.getProperty("print.tabSize"));
            this.printFolds = new JCheckBox(jEdit.getProperty("options.print.folds"));
            this.printFolds.setSelected(jEdit.getBooleanProperty("print.folds", true));
            JPanel content = new JPanel(new VariableGridLayout(2, 2, 6, 6));
            content.add(new JLabel(jEdit.getProperty("options.print.font")));
            content.add(this.font);
            content.add(new JLabel(jEdit.getProperty("options.print.tabSize")));
            content.add(this.tabSize);
            content.add(this.printHeader);
            content.add(Box.createGlue());
            content.add(this.printFooter);
            content.add(Box.createGlue());
            content.add(this.printLineNumbers);
            content.add(Box.createGlue());
            content.add(this.printFolds);
            content.add(Box.createGlue());
            this.add((Component)content, "North");
        }

        @Override
        public AttributeSet getAttributes() {
            jEdit.setFontProperty("print.font", this.font.getFont());
            jEdit.setBooleanProperty("print.header", this.printHeader.isSelected());
            jEdit.setBooleanProperty("print.footer", this.printFooter.isSelected());
            jEdit.setBooleanProperty("print.lineNumbers", this.printLineNumbers.isSelected());
            jEdit.setProperty("print.tabSize", (String)this.tabSize.getSelectedItem());
            jEdit.setBooleanProperty("print.folds", this.printFolds.isSelected());
            return null;
        }
    }

    class MyButtonGroup
    extends ButtonGroup {
        public MyButtonGroup(AbstractButton ... buttons) {
            for (AbstractButton b : buttons) {
                super.add(b);
            }
        }
    }

    private static class Priority {
        public static final Priority LOW = new Priority(1, jEdit.getProperty("print.dialog.Low", "Low"));
        public static final Priority MEDIUM = new Priority(50, jEdit.getProperty("print.dialog.Medium", "Medium"));
        public static final Priority HIGH = new Priority(80, jEdit.getProperty("print.dialog.High", "High"));
        public static final Priority URGENT = new Priority(100, jEdit.getProperty("print.dialog.Urgent", "Urgent"));
        private int value;
        private String name;

        private Priority(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }
    }

    private abstract class PrinterPanel
    extends JPanel {
        public PrinterPanel() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        }

        abstract AttributeSet getAttributes();
    }
}

