/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.annotation.Nullable;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.statusbar.HoverSetStatusMouseHandler;
import org.gjt.sp.jedit.jEdit;
import org.jedit.keymap.Keymap;

public class EnhancedMenuItem
extends JMenuItem {
    @Nullable
    private String shortcut;

    public EnhancedMenuItem(String label, String action, ActionContext context) {
        this.shortcut = GUIUtilities.getShortcutLabel(action, true);
        String toolTip = jEdit.getProperty(action + ".tooltip");
        if (toolTip != null) {
            this.setToolTipText(toolTip);
        }
        if (this.shortcut != null) {
            this.putClientProperty("AccessibleName", label + " (" + this.shortcut + ")");
        }
        if (OperatingSystem.hasScreenMenuBar() && this.shortcut != null) {
            if (jEdit.getBooleanProperty("menu.multiShortcut", false)) {
                this.setText(label + " (" + this.shortcut + ")");
            } else {
                this.setText(label);
                Keymap keymap = jEdit.getKeymapManager().getKeymap();
                String rawShortcut = keymap.getShortcut(action + ".shortcut");
                KeyStroke key = KeyEventTranslator.parseKeyStroke(rawShortcut);
                if (key != null) {
                    this.setAccelerator(key);
                }
            }
            this.shortcut = null;
        } else {
            this.setText(label);
        }
        if (action != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(context, action));
            this.addMouseListener(new HoverSetStatusMouseHandler(action));
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.shortcut != null) {
            FontMetrics fm = this.getFontMetrics(GUIUtilities.menuAcceleratorFont());
            d.width += fm.stringWidth(this.shortcut) + fm.stringWidth("AAAA");
        }
        return d;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.shortcut != null) {
            Graphics2D g2 = (Graphics2D)g;
            g.setFont(GUIUtilities.menuAcceleratorFont());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(GUIUtilities.menuAcceleratorForeground(this.getModel().isArmed()));
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            g.drawString(this.shortcut, this.getWidth() - (fm.stringWidth(this.shortcut) + insets.right + insets.left + 5), fm.getAscent() + insets.top);
        }
    }
}

