/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.manager.ViewManager;

public class ViewManagerImpl
implements ViewManager {
    public static final View[] EMPTY_VIEW_ARRAY = new View[0];
    private int viewCount;
    private View viewsFirst;
    private View viewsLast;
    private View activeView;

    @Override
    public List<View> getViews() {
        ArrayList<View> buffers = new ArrayList<View>(this.viewCount);
        this.forEach(buffers::add);
        return buffers;
    }

    @Override
    public void forEach(Consumer<? super View> action) {
        View view = this.viewsFirst;
        for (int i = 0; i < this.viewCount; ++i) {
            action.accept(view);
            view = view.getNext();
        }
    }

    @Override
    public int size() {
        return this.viewCount;
    }

    @Override
    public View getFirst() {
        return this.viewsFirst;
    }

    @Override
    public View getLast() {
        return this.viewsLast;
    }

    @Override
    public View getActiveView() {
        if (this.activeView == null) {
            return this.viewsFirst;
        }
        return this.activeView;
    }

    @Override
    public void setActiveView(View view) {
        this.activeView = view;
    }

    @Override
    @Nullable
    public View getActiveViewInternal() {
        return this.activeView;
    }

    public void addViewToList(View view) {
        ++this.viewCount;
        if (this.viewsFirst == null) {
            this.viewsFirst = this.viewsLast = view;
        } else {
            view.setPrev(this.viewsLast);
            this.viewsLast.setNext(view);
            this.viewsLast = view;
        }
    }

    public void remove(View view) {
        --this.viewCount;
        if (this.viewsFirst == this.viewsLast) {
            this.viewsLast = null;
            this.viewsFirst = null;
            return;
        }
        if (view == this.viewsFirst) {
            this.viewsFirst = view.getNext();
            view.getNext().setPrev(null);
        } else {
            view.getPrev().setNext(view.getNext());
        }
        if (view == this.viewsLast) {
            this.viewsLast = this.viewsLast.getPrev();
            view.getPrev().setNext(null);
        } else {
            view.getNext().setPrev(view.getPrev());
        }
    }
}

