/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class TaskMonitor
extends JPanel
implements TaskListener {
    private final TaskTableModel model;
    private final JLabel remainingCount;

    public TaskMonitor() {
        super(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.remainingCount = new JLabel();
        panel.add((Component)this.remainingCount, "North");
        this.model = new TaskTableModel();
        this.model.addTableModelListener(e -> {
            if (e.getType() == 1 || e.getType() == -1) {
                this.updateTasksCount();
            }
        });
        JTable table = new JTable(this.model);
        table.setRowHeight(GenericGUIUtilities.defaultRowHeight());
        table.setDefaultRenderer(Object.class, new TaskCellRenderer());
        table.getTableHeader().setVisible(false);
        table.setDefaultEditor(Object.class, new TaskTableEditor());
        table.getColumnModel().getColumn(1).setMaxWidth(16);
        table.getColumnModel().getColumn(1).setMinWidth(16);
        JScrollPane scroll = new JScrollPane(table);
        panel.add(scroll);
        this.updateTasksCount();
        this.add(panel);
    }

    @Override
    public void addNotify() {
        TaskManager.instance.visit(this.model::addTask);
        TaskManager.instance.addTaskListener(this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        TaskManager.instance.removeTaskListener(this);
        super.removeNotify();
        this.model.removeAll();
    }

    @Override
    public void waiting(Task task) {
        this.model.addTask(task);
    }

    @Override
    public void running(Task task) {
        this.repaint();
    }

    @Override
    public void done(Task task) {
        this.model.removeTask(task);
    }

    @Override
    public void statusUpdated(Task task) {
        this.repaint();
    }

    @Override
    public void maximumUpdated(Task task) {
        this.repaint();
    }

    @Override
    public void valueUpdated(Task task) {
        this.repaint();
    }

    private void updateTasksCount() {
        this.remainingCount.setText(jEdit.getProperty("taskmanager.remainingtasks.label", new Object[]{this.model.getRowCount()}));
    }

    private static class TaskTableModel
    extends AbstractTableModel {
        private final List<Task> tasks = new ArrayList<Task>();

        private TaskTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.tasks.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.tasks.get(rowIndex);
        }

        void addTask(Task task) {
            ThreadUtilities.runInDispatchThread(() -> {
                this.tasks.add(task);
                this.fireTableRowsInserted(this.tasks.size() - 1, this.tasks.size() - 1);
            });
        }

        void removeTask(Task task) {
            ThreadUtilities.runInDispatchThread(() -> {
                int index = this.tasks.indexOf(task);
                if (index != -1) {
                    this.tasks.remove(index);
                    this.fireTableRowsDeleted(index, index);
                }
            });
        }

        public void removeAll() {
            this.tasks.clear();
            this.fireTableDataChanged();
        }
    }

    private static class TaskCellRenderer
    implements TableCellRenderer {
        private final JProgressBar progress = new JProgressBar();
        private final JButton button = new JButton(GUIUtilities.loadIcon(jEdit.getProperty("close-buffer.icon")));

        private TaskCellRenderer() {
            this.progress.setStringPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Task task = (Task)value;
            if (column == 0) {
                if (task.getMaximum() == 0L) {
                    this.progress.setIndeterminate(true);
                } else {
                    this.progress.setIndeterminate(false);
                    long max = task.getMaximum();
                    long val = task.getValue();
                    if (max > Integer.MAX_VALUE) {
                        max >>= 10;
                        val >>= 10;
                    }
                    this.progress.setMaximum((int)max);
                    this.progress.setValue((int)val);
                }
                this.progress.setToolTipText(task.getLabel());
                this.progress.setString(task.getStatus());
                return this.progress;
            }
            this.button.setEnabled(task.isCancellable());
            return this.button;
        }
    }

    private static class TaskTableEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JButton button = new JButton(GUIUtilities.loadIcon(jEdit.getProperty("close-buffer.icon")));
        private Task task;

        private TaskTableEditor() {
            this.button.addActionListener(e -> {
                this.task.cancel();
                this.stopCellEditing();
            });
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.task = (Task)value;
            return this.button;
        }
    }
}

