/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.FilteredListModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;
import org.gjt.sp.util.swing.event.UniqueActionDocumentListener;

public class LogViewer
extends JPanel
implements DefaultFocusComponent {
    private final ColorizerCellRenderer cellRenderer;
    private ListHandler listHandler;
    private FilteredListModel<ListModel<String>> listModel;
    private final JList<String> list;
    private final JButton copy;
    private final JCheckBox tail;
    private final JTextField filter;
    private boolean tailIsOn;
    private static boolean showDebug = jEdit.getBooleanProperty("log-viewer.message.debug", true);
    private static boolean showMessage = jEdit.getBooleanProperty("log-viewer.message.message", true);
    private static boolean showNotice = jEdit.getBooleanProperty("log-viewer.message.notice", true);
    private static boolean showWarning = jEdit.getBooleanProperty("log-viewer.message.warning", true);
    private static boolean showError = jEdit.getBooleanProperty("log-viewer.message.error", true);

    public LogViewer() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        JPanel caption = new JPanel();
        caption.setLayout(new BoxLayout(caption, 0));
        caption.setBorder(new EmptyBorder(6, 0, 6, 0));
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory != null) {
            Object[] args = new String[]{MiscUtilities.constructPath(settingsDirectory, "activity.log")};
            JLabel label = new JLabel(jEdit.getProperty("log-viewer.caption", args));
            caption.add(label);
        }
        caption.add(Box.createHorizontalGlue());
        this.tailIsOn = jEdit.getBooleanProperty("log-viewer.tail", false);
        this.tail = new JCheckBox(jEdit.getProperty("log-viewer.tail.label"), this.tailIsOn);
        this.tail.addActionListener(new ActionHandler());
        this.filter = new JTextField();
        this.filter.getDocument().addDocumentListener(new UniqueActionDocumentListener(e -> this.setFilter()));
        caption.add(this.filter);
        caption.add(this.tail);
        caption.add(Box.createHorizontalStrut(12));
        this.copy = new JButton(jEdit.getProperty("log-viewer.copy"));
        this.copy.addActionListener(new ActionHandler());
        caption.add(this.copy);
        caption.add(Box.createHorizontalStrut(6));
        JButton settings = new JButton(jEdit.getProperty("log-viewer.settings.label"));
        settings.addActionListener(e -> new LogSettings());
        caption.add(settings);
        Log.setMaxLines(jEdit.getIntegerProperty("log-viewer.maxlines", 500));
        ListModel<String> model = Log.getLogListModel();
        this.listModel = new MyFilteredListModel(model);
        model.removeListDataListener(this.listModel);
        this.list = new LogList(this.listModel);
        this.listModel.setList(this.list);
        this.cellRenderer = new ColorizerCellRenderer(this.list);
        this.list.setCellRenderer(this.cellRenderer);
        this.setFilter();
        this.add("North", caption);
        JScrollPane scroller = new JScrollPane(this.list);
        Dimension dim = scroller.getPreferredSize();
        dim.width = Math.min(600, dim.width);
        scroller.setPreferredSize(dim);
        this.add("Center", scroller);
        this.propertiesChanged();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.scrollLaterIfRequired();
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.propertiesChanged();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.cellRenderer.updateColors(this.list);
        ListModel<String> model = Log.getLogListModel();
        model.addListDataListener(this.listModel);
        this.listHandler = new ListHandler();
        model.addListDataListener(this.listHandler);
        if (this.tailIsOn) {
            this.scrollToTail();
        }
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ListModel<String> model = Log.getLogListModel();
        model.removeListDataListener(this.listModel);
        model.removeListDataListener(this.listHandler);
        this.listHandler = null;
        EditBus.removeFromBus(this);
    }

    @Override
    public void focusOnDefaultComponent() {
        this.list.requestFocus();
    }

    private void setFilter() {
        String toFilter = this.filter.getText();
        this.listModel.setFilter(toFilter.isEmpty() ? " " : toFilter);
        this.scrollLaterIfRequired();
    }

    private void propertiesChanged() {
        this.cellRenderer.updateColors(this.list);
        this.list.setFont(jEdit.getFontProperty("view.font"));
        this.list.setFixedCellHeight(this.list.getFontMetrics(this.list.getFont()).getHeight());
    }

    private void scrollToTail() {
        int index = this.list.getModel().getSize();
        if (index != 0) {
            this.list.ensureIndexIsVisible(index - 1);
        }
    }

    private void scrollLaterIfRequired() {
        if (this.tailIsOn) {
            ThreadUtilities.runInDispatchThread(this::scrollToTail);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == LogViewer.this.tail) {
                LogViewer.this.tailIsOn = !LogViewer.this.tailIsOn;
                jEdit.setBooleanProperty("log-viewer.tail", LogViewer.this.tailIsOn);
                if (LogViewer.this.tailIsOn) {
                    LogViewer.this.scrollToTail();
                }
            } else if (src == LogViewer.this.copy) {
                StringBuilder buf = new StringBuilder();
                Object[] selected = LogViewer.this.list.getSelectedValues();
                if (selected != null && selected.length != 0) {
                    for (Object sel : selected) {
                        buf.append(sel);
                        buf.append('\n');
                    }
                } else {
                    ListModel<String> model = LogViewer.this.list.getModel();
                    for (int i = 0; i < model.getSize(); ++i) {
                        buf.append(model.getElementAt(i));
                        buf.append('\n');
                    }
                }
                Registers.setRegister('$', buf.toString());
            }
        }
    }

    private static class MyFilteredListModel
    extends FilteredListModel<ListModel<String>> {
        MyFilteredListModel(ListModel<String> model) {
            super(model);
        }

        @Override
        public String prepareFilter(String filter) {
            return filter.toLowerCase();
        }

        @Override
        public boolean passFilter(int row, @Nullable String filter) {
            if (filter == null || filter.isEmpty()) {
                return true;
            }
            Object item = this.delegated.getElementAt(row);
            if (item == null) {
                return true;
            }
            String text = item.toString().toLowerCase();
            if (!showDebug && text.contains("[debug]")) {
                return false;
            }
            if (!showMessage && text.contains("[message]")) {
                return false;
            }
            if (!showNotice && text.contains("[notice]")) {
                return false;
            }
            if (!showWarning && text.contains("[warning]")) {
                return false;
            }
            if (!showError && text.contains("[error]")) {
                return false;
            }
            return text.contains(filter);
        }
    }

    private class LogList
    extends JList<String> {
        private int startIndex;

        LogList(ListModel<String> model) {
            super(model);
            this.setVisibleRowCount(24);
            this.getSelectionModel().setSelectionMode(1);
            this.setAutoscrolls(true);
        }

        @Override
        public void processMouseEvent(MouseEvent evt) {
            if (evt.getID() == 501) {
                this.startIndex = LogViewer.this.list.locationToIndex(evt.getPoint());
            }
            super.processMouseEvent(evt);
        }

        @Override
        public void processMouseMotionEvent(MouseEvent evt) {
            if (evt.getID() == 506) {
                int row = LogViewer.this.list.locationToIndex(evt.getPoint());
                if (row != -1) {
                    if (this.startIndex == -1) {
                        LogViewer.this.list.setSelectionInterval(row, row);
                        this.startIndex = row;
                    } else {
                        LogViewer.this.list.setSelectionInterval(this.startIndex, row);
                    }
                    LogViewer.this.list.ensureIndexIsVisible(row);
                    evt.consume();
                }
            } else {
                super.processMouseMotionEvent(evt);
            }
        }
    }

    private static class ColorizerCellRenderer
    extends JPanel
    implements ListCellRenderer<String> {
        private static Color debugColor;
        private static Color messageColor;
        private static Color noticeColor;
        private static Color warningColor;
        private static Color errorColor;
        private String text;
        private final int borderWidth = 1;
        private int baseline;
        private int width;
        private int height;
        private JList<String> list;

        private ColorizerCellRenderer(JList<String> list) {
            this.list = list;
            this.updateColors(list);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public void paint(Graphics g) {
            int currentWidth = (int)this.list.getFontMetrics(this.list.getFont()).getStringBounds(this.text, g).getWidth();
            this.width = Math.max(this.width, currentWidth);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
            g.drawString(this.text, 1, this.baseline);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                value = "";
            }
            this.text = value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                Color color = list.getForeground();
                if (this.text.contains("[debug]")) {
                    color = debugColor;
                } else if (this.text.contains("[message]")) {
                    color = messageColor;
                } else if (this.text.contains("[notice]")) {
                    color = noticeColor;
                } else if (this.text.contains("[warning]")) {
                    color = warningColor;
                } else if (this.text.contains("[error]")) {
                    color = errorColor;
                }
                this.setForeground(color);
            }
            return this;
        }

        public void updateColors(JList<String> list) {
            this.list = list;
            debugColor = jEdit.getColorProperty("log-viewer.message.debug.color", Color.BLUE);
            messageColor = jEdit.getColorProperty("log-viewer.message.message.color");
            noticeColor = jEdit.getColorProperty("log-viewer.message.notice.color", Color.GREEN);
            warningColor = jEdit.getColorProperty("log-viewer.message.warning.color", Color.ORANGE);
            errorColor = jEdit.getColorProperty("log-viewer.message.error.color", Color.RED);
            this.setFont(list.getFont());
            FontMetrics fm = list.getFontMetrics(list.getFont());
            this.baseline = fm.getAscent() + 1;
            this.width = list.getWidth();
            this.height = fm.getHeight() + 2;
        }
    }

    private class ListHandler
    implements ListDataListener {
        private ListHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            LogViewer.this.scrollLaterIfRequired();
        }
    }

    private class LogSettings
    extends JDialog {
        private JSpinner maxLines;
        private JCheckBox debug;
        private JCheckBox message;
        private JCheckBox notice;
        private JCheckBox warning;
        private JCheckBox error;
        private ColorWellButton debugColor;
        private ColorWellButton messageColor;
        private ColorWellButton noticeColor;
        private ColorWellButton warningColor;
        private ColorWellButton errorColor;
        private JCheckBox beep;

        LogSettings() {
            super((Frame)jEdit.getActiveView(), jEdit.getProperty("log-viewer.dialog.title"));
            AbstractOptionPane pane = new AbstractOptionPane(jEdit.getProperty("log-viewer.settings.label")){

                @Override
                protected void _init() {
                    this.setBorder(BorderFactory.createEmptyBorder(11, 11, 12, 12));
                    LogSettings.this.maxLines = new JSpinner(new SpinnerNumberModel(jEdit.getIntegerProperty("log-viewer.maxlines", 500), 500, Integer.MAX_VALUE, 1));
                    this.addComponent(jEdit.getProperty("log-viewer.maxlines.label", "Max lines"), (Component)LogSettings.this.maxLines, 0);
                    this.addComponent(Box.createVerticalStrut(11));
                    LogSettings.this.debug = new JCheckBox(jEdit.getProperty("log-viewer.message.debug.label", "Debug"), jEdit.getBooleanProperty("log-viewer.message.debug", true));
                    LogSettings.this.message = new JCheckBox(jEdit.getProperty("log-viewer.message.message.label", "Message"), jEdit.getBooleanProperty("log-viewer.message.message", true));
                    LogSettings.this.notice = new JCheckBox(jEdit.getProperty("log-viewer.message.notice.label", "Notice"), jEdit.getBooleanProperty("log-viewer.message.notice", true));
                    LogSettings.this.warning = new JCheckBox(jEdit.getProperty("log-viewer.message.warning.label", "Warning"), jEdit.getBooleanProperty("log-viewer.message.warning", true));
                    LogSettings.this.error = new JCheckBox(jEdit.getProperty("log-viewer.message.error.label", "Error"), jEdit.getBooleanProperty("log-viewer.message.error", true));
                    this.addComponent(new JLabel(jEdit.getProperty("log-viewer.message.label", "Message Display:")));
                    LogSettings.this.debugColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.debug.color", Color.BLUE));
                    this.addComponent(LogSettings.this.debug, (Component)LogSettings.this.debugColor, 0);
                    LogSettings.this.messageColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.message.color", Color.GREEN));
                    this.addComponent(LogSettings.this.message, (Component)LogSettings.this.messageColor, 0);
                    LogSettings.this.noticeColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.notice.color", Color.GREEN));
                    this.addComponent(LogSettings.this.notice, (Component)LogSettings.this.noticeColor, 0);
                    LogSettings.this.warningColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.warning.color", Color.ORANGE));
                    this.addComponent(LogSettings.this.warning, (Component)LogSettings.this.warningColor, 0);
                    LogSettings.this.errorColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.error.color", Color.RED));
                    this.addComponent(LogSettings.this.error, (Component)LogSettings.this.errorColor, 0);
                    this.addComponent(Box.createVerticalStrut(11));
                    LogSettings.this.beep = new JCheckBox(jEdit.getProperty("debug.beepOnOutput.label"), jEdit.getBooleanProperty("debug.beepOnOutput", false));
                    this.addComponent(LogSettings.this.beep);
                    this.addComponent(Box.createVerticalStrut(11));
                    JPanel buttonPanel = new JPanel(new FlowLayout(1));
                    JButton okButton = new JButton(jEdit.getProperty("common.ok"));
                    okButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            this.save();
                            LogSettings.this.setVisible(false);
                            LogSettings.this.dispose();
                        }
                    });
                    JButton cancelButton = new JButton(jEdit.getProperty("common.cancel"));
                    cancelButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            LogSettings.this.setVisible(false);
                            LogSettings.this.dispose();
                        }
                    });
                    buttonPanel.add(okButton);
                    buttonPanel.add(cancelButton);
                    this.addComponent((Component)buttonPanel, 2);
                }

                @Override
                protected void _save() {
                    jEdit.setIntegerProperty("log-viewer.maxlines", ((SpinnerNumberModel)LogSettings.this.maxLines.getModel()).getNumber().intValue());
                    Log.setMaxLines(jEdit.getIntegerProperty("log-viewer.maxlines", 500));
                    ListModel<String> model = Log.getLogListModel();
                    LogViewer.this.listModel = new MyFilteredListModel(model);
                    LogViewer.this.list.setModel(LogViewer.this.listModel);
                    LogViewer.this.listModel.setList(LogViewer.this.list);
                    showDebug = LogSettings.this.debug.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.debug", showDebug);
                    showMessage = LogSettings.this.message.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.message", showMessage);
                    showNotice = LogSettings.this.notice.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.notice", showNotice);
                    showWarning = LogSettings.this.warning.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.warning", showWarning);
                    showError = LogSettings.this.error.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.error", showError);
                    jEdit.setColorProperty("log-viewer.message.debug.color", LogSettings.this.debugColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.message.color", LogSettings.this.messageColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.notice.color", LogSettings.this.noticeColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.warning.color", LogSettings.this.warningColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.error.color", LogSettings.this.errorColor.getSelectedColor());
                    jEdit.setBooleanProperty("debug.beepOnOutput", LogSettings.this.beep.isSelected());
                    Log.setBeepOnOutput(LogSettings.this.beep.isSelected());
                }
            };
            this.setContentPane(pane);
            pane.init();
            this.pack();
            this.setLocationRelativeTo(LogViewer.this);
            this.setVisible(true);
        }
    }
}

