/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;

public class AddModeDialog
extends EnhancedDialog {
    private final JTextField modeName;
    private final JTextField modeFile;
    private final JTextField filenameGlob;
    private final JTextField firstLineGlob;
    private boolean canceled;

    public AddModeDialog(View view) {
        super(view, jEdit.getProperty("options.editing.addMode.dialog.title"), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setContentPane(content);
        AbstractOptionPane mainContent = new AbstractOptionPane("addmode");
        mainContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.modeName = new JTextField(16);
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeName"), (Component)this.modeName);
        this.modeFile = new JTextField();
        JButton browse = new JButton("...");
        browse.addActionListener(e -> this.browse());
        JPanel browsePanel = new JPanel(new BorderLayout());
        browsePanel.add((Component)this.modeFile, "Center");
        browsePanel.add((Component)browse, "East");
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeFile"), (Component)browsePanel);
        this.filenameGlob = new JTextField(16);
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.filenameGlob"), (Component)this.filenameGlob);
        this.firstLineGlob = new JTextField();
        mainContent.addComponent(jEdit.getProperty("options.editing.addMode.dialog.firstLineGlob"), (Component)this.firstLineGlob);
        content.add(mainContent);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 6));
        JButton ok = new JButton(jEdit.getProperty("common.ok"));
        ok.addActionListener(e -> this.ok());
        this.getRootPane().setDefaultButton(ok);
        JButton cancel = new JButton(jEdit.getProperty("common.cancel"));
        cancel.addActionListener(e -> this.cancel());
        GenericGUIUtilities.makeSameSize(ok, cancel);
        buttons.add(Box.createGlue());
        buttons.add(ok);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(cancel);
        content.add("South", buttons);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public String getModeName() {
        return this.modeName.getText();
    }

    public String getModeFile() {
        return this.modeFile.getText();
    }

    public String getFilenameGlob() {
        return this.filenameGlob.getText();
    }

    public String getFirstLineGlob() {
        return this.firstLineGlob.getText();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void ok() {
        String modeName = this.getModeName();
        if (modeName == null || modeName.isEmpty()) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Mode_name_may_not_be_empty.", "Mode name may not be empty."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        String modeFile = this.getModeFile();
        if (modeFile == null || modeFile.isEmpty()) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Mode_file_may_not_be_empty.", "Mode file may not be empty."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        String filenameGlob = this.getFilenameGlob();
        String firstLineGlob = this.getFirstLineGlob();
        if ((filenameGlob == null || filenameGlob.isEmpty()) && (firstLineGlob == null || firstLineGlob.isEmpty())) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), jEdit.getProperty("options.editing.addMode.dialog.Either_file_name_glob_or_first_line_glob_or_both_must_be_filled_in.", "Either file name glob or first line glob or both must be filled in."), jEdit.getProperty("options.editing.addMode.dialog.errorTitle", "Error"), 0);
            return;
        }
        this.canceled = false;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.dispose();
    }

    private void browse() {
        boolean multiSelect;
        int type;
        String path;
        View view = jEdit.getActiveView();
        String[] filename = GUIUtilities.showVFSFileDialog(view, path = jEdit.getSettingsDirectory(), type = 0, multiSelect = false);
        this.modeFile.setText(filename.length > 0 ? filename[0] : "");
    }
}

