/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.jEdit;

public class AbbrevEditor
extends JPanel {
    private final JTextField abbrev;
    private final JTextArea beforeCaret;
    private final JTextArea afterCaret;

    public AbbrevEditor() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 1;
        cons.weightx = 0.0;
        cons.gridx = 1;
        cons.gridy = 1;
        JLabel label = new JLabel(jEdit.getProperty("abbrev-editor.abbrev"), 4);
        label.setBorder(new EmptyBorder(0, 0, 0, 12));
        layout.setConstraints(label, cons);
        this.add(label);
        ++cons.gridx;
        cons.weightx = 1.0;
        this.abbrev = new JTextField();
        layout.setConstraints(this.abbrev, cons);
        this.add(this.abbrev);
        cons.gridx = 1;
        cons.weightx = 0.0;
        cons.gridwidth = 2;
        ++cons.gridy;
        label = new JLabel(jEdit.getProperty("abbrev-editor.before"));
        label.setBorder(new EmptyBorder(6, 0, 3, 0));
        layout.setConstraints(label, cons);
        this.add(label);
        ++cons.gridy;
        cons.weighty = 1.0;
        this.beforeCaret = new JTextArea(4, 40);
        JScrollPane scroller = new JScrollPane(this.beforeCaret);
        layout.setConstraints(scroller, cons);
        this.add(scroller);
        ++cons.gridy;
        cons.weighty = 0.0;
        label = new JLabel(jEdit.getProperty("abbrev-editor.after"));
        label.setBorder(new EmptyBorder(6, 0, 3, 0));
        layout.setConstraints(label, cons);
        this.add(label);
        ++cons.gridy;
        cons.weighty = 1.0;
        this.afterCaret = new JTextArea(4, 40);
        scroller = new JScrollPane(this.afterCaret);
        layout.setConstraints(scroller, cons);
        this.add(scroller);
    }

    public String getAbbrev() {
        return this.abbrev.getText();
    }

    public void setAbbrev(String abbrev) {
        this.abbrev.setText(abbrev);
    }

    public String getExpansion() {
        char ch;
        int i;
        StringBuilder buf = new StringBuilder();
        String beforeCaretText = this.beforeCaret.getText();
        String afterCaretText = this.afterCaret.getText();
        block10: for (i = 0; i < beforeCaretText.length(); ++i) {
            ch = beforeCaretText.charAt(i);
            switch (ch) {
                case '\n': {
                    buf.append("\\n");
                    continue block10;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block10;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block10;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        if (!afterCaretText.isEmpty()) {
            buf.append("\\|");
            block11: for (i = 0; i < afterCaretText.length(); ++i) {
                ch = afterCaretText.charAt(i);
                switch (ch) {
                    case '\n': {
                        buf.append("\\n");
                        continue block11;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block11;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block11;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
        }
        return buf.toString();
    }

    public void setExpansion(String expansion) {
        if (expansion == null) {
            this.beforeCaret.setText(null);
            this.afterCaret.setText(null);
            return;
        }
        String beforeCaretText = null;
        String afterCaretText = null;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < expansion.length(); ++i) {
            char ch = expansion.charAt(i);
            if (ch == '\\' && i != expansion.length() - 1) {
                ch = expansion.charAt(++i);
                switch (ch) {
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case '|': {
                        beforeCaretText = buf.toString();
                        buf.setLength(0);
                        break;
                    }
                    default: {
                        buf.append(ch);
                        break;
                    }
                }
                continue;
            }
            buf.append(ch);
        }
        if (beforeCaretText == null) {
            beforeCaretText = buf.toString();
        } else {
            afterCaretText = buf.toString();
        }
        this.beforeCaret.setText(beforeCaretText);
        this.afterCaret.setText(afterCaretText);
    }

    public JTextField getAbbrevField() {
        return this.abbrev;
    }

    public JTextArea getBeforeCaretTextArea() {
        return this.beforeCaret;
    }

    public JTextArea getAfterCaretTextArea() {
        return this.afterCaret;
    }
}

