/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;
import org.gjt.sp.util.GenericGUIUtilities;

public class BrowserCommandsMenu
extends JPopupMenu {
    private final VFSBrowser browser;
    private HashMap<String, JRadioButtonMenuItem> encodingMenuItems;
    private JCheckBoxMenuItem autoDetect;
    private JRadioButtonMenuItem otherEncoding;

    public BrowserCommandsMenu(VFSBrowser browser, VFSFile[] files) {
        this.browser = browser;
        if (files != null) {
            VFS vfs = VFSManager.getVFSForPath(files[0].getDeletePath());
            int type = files[0].getType();
            BufferManager bufferManager = jEdit.getBufferManager();
            boolean fileOpen = bufferManager.getBuffer(files[0].getPath()).isPresent();
            boolean deletePathOpen = bufferManager.getBuffer(files[0].getDeletePath()).isPresent();
            boolean delete = !deletePathOpen && (vfs.getCapabilities() & 8) != 0;
            boolean rename = !fileOpen && (vfs.getCapabilities() & 0x10) != 0;
            for (int i = 1; i < files.length; ++i) {
                VFSFile file = files[i];
                VFS _vfs = VFSManager.getVFSForPath(file.getDeletePath());
                delete &= vfs == _vfs && (_vfs.getCapabilities() & 8) != 0;
                if (type != file.getType()) {
                    type = -1;
                }
                rename = false;
                if (!bufferManager.getBuffer(file.getPath()).isPresent()) continue;
                fileOpen = true;
            }
            if (type == 1 || type == 2) {
                if (files.length == 1) {
                    this.add(BrowserCommandsMenu.createMenuItem("browse"));
                }
                if (browser.getMode() == 2) {
                    this.add(BrowserCommandsMenu.createMenuItem("browse-window"));
                }
            } else if (type == 0 && (browser.getMode() == 2 || browser.getMode() == 4)) {
                this.add(BrowserCommandsMenu.createMenuItem("open", "22x22/actions/document-open.png"));
                this.add(GUIUtilities.loadMenu(VFSBrowser.getActionContext(), "vfs.browser.open-in"));
                if (browser.getSelectedFiles().length == 1) {
                    this.add(BrowserCommandsMenu.createMenuItem("open-desktop", "22x22/actions/document-open.png"));
                    this.add(BrowserCommandsMenu.createMenuItem("insert"));
                }
                if (fileOpen) {
                    this.add(BrowserCommandsMenu.createMenuItem("close"));
                }
            } else if (type != -1) {
                this.add(BrowserCommandsMenu.createMenuItem("open", "22x22/actions/document-open.png"));
            }
            if (rename) {
                this.add(BrowserCommandsMenu.createMenuItem("rename"));
            }
            if (delete) {
                this.add(BrowserCommandsMenu.createMenuItem("delete", "22x22/actions/edit-delete.png"));
            }
            this.add(BrowserCommandsMenu.createMenuItem("copy-path", "22x22/actions/edit-copy.png"));
            this.add(BrowserCommandsMenu.createMenuItem("paste", "22x22/actions/edit-paste.png"));
            if (files.length == 1 || browser.getSelectedFiles().length != 0) {
                this.add(BrowserCommandsMenu.createMenuItem("properties", "22x22/actions/document-properties.png"));
            }
            this.addSeparator();
        }
        this.add(BrowserCommandsMenu.createMenuItem("up", "22x22/actions/go-parent.png"));
        this.add(BrowserCommandsMenu.createMenuItem("previous", "22x22/actions/go-previous.png"));
        this.add(BrowserCommandsMenu.createMenuItem("next", "22x22/actions/go-next.png"));
        this.add(BrowserCommandsMenu.createMenuItem("reload", "22x22/actions/document-reload.png"));
        this.add(BrowserCommandsMenu.createMenuItem("roots"));
        this.add(BrowserCommandsMenu.createMenuItem("home", "22x22/actions/go-home.png"));
        this.add(BrowserCommandsMenu.createMenuItem("synchronize"));
        this.addSeparator();
        if (browser.getMode() == 2) {
            this.add(BrowserCommandsMenu.createMenuItem("new-file", "22x22/actions/document-new.png"));
        }
        this.add(BrowserCommandsMenu.createMenuItem("new-directory", "22x22/actions/folder-new.png"));
        if (browser.getMode() == 2) {
            this.addSeparator();
            this.add(BrowserCommandsMenu.createMenuItem("search-directory", "22x22/actions/system-search.png"));
        }
        this.addSeparator();
        this.add(BrowserCommandsMenu.createMenuItem("show-hidden-files"));
        if (browser.getMode() == 2 || browser.getMode() == 4) {
            this.addSeparator();
            this.add(this.createEncodingMenu());
        }
        BrowserCommandsMenu.createCustomMenu().ifPresent(customMenu -> {
            Component[] menuComponents;
            this.addSeparator();
            for (Component menuComponent : menuComponents = customMenu.getMenuComponents()) {
                this.add((JMenuItem)menuComponent);
            }
        });
        this.addSeparator();
        this.add(BrowserCommandsMenu.createPluginMenu(browser));
        this.update();
    }

    public void update() {
        if (this.encodingMenuItems != null && this.browser.currentEncoding != null) {
            JRadioButtonMenuItem mi = this.encodingMenuItems.get(this.browser.currentEncoding);
            if (mi != null) {
                mi.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding.label"));
            } else {
                this.otherEncoding.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding-2.label", new String[]{this.browser.currentEncoding}));
            }
        }
    }

    private static JMenuItem createMenuItem(String name, String iconName) {
        JMenuItem jMenuItem = GUIUtilities.loadMenuItem(VFSBrowser.getActionContext(), "vfs.browser." + name, false);
        jMenuItem.setIcon(GUIUtilities.loadIcon(iconName));
        return jMenuItem;
    }

    private static JMenuItem createMenuItem(String name) {
        return BrowserCommandsMenu.createMenuItem(name, null);
    }

    /*
     * WARNING - void declaration
     */
    private JMenu createEncodingMenu() {
        void var9_12;
        String[] encodings;
        JMenu encodingMenu;
        ActionHandler actionHandler = new ActionHandler();
        this.encodingMenuItems = new HashMap();
        JMenu menu = encodingMenu = new JMenu(jEdit.getProperty("vfs.browser.commands.encoding.label"));
        this.autoDetect = new JCheckBoxMenuItem(jEdit.getProperty("vfs.browser.commands.encoding.auto-detect"));
        this.autoDetect.setSelected(this.browser.autoDetectEncoding);
        this.autoDetect.setActionCommand("auto-detect");
        this.autoDetect.addActionListener(actionHandler);
        menu.add(this.autoDetect);
        menu.addSeparator();
        ButtonGroup grp = new ButtonGroup();
        ArrayList<JMenuItem> encodingMenuItemList = new ArrayList<JMenuItem>();
        String[] stringArray = encodings = MiscUtilities.getEncodings(true);
        int n = stringArray.length;
        boolean bl = false;
        while (var9_12 < n) {
            String encoding = stringArray[var9_12];
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(encoding);
            mi.setActionCommand("encoding@" + encoding);
            mi.addActionListener(actionHandler);
            grp.add(mi);
            this.encodingMenuItems.put(encoding, mi);
            encodingMenuItemList.add(mi);
            ++var9_12;
        }
        String systemEncoding = System.getProperty("file.encoding");
        if (this.encodingMenuItems.get(systemEncoding) == null) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(systemEncoding);
            mi.setActionCommand("encoding@" + systemEncoding);
            mi.addActionListener(actionHandler);
            grp.add(mi);
            this.encodingMenuItems.put(systemEncoding, mi);
            encodingMenuItemList.add(mi);
        }
        encodingMenuItemList.sort(new MenuItemTextComparator());
        for (JRadioButtonMenuItem jRadioButtonMenuItem : encodingMenuItemList) {
            if (menu.getMenuComponentCount() > 20) {
                JMenu newMenu = new JMenu(jEdit.getProperty("common.more"));
                menu.add(newMenu);
                menu = newMenu;
            }
            menu.add(jRadioButtonMenuItem);
        }
        menu.addSeparator();
        this.otherEncoding = new JRadioButtonMenuItem();
        this.otherEncoding.setActionCommand("other-encoding");
        this.otherEncoding.addActionListener(actionHandler);
        grp.add(this.otherEncoding);
        menu.add(this.otherEncoding);
        return encodingMenu;
    }

    private static Optional<JMenu> createCustomMenu() {
        if (!jEdit.getProperty("browser.custom.context", "").isEmpty()) {
            JMenu custom = GUIUtilities.loadMenu(VFSBrowser.getActionContext(), "browser.custom.context");
            return Optional.of(custom);
        }
        return Optional.empty();
    }

    private static JMenu createPluginMenu(VFSBrowser browser) {
        JMenu pluginMenu = new JMenu(jEdit.getProperty("vfs.browser.plugins.label"));
        GenericGUIUtilities.setAutoMnemonic(pluginMenu);
        return (JMenu)browser.createPluginsMenu(pluginMenu, false);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String actionCommand = evt.getActionCommand();
            if (actionCommand.equals("auto-detect")) {
                BrowserCommandsMenu.this.browser.autoDetectEncoding = BrowserCommandsMenu.this.autoDetect.isSelected();
            } else if (actionCommand.equals("other-encoding")) {
                String encoding = GUIUtilities.input(BrowserCommandsMenu.this.browser, "encoding-prompt", null, jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
                if (encoding == null) {
                    return;
                }
                BrowserCommandsMenu.this.browser.currentEncoding = encoding;
            } else if (actionCommand.startsWith("encoding@")) {
                BrowserCommandsMenu.this.browser.currentEncoding = actionCommand.substring(9);
            }
        }
    }
}

