/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.StandardUtilities;

public class TextUtilities {
    public static final int BRACKET_MATCH_LIMIT = 10000;
    public static final int WHITESPACE = 0;
    public static final int WORD_CHAR = 1;
    public static final int SYMBOL = 2;
    public static final int MIXED = 0;
    public static final int LOWER_CASE = 1;
    public static final int UPPER_CASE = 2;
    public static final int TITLE_CASE = 3;

    public static Token getTokenAtOffset(Token tokens, int offset) {
        if (offset == 0 && tokens.id == 127) {
            return tokens;
        }
        while (true) {
            if (tokens.id == 127) {
                throw new ArrayIndexOutOfBoundsException("offset > line length");
            }
            if (tokens.offset + tokens.length > offset) {
                return tokens;
            }
            tokens = tokens.next;
        }
    }

    public static char getComplementaryBracket(char ch, boolean[] direction) {
        switch (ch) {
            case '(': {
                if (direction != null) {
                    direction[0] = true;
                }
                return ')';
            }
            case ')': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '(';
            }
            case '[': {
                if (direction != null) {
                    direction[0] = true;
                }
                return ']';
            }
            case ']': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '[';
            }
            case '{': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '}';
            }
            case '}': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '{';
            }
            case '<': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '>';
            }
            case '>': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '<';
            }
            case '\u00ab': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u00bb';
            }
            case '\u00bb': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u00ab';
            }
            case '\u2039': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u203a';
            }
            case '\u203a': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u2039';
            }
            case '\u27e8': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u27e9';
            }
            case '\u27e9': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u27e8';
            }
            case '\u2308': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u2309';
            }
            case '\u2309': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u2308';
            }
            case '\u230a': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u230b';
            }
            case '\u230b': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u230a';
            }
            case '\u2987': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u2988';
            }
            case '\u2988': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u2987';
            }
            case '\u27e6': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u27e7';
            }
            case '\u27e7': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u27e6';
            }
            case '\u2983': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u2984';
            }
            case '\u2984': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u2983';
            }
            case '\u27ea': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u27eb';
            }
            case '\u27eb': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u27ea';
            }
            case '\u2989': {
                if (direction != null) {
                    direction[0] = true;
                }
                return '\u298a';
            }
            case '\u298a': {
                if (direction != null) {
                    direction[0] = false;
                }
                return '\u2989';
            }
        }
        return '\u0000';
    }

    public static int findMatchingBracket(JEditBuffer buffer, int line, int offset) {
        if (offset < 0 || offset >= buffer.getLineLength(line)) {
            throw new ArrayIndexOutOfBoundsException(offset + ":" + buffer.getLineLength(line));
        }
        Segment lineText = new Segment();
        buffer.getLineText(line, lineText);
        char c = lineText.array[lineText.offset + offset];
        boolean[] direction = new boolean[1];
        char cprime = TextUtilities.getComplementaryBracket(c, direction);
        if (cprime == '\u0000') {
            return -1;
        }
        int count = 1;
        DefaultTokenHandler tokenHandler = new DefaultTokenHandler();
        buffer.markTokens(line, tokenHandler);
        byte idOfBracket = TextUtilities.getTokenAtOffset((Token)tokenHandler.getTokens(), (int)offset).id;
        boolean haveTokens = true;
        int startLine = line;
        if (direction[0]) {
            ++offset;
            while (true) {
                for (int i = offset; i < lineText.count; ++i) {
                    char ch = lineText.array[lineText.offset + i];
                    if (ch == c) {
                        if (!haveTokens) {
                            tokenHandler.init();
                            buffer.markTokens(line, tokenHandler);
                            haveTokens = true;
                        }
                        if (TextUtilities.getTokenAtOffset((Token)tokenHandler.getTokens(), (int)i).id != idOfBracket) continue;
                        ++count;
                        continue;
                    }
                    if (ch != cprime) continue;
                    if (!haveTokens) {
                        tokenHandler.init();
                        buffer.markTokens(line, tokenHandler);
                        haveTokens = true;
                    }
                    if (TextUtilities.getTokenAtOffset((Token)tokenHandler.getTokens(), (int)i).id != idOfBracket || --count != 0) continue;
                    return buffer.getLineStartOffset(line) + i;
                }
                if (++line < buffer.getLineCount() && line - startLine <= 10000) {
                    buffer.getLineText(line, lineText);
                    offset = 0;
                    haveTokens = false;
                    continue;
                }
                break;
            }
        } else {
            --offset;
            while (true) {
                for (int i = offset; i >= 0; --i) {
                    char ch = lineText.array[lineText.offset + i];
                    if (ch == c) {
                        if (!haveTokens) {
                            tokenHandler.init();
                            buffer.markTokens(line, tokenHandler);
                            haveTokens = true;
                        }
                        if (TextUtilities.getTokenAtOffset((Token)tokenHandler.getTokens(), (int)i).id != idOfBracket) continue;
                        ++count;
                        continue;
                    }
                    if (ch != cprime) continue;
                    if (!haveTokens) {
                        tokenHandler.init();
                        buffer.markTokens(line, tokenHandler);
                        haveTokens = true;
                    }
                    if (TextUtilities.getTokenAtOffset((Token)tokenHandler.getTokens(), (int)i).id != idOfBracket || --count != 0) continue;
                    return buffer.getLineStartOffset(line) + i;
                }
                if (--line < 0 || startLine - line > 10000) break;
                buffer.getLineText(line, lineText);
                offset = lineText.count - 1;
                haveTokens = false;
            }
        }
        return -1;
    }

    @Deprecated
    public static String join(Collection<?> c, String delim) {
        StringBuilder retval = new StringBuilder();
        Iterator<?> itr = c.iterator();
        if (itr.hasNext()) {
            retval.append(itr.next());
        } else {
            return "";
        }
        while (itr.hasNext()) {
            retval.append(delim);
            retval.append(itr.next());
        }
        return retval.toString();
    }

    public static int findWordStart(String line, int pos, String noWordSep) {
        return TextUtilities.findWordStart(line, pos, noWordSep, true, false);
    }

    public static int findWordStart(CharSequence line, int pos, String noWordSep) {
        return TextUtilities.findWordStart(line, pos, noWordSep, true, false, false);
    }

    public static int findWordStart(String line, int pos, String noWordSep, boolean joinNonWordChars) {
        return TextUtilities.findWordStart(line, pos, noWordSep, joinNonWordChars, false);
    }

    public static int findWordStart(String line, int pos, String noWordSep, boolean joinNonWordChars, boolean eatWhitespace) {
        return TextUtilities.findWordStart(line, pos, noWordSep, joinNonWordChars, false, eatWhitespace);
    }

    public static int findWordStart(String line, int pos, String noWordSep, boolean joinNonWordChars, boolean camelCasedWords, boolean eatWhitespace) {
        return TextUtilities.findWordStart((CharSequence)line, pos, noWordSep, joinNonWordChars, camelCasedWords, eatWhitespace);
    }

    public static int findWordStart(CharSequence line, int pos, String noWordSep, boolean joinNonWordChars, boolean camelCasedWords, boolean eatWhitespace) {
        return TextUtilities.findWordStart(line, pos, noWordSep, joinNonWordChars, camelCasedWords, eatWhitespace, false);
    }

    public static int findWordStart(CharSequence line, int pos, String noWordSep, boolean joinNonWordChars, boolean camelCasedWords, boolean eatWhitespace, boolean eatOnlyAfterWord) {
        char ch = line.charAt(pos);
        if (noWordSep == null) {
            noWordSep = "";
        }
        int type = TextUtilities.getCharType(ch, noWordSep);
        block5: for (int i = pos; i >= 0; --i) {
            char lastCh = ch;
            ch = line.charAt(i);
            switch (type) {
                case 0: {
                    if (Character.isWhitespace(ch)) continue block5;
                    if (!eatOnlyAfterWord) {
                        return i + 1;
                    }
                    if (Character.isLetterOrDigit(ch) || noWordSep.indexOf(ch) != -1) {
                        type = 1;
                        continue block5;
                    }
                    type = 2;
                    continue block5;
                }
                case 1: {
                    if (camelCasedWords && Character.isUpperCase(ch) && !Character.isUpperCase(lastCh) && Character.isLetterOrDigit(lastCh)) {
                        return i;
                    }
                    if (camelCasedWords && !Character.isUpperCase(ch) && Character.isUpperCase(lastCh)) {
                        return i + 1;
                    }
                    if (Character.isLetterOrDigit(ch) || noWordSep.indexOf(ch) != -1) continue block5;
                    if (Character.isWhitespace(ch) && eatWhitespace && !eatOnlyAfterWord) {
                        type = 0;
                        continue block5;
                    }
                    return i + 1;
                }
                case 2: {
                    if (!joinNonWordChars && pos != i) {
                        return i + 1;
                    }
                    if (Character.isWhitespace(ch)) {
                        if (eatWhitespace && !eatOnlyAfterWord) {
                            type = 0;
                            continue block5;
                        }
                        return i + 1;
                    }
                    if (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1) continue block5;
                    return i + 1;
                }
            }
        }
        return 0;
    }

    public static int findWordEnd(String line, int pos, String noWordSep) {
        return TextUtilities.findWordEnd(line, pos, noWordSep, true);
    }

    public static int findWordEnd(CharSequence line, int pos, String noWordSep) {
        return TextUtilities.findWordEnd(line, pos, noWordSep, true, false, false);
    }

    public static int findWordEnd(String line, int pos, String noWordSep, boolean joinNonWordChars) {
        return TextUtilities.findWordEnd(line, pos, noWordSep, joinNonWordChars, false);
    }

    public static int findWordEnd(String line, int pos, String noWordSep, boolean joinNonWordChars, boolean eatWhitespace) {
        return TextUtilities.findWordEnd(line, pos, noWordSep, joinNonWordChars, false, eatWhitespace);
    }

    public static int findWordEnd(String line, int pos, String noWordSep, boolean joinNonWordChars, boolean camelCasedWords, boolean eatWhitespace) {
        return TextUtilities.findWordEnd((CharSequence)line, pos, noWordSep, joinNonWordChars, camelCasedWords, eatWhitespace);
    }

    public static int findWordEnd(CharSequence line, int pos, String noWordSep, boolean joinNonWordChars, boolean camelCasedWords, boolean eatWhitespace) {
        if (pos != 0) {
            --pos;
        }
        char ch = line.charAt(pos);
        if (noWordSep == null) {
            noWordSep = "";
        }
        int type = TextUtilities.getCharType(ch, noWordSep);
        block5: for (int i = pos; i < line.length(); ++i) {
            char lastCh = ch;
            ch = line.charAt(i);
            switch (type) {
                case 0: {
                    if (Character.isWhitespace(ch)) continue block5;
                    return i;
                }
                case 1: {
                    if (camelCasedWords && i > pos + 1 && !Character.isUpperCase(ch) && Character.isLetterOrDigit(ch) && Character.isUpperCase(lastCh)) {
                        return i - 1;
                    }
                    if (camelCasedWords && Character.isUpperCase(ch) && !Character.isUpperCase(lastCh)) {
                        return i;
                    }
                    if (Character.isLetterOrDigit(ch) || noWordSep.indexOf(ch) != -1) continue block5;
                    if (Character.isWhitespace(ch) && eatWhitespace) {
                        type = 0;
                        continue block5;
                    }
                    return i;
                }
                case 2: {
                    if (!joinNonWordChars && i != pos) {
                        return i;
                    }
                    if (Character.isWhitespace(ch)) {
                        if (eatWhitespace) {
                            type = 0;
                            continue block5;
                        }
                        return i;
                    }
                    if (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1) continue block5;
                    return i;
                }
            }
        }
        return line.length();
    }

    public static int getCharType(char ch, String noWordSep) {
        int type = Character.isWhitespace(ch) ? 0 : (Character.isLetterOrDigit(ch) || noWordSep.indexOf(ch) != -1 ? 1 : 2);
        return type;
    }

    public static String spacesToTabs(String in, int tabSize) {
        StringBuilder buf = new StringBuilder();
        int width = 0;
        int whitespace = 0;
        block5: for (int i = 0; i < in.length(); ++i) {
            switch (in.charAt(i)) {
                case ' ': {
                    ++whitespace;
                    ++width;
                    continue block5;
                }
                case '\t': {
                    int tab = tabSize - width % tabSize;
                    width += tab;
                    whitespace += tab;
                    continue block5;
                }
                case '\n': {
                    if (whitespace != 0) {
                        buf.append(StandardUtilities.createWhiteSpace(whitespace, tabSize, width - whitespace));
                    }
                    whitespace = 0;
                    width = 0;
                    buf.append('\n');
                    continue block5;
                }
                default: {
                    if (whitespace != 0) {
                        buf.append(StandardUtilities.createWhiteSpace(whitespace, tabSize, width - whitespace));
                        whitespace = 0;
                    }
                    buf.append(in.charAt(i));
                    ++width;
                }
            }
        }
        if (whitespace != 0) {
            buf.append(StandardUtilities.createWhiteSpace(whitespace, tabSize, width - whitespace));
        }
        return buf.toString();
    }

    public static String tabsToSpaces(String in, int tabSize) {
        StringBuilder buf = new StringBuilder();
        int width = 0;
        block4: for (int i = 0; i < in.length(); ++i) {
            switch (in.charAt(i)) {
                case '\t': {
                    int count = tabSize - width % tabSize;
                    width += count;
                    while (--count >= 0) {
                        buf.append(' ');
                    }
                    continue block4;
                }
                case '\n': {
                    width = 0;
                    buf.append(in.charAt(i));
                    continue block4;
                }
                default: {
                    ++width;
                    buf.append(in.charAt(i));
                }
            }
        }
        return buf.toString();
    }

    public static String format(String text, int maxLineLength, int tabSize) {
        int newIndex;
        StringBuilder buf = new StringBuilder();
        int index = 0;
        while ((newIndex = text.indexOf("\n\n", index)) != -1) {
            TextUtilities.formatParagraph(text.substring(index, newIndex), maxLineLength, tabSize, buf);
            buf.append("\n\n");
            index = newIndex + 2;
        }
        if (index != text.length()) {
            TextUtilities.formatParagraph(text.substring(index), maxLineLength, tabSize, buf);
        }
        return buf.toString();
    }

    public static int indexIgnoringWhitespace(String str, int index) {
        int j = 0;
        for (int i = 0; i < index; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            ++j;
        }
        return j;
    }

    public static int ignoringWhitespaceIndex(String str, int index) {
        int j = 0;
        int i = 0;
        while (true) {
            if (!Character.isWhitespace(str.charAt(i))) {
                ++j;
            }
            if (j > index) {
                return i;
            }
            if (i == str.length() - 1) {
                return i + 1;
            }
            ++i;
        }
    }

    public static int getStringCase(CharSequence str) {
        if (str.length() == 0) {
            return 0;
        }
        int state = -1;
        char ch = str.charAt(0);
        if (Character.isLetter(ch)) {
            state = Character.isUpperCase(ch) ? 2 : 1;
        }
        block4: for (int i = 1; i < str.length(); ++i) {
            ch = str.charAt(i);
            if (!Character.isLetter(ch)) continue;
            switch (state) {
                case 2: {
                    if (!Character.isLowerCase(ch)) continue block4;
                    if (i == 1) {
                        state = 3;
                        continue block4;
                    }
                    return 0;
                }
                case 1: 
                case 3: {
                    if (!Character.isUpperCase(ch)) continue block4;
                    return 0;
                }
            }
        }
        return state;
    }

    public static int getStringCase(String str) {
        return TextUtilities.getStringCase((CharSequence)str);
    }

    public static String toTitleCase(String str) {
        if (str.length() == 0) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1).toLowerCase();
    }

    public static String escapeText(String text) {
        String result = text.replace("\\E", "\\\\E");
        return "\\Q" + result + "\\E";
    }

    private static void formatParagraph(String text, int maxLineLength, int tabSize, StringBuilder buf) {
        int leadingWhitespaceCount = StandardUtilities.getLeadingWhiteSpace(text);
        String leadingWhitespace = text.substring(0, leadingWhitespaceCount);
        int leadingWhitespaceWidth = StandardUtilities.getLeadingWhiteSpaceWidth(text, tabSize);
        buf.append(leadingWhitespace);
        int lineLength = leadingWhitespaceWidth;
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (lineLength != leadingWhitespaceWidth) {
                if (lineLength + word.length() + 1 > maxLineLength) {
                    buf.append('\n');
                    buf.append(leadingWhitespace);
                    lineLength = leadingWhitespaceWidth;
                } else {
                    buf.append(' ');
                    ++lineLength;
                }
            }
            buf.append(word);
            lineLength += word.length();
        }
    }

    public static void indexIgnoringWhitespace(String text, int maxLineLength, int tabSize, StringBuffer buf) {
        int leadingWhitespaceCount = StandardUtilities.getLeadingWhiteSpace(text);
        String leadingWhitespace = text.substring(0, leadingWhitespaceCount);
        int leadingWhitespaceWidth = StandardUtilities.getLeadingWhiteSpaceWidth(text, tabSize);
        buf.append(leadingWhitespace);
        int lineLength = leadingWhitespaceWidth;
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (lineLength != leadingWhitespaceWidth) {
                if (lineLength + word.length() + 1 > maxLineLength) {
                    buf.append('\n');
                    buf.append(leadingWhitespace);
                    lineLength = leadingWhitespaceWidth;
                } else {
                    buf.append(' ');
                    ++lineLength;
                }
            }
            buf.append(word);
            lineLength += word.length();
        }
    }
}

