/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.SettingsXML;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class JEditKillRing
extends KillRing {
    private SettingsXML killringXML;

    JEditKillRing() {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory != null) {
            this.killringXML = new SettingsXML(settingsDirectory, "killring");
        }
    }

    @Override
    public void load() {
        if (this.killringXML == null) {
            return;
        }
        if (!this.killringXML.fileExists()) {
            return;
        }
        Log.log(3, KillRing.class, "Loading " + String.valueOf(this.killringXML));
        KillRingHandler handler = new KillRingHandler();
        try {
            this.killringXML.load(handler);
        }
        catch (OutOfMemoryError oem) {
            Log.log(9, this, "Unable to load entire Killring, too low memory, increase your jvm max heap size");
            String start = jEdit.getProperty("killring.start");
            String deleteKillRing = jEdit.getProperty("killring.delete");
            String stop = jEdit.getProperty("killring.stop");
            int selected = GUIUtilities.option(null, "killring.load-memoryerror", null, 0, new Object[]{start, deleteKillRing, stop}, start);
            if (selected == 2) {
                System.exit(-1);
            } else if (selected == 1) {
                new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "killring.xml")).delete();
                return;
            }
        }
        catch (IOException ioe) {
            Log.log(9, this, ioe);
        }
        this.reset(handler.list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        if (this.killringXML == null) {
            return;
        }
        if (this.killringXML.hasChangedOnDisk()) {
            Log.log(7, KillRing.class, String.valueOf(this.killringXML) + " changed on disk; will not save killring files");
            return;
        }
        Log.log(3, KillRing.class, "Saving " + String.valueOf(this.killringXML));
        String lineSep = System.getProperty("line.separator");
        SettingsXML.Saver out = null;
        try {
            out = this.killringXML.openSaver();
            out.writeXMLDeclaration("1.1");
            out.write("<!DOCTYPE KILLRING SYSTEM \"killring.dtd\">");
            out.write(lineSep);
            out.write("<KILLRING>");
            out.write(lineSep);
            int size = this.getSize();
            for (int i = size - 1; i >= 0; --i) {
                out.write("<ENTRY>");
                out.write(XMLUtilities.charsToEntities(this.getElementAt(i), true));
                out.write("</ENTRY>");
                out.write(lineSep);
            }
            out.write("</KILLRING>");
            out.write(lineSep);
            out.finish();
        }
        catch (Exception e) {
            Log.log(9, KillRing.class, e);
        }
        finally {
            IOUtilities.closeQuietly(out);
        }
    }

    private static class KillRingHandler
    extends DefaultHandler {
        public List<String> list = new LinkedList<String>();
        private final StringBuilder charData = new StringBuilder();
        private boolean inEntry;

        private KillRingHandler() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return XMLUtilities.findEntity(systemId, "killring.dtd", this.getClass());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            this.inEntry = qName.equals("ENTRY");
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            if (name.equals("ENTRY")) {
                this.list.add(this.charData.toString());
                this.inEntry = false;
                this.charData.setLength(0);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.inEntry) {
                this.charData.append(ch, start, length);
            }
        }

        @Override
        public void processingInstruction(String target, String data) {
            if ("illegal-xml-character".equals(target)) {
                char ch;
                try {
                    ch = (char)Integer.parseInt(data.trim());
                }
                catch (Exception e) {
                    Log.log(9, this, "Failed to get character from PI\"" + target + "\" with \"" + data + "\": " + String.valueOf(e));
                    return;
                }
                this.characters(new char[]{ch}, 0, 1);
            }
        }
    }
}

